/*
 * Decompiled with CFR 0.152.
 */
package de.fisch37.betterserverpacksfabric;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.fisch37.betterserverpacksfabric.Main;
import de.fisch37.betterserverpacksfabric.ResourcePackHandler;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2178;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_7157;
import net.minecraft.class_7225;

public class PackCommand {
    public static final class_2561 MSG_PREFIX = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"BSP").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"] ").method_27692(class_124.field_1054));
    private static final SimpleCommandExceptionType INVALID_URI_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_48321((String)"bsp.commands.exc.invalid_uri", (String)"The pack URI is malformed. You can try fixing this in the config or just use /pack set <url> again"));

    private static LiteralArgumentBuilder<class_2168> makeCommand(class_7157 registryAccess) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pack").requires(required -> required.method_9259(3))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").executes(PackCommand::disablePack)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.string()).executes(context -> PackCommand.setPack((CommandContext<class_2168>)context, false))).then(class_2170.method_9247((String)"push").executes(context -> PackCommand.setPack((CommandContext<class_2168>)context, true)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").executes(context -> PackCommand.reloadPack((CommandContext<class_2168>)context, false))).then(class_2170.method_9247((String)"push").executes(context -> PackCommand.reloadPack((CommandContext<class_2168>)context, true))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"push").executes(context -> ResourcePackHandler.pushTo(((class_2168)context.getSource()).method_9211()))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(context -> ResourcePackHandler.pushTo(class_2186.method_9312((CommandContext)context, (String)"players")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"required").executes(PackCommand::getRequired)).then(class_2170.method_9244((String)"required", (ArgumentType)BoolArgumentType.bool()).executes(PackCommand::setRequired)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"prompt").executes(PackCommand::showPrompt)).then(class_2170.method_9244((String)"prompt", (ArgumentType)class_2178.method_9281((class_7157)registryAccess)).executes(PackCommand::setPrompt))).then(class_2170.method_9247((String)"clear").executes(PackCommand::clearPrompt)))).then(class_2170.method_9247((String)"info").executes(PackCommand::showInfo));
    }

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register(PackCommand.makeCommand(registryAccess)));
    }

    private static void updateHashWithContext(class_2168 source, boolean pushAfterSet) {
        source.method_9226(() -> MSG_PREFIX.method_27661().method_27693("Updating pack hash..."), true);
        Main.updateHash().thenAccept(result -> {
            if (result == null) {
                source.method_9226(() -> MSG_PREFIX.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Failed to update hash.Please check the server logs for more information.").method_27692(class_124.field_1061)), true);
            } else if (result.booleanValue()) {
                source.method_9226(() -> MSG_PREFIX.method_27661().method_27693("Pack Hash has been updated!"), true);
                if (pushAfterSet) {
                    source.method_9226(() -> MSG_PREFIX.method_27661().method_27693("Pushing to players..."), true);
                    ResourcePackHandler.pushTo(source.method_9211());
                }
            } else {
                source.method_9226(() -> MSG_PREFIX.method_27661().method_27693("BetterServerPacks has been disabled. ").method_27693("This cannot be pushed to the players :("), true);
            }
        });
    }

    private static int setPack(CommandContext<class_2168> context, boolean pushAfterSet) {
        URL parsedUrl;
        Supplier<class_2561> INVALID_URL_ERROR = () -> MSG_PREFIX.method_27661().method_10852((class_2561)class_2561.method_43470((String)"The text supplied is not a valid URL").method_27692(class_124.field_1061));
        class_2168 source = (class_2168)context.getSource();
        String url = StringArgumentType.getString(context, (String)"url");
        try {
            parsedUrl = new URI(url).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            ((class_2168)context.getSource()).method_9226(INVALID_URL_ERROR, false);
            return 0;
        }
        String protocol = parsedUrl.getProtocol();
        if (!protocol.equals("https") && !protocol.equals("http")) {
            source.method_9226(INVALID_URL_ERROR, false);
            return 0;
        }
        Main.config.url.set((Object)url).save();
        source.method_9226(() -> MSG_PREFIX.method_27661().method_27693("Pack URL has been updated. Reloading hash..."), true);
        PackCommand.updateHashWithContext(source, pushAfterSet);
        return 1;
    }

    private static int disablePack(CommandContext<class_2168> context) {
        Main.config.url.set((Object)"").save();
        PackCommand.updateHashWithContext((class_2168)context.getSource(), false);
        return 1;
    }

    private static int reloadPack(CommandContext<class_2168> context, boolean pushAfterReload) {
        PackCommand.updateHashWithContext((class_2168)context.getSource(), pushAfterReload);
        return 1;
    }

    private static int getRequired(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        Boolean required = (Boolean)Main.config.required.get();
        source.method_9226(() -> MSG_PREFIX.method_27661().method_27693("Pack is " + (required != false ? "required" : "optional")), false);
        return 1;
    }

    private static int setRequired(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        Boolean required = BoolArgumentType.getBool(context, (String)"required");
        Main.config.required.set((Object)required).save();
        source.method_9226(() -> MSG_PREFIX.method_27661().method_27693("Pack is now " + (required != false ? "required" : "optional")), true);
        return 1;
    }

    private static int showPrompt(CommandContext<class_2168> context) {
        Optional<class_2561> prompt = Main.config.getPrompt((class_7225.class_7874)((class_2168)context.getSource()).method_30497());
        ((class_2168)context.getSource()).method_9226(() -> (class_2561)prompt.map(text -> MSG_PREFIX.method_27661().method_27693("Current Prompt is: ").method_10852(text)).orElseGet(() -> MSG_PREFIX.method_27661().method_27693("No prompt is set")), false);
        return 1;
    }

    private static int setPrompt(CommandContext<class_2168> context) {
        class_2561 prompt = class_2178.method_67414(context, (String)"prompt");
        Main.config.setPrompt(prompt, (class_7225.class_7874)((class_2168)context.getSource()).method_30497()).save();
        ((class_2168)context.getSource()).method_9226(() -> MSG_PREFIX.method_27661().method_27693("Prompt has been set to: ").method_10852(prompt), true);
        return 1;
    }

    private static int clearPrompt(CommandContext<class_2168> context) {
        Main.config.setPrompt(null, null);
        ((class_2168)context.getSource()).method_9226(() -> MSG_PREFIX.method_27661().method_27693("Prompt has been removed"), true);
        return 1;
    }

    private static int showInfo(CommandContext<class_2168> context) throws CommandSyntaxException {
        URI uriObj;
        String url = (String)Main.config.url.get();
        try {
            uriObj = new URI(url);
        }
        catch (URISyntaxException e) {
            throw INVALID_URI_EXCEPTION.create();
        }
        boolean required = (Boolean)Main.config.required.get();
        Optional<class_2561> prompt = Main.config.getPrompt((class_7225.class_7874)((class_2168)context.getSource()).method_30497());
        if (!url.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> MSG_PREFIX.method_27661().method_27693("Pack URL: ").method_10852((class_2561)class_2561.method_43470((String)url).method_27696(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10608(uriObj))).method_27692(class_124.field_1060).method_27692(class_124.field_1073)).method_27693("\n").method_27693("Pack hash: ").method_10852((class_2561)Optional.ofNullable(Main.getHashString()).map(s -> class_2561.method_43470((String)s).method_27692(class_124.field_1076).method_27692(class_124.field_1056)).orElse(class_2561.method_43470((String)"undetermined").method_27692(class_124.field_1080))).method_27693("\n").method_27693("Pack is ").method_10852((class_2561)(required ? class_2561.method_43470((String)"required").method_27692(class_124.field_1061) : class_2561.method_43470((String)"optional").method_27692(class_124.field_1054))).method_27693("\n").method_10852((class_2561)prompt.map(text -> class_2561.method_43470((String)"Prompt: \n    ").method_10852(text)).orElseGet(() -> class_2561.method_43470((String)"No prompt is set"))), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> MSG_PREFIX.method_27661().method_27693("No resourcepack is set"), false);
        }
        return 1;
    }
}

