/*
 * Decompiled with CFR 0.152.
 */
package com.aarocket.golemforgetmenot;

import com.aarocket.golemforgetmenot.GolemForgetMeNot;
import com.aarocket.golemforgetmenot.GolemForgetMeNotConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class GolemForgetmeNotConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/golem_forget_me_not.json");

    public static void loadConfig() {
        if (!CONFIG_FILE.exists()) {
            GolemForgetmeNotConfigLoader.saveConfig();
            return;
        }
        boolean markRegenerate = false;
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (json.has("visitsUntilCooldown")) {
                GolemForgetMeNotConfig.setVisitsUntilCooldown(json.get("visitsUntilCooldown").getAsInt());
            } else {
                markRegenerate = true;
            }
            if (json.has("heightReach")) {
                GolemForgetMeNotConfig.setHeightReach(json.get("heightReach").getAsInt());
            } else {
                markRegenerate = true;
            }
            GolemForgetMeNot.LOGGER.info("Golem memory loaded!");
        }
        catch (IOException e) {
            GolemForgetMeNot.LOGGER.error("Failed to load golem_forget_me_not.json... using defaults", (Throwable)e);
        }
        if (markRegenerate) {
            GolemForgetmeNotConfigLoader.saveConfig();
        }
    }

    private static void saveConfig() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            JsonObject json = new JsonObject();
            json.addProperty("visitsUntilCooldown", (Number)GolemForgetMeNotConfig.getVisitsUntilCooldown());
            json.addProperty("heightReach", (Number)GolemForgetMeNotConfig.getHeightReach());
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((JsonElement)json, (Appendable)writer);
                GolemForgetMeNot.LOGGER.info("Golem memory increased!");
            }
        }
        catch (IOException e) {
            GolemForgetMeNot.LOGGER.error("Failed to save golem_forget_me_not.json", (Throwable)e);
        }
    }
}

