/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars;

import dev.muon.dynamic_resource_bars.compat.AppleSkinEventHandler;
import dev.muon.dynamic_resource_bars.compat.ManaProviderManager;
import dev.muon.dynamic_resource_bars.compat.StaminaProviderManager;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.config.gui.ModConfigScreen;
import dev.muon.dynamic_resource_bars.util.AnimationCacheReloadListener;
import dev.muon.dynamic_resource_bars.util.PlatformUtil;
import dev.muon.dynamic_resource_bars.util.TickHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dynamic_resource_bars")
public class DynamicResourceBars {
    public static final String MODNAME = "Dynamic RPG Resource Bars";
    public static final String ID = "dynamic_resource_bars";
    public static final Logger LOGGER = LogManager.getLogger((String)"Dynamic RPG Resource Bars");

    public static ResourceLocation loc(String path) {
        return new ResourceLocation(ID, path);
    }

    public DynamicResourceBars(FMLJavaModLoadingContext fmlContext) {
        fmlContext.getModEventBus().addListener(this::clientSetup);
        fmlContext.getModEventBus().addListener(this::registerReloadListeners);
        fmlContext.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new ModConfigScreen((Screen)screen)));
    }

    public void onInitializeClient() {
        ModConfigManager.initializeConfig();
        ManaProviderManager.initialize();
        StaminaProviderManager.initialize();
        if (PlatformUtil.isModLoaded("appleskin")) {
            AppleSkinEventHandler.register();
            LOGGER.info("AppleSkin detected, registering event handlers.");
        }
    }

    public void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> this.onInitializeClient());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new AnimationCacheReloadListener());
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TickHandler.onClientTick();
        }
    }
}

