/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.compat;

import dev.muon.dynamic_resource_bars.util.PlatformUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.helpers.FoodHelper;

public class AppleSkinCompat {
    private static final boolean APPLESKIN_LOADED = PlatformUtil.isModLoaded("appleskin");

    public static boolean isLoaded() {
        return APPLESKIN_LOADED;
    }

    public static FoodData getFoodValues(ItemStack stack, Player player) {
        if (!APPLESKIN_LOADED || stack.m_41619_() || !AppleSkinCompat.canConsume(stack, player)) {
            return FoodData.EMPTY;
        }
        FoodValues modifiedValues = FoodHelper.getModifiedFoodValues((ItemStack)stack, (Player)player);
        FoodValues defaultValues = FoodHelper.getDefaultFoodValues((ItemStack)stack, (Player)player);
        FoodValuesEvent event = new FoodValuesEvent(player, stack, defaultValues, modifiedValues);
        MinecraftForge.EVENT_BUS.post((Event)event);
        modifiedValues = event.modifiedFoodValues;
        return new FoodData(modifiedValues.hunger, modifiedValues.getSaturationIncrement());
    }

    public static boolean canConsume(ItemStack stack, Player player) {
        if (!APPLESKIN_LOADED || stack.m_41619_()) {
            return false;
        }
        return FoodHelper.canConsume((ItemStack)stack, (Player)player);
    }

    public static float getEstimatedHealthRestoration(ItemStack stack, Player player) {
        if (!APPLESKIN_LOADED || !AppleSkinCompat.canConsume(stack, player)) {
            return 0.0f;
        }
        FoodValues modifiedValues = FoodHelper.getModifiedFoodValues((ItemStack)stack, (Player)player);
        return FoodHelper.getEstimatedHealthIncrement((ItemStack)stack, (FoodValues)modifiedValues, (Player)player);
    }

    public static class FoodData {
        public static final FoodData EMPTY = new FoodData(0, 0.0f);
        public final int hunger;
        public final float saturation;

        public FoodData(int hunger, float saturation) {
            this.hunger = hunger;
            this.saturation = saturation;
        }

        public boolean isEmpty() {
            return this.hunger <= 0 && this.saturation <= 0.0f;
        }
    }
}

