/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.compat;

import dev.muon.dynamic_resource_bars.compat.FoodStaminaProvider;
import dev.muon.dynamic_resource_bars.compat.StaminaAttributesProvider;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.provider.StaminaBarBehavior;
import dev.muon.dynamic_resource_bars.provider.StaminaProvider;
import dev.muon.dynamic_resource_bars.provider.StaminaProviderRegistry;
import dev.muon.dynamic_resource_bars.util.PlatformUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;

public class StaminaProviderManager {
    private static FoodStaminaProvider foodProvider;
    private static StaminaAttributesProvider staminaAttributesProvider;
    private static final StaminaProvider EMPTY_PROVIDER;

    public static void init() {
        StaminaProviderRegistry.clear();
        if (foodProvider == null) {
            foodProvider = new FoodStaminaProvider();
        }
        StaminaProviderRegistry.registerProvider(() -> foodProvider);
        if (PlatformUtil.isModLoaded("staminaattributes")) {
            if (staminaAttributesProvider == null) {
                staminaAttributesProvider = new StaminaAttributesProvider();
            }
            StaminaProviderRegistry.registerProvider(() -> staminaAttributesProvider);
        }
        StaminaProviderRegistry.registerProvider(() -> EMPTY_PROVIDER);
    }

    public static StaminaProvider getProviderForBehavior(StaminaBarBehavior behavior) {
        switch (behavior) {
            case FOOD: {
                return foodProvider != null ? foodProvider : EMPTY_PROVIDER;
            }
            case STAMINA_ATTRIBUTES: {
                return staminaAttributesProvider != null ? staminaAttributesProvider : EMPTY_PROVIDER;
            }
        }
        return EMPTY_PROVIDER;
    }

    public static StaminaProvider getCurrentProvider() {
        StaminaBarBehavior currentBehavior = ModConfigManager.getClient().staminaBarBehavior;
        return StaminaProviderManager.getProviderForBehavior(currentBehavior);
    }

    public static boolean isModLoaded(String modId) {
        return PlatformUtil.isModLoaded(modId);
    }

    public static boolean isModLoaded(StaminaBarBehavior behavior) {
        switch (behavior) {
            case FOOD: {
                return true;
            }
            case STAMINA_ATTRIBUTES: {
                return PlatformUtil.isModLoaded("staminaattributes");
            }
            case OFF: {
                return true;
            }
        }
        return false;
    }

    public static boolean hasAnyStaminaMods() {
        return PlatformUtil.isModLoaded("staminaattributes");
    }

    public static void initialize() {
        foodProvider = new FoodStaminaProvider();
        if (PlatformUtil.isModLoaded("staminaattributes")) {
            staminaAttributesProvider = new StaminaAttributesProvider();
        }
        StaminaProviderManager.updateActiveProvider();
    }

    public static void updateActiveProvider() {
        StaminaBarBehavior behavior = ModConfigManager.getClient().staminaBarBehavior;
        if (behavior == null) {
            behavior = StaminaBarBehavior.FOOD;
        }
        StaminaProvider newProvider = EMPTY_PROVIDER;
        switch (behavior) {
            case FOOD: {
                if (foodProvider == null) break;
                newProvider = foodProvider;
                break;
            }
            case STAMINA_ATTRIBUTES: {
                if (staminaAttributesProvider == null) break;
                newProvider = staminaAttributesProvider;
            }
        }
        StaminaProviderRegistry.setActiveProvider(newProvider);
    }

    static {
        EMPTY_PROVIDER = new StaminaProvider(){

            @Override
            public float getCurrentStamina(Player player) {
                return 0.0f;
            }

            @Override
            public float getMaxStamina(Player player) {
                return 0.0f;
            }

            @Override
            public long getGameTime() {
                if (Minecraft.m_91087_().f_91073_ != null) {
                    return Minecraft.m_91087_().f_91073_.m_46467_();
                }
                return 0L;
            }
        };
    }
}

