/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.config.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.muon.dynamic_resource_bars.config.gui.ContextMenuItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.FormattedText;

public class ContextMenu
implements Renderable,
GuiEventListener {
    private static final int BACKGROUND_COLOR = -536870912;
    private static final int HOVER_COLOR = -2130706433;
    private static final int BORDER_COLOR = -12566464;
    private static final float SCALE_FACTOR = 0.5f;
    private static final int PADDING = 3;
    private static final int ITEM_HEIGHT = 9;
    private static final int MIN_WIDTH = 100;
    private final List<ContextMenuItem> items;
    private final int x;
    private final int y;
    private int width;
    private int height;
    private int hoveredIndex = -1;
    private boolean visible = true;
    private Runnable onClose;

    public ContextMenu(int x, int y, List<ContextMenuItem> items) {
        this.items = new ArrayList<ContextMenuItem>(items);
        this.calculateDimensions();
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        if (x + this.width > screenWidth) {
            x = screenWidth - this.width - 2;
        }
        if (x < 0) {
            x = 2;
        }
        if (y + this.height > screenHeight) {
            y = screenHeight - this.height - 2;
        }
        if (y < 0) {
            y = 2;
        }
        this.x = x;
        this.y = y;
    }

    private void calculateDimensions() {
        Font font = Minecraft.m_91087_().f_91062_;
        int maxWidth = 100;
        for (ContextMenuItem item : this.items) {
            if (item.getLabel().getString().isEmpty()) continue;
            int labelWidth = (int)((float)(font.m_92852_((FormattedText)item.getLabel()) + 6) * 0.5f);
            maxWidth = Math.max(maxWidth, labelWidth);
        }
        this.width = maxWidth;
        this.height = this.items.size() * 9 + 6;
    }

    public void setOnClose(Runnable onClose) {
        this.onClose = onClose;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        RenderSystem.enableBlend();
        graphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, -536870912);
        graphics.m_280509_(this.x, this.y, this.x + this.width, this.y + 1, -12566464);
        graphics.m_280509_(this.x, this.y + this.height - 1, this.x + this.width, this.y + this.height, -12566464);
        graphics.m_280509_(this.x, this.y, this.x + 1, this.y + this.height, -12566464);
        graphics.m_280509_(this.x + this.width - 1, this.y, this.x + this.width, this.y + this.height, -12566464);
        this.updateHoveredIndex(mouseX, mouseY);
        Font font = Minecraft.m_91087_().f_91062_;
        int itemY = this.y + 3;
        graphics.m_280168_().m_85836_();
        for (int i = 0; i < this.items.size(); ++i) {
            ContextMenuItem item = this.items.get(i);
            if (i == this.hoveredIndex && item.isClickable()) {
                graphics.m_280509_(this.x + 1, itemY, this.x + this.width - 1, itemY + 9, -2130706433);
            }
            if (!item.getLabel().getString().isEmpty()) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)(this.x + 3), (float)(itemY + 2), 0.0f);
                graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                int color = item.isEnabled() ? item.getTextColor() : 0x808080;
                graphics.m_280614_(font, item.getLabel(), 0, 0, color, false);
                graphics.m_280168_().m_85849_();
            }
            itemY += 9;
        }
        graphics.m_280168_().m_85849_();
        RenderSystem.disableBlend();
    }

    private void updateHoveredIndex(int mouseX, int mouseY) {
        int relativeY;
        int index;
        this.hoveredIndex = -1;
        if (mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height && (index = (relativeY = mouseY - this.y - 3) / 9) >= 0 && index < this.items.size() && this.items.get(index).isClickable()) {
            this.hoveredIndex = index;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        ContextMenuItem item;
        if (!this.visible) {
            return false;
        }
        int mx = (int)mouseX;
        int my = (int)mouseY;
        if (mx < this.x || mx >= this.x + this.width || my < this.y || my >= this.y + this.height) {
            this.close();
            return false;
        }
        if (button == 0 && this.hoveredIndex >= 0 && this.hoveredIndex < this.items.size() && (item = this.items.get(this.hoveredIndex)).isClickable()) {
            item.execute();
            return true;
        }
        return true;
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.updateHoveredIndex((int)mouseX, (int)mouseY);
    }

    public void close() {
        this.visible = false;
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.visible && mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public void m_93692_(boolean focused) {
    }

    public boolean m_93696_() {
        return this.visible;
    }
}

