/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.config.gui;

import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.config.gui.HudEditorScreen;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ModConfigScreen
extends Screen {
    private final Screen parentScreen;
    private EditBox textColorBox;
    private EditBox textOpacityBox;
    private EditBox textSizeBox;

    public ModConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Dynamic RPG Resource Bars Configuration"));
        this.parentScreen = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 200;
        int buttonHeight = 20;
        int centerX = this.f_96543_ / 2;
        int currentY = this.f_96544_ / 4;
        Minecraft mc = Minecraft.m_91087_();
        boolean canEditHUD = mc.f_91073_ != null;
        Button editHudButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.dynamic_resource_bars.config.button.open_hud_editor"), button -> {
            if (button.f_93623_) {
                this.f_96541_.m_91152_((Screen)new HudEditorScreen(this));
            }
        }).m_252987_(centerX - buttonWidth / 2, currentY, buttonWidth, buttonHeight).m_253136_();
        editHudButton.f_93623_ = canEditHUD;
        if (!canEditHUD) {
            editHudButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.dynamic_resource_bars.config.tooltip.hud_editor_disabled")));
        }
        this.m_142416_((GuiEventListener)editHudButton);
        currentY += buttonHeight + 15;
        ClientConfig config = ModConfigManager.getClient();
        int labelWidth = 80;
        int editBoxWidth = 60;
        int totalWidth = labelWidth + editBoxWidth + 5;
        int startX = centerX - totalWidth / 2;
        this.textColorBox = new EditBox(this.f_96547_, startX + labelWidth + 5, currentY, editBoxWidth, buttonHeight, (Component)Component.m_237113_((String)String.format("#%06X", config.globalTextColor & 0xFFFFFF)));
        this.textColorBox.m_94144_(String.format("%06X", config.globalTextColor & 0xFFFFFF));
        this.textColorBox.m_94199_(6);
        this.textColorBox.m_94151_(text -> {
            try {
                int color = Integer.parseInt(text, 16);
                config.globalTextColor = color | 0xFF000000;
                this.textColorBox.m_94202_(0xE0E0E0);
            }
            catch (NumberFormatException e) {
                this.textColorBox.m_94202_(0xFF5555);
            }
        });
        this.m_142416_((GuiEventListener)this.textColorBox);
        this.textOpacityBox = new EditBox(this.f_96547_, startX + labelWidth + 5, currentY += buttonHeight + 5, editBoxWidth, buttonHeight, (Component)Component.m_237113_((String)String.valueOf(config.globalTextOpacity)));
        this.textOpacityBox.m_94144_(String.valueOf(config.globalTextOpacity));
        this.textOpacityBox.m_94199_(3);
        this.textOpacityBox.m_94151_(text -> {
            try {
                int opacity = Integer.parseInt(text);
                if (opacity >= 0 && opacity <= 255) {
                    config.globalTextOpacity = opacity;
                    this.textOpacityBox.m_94202_(0xE0E0E0);
                } else {
                    this.textOpacityBox.m_94202_(0xFF5555);
                }
            }
            catch (NumberFormatException e) {
                this.textOpacityBox.m_94202_(0xFF5555);
            }
        });
        this.m_142416_((GuiEventListener)this.textOpacityBox);
        this.textSizeBox = new EditBox(this.f_96547_, startX + labelWidth + 5, currentY += buttonHeight + 5, editBoxWidth, buttonHeight, (Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf(config.globalTextSize))));
        this.textSizeBox.m_94144_(String.format("%.1f", Float.valueOf(config.globalTextSize)));
        this.textSizeBox.m_94199_(4);
        this.textSizeBox.m_94151_(text -> {
            try {
                float size = Float.parseFloat(text);
                if (size >= 0.1f && size <= 5.0f) {
                    config.globalTextSize = size;
                    this.textSizeBox.m_94202_(0xE0E0E0);
                } else {
                    this.textSizeBox.m_94202_(0xFF5555);
                }
            }
            catch (NumberFormatException e) {
                this.textSizeBox.m_94202_(0xFF5555);
            }
        });
        this.m_142416_((GuiEventListener)this.textSizeBox);
        currentY += buttonHeight + 5;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> this.m_7379_()).m_252987_(centerX - buttonWidth / 2, this.f_96544_ - buttonHeight - 20, buttonWidth, buttonHeight).m_253136_());
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        if (this.textColorBox != null) {
            int labelX = this.textColorBox.m_252754_() - 95;
            int n = this.textColorBox.m_252907_();
            int n2 = this.textColorBox.m_93694_();
            Objects.requireNonNull(this.f_96547_);
            int labelY = n + (n2 - 9) / 2;
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.dynamic_resource_bars.config.label.text_color"), labelX, labelY, 0xFFFFFF);
            int n3 = this.textOpacityBox.m_252907_();
            int n4 = this.textOpacityBox.m_93694_();
            Objects.requireNonNull(this.f_96547_);
            labelY = n3 + (n4 - 9) / 2;
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.dynamic_resource_bars.config.label.text_opacity"), labelX, labelY, 0xFFFFFF);
            int n5 = this.textSizeBox.m_252907_();
            int n6 = this.textSizeBox.m_93694_();
            Objects.requireNonNull(this.f_96547_);
            labelY = n5 + (n6 - 9) / 2;
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.dynamic_resource_bars.config.label.text_size"), labelX, labelY, 0xFFFFFF);
        }
    }

    public void m_7379_() {
        ClientConfig.getInstance().save();
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parentScreen);
        }
    }
}

