/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.config.gui;

import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.util.DraggableElement;
import dev.muon.dynamic_resource_bars.util.ScreenRect;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ResizeElementScreen
extends Screen {
    private final Screen parentScreen;
    private final DraggableElement elementToResize;
    private EditBox bgWidthBox;
    private EditBox bgHeightBox;
    private EditBox bgXOffsetBox;
    private EditBox bgYOffsetBox;
    private EditBox barWidthBox;
    private EditBox barHeightBox;
    private EditBox overlayWidthBox;
    private EditBox overlayHeightBox;

    public ResizeElementScreen(Screen parent, DraggableElement element) {
        super((Component)Component.m_237110_((String)"gui.dynamic_resource_bars.resize.title_format", (Object[])new Object[]{ResizeElementScreen.getFriendlyElementName(element)}));
        this.parentScreen = parent;
        this.elementToResize = element;
    }

    protected void m_7856_() {
        int overlayHeightConf;
        int overlayWidthConf;
        int barHeightConf;
        int barWidthConf;
        int bgYOffsetConf;
        int bgXOffsetConf;
        int bgHeightConf;
        int bgWidthConf;
        super.m_7856_();
        ClientConfig config = ModConfigManager.getClient();
        switch (this.elementToResize) {
            case HEALTH_BAR: {
                bgWidthConf = config.healthBackgroundWidth;
                bgHeightConf = config.healthBackgroundHeight;
                bgXOffsetConf = config.healthBackgroundXOffset;
                bgYOffsetConf = config.healthBackgroundYOffset;
                barWidthConf = config.healthBarWidth;
                barHeightConf = config.healthBarHeight;
                overlayWidthConf = config.healthOverlayWidth;
                overlayHeightConf = config.healthOverlayHeight;
                break;
            }
            case STAMINA_BAR: {
                bgWidthConf = config.staminaBackgroundWidth;
                bgHeightConf = config.staminaBackgroundHeight;
                bgXOffsetConf = config.staminaBackgroundXOffset;
                bgYOffsetConf = config.staminaBackgroundYOffset;
                barWidthConf = config.staminaBarWidth;
                barHeightConf = config.staminaBarHeight;
                overlayWidthConf = config.staminaOverlayWidth;
                overlayHeightConf = config.staminaOverlayHeight;
                break;
            }
            case MANA_BAR: {
                bgWidthConf = config.manaBackgroundWidth;
                bgHeightConf = config.manaBackgroundHeight;
                bgXOffsetConf = config.manaBackgroundXOffset;
                bgYOffsetConf = config.manaBackgroundYOffset;
                barWidthConf = config.manaBarWidth;
                barHeightConf = config.manaBarHeight;
                overlayWidthConf = config.manaOverlayWidth;
                overlayHeightConf = config.manaOverlayHeight;
                break;
            }
            default: {
                if (this.f_96541_ != null) {
                    this.f_96541_.m_91152_(this.parentScreen);
                }
                return;
            }
        }
        int boxWidth = 50;
        int boxHeight = 20;
        int labelWidth = 100;
        int componentBlockWidth = labelWidth + 5 + boxWidth;
        int startX = this.f_96543_ / 2 - componentBlockWidth / 2;
        int editBoxX = startX + labelWidth + 5;
        int currentY = 40;
        int rowSpacing = 5;
        this.bgWidthBox = this.createIntEditBox(editBoxX, currentY, boxWidth, boxHeight, bgWidthConf);
        this.bgHeightBox = this.createIntEditBox(editBoxX, currentY + boxHeight + rowSpacing, boxWidth, boxHeight, bgHeightConf);
        this.bgXOffsetBox = this.createIntEditBox(editBoxX, currentY + 2 * (boxHeight + rowSpacing), boxWidth, boxHeight, bgXOffsetConf, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.bgYOffsetBox = this.createIntEditBox(editBoxX, currentY + 3 * (boxHeight + rowSpacing), boxWidth, boxHeight, bgYOffsetConf, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.m_142416_((GuiEventListener)this.bgWidthBox);
        this.m_142416_((GuiEventListener)this.bgHeightBox);
        this.m_142416_((GuiEventListener)this.bgXOffsetBox);
        this.m_142416_((GuiEventListener)this.bgYOffsetBox);
        this.barWidthBox = this.createIntEditBox(editBoxX, currentY += 4 * (boxHeight + rowSpacing) + rowSpacing, boxWidth, boxHeight, barWidthConf, 0, 256);
        this.barHeightBox = this.createIntEditBox(editBoxX, currentY + boxHeight + rowSpacing, boxWidth, boxHeight, barHeightConf, 0, 32);
        this.m_142416_((GuiEventListener)this.barWidthBox);
        this.m_142416_((GuiEventListener)this.barHeightBox);
        this.overlayWidthBox = this.createIntEditBox(editBoxX, currentY += 2 * (boxHeight + rowSpacing) + rowSpacing, boxWidth, boxHeight, overlayWidthConf, 0, 256);
        this.overlayHeightBox = this.createIntEditBox(editBoxX, currentY + boxHeight + rowSpacing, boxWidth, boxHeight, overlayHeightConf, 0, 256);
        this.m_142416_((GuiEventListener)this.overlayWidthBox);
        this.m_142416_((GuiEventListener)this.overlayHeightBox);
        int doneButtonWidth = 100;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - doneButtonWidth / 2, this.f_96544_ - boxHeight - 20, doneButtonWidth, boxHeight).m_253136_());
    }

    private EditBox createIntEditBox(int x, int y, int width, int height, int configIntValue) {
        return this.createIntEditBox(x, y, width, height, configIntValue, 1, Integer.MAX_VALUE);
    }

    private EditBox createIntEditBox(int x, int y, int width, int height, int configIntValue, int minValue, int maxValue) {
        EditBox editBox = new EditBox(this.f_96547_, x, y, width, height, (Component)Component.m_237119_());
        editBox.m_94144_(String.valueOf(configIntValue));
        editBox.m_94151_(text -> {
            try {
                int value = Integer.parseInt(text);
                if (value >= minValue && value <= maxValue) {
                    editBox.m_94202_(0xE0E0E0);
                } else {
                    editBox.m_94202_(0xFF5555);
                }
            }
            catch (NumberFormatException e) {
                editBox.m_94202_(0xFF5555);
            }
        });
        return editBox;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        if (this.bgWidthBox != null) {
            int labelX = this.bgWidthBox.m_252754_() - 5 - 100;
            MutableComponent mutableComponent = Component.m_237115_((String)"gui.dynamic_resource_bars.resize.label.background_width");
            int n = this.bgWidthBox.m_252907_();
            int n2 = this.bgWidthBox.m_93694_();
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280430_(this.f_96547_, (Component)mutableComponent, labelX, n + (n2 - 9) / 2, 0xFFFFFF);
            MutableComponent mutableComponent2 = Component.m_237115_((String)"gui.dynamic_resource_bars.resize.label.background_height");
            int n3 = this.bgHeightBox.m_252907_();
            int n4 = this.bgHeightBox.m_93694_();
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280430_(this.f_96547_, (Component)mutableComponent2, labelX, n3 + (n4 - 9) / 2, 0xFFFFFF);
            MutableComponent mutableComponent3 = Component.m_237115_((String)"gui.dynamic_resource_bars.resize.label.background_x_offset");
            int n5 = this.bgXOffsetBox.m_252907_();
            int n6 = this.bgXOffsetBox.m_93694_();
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280430_(this.f_96547_, (Component)mutableComponent3, labelX, n5 + (n6 - 9) / 2, 0xFFFFFF);
            MutableComponent mutableComponent4 = Component.m_237115_((String)"gui.dynamic_resource_bars.resize.label.background_y_offset");
            int n7 = this.bgYOffsetBox.m_252907_();
            int n8 = this.bgYOffsetBox.m_93694_();
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280430_(this.f_96547_, (Component)mutableComponent4, labelX, n7 + (n8 - 9) / 2, 0xFFFFFF);
            MutableComponent mutableComponent5 = Component.m_237115_((String)"gui.dynamic_resource_bars.resize.label.bar_width");
            int n9 = this.barWidthBox.m_252907_();
            int n10 = this.barWidthBox.m_93694_();
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280430_(this.f_96547_, (Component)mutableComponent5, labelX, n9 + (n10 - 9) / 2, 0xFFFFFF);
            MutableComponent mutableComponent6 = Component.m_237115_((String)"gui.dynamic_resource_bars.resize.label.bar_height");
            int n11 = this.barHeightBox.m_252907_();
            int n12 = this.barHeightBox.m_93694_();
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280430_(this.f_96547_, (Component)mutableComponent6, labelX, n11 + (n12 - 9) / 2, 0xFFFFFF);
            MutableComponent mutableComponent7 = Component.m_237115_((String)"gui.dynamic_resource_bars.resize.label.overlay_width");
            int n13 = this.overlayWidthBox.m_252907_();
            int n14 = this.overlayWidthBox.m_93694_();
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280430_(this.f_96547_, (Component)mutableComponent7, labelX, n13 + (n14 - 9) / 2, 0xFFFFFF);
            MutableComponent mutableComponent8 = Component.m_237115_((String)"gui.dynamic_resource_bars.resize.label.overlay_height");
            int n15 = this.overlayHeightBox.m_252907_();
            int n16 = this.overlayHeightBox.m_93694_();
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280430_(this.f_96547_, (Component)mutableComponent8, labelX, n15 + (n16 - 9) / 2, 0xFFFFFF);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        boolean unfocusedAny = false;
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof EditBox)) continue;
            EditBox box = (EditBox)listener;
            ScreenRectangle vanillaRect = box.m_264198_();
            ScreenRect customRect = new ScreenRect(vanillaRect.m_274563_(), vanillaRect.m_274449_(), vanillaRect.f_263770_(), vanillaRect.f_263800_());
            if (!box.m_93696_() || customRect.contains((int)mouseX, (int)mouseY)) continue;
            box.m_93692_(false);
            unfocusedAny = true;
        }
        return unfocusedAny;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.m_7222_() != null && this.m_7222_().m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        ClientConfig config = ModConfigManager.getClient();
        try {
            switch (this.elementToResize) {
                case HEALTH_BAR: {
                    config.healthBackgroundWidth = this.parseIntSafely(this.bgWidthBox.m_94155_(), config.healthBackgroundWidth, 1, Integer.MAX_VALUE);
                    config.healthBackgroundHeight = this.parseIntSafely(this.bgHeightBox.m_94155_(), config.healthBackgroundHeight, 1, Integer.MAX_VALUE);
                    config.healthBarWidth = this.parseIntSafely(this.barWidthBox.m_94155_(), config.healthBarWidth, 1, 256);
                    config.healthBarHeight = this.parseIntSafely(this.barHeightBox.m_94155_(), config.healthBarHeight, 1, 32);
                    config.healthOverlayWidth = this.parseIntSafely(this.overlayWidthBox.m_94155_(), config.healthOverlayWidth, 1, 256);
                    config.healthOverlayHeight = this.parseIntSafely(this.overlayHeightBox.m_94155_(), config.healthOverlayHeight, 1, 256);
                    config.healthBackgroundXOffset = this.parseIntSafely(this.bgXOffsetBox.m_94155_(), config.healthBackgroundXOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    config.healthBackgroundYOffset = this.parseIntSafely(this.bgYOffsetBox.m_94155_(), config.healthBackgroundYOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    break;
                }
                case STAMINA_BAR: {
                    config.staminaBackgroundWidth = this.parseIntSafely(this.bgWidthBox.m_94155_(), config.staminaBackgroundWidth, 1, Integer.MAX_VALUE);
                    config.staminaBackgroundHeight = this.parseIntSafely(this.bgHeightBox.m_94155_(), config.staminaBackgroundHeight, 1, Integer.MAX_VALUE);
                    config.staminaBarWidth = this.parseIntSafely(this.barWidthBox.m_94155_(), config.staminaBarWidth, 1, 256);
                    config.staminaBarHeight = this.parseIntSafely(this.barHeightBox.m_94155_(), config.staminaBarHeight, 1, 32);
                    config.staminaOverlayWidth = this.parseIntSafely(this.overlayWidthBox.m_94155_(), config.staminaOverlayWidth, 1, 256);
                    config.staminaOverlayHeight = this.parseIntSafely(this.overlayHeightBox.m_94155_(), config.staminaOverlayHeight, 1, 256);
                    config.staminaBackgroundXOffset = this.parseIntSafely(this.bgXOffsetBox.m_94155_(), config.staminaBackgroundXOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    config.staminaBackgroundYOffset = this.parseIntSafely(this.bgYOffsetBox.m_94155_(), config.staminaBackgroundYOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    break;
                }
                case MANA_BAR: {
                    config.manaBackgroundWidth = this.parseIntSafely(this.bgWidthBox.m_94155_(), config.manaBackgroundWidth, 1, Integer.MAX_VALUE);
                    config.manaBackgroundHeight = this.parseIntSafely(this.bgHeightBox.m_94155_(), config.manaBackgroundHeight, 1, Integer.MAX_VALUE);
                    config.manaBarWidth = this.parseIntSafely(this.barWidthBox.m_94155_(), config.manaBarWidth, 1, 256);
                    config.manaBarHeight = this.parseIntSafely(this.barHeightBox.m_94155_(), config.manaBarHeight, 1, 32);
                    config.manaOverlayWidth = this.parseIntSafely(this.overlayWidthBox.m_94155_(), config.manaOverlayWidth, 1, 256);
                    config.manaOverlayHeight = this.parseIntSafely(this.overlayHeightBox.m_94155_(), config.manaOverlayHeight, 1, 256);
                    config.manaBackgroundXOffset = this.parseIntSafely(this.bgXOffsetBox.m_94155_(), config.manaBackgroundXOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    config.manaBackgroundYOffset = this.parseIntSafely(this.bgYOffsetBox.m_94155_(), config.manaBackgroundYOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                }
            }
            config.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parentScreen);
        }
    }

    private int parseIntSafely(String value, int defaultValue, int minValue, int maxValue) {
        try {
            int parsed = Integer.parseInt(value);
            if (parsed < minValue) {
                return minValue;
            }
            if (parsed > maxValue) {
                return maxValue;
            }
            return parsed;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private static String getFriendlyElementName(DraggableElement element) {
        if (element == null) {
            return "";
        }
        return switch (element) {
            case DraggableElement.HEALTH_BAR -> Component.m_237115_((String)"gui.dynamic_resource_bars.element.health_bar").getString();
            case DraggableElement.MANA_BAR -> Component.m_237115_((String)"gui.dynamic_resource_bars.element.mana_bar").getString();
            case DraggableElement.STAMINA_BAR -> Component.m_237115_((String)"gui.dynamic_resource_bars.element.stamina_bar").getString();
            default -> element.name();
        };
    }
}

