/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.event;

import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.provider.StaminaBarBehavior;
import dev.muon.dynamic_resource_bars.render.AirBarRenderer;
import dev.muon.dynamic_resource_bars.render.ArmorBarRenderer;
import dev.muon.dynamic_resource_bars.render.HealthBarRenderer;
import dev.muon.dynamic_resource_bars.render.StaminaBarRenderer;
import dev.muon.dynamic_resource_bars.util.BarRenderBehavior;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class GuiOverlays {
    public static final IGuiOverlay RESOURCE_BARS = (gui, graphics, partialTick, screenWidth, screenHeight) -> {
        Minecraft minecraft = gui.getMinecraft();
        if (minecraft.f_91066_.f_92062_) {
            return;
        }
        if (!gui.shouldDrawSurvivalElements()) {
            return;
        }
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        ClientConfig config = ModConfigManager.getClient();
        if (config.enableHealthBar) {
            HealthBarRenderer.render(graphics, (Player)player, player.m_21233_(), player.m_21223_(), (int)player.m_6103_(), partialTick);
            gui.leftHeight += config.healthBackgroundHeight + 1;
        }
        if (config.staminaBarBehavior != StaminaBarBehavior.OFF) {
            StaminaBarRenderer.render(graphics, (Player)player, partialTick);
            gui.rightHeight += config.staminaBackgroundHeight + 1;
        }
        if (config.armorBarBehavior == BarRenderBehavior.CUSTOM) {
            ArmorBarRenderer.render(graphics, (Player)player);
            gui.leftHeight += config.armorBackgroundHeight + 1;
        }
        if (config.airBarBehavior == BarRenderBehavior.CUSTOM) {
            AirBarRenderer.render(graphics, (Player)player, partialTick);
            gui.rightHeight += config.airBackgroundHeight + 1;
        }
    };
}

