/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.muon.dynamic_resource_bars.DynamicResourceBars;
import dev.muon.dynamic_resource_bars.compat.AppleSkinCompat;
import dev.muon.dynamic_resource_bars.compat.FoodStaminaProvider;
import dev.muon.dynamic_resource_bars.compat.StaminaProviderManager;
import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.provider.StaminaProvider;
import dev.muon.dynamic_resource_bars.util.AnimationMetadata;
import dev.muon.dynamic_resource_bars.util.AnimationMetadataCache;
import dev.muon.dynamic_resource_bars.util.DraggableElement;
import dev.muon.dynamic_resource_bars.util.EditModeManager;
import dev.muon.dynamic_resource_bars.util.FillDirection;
import dev.muon.dynamic_resource_bars.util.HUDPositioning;
import dev.muon.dynamic_resource_bars.util.HorizontalAlignment;
import dev.muon.dynamic_resource_bars.util.NineSliceRenderer;
import dev.muon.dynamic_resource_bars.util.PlatformUtil;
import dev.muon.dynamic_resource_bars.util.Position;
import dev.muon.dynamic_resource_bars.util.RenderUtil;
import dev.muon.dynamic_resource_bars.util.ScreenRect;
import dev.muon.dynamic_resource_bars.util.SubElementType;
import dev.muon.dynamic_resource_bars.util.TextBehavior;
import dev.muon.dynamic_resource_bars.util.TickHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class StaminaBarRenderer {
    private static float lastStamina = -1.0f;
    private static long fullStaminaStartTime = 0L;
    private static boolean staminaBarSetVisible = true;
    private static long staminaBarDisabledStartTime = 0L;
    private static float lastMountHealth = -1.0f;
    private static float lastMountMaxHealth = -1.0f;
    private static long fullMountHealthStartTime = 0L;
    private static final long CHUNK_FADEOUT_DURATION = 500L;
    private static final List<FadingChunk> fadingChunks = new ArrayList<FadingChunk>();
    private static float previousValue = -1.0f;
    private static float previousMax = -1.0f;
    private static boolean wasMounted = false;

    public static ScreenRect getScreenRect(Player player) {
        if (player == null) {
            return new ScreenRect(0, 0, 0, 0);
        }
        Position staminaPosBase = HUDPositioning.getPositionFromAnchor(ModConfigManager.getClient().staminaBarAnchor);
        Position staminaPos = staminaPosBase.offset(ModConfigManager.getClient().staminaTotalXOffset, ModConfigManager.getClient().staminaTotalYOffset);
        int backgroundWidth = ModConfigManager.getClient().staminaBackgroundWidth;
        int backgroundHeight = ModConfigManager.getClient().staminaBackgroundHeight;
        return new ScreenRect(staminaPos.x(), staminaPos.y(), backgroundWidth, backgroundHeight);
    }

    public static ScreenRect getSubElementRect(SubElementType type, Player player) {
        ScreenRect complexRect = StaminaBarRenderer.getScreenRect(player);
        if (complexRect == null || complexRect.width() == 0 && complexRect.height() == 0) {
            return new ScreenRect(0, 0, 0, 0);
        }
        int x = complexRect.x();
        int y = complexRect.y();
        switch (type) {
            case BACKGROUND: {
                return new ScreenRect(x + ModConfigManager.getClient().staminaBackgroundXOffset, y + ModConfigManager.getClient().staminaBackgroundYOffset, ModConfigManager.getClient().staminaBackgroundWidth, ModConfigManager.getClient().staminaBackgroundHeight);
            }
            case BAR_MAIN: {
                return new ScreenRect(x + ModConfigManager.getClient().staminaBarXOffset, y + ModConfigManager.getClient().staminaBarYOffset, ModConfigManager.getClient().staminaBarWidth, ModConfigManager.getClient().staminaBarHeight);
            }
            case FOREGROUND: {
                return new ScreenRect(x + ModConfigManager.getClient().staminaOverlayXOffset, y + ModConfigManager.getClient().staminaOverlayYOffset, ModConfigManager.getClient().staminaOverlayWidth, ModConfigManager.getClient().staminaOverlayHeight);
            }
            case TEXT: {
                return new ScreenRect(x + ModConfigManager.getClient().staminaTextXOffset, y + ModConfigManager.getClient().staminaTextYOffset, ModConfigManager.getClient().staminaBarWidth, ModConfigManager.getClient().staminaBarHeight);
            }
        }
        return new ScreenRect(0, 0, 0, 0);
    }

    public static void render(GuiGraphics graphics, Player player, float partialTicks) {
        boolean isRightAnchored;
        if (!Minecraft.m_91087_().f_91072_.m_105205_() && !EditModeManager.isEditModeEnabled()) {
            return;
        }
        StaminaProvider staminaProvider = StaminaProviderManager.getCurrentProvider();
        if (staminaProvider == null) {
            return;
        }
        BarValues values = StaminaBarRenderer.getBarValues(player, staminaProvider);
        StaminaBarRenderer.updateChunkTracking(player, values, staminaProvider, partialTicks);
        boolean shouldFade = StaminaBarRenderer.shouldBarFade(player, values);
        StaminaBarRenderer.setStaminaBarVisibility(!shouldFade || EditModeManager.isEditModeEnabled());
        if (!StaminaBarRenderer.isStaminaBarVisible() && !EditModeManager.isEditModeEnabled() && System.currentTimeMillis() - staminaBarDisabledStartTime > 1500L) {
            return;
        }
        float currentAlphaForRender = StaminaBarRenderer.getStaminaBarAlpha();
        if (EditModeManager.isEditModeEnabled() && !StaminaBarRenderer.isStaminaBarVisible()) {
            currentAlphaForRender = 1.0f;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)currentAlphaForRender);
        ScreenRect complexRect = StaminaBarRenderer.getScreenRect(player);
        AnimationMetadata.AnimationData animData = AnimationMetadataCache.getStaminaBarAnimation();
        float ticks = (float)player.f_19797_ + partialTicks;
        int animOffset = AnimationMetadata.calculateAnimationOffset(animData, ticks);
        boolean bl = isRightAnchored = ModConfigManager.getClient().staminaBarAnchor.getSide() == HUDPositioning.AnchorSide.RIGHT;
        if (ModConfigManager.getClient().enableStaminaBackground) {
            ScreenRect bgRect = StaminaBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
            ResourceLocation bgTexture = DynamicResourceBars.loc("textures/gui/stamina_background.png");
            AnimationMetadata.ScalingInfo bgScaling = AnimationMetadataCache.getStaminaBackgroundScaling();
            AnimationMetadata.TextureDimensions bgDims = AnimationMetadataCache.getTextureDimensions(bgTexture);
            NineSliceRenderer.renderWithScaling(graphics, bgTexture, bgScaling, bgRect.x(), bgRect.y(), bgRect.width(), bgRect.height(), bgDims.width, bgDims.height);
        }
        ScreenRect barRect = StaminaBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
        StaminaBarRenderer.renderBaseBar(graphics, player, values, staminaProvider, barRect, animOffset, isRightAnchored, animData);
        StaminaBarRenderer.renderFadingChunks(graphics, barRect, values, isRightAnchored, currentAlphaForRender, animData);
        if (staminaProvider.shouldShowOverlays() && !values.isMounted) {
            if (PlatformUtil.isModLoaded("appleskin")) {
                ItemStack heldFood = StaminaBarRenderer.getHeldFood(player);
                StaminaBarRenderer.renderHungerRestoredOverlay(graphics, player, heldFood, barRect, partialTicks, animOffset, isRightAnchored, animData);
                StaminaBarRenderer.renderSaturationOverlay(graphics, player, barRect, animOffset, isRightAnchored, animData);
            }
            if (PlatformUtil.isModLoaded("farmersdelight") && StaminaBarRenderer.hasNourishmentEffect(player)) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                float pulseAlpha = TickHandler.getOverlayFlashAlpha();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)pulseAlpha);
                ResourceLocation nourishmentTexture = DynamicResourceBars.loc("textures/gui/nourishment_overlay.png");
                AnimationMetadata.ScalingInfo nourishmentScaling = AnimationMetadataCache.getNourishmentOverlayScaling();
                AnimationMetadata.TextureDimensions nourishmentDims = AnimationMetadataCache.getTextureDimensions(nourishmentTexture);
                NineSliceRenderer.renderWithScaling(graphics, nourishmentTexture, nourishmentScaling, barRect.x(), barRect.y(), barRect.width(), barRect.height(), nourishmentDims.width, nourishmentDims.height);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
            }
        }
        if (ModConfigManager.getClient().enableStaminaForeground) {
            ScreenRect fgRect = StaminaBarRenderer.getSubElementRect(SubElementType.FOREGROUND, player);
            ResourceLocation fgTexture = DynamicResourceBars.loc("textures/gui/stamina_foreground.png");
            AnimationMetadata.ScalingInfo fgScaling = AnimationMetadataCache.getStaminaForegroundScaling();
            AnimationMetadata.TextureDimensions fgDims = AnimationMetadataCache.getTextureDimensions(fgTexture);
            NineSliceRenderer.renderWithScaling(graphics, fgTexture, fgScaling, fgRect.x(), fgRect.y(), fgRect.width(), fgRect.height(), fgDims.width, fgDims.height);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (StaminaBarRenderer.shouldRenderStaminaText(values.current, values.max, player, values.isMounted)) {
            ScreenRect textRect = StaminaBarRenderer.getSubElementRect(SubElementType.TEXT, player);
            int textX = textRect.x() + textRect.width() / 2;
            int textY = textRect.y() + textRect.height() / 2;
            int color = StaminaBarRenderer.getStaminaTextColor(values.current, values.max, values.isMounted);
            HorizontalAlignment alignment = ModConfigManager.getClient().staminaTextAlign;
            int baseX = textRect.x();
            if (alignment == HorizontalAlignment.CENTER) {
                baseX = textX;
            } else if (alignment == HorizontalAlignment.RIGHT) {
                baseX = textRect.x() + textRect.width();
            }
            RenderUtil.renderText(values.current, values.max, graphics, baseX, textY, color, alignment);
        }
        if (EditModeManager.isEditModeEnabled()) {
            DraggableElement currentBarType = DraggableElement.STAMINA_BAR;
            if (EditModeManager.getFocusedElement() == currentBarType) {
                int focusedBorderColor = -1593835776;
                ScreenRect bgRect = StaminaBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                if (ModConfigManager.getClient().enableStaminaBackground) {
                    graphics.m_280637_(bgRect.x() - 1, bgRect.y() - 1, bgRect.width() + 2, bgRect.height() + 2, focusedBorderColor);
                }
                ScreenRect barRectOutline = StaminaBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                graphics.m_280637_(barRectOutline.x() - 1, barRectOutline.y() - 1, barRectOutline.width() + 2, barRectOutline.height() + 2, -1593858816);
                if (ModConfigManager.getClient().enableStaminaForeground) {
                    ScreenRect fgRect = StaminaBarRenderer.getSubElementRect(SubElementType.FOREGROUND, player);
                    graphics.m_280637_(fgRect.x() - 1, fgRect.y() - 1, fgRect.width() + 2, fgRect.height() + 2, -1593900801);
                }
                graphics.m_280637_(complexRect.x() - 2, complexRect.y() - 2, complexRect.width() + 4, complexRect.height() + 4, -2130706433);
            } else {
                int borderColor = -2130706433;
                graphics.m_280637_(complexRect.x() - 1, complexRect.y() - 1, complexRect.width() + 2, complexRect.height() + 2, borderColor);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void updateChunkTracking(Player player, BarValues values, StaminaProvider provider, float partialTicks) {
        Iterator<FadingChunk> it = fadingChunks.iterator();
        while (it.hasNext()) {
            FadingChunk chunk = it.next();
            if (!chunk.isExpired() && (chunk.isMounted != values.isMounted || !(values.current >= chunk.endValue))) continue;
            it.remove();
        }
        if (previousValue > 0.0f && values.current < previousValue && wasMounted == values.isMounted && previousMax == values.max) {
            float healthPercentage;
            String texture = values.isMounted ? ((healthPercentage = values.current / values.max) <= 0.2f ? "stamina_bar_critical" : "stamina_bar_mounted") : provider.getBarTexture(player, values.current);
            AnimationMetadata.AnimationData animData = AnimationMetadataCache.getStaminaBarAnimation();
            float ticks = (float)player.f_19797_ + partialTicks;
            int animOffset = AnimationMetadata.calculateAnimationOffset(animData, ticks);
            float chunkStart = Math.max(0.0f, values.current);
            fadingChunks.add(new FadingChunk(chunkStart, previousValue, values.max, texture, animOffset, values.isMounted));
        }
        previousValue = values.current;
        previousMax = values.max;
        wasMounted = values.isMounted;
    }

    private static void renderFadingChunks(GuiGraphics graphics, ScreenRect barRect, BarValues currentValues, boolean isRightAnchored, float parentAlpha, AnimationMetadata.AnimationData animData) {
        if (fadingChunks.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        FillDirection fillDirection = ModConfigManager.getClient().staminaFillDirection;
        for (FadingChunk chunk : fadingChunks) {
            int uOffset;
            int xPos;
            float endRatio;
            float startRatio;
            float alpha;
            if (chunk.isMounted != currentValues.isMounted || (alpha = chunk.getAlpha() * parentAlpha) <= 0.0f) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            ResourceLocation chunkTexture = DynamicResourceBars.loc("textures/gui/" + chunk.texture + ".png");
            if (fillDirection == FillDirection.VERTICAL) {
                startRatio = chunk.startValue / chunk.maxValue;
                endRatio = chunk.endValue / chunk.maxValue;
                int startHeight = (int)((float)barRect.height() * startRatio);
                int endHeight = (int)((float)barRect.height() * endRatio);
                int chunkHeight = endHeight - startHeight;
                if (chunkHeight <= 0) continue;
                int yPos = barRect.y() + (barRect.height() - endHeight);
                int textureVOffset = chunk.animOffset + (barRect.height() - endHeight);
                RenderUtil.blitWithBinding(graphics, chunkTexture, barRect.x(), yPos, 0, textureVOffset, barRect.width(), chunkHeight, animData.textureWidth, animData.textureHeight);
                continue;
            }
            startRatio = chunk.startValue / chunk.maxValue;
            endRatio = chunk.endValue / chunk.maxValue;
            int startWidth = (int)((float)barRect.width() * startRatio);
            int endWidth = (int)((float)barRect.width() * endRatio);
            int chunkWidth = endWidth - startWidth;
            if (chunkWidth <= 0) continue;
            if (isRightAnchored) {
                xPos = barRect.x() + barRect.width() - endWidth;
                uOffset = barRect.width() - endWidth;
            } else {
                xPos = barRect.x() + startWidth;
                uOffset = startWidth;
            }
            RenderUtil.blitWithBinding(graphics, chunkTexture, xPos, barRect.y(), uOffset, chunk.animOffset, chunkWidth, barRect.height(), animData.textureWidth, animData.textureHeight);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static BarValues getBarValues(Player player, StaminaProvider provider) {
        Entity entity;
        if (ModConfigManager.getClient().mergeMountHealth && (entity = player.m_20202_()) instanceof LivingEntity) {
            LivingEntity mount = (LivingEntity)entity;
            return new BarValues(mount.m_21223_(), mount.m_21233_(), true);
        }
        return new BarValues(provider.getCurrentStamina(player), provider.getMaxStamina(player), false);
    }

    private static boolean shouldBarFade(Player player, BarValues values) {
        if (values.isMounted) {
            return ModConfigManager.getClient().fadeHealthWhenFull && values.current >= values.max;
        }
        return ModConfigManager.getClient().fadeStaminaWhenFull && values.current >= values.max;
    }

    private static void renderBaseBar(GuiGraphics graphics, Player player, BarValues values, StaminaProvider provider, ScreenRect barAreaRect, int animOffset, boolean isRightAnchored, AnimationMetadata.AnimationData animData) {
        float healthPercentage;
        String barTextureStr = values.isMounted ? ((healthPercentage = values.current / values.max) <= 0.2f ? "stamina_bar_critical" : "stamina_bar_mounted") : provider.getBarTexture(player, values.current);
        ResourceLocation barTexture = DynamicResourceBars.loc("textures/gui/" + barTextureStr + ".png");
        int totalBarWidth = barAreaRect.width();
        int barHeight = barAreaRect.height();
        float currentStaminaRatio = values.max == 0.0f ? 0.0f : values.current / values.max;
        FillDirection fillDirection = ModConfigManager.getClient().staminaFillDirection;
        if (fillDirection == FillDirection.VERTICAL) {
            int partialBarHeight = (int)((float)barHeight * currentStaminaRatio);
            if (partialBarHeight <= 0 && values.current > 0.0f) {
                partialBarHeight = 1;
            }
            if (partialBarHeight > barHeight) {
                partialBarHeight = barHeight;
            }
            int barX = barAreaRect.x();
            int barY = barAreaRect.y() + (barHeight - partialBarHeight);
            int textureVOffset = animOffset + (barHeight - partialBarHeight);
            if (partialBarHeight > 0) {
                RenderUtil.blitWithBinding(graphics, barTexture, barX, barY, 0, textureVOffset, totalBarWidth, partialBarHeight, animData.textureWidth, animData.textureHeight);
            }
        } else {
            int partialBarWidth = (int)((float)totalBarWidth * currentStaminaRatio);
            if (partialBarWidth <= 0 && values.current > 0.0f) {
                partialBarWidth = 1;
            }
            if (partialBarWidth > totalBarWidth) {
                partialBarWidth = totalBarWidth;
            }
            int barRenderX = barAreaRect.x();
            int barRenderY = barAreaRect.y();
            int uTexOffset = 0;
            if (isRightAnchored) {
                barRenderX = barAreaRect.x() + totalBarWidth - partialBarWidth;
                uTexOffset = totalBarWidth - partialBarWidth;
            }
            if (uTexOffset < 0) {
                uTexOffset = 0;
            }
            if (partialBarWidth > 0) {
                RenderUtil.blitWithBinding(graphics, barTexture, barRenderX, barRenderY, uTexOffset, animOffset, partialBarWidth, barHeight, animData.textureWidth, animData.textureHeight);
            }
        }
    }

    private static boolean shouldRenderStaminaText(float currentValue, float maxValue, Player player, boolean isMounted) {
        boolean isFull;
        TextBehavior textBehavior;
        TextBehavior textBehavior2 = textBehavior = isMounted ? ModConfigManager.getClient().showHealthText : ModConfigManager.getClient().showStaminaText;
        if (EditModeManager.isEditModeEnabled() && (textBehavior == TextBehavior.ALWAYS || textBehavior == TextBehavior.WHEN_NOT_FULL)) {
            return true;
        }
        if (textBehavior == TextBehavior.NEVER) {
            return false;
        }
        if (textBehavior == TextBehavior.ALWAYS) {
            return true;
        }
        if (isMounted) {
            boolean isFull2;
            boolean bl = isFull2 = currentValue >= maxValue;
            if (isFull2) {
                if (lastMountHealth < maxValue || lastMountMaxHealth != maxValue || lastMountHealth == -1.0f) {
                    fullMountHealthStartTime = System.currentTimeMillis();
                }
                lastMountHealth = currentValue;
                lastMountMaxHealth = maxValue;
                return System.currentTimeMillis() - fullMountHealthStartTime < 2000L;
            }
            lastMountHealth = currentValue;
            lastMountMaxHealth = maxValue;
            return true;
        }
        boolean bl = isFull = currentValue >= maxValue;
        if (isFull) {
            if (lastStamina < maxValue || lastStamina == -1.0f) {
                fullStaminaStartTime = System.currentTimeMillis();
            }
            lastStamina = currentValue;
            return System.currentTimeMillis() - fullStaminaStartTime < 2000L;
        }
        lastStamina = currentValue;
        return true;
    }

    private static int getStaminaTextColor(float currentValue, float maxValue, boolean isMounted) {
        int alpha;
        int baseColor;
        TextBehavior textBehavior = isMounted ? ModConfigManager.getClient().showHealthText : ModConfigManager.getClient().showStaminaText;
        ClientConfig config = ModConfigManager.getClient();
        if (isMounted) {
            baseColor = config.healthTextColor & 0xFFFFFF;
            alpha = config.healthTextOpacity;
        } else {
            baseColor = config.staminaTextColor & 0xFFFFFF;
            alpha = config.staminaTextOpacity;
        }
        if (textBehavior == TextBehavior.WHEN_NOT_FULL && currentValue >= maxValue) {
            long timeSinceFull = isMounted ? System.currentTimeMillis() - fullMountHealthStartTime : System.currentTimeMillis() - fullStaminaStartTime;
            alpha = (int)((float)alpha * ((float)RenderUtil.calculateTextAlpha(timeSinceFull) / 200.0f));
        }
        alpha = (int)((float)alpha * StaminaBarRenderer.getStaminaBarAlpha());
        alpha = Math.max(10, Math.min(255, alpha));
        return alpha << 24 | baseColor;
    }

    private static void setStaminaBarVisibility(boolean visible) {
        if (staminaBarSetVisible != visible) {
            if (!visible) {
                staminaBarDisabledStartTime = System.currentTimeMillis();
            }
            staminaBarSetVisible = visible;
        }
    }

    private static boolean isStaminaBarVisible() {
        return staminaBarSetVisible;
    }

    private static float getStaminaBarAlpha() {
        if (StaminaBarRenderer.isStaminaBarVisible()) {
            return 1.0f;
        }
        long timeSinceDisabled = System.currentTimeMillis() - staminaBarDisabledStartTime;
        if (timeSinceDisabled >= 1500L) {
            return 0.0f;
        }
        return Math.max(0.0f, 1.0f - (float)timeSinceDisabled / 1500.0f);
    }

    private static void renderSaturationOverlay(GuiGraphics graphics, Player player, ScreenRect barRect, int animOffset, boolean isRightAnchored, AnimationMetadata.AnimationData animData) {
        if (!PlatformUtil.isModLoaded("appleskin")) {
            return;
        }
        float saturation = player.m_36324_().m_38722_();
        if (saturation <= 0.0f) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float saturationPercent = Math.min(1.0f, saturation / 20.0f);
        FillDirection fillDirection = ModConfigManager.getClient().staminaFillDirection;
        float pulseAlpha = 0.5f + TickHandler.getOverlayFlashAlpha() * 0.5f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)pulseAlpha);
        ResourceLocation overlayTexture = DynamicResourceBars.loc("textures/gui/saturation_overlay.png");
        if (fillDirection == FillDirection.VERTICAL) {
            int overlayHeight = (int)((float)barRect.height() * saturationPercent);
            if (overlayHeight > 0) {
                RenderUtil.blitWithBinding(graphics, overlayTexture, barRect.x(), barRect.y() + (barRect.height() - overlayHeight), 0, 0, barRect.width(), overlayHeight, animData.textureWidth, animData.textureHeight);
            }
        } else {
            int overlayWidth = (int)((float)barRect.width() * saturationPercent);
            if (overlayWidth > 0) {
                int uTexOffset;
                int xPos;
                if (isRightAnchored) {
                    xPos = barRect.x() + barRect.width() - overlayWidth;
                    uTexOffset = barRect.width() - overlayWidth;
                } else {
                    xPos = barRect.x();
                    uTexOffset = 0;
                }
                if (uTexOffset < 0) {
                    uTexOffset = 0;
                }
                RenderUtil.blitWithBinding(graphics, overlayTexture, xPos, barRect.y(), uTexOffset, 0, overlayWidth, barRect.height(), animData.textureWidth, animData.textureHeight);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void renderHungerRestoredOverlay(GuiGraphics graphics, Player player, ItemStack heldFood, ScreenRect barRect, float partialTicks, int animOffset, boolean isRightAnchored, AnimationMetadata.AnimationData animData) {
        if (!PlatformUtil.isModLoaded("appleskin")) {
            return;
        }
        AppleSkinCompat.FoodData foodData = AppleSkinCompat.getFoodValues(heldFood, player);
        if (foodData.isEmpty()) {
            return;
        }
        float currentHunger = player.m_36324_().m_38702_();
        float restoredHunger = Math.min(20.0f, currentHunger + (float)foodData.hunger);
        if (restoredHunger <= currentHunger) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)TickHandler.getOverlayFlashAlpha());
        FillDirection fillDirection = ModConfigManager.getClient().staminaFillDirection;
        StaminaProvider provider = StaminaProviderManager.getCurrentProvider();
        String barTextureStr = "stamina_bar";
        if (provider instanceof FoodStaminaProvider) {
            barTextureStr = provider.getBarTexture(player, restoredHunger);
        }
        ResourceLocation barTexture = DynamicResourceBars.loc("textures/gui/" + barTextureStr + ".png");
        if (fillDirection == FillDirection.VERTICAL) {
            int currentHeight = (int)((float)barRect.height() * (currentHunger / 20.0f));
            int restoredHeight = (int)((float)barRect.height() * (restoredHunger / 20.0f));
            int overlayHeight = restoredHeight - currentHeight;
            if (overlayHeight > 0) {
                int yPos = barRect.y() + (barRect.height() - restoredHeight);
                int textureVOffset = animOffset + (barRect.height() - restoredHeight);
                RenderUtil.blitWithBinding(graphics, barTexture, barRect.x(), yPos, 0, textureVOffset, barRect.width(), overlayHeight, animData.textureWidth, animData.textureHeight);
            }
        } else {
            int currentWidth = (int)((float)barRect.width() * (currentHunger / 20.0f));
            int restoredWidth = (int)((float)barRect.width() * (restoredHunger / 20.0f));
            int overlayWidth = restoredWidth - currentWidth;
            if (overlayWidth > 0) {
                int uTexOffset;
                int xDrawPos;
                if (isRightAnchored) {
                    xDrawPos = barRect.x() + barRect.width() - restoredWidth;
                    uTexOffset = barRect.width() - restoredWidth;
                } else {
                    xDrawPos = barRect.x() + currentWidth;
                    uTexOffset = currentWidth;
                }
                if (uTexOffset < 0) {
                    uTexOffset = 0;
                }
                RenderUtil.blitWithBinding(graphics, barTexture, xDrawPos, barRect.y(), uTexOffset, animOffset, overlayWidth, barRect.height(), animData.textureWidth, animData.textureHeight);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static ItemStack getHeldFood(Player player) {
        ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
        if (AppleSkinCompat.canConsume(mainHand, player)) {
            return mainHand;
        }
        ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
        if (AppleSkinCompat.canConsume(offHand, player)) {
            return offHand;
        }
        return ItemStack.f_41583_;
    }

    private static boolean hasNourishmentEffect(Player player) {
        MobEffect nourishmentEffect = (MobEffect)ModEffects.NOURISHMENT.get();
        return player.m_21023_(nourishmentEffect);
    }

    public static boolean isVampire(Player player) {
        return false;
    }

    private static class BarValues {
        float current;
        float max;
        boolean isMounted;

        BarValues(float current, float max, boolean isMounted) {
            this.current = current;
            this.max = max;
            this.isMounted = isMounted;
        }
    }

    private static class FadingChunk {
        final float startValue;
        final float endValue;
        final float maxValue;
        final long creationTime;
        final String texture;
        final int animOffset;
        final boolean isMounted;

        FadingChunk(float startValue, float endValue, float maxValue, String texture, int animOffset, boolean isMounted) {
            this.startValue = startValue;
            this.endValue = endValue;
            this.maxValue = maxValue;
            this.creationTime = System.currentTimeMillis();
            this.texture = texture;
            this.animOffset = animOffset;
            this.isMounted = isMounted;
        }

        float getAlpha() {
            long elapsed = System.currentTimeMillis() - this.creationTime;
            if (elapsed >= 500L) {
                return 0.0f;
            }
            return 1.0f - (float)elapsed / 500.0f;
        }

        boolean isExpired() {
            return this.getAlpha() <= 0.0f;
        }
    }
}

