/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.util;

import dev.muon.dynamic_resource_bars.DynamicResourceBars;
import dev.muon.dynamic_resource_bars.util.AnimationMetadata;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class AnimationMetadataCache {
    private static final Map<ResourceLocation, AnimationMetadata.AnimationData> animationCache = new HashMap<ResourceLocation, AnimationMetadata.AnimationData>();
    private static final Map<ResourceLocation, AnimationMetadata.BarDimensions> dimensionsCache = new HashMap<ResourceLocation, AnimationMetadata.BarDimensions>();
    private static final Map<ResourceLocation, AnimationMetadata.ScalingInfo> scalingCache = new HashMap<ResourceLocation, AnimationMetadata.ScalingInfo>();
    private static final Map<ResourceLocation, AnimationMetadata.TextureDimensions> textureDimensionsCache = new HashMap<ResourceLocation, AnimationMetadata.TextureDimensions>();
    private static boolean needsRefresh = true;

    public static void markDirty() {
        needsRefresh = true;
        DynamicResourceBars.LOGGER.debug("Animation metadata cache marked for refresh");
    }

    public static void clear() {
        animationCache.clear();
        dimensionsCache.clear();
        scalingCache.clear();
        textureDimensionsCache.clear();
        needsRefresh = true;
        DynamicResourceBars.LOGGER.info("Texture metadata cache cleared");
    }

    public static AnimationMetadata.AnimationData getHealthBarAnimation() {
        ResourceLocation location = DynamicResourceBars.loc("textures/gui/health_bar.png");
        return AnimationMetadataCache.getOrLoad(location);
    }

    public static AnimationMetadata.AnimationData getStaminaBarAnimation() {
        ResourceLocation location = DynamicResourceBars.loc("textures/gui/stamina_bar.png");
        return AnimationMetadataCache.getOrLoad(location);
    }

    public static AnimationMetadata.AnimationData getManaBarAnimation() {
        ResourceLocation location = DynamicResourceBars.loc("textures/gui/mana_bar.png");
        return AnimationMetadataCache.getOrLoad(location);
    }

    public static AnimationMetadata.AnimationData getAirBarAnimation() {
        ResourceLocation location = DynamicResourceBars.loc("textures/gui/air_bar.png");
        return AnimationMetadataCache.getOrLoad(location);
    }

    private static AnimationMetadata.AnimationData getOrLoad(ResourceLocation location) {
        if (needsRefresh) {
            DynamicResourceBars.LOGGER.info("CACHE: Refreshing animation cache...");
            animationCache.clear();
            dimensionsCache.clear();
            scalingCache.clear();
            needsRefresh = false;
        }
        if (animationCache.containsKey(location)) {
            return animationCache.get(location);
        }
        DynamicResourceBars.LOGGER.info("CACHE: Loading and caching animation data for {}", (Object)location);
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        AnimationMetadata.AnimationData data = AnimationMetadata.loadAnimationData(resourceManager, location);
        animationCache.put(location, data);
        DynamicResourceBars.LOGGER.info("CACHE: Cached animation data for {}: frameHeight={}, totalFrames={}, textureSize={}x{}", (Object)location, (Object)data.frameHeight, (Object)data.totalFrames, (Object)data.textureWidth, (Object)data.textureHeight);
        return data;
    }

    public static AnimationMetadata.ScalingInfo getScalingOrLoad(ResourceLocation location, AnimationMetadata.TextureType textureType) {
        if (needsRefresh) {
            animationCache.clear();
            dimensionsCache.clear();
            scalingCache.clear();
            needsRefresh = false;
        }
        if (scalingCache.containsKey(location)) {
            return scalingCache.get(location);
        }
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        AnimationMetadata.ScalingInfo scalingInfo = AnimationMetadata.loadScalingInfo(resourceManager, location, textureType);
        scalingCache.put(location, scalingInfo);
        return scalingInfo;
    }

    public static AnimationMetadata.ScalingInfo getHealthBackgroundScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/health_background.png"), AnimationMetadata.TextureType.BACKGROUND);
    }

    public static AnimationMetadata.ScalingInfo getHealthForegroundScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/health_foreground.png"), AnimationMetadata.TextureType.FOREGROUND);
    }

    public static AnimationMetadata.ScalingInfo getManaBackgroundScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/mana_background.png"), AnimationMetadata.TextureType.BACKGROUND);
    }

    public static AnimationMetadata.ScalingInfo getManaForegroundScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/mana_foreground.png"), AnimationMetadata.TextureType.FOREGROUND);
    }

    public static AnimationMetadata.ScalingInfo getStaminaBackgroundScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/stamina_background.png"), AnimationMetadata.TextureType.BACKGROUND);
    }

    public static AnimationMetadata.ScalingInfo getStaminaForegroundScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/stamina_foreground.png"), AnimationMetadata.TextureType.FOREGROUND);
    }

    public static AnimationMetadata.ScalingInfo getAirBackgroundScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/air_background.png"), AnimationMetadata.TextureType.BACKGROUND);
    }

    public static AnimationMetadata.ScalingInfo getAbsorptionOverlayScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/absorption_overlay.png"), AnimationMetadata.TextureType.OVERLAY_ANIMATED);
    }

    public static AnimationMetadata.ScalingInfo getRegenerationOverlayScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/regeneration_overlay.png"), AnimationMetadata.TextureType.OVERLAY_ANIMATED);
    }

    public static AnimationMetadata.ScalingInfo getHeatOverlayScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/heat_overlay.png"), AnimationMetadata.TextureType.OVERLAY_ANIMATED);
    }

    public static AnimationMetadata.ScalingInfo getColdOverlayScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/cold_overlay.png"), AnimationMetadata.TextureType.OVERLAY_ANIMATED);
    }

    public static AnimationMetadata.ScalingInfo getWetnessOverlayScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/wetness_overlay.png"), AnimationMetadata.TextureType.OVERLAY_STATIC);
    }

    public static AnimationMetadata.ScalingInfo getHardcoreOverlayScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/hardcore_overlay.png"), AnimationMetadata.TextureType.OVERLAY_STATIC);
    }

    public static AnimationMetadata.ScalingInfo getComfortOverlayScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/comfort_overlay.png"), AnimationMetadata.TextureType.OVERLAY_ANIMATED);
    }

    public static AnimationMetadata.ScalingInfo getNourishmentOverlayScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/nourishment_overlay.png"), AnimationMetadata.TextureType.OVERLAY_ANIMATED);
    }

    public static AnimationMetadata.ScalingInfo getProtectionOverlayScaling() {
        return AnimationMetadataCache.getScalingOrLoad(DynamicResourceBars.loc("textures/gui/protection_overlay.png"), AnimationMetadata.TextureType.OVERLAY_ANIMATED);
    }

    public static AnimationMetadata.TextureDimensions getTextureDimensions(ResourceLocation location) {
        if (needsRefresh) {
            textureDimensionsCache.clear();
        }
        if (textureDimensionsCache.containsKey(location)) {
            return textureDimensionsCache.get(location);
        }
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        AnimationMetadata.TextureDimensions dims = AnimationMetadata.loadTextureDimensions(resourceManager, location);
        textureDimensionsCache.put(location, dims);
        return dims;
    }
}

