/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.util;

import dev.muon.dynamic_resource_bars.DynamicResourceBars;
import dev.muon.dynamic_resource_bars.util.DraggableElement;
import dev.muon.dynamic_resource_bars.util.SubElementType;

public class EditModeManager {
    private static boolean editModeEnabled = false;
    private static DraggableElement draggedElement = null;
    private static int dragStartX = 0;
    private static int dragStartY = 0;
    private static int initialElementXOffset = 0;
    private static int initialElementYOffset = 0;
    private static DraggableElement focusedElement = null;
    private static SubElementType draggedSubElement = null;
    private static int subElementDragStartX = 0;
    private static int subElementDragStartY = 0;
    private static int initialSubElementXOffset = 0;
    private static int initialSubElementYOffset = 0;
    private static DraggableElement keyboardSelectedElement = null;
    private static SubElementType keyboardSelectedSubElement = null;

    public static boolean isEditModeEnabled() {
        return editModeEnabled;
    }

    public static void toggleEditMode() {
        boolean bl = editModeEnabled = !editModeEnabled;
        if (!editModeEnabled) {
            EditModeManager.clearDraggedElement();
            EditModeManager.clearFocusedElement();
            EditModeManager.clearKeyboardSelectedElement();
            EditModeManager.clearKeyboardSelectedSubElement();
        } else {
            EditModeManager.clearDraggedElement();
            EditModeManager.clearFocusedElement();
            EditModeManager.clearKeyboardSelectedElement();
            EditModeManager.clearKeyboardSelectedSubElement();
        }
        DynamicResourceBars.LOGGER.debug("Edit Mode toggled: {}", (Object)(editModeEnabled ? "Enabled" : "Disabled"));
    }

    public static DraggableElement getDraggedElement() {
        return draggedElement;
    }

    public static void setDraggedElement(DraggableElement element, int mouseX, int mouseY, int currentTotalXOffset, int currentTotalYOffset) {
        if (!editModeEnabled) {
            return;
        }
        if (draggedSubElement != null || focusedElement != null) {
            return;
        }
        draggedElement = element;
        dragStartX = mouseX;
        dragStartY = mouseY;
        initialElementXOffset = currentTotalXOffset;
        initialElementYOffset = currentTotalYOffset;
    }

    public static void clearDraggedElement() {
        draggedElement = null;
    }

    public static int getDragStartX() {
        return dragStartX;
    }

    public static int getDragStartY() {
        return dragStartY;
    }

    public static int getInitialElementXOffset() {
        return initialElementXOffset;
    }

    public static int getInitialElementYOffset() {
        return initialElementYOffset;
    }

    public static DraggableElement getFocusedElement() {
        return focusedElement;
    }

    public static void setFocusedElement(DraggableElement element) {
        if (!editModeEnabled) {
            return;
        }
        focusedElement = element;
        EditModeManager.clearDraggedElement();
        EditModeManager.clearDraggedSubElement();
        EditModeManager.clearKeyboardSelectedElement();
        EditModeManager.clearKeyboardSelectedSubElement();
        DynamicResourceBars.LOGGER.debug("Focused element set to: {}", (Object)element);
    }

    public static void clearFocusedElement() {
        focusedElement = null;
        EditModeManager.clearDraggedSubElement();
        EditModeManager.clearKeyboardSelectedSubElement();
        DynamicResourceBars.LOGGER.debug("Focused element cleared.");
    }

    public static SubElementType getDraggedSubElement() {
        return draggedSubElement;
    }

    public static void setDraggedSubElement(SubElementType subElement, int mouseX, int mouseY, int currentSubElementX, int currentSubElementY) {
        if (!editModeEnabled || focusedElement == null) {
            return;
        }
        draggedSubElement = subElement;
        subElementDragStartX = mouseX;
        subElementDragStartY = mouseY;
        initialSubElementXOffset = currentSubElementX;
        initialSubElementYOffset = currentSubElementY;
        DynamicResourceBars.LOGGER.debug("Dragging sub-element: {} of bar: {}", (Object)subElement, (Object)focusedElement);
    }

    public static void clearDraggedSubElement() {
        draggedSubElement = null;
    }

    public static int getSubElementDragStartX() {
        return subElementDragStartX;
    }

    public static int getSubElementDragStartY() {
        return subElementDragStartY;
    }

    public static int getInitialSubElementXOffset() {
        return initialSubElementXOffset;
    }

    public static int getInitialSubElementYOffset() {
        return initialSubElementYOffset;
    }

    public static DraggableElement getKeyboardSelectedElement() {
        return keyboardSelectedElement;
    }

    public static void setKeyboardSelectedElement(DraggableElement element) {
        if (!editModeEnabled) {
            return;
        }
        keyboardSelectedElement = element;
        DynamicResourceBars.LOGGER.debug("Keyboard selected element: {}", (Object)element);
    }

    public static void clearKeyboardSelectedElement() {
        keyboardSelectedElement = null;
    }

    public static SubElementType getKeyboardSelectedSubElement() {
        return keyboardSelectedSubElement;
    }

    public static void setKeyboardSelectedSubElement(SubElementType subElement) {
        if (!editModeEnabled || focusedElement == null) {
            return;
        }
        keyboardSelectedSubElement = subElement;
        DynamicResourceBars.LOGGER.debug("Keyboard selected sub-element: {} of bar: {}", (Object)subElement, (Object)focusedElement);
    }

    public static void clearKeyboardSelectedSubElement() {
        keyboardSelectedSubElement = null;
    }
}

