/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.util;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.util.HorizontalAlignment;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class RenderUtil {
    public static final long BAR_FADEOUT_DURATION = 1500L;
    public static final long TEXT_DISPLAY_DURATION = 2000L;
    public static final long TEXT_FADEOUT_DURATION = 500L;
    public static final int BASE_TEXT_ALPHA = 200;

    public static void renderText(float current, float max, GuiGraphics graphics, int baseX, int baseY, int color, HorizontalAlignment alignment) {
        Minecraft minecraft = Minecraft.m_91087_();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        float scalingFactor = (float)ModConfigManager.getClient().textScalingFactor;
        float globalTextSize = ModConfigManager.getClient().globalTextSize;
        float finalScale = scalingFactor * globalTextSize;
        poseStack.m_85841_(finalScale, finalScale, 1.0f);
        int scaledX = (int)((float)baseX / finalScale);
        int n = (int)((float)baseY / finalScale);
        Objects.requireNonNull(minecraft.f_91062_);
        int scaledY = n - 9 / 2;
        String currentText = String.valueOf((int)current);
        String maxText = String.valueOf((int)max);
        String slashText = " / ";
        MutableComponent fullTextComponent = Component.m_237113_((String)(currentText + slashText + maxText));
        String fullText = fullTextComponent.getString();
        int totalTextWidth = minecraft.f_91062_.m_92895_(fullText);
        int actualX = scaledX;
        if (alignment == HorizontalAlignment.CENTER) {
            actualX = scaledX - totalTextWidth / 2;
        } else if (alignment == HorizontalAlignment.RIGHT) {
            actualX = scaledX - totalTextWidth;
        }
        graphics.m_280614_(minecraft.f_91062_, (Component)fullTextComponent, actualX, scaledY, color, true);
        poseStack.m_85849_();
    }

    public static void renderText(float current, float max, GuiGraphics graphics, int baseX, int baseY, int color) {
        RenderUtil.renderText(current, max, graphics, baseX, baseY, color, HorizontalAlignment.CENTER);
    }

    public static void renderAdditionText(String text, GuiGraphics graphics, int baseX, int baseY, int color) {
        Minecraft minecraft = Minecraft.m_91087_();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        float scalingFactor = (float)ModConfigManager.getClient().textScalingFactor;
        float globalTextSize = ModConfigManager.getClient().globalTextSize;
        float finalScale = scalingFactor * globalTextSize;
        int xPos = (int)((float)baseX / finalScale);
        int n = (int)((float)baseY / finalScale);
        Objects.requireNonNull(minecraft.f_91062_);
        int yPos = n - 9 / 2;
        poseStack.m_85841_(finalScale, finalScale, 1.0f);
        graphics.m_280056_(minecraft.f_91062_, text, xPos, yPos, color, true);
        poseStack.m_85849_();
    }

    public static void renderArmorText(float value, GuiGraphics graphics, int baseX, int baseY, int color, HorizontalAlignment alignment) {
        Minecraft minecraft = Minecraft.m_91087_();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        float scalingFactor = (float)ModConfigManager.getClient().textScalingFactor;
        float globalTextSize = ModConfigManager.getClient().globalTextSize;
        float finalScale = scalingFactor * globalTextSize;
        int scaledX = (int)((float)baseX / finalScale);
        int n = (int)((float)baseY / finalScale);
        Objects.requireNonNull(minecraft.f_91062_);
        int scaledY = n - 9 / 2;
        poseStack.m_85841_(finalScale, finalScale, 1.0f);
        String text = Math.abs((double)value - Math.floor(value)) < (double)0.1f ? String.valueOf((int)value) : String.format("%.1f", Float.valueOf(value));
        int textWidth = minecraft.f_91062_.m_92895_(text);
        int actualX = scaledX;
        if (alignment == HorizontalAlignment.CENTER) {
            actualX = scaledX - textWidth / 2;
        } else if (alignment == HorizontalAlignment.RIGHT) {
            actualX = scaledX - textWidth;
        }
        graphics.m_280056_(minecraft.f_91062_, text, actualX, scaledY, color, true);
        poseStack.m_85849_();
    }

    public static void renderArmorText(float value, GuiGraphics graphics, int baseX, int baseY, int color) {
        RenderUtil.renderArmorText(value, graphics, baseX, baseY, color, HorizontalAlignment.CENTER);
    }

    public static int calculateTextAlpha(long timeSinceEvent) {
        int alpha = timeSinceEvent < 2000L ? (timeSinceEvent > 1500L ? (int)(200L * (2000L - timeSinceEvent) / 500L) : 200) : 0;
        return Math.max(10, Math.min(alpha, 200));
    }

    public static void blitWithBinding(GuiGraphics graphics, ResourceLocation texture, int x, int y, int uOffset, int vOffset, int width, int height, int textureWidth, int textureHeight) {
        try {
            TextureManager textureManager = Minecraft.m_91087_().m_91097_();
            textureManager.m_174784_(texture);
        }
        catch (Exception exception) {
            // empty catch block
        }
        graphics.m_280163_(texture, x, y, (float)uOffset, (float)vOffset, width, height, textureWidth, textureHeight);
    }
}

