/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.provider;

import dev.muon.dynamic_resource_bars.provider.ManaProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class ManaProviderRegistry {
    private static final List<Supplier<ManaProvider>> registeredProviders = new ArrayList<Supplier<ManaProvider>>();
    private static ManaProvider activeProvider = null;

    public static void registerProvider(Supplier<ManaProvider> providerSupplier) {
        registeredProviders.add(providerSupplier);
        if (activeProvider == null) {
            ManaProviderRegistry.setActiveProvider(providerSupplier.get());
        }
    }

    public static void setActiveProvider(@Nullable ManaProvider provider) {
        activeProvider = provider;
    }

    @Nullable
    public static ManaProvider getActiveProvider() {
        if (activeProvider == null && !registeredProviders.isEmpty()) {
            ManaProviderRegistry.setActiveProvider(registeredProviders.get(0).get());
        }
        return activeProvider;
    }

    public static boolean hasProviders() {
        return !registeredProviders.isEmpty();
    }

    public static List<Supplier<ManaProvider>> getRegisteredProviders() {
        return List.copyOf(registeredProviders);
    }

    public static void clear() {
        registeredProviders.clear();
        activeProvider = null;
    }
}

