/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.muon.dynamic_resource_bars.DynamicResourceBars;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class AnimationMetadata {
    /*
     * Enabled aggressive exception aggregation
     */
    public static AnimationData loadAnimationData(class_3300 resourceManager, class_2960 textureLocation) {
        int frameHeight;
        boolean interpolate;
        JsonObject root;
        BufferedReader reader;
        TextureDimensions textureDims;
        block16: {
            AnimationData animationData;
            DynamicResourceBars.LOGGER.info("ANIM_LOAD: Starting animation data load for: {}", (Object)textureLocation);
            class_2960 mcmetaLocation = class_2960.method_60655((String)textureLocation.method_12836(), (String)(textureLocation.method_12832() + ".mcmeta"));
            DynamicResourceBars.LOGGER.info("ANIM_LOAD: Looking for .mcmeta at: {}", (Object)mcmetaLocation);
            int DEFAULT_FRAMETIME = 3;
            int DEFAULT_FRAME_HEIGHT = 32;
            int DEFAULT_TOTAL_FRAMES = 32;
            boolean DEFAULT_INTERPOLATE = false;
            textureDims = AnimationMetadata.loadTextureDimensions(resourceManager, textureLocation);
            DynamicResourceBars.LOGGER.info("ANIM_LOAD: Texture dimensions loaded: {}x{}", (Object)textureDims.width, (Object)textureDims.height);
            Optional resourceOpt = resourceManager.method_14486(mcmetaLocation);
            if (resourceOpt.isEmpty()) {
                DynamicResourceBars.LOGGER.info("ANIM_LOAD: No .mcmeta found for {}, using hardcoded defaults (frametime={}, frameHeight={}, totalFrames={})", (Object)textureLocation, (Object)3, (Object)32, (Object)32);
                return new AnimationData(3, 32, 32, false, textureDims.width, textureDims.height);
            }
            DynamicResourceBars.LOGGER.info("ANIM_LOAD: .mcmeta resource found, parsing JSON...");
            class_3298 resource = (class_3298)resourceOpt.get();
            reader = new BufferedReader(new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8));
            try {
                root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                DynamicResourceBars.LOGGER.info("ANIM_LOAD: JSON parsed successfully, checking for 'animation' section...");
                if (root.has("animation")) break block16;
                DynamicResourceBars.LOGGER.info("ANIM_LOAD: INVALID .mcmeta for {}: Missing 'animation' section! Using defaults.", (Object)textureLocation);
                animationData = new AnimationData(3, 32, 32, false, textureDims.width, textureDims.height);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    try {
                        DynamicResourceBars.LOGGER.info("ANIM_LOAD: ERROR parsing .mcmeta for {}: {} ({}). Using hardcoded defaults.", (Object)textureLocation, (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
                        e.printStackTrace();
                        return new AnimationData(3, 32, 32, false, textureDims.width, textureDims.height);
                    }
                    catch (Exception e2) {
                        DynamicResourceBars.LOGGER.info("ANIM_LOAD: ERROR loading .mcmeta for {}: {} ({}). Using hardcoded defaults.", (Object)textureLocation, (Object)e2.getClass().getSimpleName(), (Object)e2.getMessage());
                        e2.printStackTrace();
                        return new AnimationData(3, 32, 32, false, textureDims.width, textureDims.height);
                    }
                }
            }
            reader.close();
            return animationData;
        }
        JsonObject animation = root.getAsJsonObject("animation");
        DynamicResourceBars.LOGGER.info("ANIM_LOAD: Found 'animation' section");
        int frametime = animation.has("frametime") ? animation.get("frametime").getAsInt() : 3;
        boolean bl = interpolate = animation.has("interpolate") && animation.get("interpolate").getAsBoolean();
        if (animation.has("height")) {
            frameHeight = animation.get("height").getAsInt();
            DynamicResourceBars.LOGGER.info("ANIM_LOAD: Frame height from 'height' field: {}", (Object)frameHeight);
        } else if (animation.has("frameHeight")) {
            frameHeight = animation.get("frameHeight").getAsInt();
            DynamicResourceBars.LOGGER.info("ANIM_LOAD: Frame height from 'frameHeight' field: {}", (Object)frameHeight);
        } else {
            DynamicResourceBars.LOGGER.info("ANIM_LOAD: INVALID .mcmeta for {}: Missing 'height' field! Using default ({}px).", (Object)textureLocation, (Object)32);
            frameHeight = 32;
        }
        int totalFrames = textureDims.height / frameHeight;
        DynamicResourceBars.LOGGER.info("ANIM_LOAD: Calculated totalFrames = {} / {} = {}", (Object)textureDims.height, (Object)frameHeight, (Object)totalFrames);
        DynamicResourceBars.LOGGER.info("ANIM_LOAD: Successfully loaded animation data for {}: frametime={}, frameHeight={}, totalFrames={}, textureSize={}x{}, interpolate={}", (Object)textureLocation, (Object)frametime, (Object)frameHeight, (Object)totalFrames, (Object)textureDims.width, (Object)textureDims.height, (Object)interpolate);
        AnimationData animationData = new AnimationData(frametime, frameHeight, totalFrames, interpolate, textureDims.width, textureDims.height);
        reader.close();
        return animationData;
    }

    public static TextureDimensions loadTextureDimensions(class_3300 resourceManager, class_2960 textureLocation) {
        TextureDimensions textureDimensions;
        block9: {
            int DEFAULT_WIDTH = 256;
            int DEFAULT_HEIGHT = 1024;
            DynamicResourceBars.LOGGER.info("DIMENSION_LOAD: Attempting to load texture dimensions for: {}", (Object)textureLocation);
            Optional resourceOpt = resourceManager.method_14486(textureLocation);
            if (resourceOpt.isEmpty()) {
                DynamicResourceBars.LOGGER.info("DIMENSION_LOAD: Texture not found: {}. Using default dimensions {}x{}", (Object)textureLocation, (Object)256, (Object)1024);
                return new TextureDimensions(256, 1024);
            }
            DynamicResourceBars.LOGGER.info("DIMENSION_LOAD: Resource found for {}, attempting to read PNG...", (Object)textureLocation);
            InputStream stream = ((class_3298)resourceOpt.get()).method_14482();
            try {
                class_1011 image = class_1011.method_4309((InputStream)stream);
                int width = image.method_4307();
                int height = image.method_4323();
                image.close();
                DynamicResourceBars.LOGGER.info("DIMENSION_LOAD: Successfully detected texture dimensions for {}: {}x{}", (Object)textureLocation, (Object)width, (Object)height);
                textureDimensions = new TextureDimensions(width, height);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    DynamicResourceBars.LOGGER.info("DIMENSION_LOAD: ERROR loading texture dimensions for {}: {} ({}). Using defaults {}x{}", (Object)textureLocation, (Object)e.getClass().getSimpleName(), (Object)e.getMessage(), (Object)256, (Object)1024);
                    e.printStackTrace();
                    return new TextureDimensions(256, 1024);
                }
            }
            stream.close();
        }
        return textureDimensions;
    }

    public static int calculateAnimationOffset(AnimationData data, float ticks) {
        int currentFrame = (int)(ticks / (float)data.frametime % (float)data.totalFrames);
        return currentFrame * data.frameHeight;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static BarDimensions loadBarDimensions(class_3300 resourceManager, class_2960 textureLocation) {
        JsonObject bar;
        BufferedReader reader;
        block16: {
            JsonObject custom;
            block15: {
                JsonObject root;
                block14: {
                    BarDimensions barDimensions;
                    class_2960 mcmetaLocation = class_2960.method_60655((String)textureLocation.method_12836(), (String)(textureLocation.method_12832() + ".mcmeta"));
                    Optional resourceOpt = resourceManager.method_14486(mcmetaLocation);
                    if (resourceOpt.isEmpty()) {
                        return null;
                    }
                    class_3298 resource = (class_3298)resourceOpt.get();
                    reader = new BufferedReader(new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8));
                    try {
                        root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        if (root.has("dynamic_resource_bars")) break block14;
                        barDimensions = null;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            try {
                                DynamicResourceBars.LOGGER.error("ERROR parsing bar dimensions for {}: {}", (Object)textureLocation, (Object)e.getMessage());
                                return null;
                            }
                            catch (Exception e2) {
                                return null;
                            }
                        }
                    }
                    reader.close();
                    return barDimensions;
                }
                custom = root.getAsJsonObject("dynamic_resource_bars");
                if (custom.has("bar")) break block15;
                BarDimensions barDimensions = null;
                reader.close();
                return barDimensions;
            }
            bar = custom.getAsJsonObject("bar");
            if (bar.has("width") && bar.has("height")) break block16;
            DynamicResourceBars.LOGGER.error("INVALID bar dimensions in .mcmeta for {}: missing width or height", (Object)textureLocation);
            BarDimensions barDimensions = null;
            reader.close();
            return barDimensions;
        }
        int width = bar.get("width").getAsInt();
        int height = bar.get("height").getAsInt();
        DynamicResourceBars.LOGGER.info("Loaded bar dimensions from .mcmeta for {}: {}x{}", (Object)textureLocation, (Object)width, (Object)height);
        BarDimensions barDimensions = new BarDimensions(width, height, true);
        reader.close();
        return barDimensions;
    }

    /*
     * Exception decompiling
     */
    public static ScalingInfo loadScalingInfo(class_3300 resourceManager, class_2960 textureLocation, TextureType textureType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 30[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ScalingInfo getDefaultScaling(TextureType type) {
        switch (type.ordinal()) {
            case 0: {
                DynamicResourceBars.LOGGER.warn("Scaling requested for BAR texture - bars should use UV sampling, not scaling!");
                return ScalingInfo.stretch();
            }
            case 1: 
            case 2: {
                return ScalingInfo.nineSlice(4, 4, 3, 3, ScalingMode.STRETCH, ScalingMode.STRETCH);
            }
            case 3: {
                return ScalingInfo.stretch();
            }
            case 4: {
                return ScalingInfo.nineSlice(3, 3, 2, 2, ScalingMode.TILE, ScalingMode.TILE);
            }
        }
        return ScalingInfo.stretch();
    }

    private static SourceRegion parseSourceRegion(JsonObject source, class_2960 textureLocation) {
        if (source.has("width") && source.has("height")) {
            int u = source.has("u") ? source.get("u").getAsInt() : 0;
            int v = source.has("v") ? source.get("v").getAsInt() : 0;
            int width = source.get("width").getAsInt();
            int height = source.get("height").getAsInt();
            DynamicResourceBars.LOGGER.info("Loaded source region for {}: u={}, v={}, {}x{}", (Object)textureLocation, (Object)u, (Object)v, (Object)width, (Object)height);
            return new SourceRegion(u, v, width, height);
        }
        return null;
    }

    public static class TextureDimensions {
        public final int width;
        public final int height;

        public TextureDimensions(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    public static class AnimationData {
        public final int frametime;
        public final int frameHeight;
        public final int totalFrames;
        public final boolean interpolate;
        public final int textureWidth;
        public final int textureHeight;

        public AnimationData(int frametime, int frameHeight, int totalFrames, boolean interpolate, int textureWidth, int textureHeight) {
            this.frametime = frametime;
            this.frameHeight = frameHeight;
            this.totalFrames = totalFrames;
            this.interpolate = interpolate;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
        }
    }

    public static class BarDimensions {
        public final int width;
        public final int height;
        public final boolean fromMcmeta;

        public BarDimensions(int width, int height, boolean fromMcmeta) {
            this.width = width;
            this.height = height;
            this.fromMcmeta = fromMcmeta;
        }
    }

    public static enum TextureType {
        BAR,
        BACKGROUND,
        FOREGROUND,
        OVERLAY_STATIC,
        OVERLAY_ANIMATED;

    }

    public static class ScalingInfo {
        public final ScalingMode mode;
        public final NineSliceData nineSlice;
        public final SourceRegion sourceRegion;

        private ScalingInfo(ScalingMode mode, NineSliceData nineSlice, SourceRegion sourceRegion) {
            this.mode = mode;
            this.nineSlice = nineSlice;
            this.sourceRegion = sourceRegion;
        }

        public static ScalingInfo none() {
            return new ScalingInfo(ScalingMode.NONE, null, null);
        }

        public static ScalingInfo none(SourceRegion sourceRegion) {
            return new ScalingInfo(ScalingMode.NONE, null, sourceRegion);
        }

        public static ScalingInfo stretch() {
            return new ScalingInfo(ScalingMode.STRETCH, null, null);
        }

        public static ScalingInfo stretch(SourceRegion sourceRegion) {
            return new ScalingInfo(ScalingMode.STRETCH, null, sourceRegion);
        }

        public static ScalingInfo tile() {
            return new ScalingInfo(ScalingMode.TILE, null, null);
        }

        public static ScalingInfo tile(SourceRegion sourceRegion) {
            return new ScalingInfo(ScalingMode.TILE, null, sourceRegion);
        }

        public static ScalingInfo nineSlice(int left, int right, int top, int bottom, ScalingMode edgeMode, ScalingMode centerMode) {
            return new ScalingInfo(ScalingMode.NINE_SLICE, new NineSliceData(left, right, top, bottom, edgeMode, centerMode, null), null);
        }

        public static ScalingInfo nineSlice(int left, int right, int top, int bottom, ScalingMode edgeMode, ScalingMode centerMode, SourceRegion sourceRegion) {
            return new ScalingInfo(ScalingMode.NINE_SLICE, new NineSliceData(left, right, top, bottom, edgeMode, centerMode, sourceRegion), sourceRegion);
        }

        public boolean isNineSlice() {
            return this.mode == ScalingMode.NINE_SLICE && this.nineSlice != null;
        }
    }

    public static class SourceRegion {
        public final int u;
        public final int v;
        public final int width;
        public final int height;

        public SourceRegion(int u, int v, int width, int height) {
            this.u = u;
            this.v = v;
            this.width = width;
            this.height = height;
        }

        public static SourceRegion fullTexture(int width, int height) {
            return new SourceRegion(0, 0, width, height);
        }
    }

    public static enum ScalingMode {
        NONE,
        STRETCH,
        TILE,
        NINE_SLICE;

    }

    public static class NineSliceData {
        public final int left;
        public final int right;
        public final int top;
        public final int bottom;
        public final ScalingMode edgeMode;
        public final ScalingMode centerMode;
        public final SourceRegion sourceRegion;

        public NineSliceData(int left, int right, int top, int bottom, ScalingMode edgeMode, ScalingMode centerMode, SourceRegion sourceRegion) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
            this.edgeMode = edgeMode;
            this.centerMode = centerMode;
            this.sourceRegion = sourceRegion;
        }
    }
}

