/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.util;

import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.util.HorizontalAlignment;
import java.util.Objects;
import net.minecraft.class_1060;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class RenderUtil {
    public static final long BAR_FADEOUT_DURATION = 1500L;
    public static final long TEXT_DISPLAY_DURATION = 2000L;
    public static final long TEXT_FADEOUT_DURATION = 500L;
    public static final int BASE_TEXT_ALPHA = 200;

    public static void renderText(float current, float max, class_332 graphics, int baseX, int baseY, int color, HorizontalAlignment alignment) {
        class_310 minecraft = class_310.method_1551();
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        float scalingFactor = (float)ModConfigManager.getClient().textScalingFactor;
        float globalTextSize = ModConfigManager.getClient().globalTextSize;
        float finalScale = scalingFactor * globalTextSize;
        poseStack.method_22905(finalScale, finalScale, 1.0f);
        int scaledX = (int)((float)baseX / finalScale);
        int n = (int)((float)baseY / finalScale);
        Objects.requireNonNull(minecraft.field_1772);
        int scaledY = n - 9 / 2;
        String currentText = String.valueOf((int)current);
        String maxText = String.valueOf((int)max);
        String slashText = " / ";
        class_5250 fullTextComponent = class_2561.method_43470((String)(currentText + slashText + maxText));
        String fullText = fullTextComponent.getString();
        int totalTextWidth = minecraft.field_1772.method_1727(fullText);
        int actualX = scaledX;
        if (alignment == HorizontalAlignment.CENTER) {
            actualX = scaledX - totalTextWidth / 2;
        } else if (alignment == HorizontalAlignment.RIGHT) {
            actualX = scaledX - totalTextWidth;
        }
        graphics.method_51439(minecraft.field_1772, (class_2561)fullTextComponent, actualX, scaledY, color, true);
        poseStack.method_22909();
    }

    public static void renderText(float current, float max, class_332 graphics, int baseX, int baseY, int color) {
        RenderUtil.renderText(current, max, graphics, baseX, baseY, color, HorizontalAlignment.CENTER);
    }

    public static void renderAdditionText(String text, class_332 graphics, int baseX, int baseY, int color) {
        class_310 minecraft = class_310.method_1551();
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        float scalingFactor = (float)ModConfigManager.getClient().textScalingFactor;
        float globalTextSize = ModConfigManager.getClient().globalTextSize;
        float finalScale = scalingFactor * globalTextSize;
        int xPos = (int)((float)baseX / finalScale);
        int n = (int)((float)baseY / finalScale);
        Objects.requireNonNull(minecraft.field_1772);
        int yPos = n - 9 / 2;
        poseStack.method_22905(finalScale, finalScale, 1.0f);
        graphics.method_51433(minecraft.field_1772, text, xPos, yPos, color, true);
        poseStack.method_22909();
    }

    public static void renderArmorText(float value, class_332 graphics, int baseX, int baseY, int color, HorizontalAlignment alignment) {
        class_310 minecraft = class_310.method_1551();
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        float scalingFactor = (float)ModConfigManager.getClient().textScalingFactor;
        float globalTextSize = ModConfigManager.getClient().globalTextSize;
        float finalScale = scalingFactor * globalTextSize;
        int scaledX = (int)((float)baseX / finalScale);
        int n = (int)((float)baseY / finalScale);
        Objects.requireNonNull(minecraft.field_1772);
        int scaledY = n - 9 / 2;
        poseStack.method_22905(finalScale, finalScale, 1.0f);
        String text = Math.abs((double)value - Math.floor(value)) < (double)0.1f ? String.valueOf((int)value) : String.format("%.1f", Float.valueOf(value));
        int textWidth = minecraft.field_1772.method_1727(text);
        int actualX = scaledX;
        if (alignment == HorizontalAlignment.CENTER) {
            actualX = scaledX - textWidth / 2;
        } else if (alignment == HorizontalAlignment.RIGHT) {
            actualX = scaledX - textWidth;
        }
        graphics.method_51433(minecraft.field_1772, text, actualX, scaledY, color, true);
        poseStack.method_22909();
    }

    public static void renderArmorText(float value, class_332 graphics, int baseX, int baseY, int color) {
        RenderUtil.renderArmorText(value, graphics, baseX, baseY, color, HorizontalAlignment.CENTER);
    }

    public static int calculateTextAlpha(long timeSinceEvent) {
        int alpha = timeSinceEvent < 2000L ? (timeSinceEvent > 1500L ? (int)(200L * (2000L - timeSinceEvent) / 500L) : 200) : 0;
        return Math.max(10, Math.min(alpha, 200));
    }

    public static void blitWithBinding(class_332 graphics, class_2960 texture, int x, int y, int uOffset, int vOffset, int width, int height, int textureWidth, int textureHeight) {
        try {
            class_1060 textureManager = class_310.method_1551().method_1531();
            textureManager.method_22813(texture);
        }
        catch (Exception exception) {
            // empty catch block
        }
        graphics.method_25290(texture, x, y, (float)uOffset, (float)vOffset, width, height, textureWidth, textureHeight);
    }
}

