/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars;

import dev.muon.dynamic_resource_bars.compat.AppleSkinEventHandler;
import dev.muon.dynamic_resource_bars.compat.ManaProviderManager;
import dev.muon.dynamic_resource_bars.compat.StaminaProviderManager;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.config.gui.ModConfigScreen;
import dev.muon.dynamic_resource_bars.event.CommonEvents;
import dev.muon.dynamic_resource_bars.util.AnimationCacheReloadListener;
import dev.muon.dynamic_resource_bars.util.PlatformUtil;
import dev.muon.dynamic_resource_bars.util.TickHandler;
import fuzs.puzzleslib.api.client.event.v1.gui.RenderGuiLayerEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dynamic_resource_bars")
public class DynamicResourceBars {
    public static final String MODNAME = "Dynamic RPG Resource Bars";
    public static final String ID = "dynamic_resource_bars";
    public static final Logger LOGGER = LogManager.getLogger((String)"Dynamic RPG Resource Bars");

    public static ResourceLocation loc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public DynamicResourceBars(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::registerReloadListeners);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(mc, screen) -> new ModConfigScreen(screen)));
        RenderGuiLayerEvents.before((ResourceLocation)RenderGuiLayerEvents.PLAYER_HEALTH).register(CommonEvents::onRenderPlayerHealth);
        RenderGuiLayerEvents.before((ResourceLocation)RenderGuiLayerEvents.FOOD_LEVEL).register(CommonEvents::onRenderHunger);
        RenderGuiLayerEvents.before((ResourceLocation)RenderGuiLayerEvents.ARMOR_LEVEL).register(CommonEvents::onRenderArmor);
        RenderGuiLayerEvents.before((ResourceLocation)RenderGuiLayerEvents.AIR_LEVEL).register(CommonEvents::onRenderAir);
        RenderGuiLayerEvents.before((ResourceLocation)RenderGuiLayerEvents.VEHICLE_HEALTH).register(CommonEvents::onRenderMountHealth);
    }

    public void onInitializeClient() {
        ModConfigManager.initializeConfig();
        ManaProviderManager.initialize();
        StaminaProviderManager.initialize();
        if (PlatformUtil.isModLoaded("appleskin")) {
            AppleSkinEventHandler.register();
            LOGGER.info("AppleSkin detected, registering event handlers.");
        }
    }

    public void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> this.onInitializeClient());
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public void registerReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new AnimationCacheReloadListener());
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post event) {
        TickHandler.onClientTick();
    }
}

