/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.compat;

import dev.muon.dynamic_resource_bars.util.PlatformUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import squeek.appleskin.helpers.FoodHelper;

public class AppleSkinCompat {
    private static final boolean APPLESKIN_LOADED = PlatformUtil.isModLoaded("appleskin");

    public static boolean isLoaded() {
        return APPLESKIN_LOADED;
    }

    public static FoodData getFoodValues(ItemStack stack, Player player) {
        if (!APPLESKIN_LOADED || stack.isEmpty() || !AppleSkinCompat.canConsume(stack, player)) {
            return FoodData.EMPTY;
        }
        FoodHelper.QueriedFoodResult queriedResult = FoodHelper.query((ItemStack)stack, (Player)player);
        if (queriedResult == null) {
            return FoodData.EMPTY;
        }
        return new FoodData(queriedResult.modifiedFoodProperties.nutrition(), queriedResult.modifiedFoodProperties.saturation());
    }

    public static boolean canConsume(ItemStack stack, Player player) {
        if (!APPLESKIN_LOADED || stack.isEmpty()) {
            return false;
        }
        FoodHelper.QueriedFoodResult result = FoodHelper.query((ItemStack)stack, (Player)player);
        return result != null && FoodHelper.canConsume((Player)player, (FoodProperties)result.modifiedFoodProperties);
    }

    public static float getEstimatedHealthRestoration(ItemStack stack, Player player) {
        if (!APPLESKIN_LOADED || !AppleSkinCompat.canConsume(stack, player)) {
            return 0.0f;
        }
        FoodHelper.QueriedFoodResult queriedResult = FoodHelper.query((ItemStack)stack, (Player)player);
        if (queriedResult == null) {
            return 0.0f;
        }
        return FoodHelper.getEstimatedHealthIncrement((Player)player, (FoodProperties)queriedResult.modifiedFoodProperties);
    }

    public static class FoodData {
        public static final FoodData EMPTY = new FoodData(0, 0.0f);
        public final int hunger;
        public final float saturation;

        public FoodData(int hunger, float saturation) {
            this.hunger = hunger;
            this.saturation = saturation;
        }

        public boolean isEmpty() {
            return this.hunger <= 0 && this.saturation <= 0.0f;
        }
    }
}

