/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.compat;

import dev.muon.dynamic_resource_bars.provider.StaminaProvider;
import dev.muon.dynamic_resource_bars.util.PlatformUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class FoodStaminaProvider
implements StaminaProvider {
    @Override
    public float getCurrentStamina(Player player) {
        return player.getFoodData().getFoodLevel();
    }

    @Override
    public float getMaxStamina(Player player) {
        return 20.0f;
    }

    @Override
    public long getGameTime() {
        if (Minecraft.getInstance().level != null) {
            return Minecraft.getInstance().level.getGameTime();
        }
        return 0L;
    }

    @Override
    public String getBarTexture(Player player, float currentValue) {
        if (PlatformUtil.isModLoaded("farmersdelight") && this.hasNourishmentEffect(player)) {
            return "stamina_bar_nourished";
        }
        if (player.hasEffect(MobEffects.HUNGER)) {
            return "stamina_bar_hunger";
        }
        if (currentValue <= 6.0f) {
            return "stamina_bar_critical";
        }
        return "stamina_bar";
    }

    @Override
    public boolean shouldShowOverlays() {
        return true;
    }

    private boolean hasNourishmentEffect(Player player) {
        Holder nourishmentEffect = ModEffects.NOURISHMENT;
        return player.hasEffect(nourishmentEffect);
    }
}

