/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.config.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.muon.dynamic_resource_bars.config.gui.ContextMenuItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.FormattedText;

public class ContextMenu
implements Renderable,
GuiEventListener {
    private static final int BACKGROUND_COLOR = -536870912;
    private static final int HOVER_COLOR = -2130706433;
    private static final int BORDER_COLOR = -12566464;
    private static final float SCALE_FACTOR = 0.5f;
    private static final int PADDING = 3;
    private static final int ITEM_HEIGHT = 9;
    private static final int MIN_WIDTH = 100;
    private final List<ContextMenuItem> items;
    private final int x;
    private final int y;
    private int width;
    private int height;
    private int hoveredIndex = -1;
    private boolean visible = true;
    private Runnable onClose;

    public ContextMenu(int x, int y, List<ContextMenuItem> items) {
        this.items = new ArrayList<ContextMenuItem>(items);
        this.calculateDimensions();
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        if (x + this.width > screenWidth) {
            x = screenWidth - this.width - 2;
        }
        if (x < 0) {
            x = 2;
        }
        if (y + this.height > screenHeight) {
            y = screenHeight - this.height - 2;
        }
        if (y < 0) {
            y = 2;
        }
        this.x = x;
        this.y = y;
    }

    private void calculateDimensions() {
        Font font = Minecraft.getInstance().font;
        int maxWidth = 100;
        for (ContextMenuItem item : this.items) {
            if (item.getLabel().getString().isEmpty()) continue;
            int labelWidth = (int)((float)(font.width((FormattedText)item.getLabel()) + 6) * 0.5f);
            maxWidth = Math.max(maxWidth, labelWidth);
        }
        this.width = maxWidth;
        this.height = this.items.size() * 9 + 6;
    }

    public void setOnClose(Runnable onClose) {
        this.onClose = onClose;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        RenderSystem.enableBlend();
        graphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, -536870912);
        graphics.fill(this.x, this.y, this.x + this.width, this.y + 1, -12566464);
        graphics.fill(this.x, this.y + this.height - 1, this.x + this.width, this.y + this.height, -12566464);
        graphics.fill(this.x, this.y, this.x + 1, this.y + this.height, -12566464);
        graphics.fill(this.x + this.width - 1, this.y, this.x + this.width, this.y + this.height, -12566464);
        this.updateHoveredIndex(mouseX, mouseY);
        Font font = Minecraft.getInstance().font;
        int itemY = this.y + 3;
        graphics.pose().pushPose();
        for (int i = 0; i < this.items.size(); ++i) {
            ContextMenuItem item = this.items.get(i);
            if (i == this.hoveredIndex && item.isClickable()) {
                graphics.fill(this.x + 1, itemY, this.x + this.width - 1, itemY + 9, -2130706433);
            }
            if (!item.getLabel().getString().isEmpty()) {
                graphics.pose().pushPose();
                graphics.pose().translate((float)(this.x + 3), (float)(itemY + 2), 0.0f);
                graphics.pose().scale(0.5f, 0.5f, 1.0f);
                int color = item.isEnabled() ? item.getTextColor() : 0x808080;
                graphics.drawString(font, item.getLabel(), 0, 0, color, false);
                graphics.pose().popPose();
            }
            itemY += 9;
        }
        graphics.pose().popPose();
        RenderSystem.disableBlend();
    }

    private void updateHoveredIndex(int mouseX, int mouseY) {
        int relativeY;
        int index;
        this.hoveredIndex = -1;
        if (mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height && (index = (relativeY = mouseY - this.y - 3) / 9) >= 0 && index < this.items.size() && this.items.get(index).isClickable()) {
            this.hoveredIndex = index;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        ContextMenuItem item;
        if (!this.visible) {
            return false;
        }
        int mx = (int)mouseX;
        int my = (int)mouseY;
        if (mx < this.x || mx >= this.x + this.width || my < this.y || my >= this.y + this.height) {
            this.close();
            return false;
        }
        if (button == 0 && this.hoveredIndex >= 0 && this.hoveredIndex < this.items.size() && (item = this.items.get(this.hoveredIndex)).isClickable()) {
            item.execute();
            return true;
        }
        return true;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.updateHoveredIndex((int)mouseX, (int)mouseY);
    }

    public void close() {
        this.visible = false;
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.visible && mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public void setFocused(boolean focused) {
    }

    public boolean isFocused() {
        return this.visible;
    }
}

