/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.config.gui;

import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.util.DraggableElement;
import java.lang.invoke.LambdaMetafactory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class ManualPositionScreen
extends Screen {
    private final Screen parentScreen;
    private final DraggableElement element;
    private EditBox xOffsetBox;
    private EditBox yOffsetBox;

    public ManualPositionScreen(Screen parent, DraggableElement element) {
        super((Component)Component.translatable((String)"gui.dynamic_resource_bars.manual_position.title"));
        this.parentScreen = parent;
        this.element = element;
    }

    protected void init() {
        super.init();
        ClientConfig config = ModConfigManager.getClient();
        int[] offsets = this.getCurrentOffsets(config);
        int xOffset = offsets[0];
        int yOffset = offsets[1];
        int centerX = this.width / 2;
        int startY = this.height / 3;
        int boxWidth = 80;
        int boxHeight = 20;
        int spacing = 30;
        ((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.dynamic_resource_bars.manual.x_offset"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$0(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)()).bounds((int)(centerX - 150), (int)startY, (int)60, (int)boxHeight).build())).active = false;
        this.xOffsetBox = new EditBox(this.font, centerX - 80, startY, boxWidth, boxHeight, (Component)Component.empty());
        this.xOffsetBox.setValue(String.valueOf(xOffset));
        this.xOffsetBox.setMaxLength(5);
        this.addRenderableWidget((GuiEventListener)this.xOffsetBox);
        ((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.dynamic_resource_bars.manual.y_offset"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$1(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)()).bounds((int)(centerX - 150), (int)(startY + spacing), (int)60, (int)boxHeight).build())).active = false;
        this.yOffsetBox = new EditBox(this.font, centerX - 80, startY + spacing, boxWidth, boxHeight, (Component)Component.empty());
        this.yOffsetBox.setValue(String.valueOf(yOffset));
        this.yOffsetBox.setMaxLength(5);
        this.addRenderableWidget((GuiEventListener)this.yOffsetBox);
        int buttonY = this.height - 40;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), btn -> {
            this.applyOffsets();
            this.onClose();
        }).bounds(centerX - 110, buttonY, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), btn -> this.onClose()).bounds(centerX + 10, buttonY, 100, 20).build());
    }

    private int[] getCurrentOffsets(ClientConfig config) {
        int[] nArray;
        switch (this.element) {
            default: {
                throw new MatchException(null, null);
            }
            case HEALTH_BAR: {
                int[] nArray2 = new int[2];
                nArray2[0] = config.healthTotalXOffset;
                nArray = nArray2;
                nArray2[1] = config.healthTotalYOffset;
                break;
            }
            case STAMINA_BAR: {
                int[] nArray3 = new int[2];
                nArray3[0] = config.staminaTotalXOffset;
                nArray = nArray3;
                nArray3[1] = config.staminaTotalYOffset;
                break;
            }
            case MANA_BAR: {
                int[] nArray4 = new int[2];
                nArray4[0] = config.manaTotalXOffset;
                nArray = nArray4;
                nArray4[1] = config.manaTotalYOffset;
                break;
            }
            case ARMOR_BAR: {
                int[] nArray5 = new int[2];
                nArray5[0] = config.armorTotalXOffset;
                nArray = nArray5;
                nArray5[1] = config.armorTotalYOffset;
                break;
            }
            case AIR_BAR: {
                int[] nArray6 = new int[2];
                nArray6[0] = config.airTotalXOffset;
                nArray = nArray6;
                nArray6[1] = config.airTotalYOffset;
            }
        }
        return nArray;
    }

    private void applyOffsets() {
        try {
            int xOffset = Integer.parseInt(this.xOffsetBox.getValue());
            int yOffset = Integer.parseInt(this.yOffsetBox.getValue());
            ClientConfig config = ModConfigManager.getClient();
            switch (this.element) {
                case HEALTH_BAR: {
                    config.healthTotalXOffset = xOffset;
                    config.healthTotalYOffset = yOffset;
                    break;
                }
                case STAMINA_BAR: {
                    config.staminaTotalXOffset = xOffset;
                    config.staminaTotalYOffset = yOffset;
                    break;
                }
                case MANA_BAR: {
                    config.manaTotalXOffset = xOffset;
                    config.manaTotalYOffset = yOffset;
                    break;
                }
                case ARMOR_BAR: {
                    config.armorTotalXOffset = xOffset;
                    config.armorTotalYOffset = yOffset;
                    break;
                }
                case AIR_BAR: {
                    config.airTotalXOffset = xOffset;
                    config.airTotalYOffset = yOffset;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        MutableComponent elementName = switch (this.element) {
            default -> throw new MatchException(null, null);
            case DraggableElement.HEALTH_BAR -> Component.translatable((String)"gui.dynamic_resource_bars.element.health");
            case DraggableElement.STAMINA_BAR -> Component.translatable((String)"gui.dynamic_resource_bars.element.stamina");
            case DraggableElement.MANA_BAR -> Component.translatable((String)"gui.dynamic_resource_bars.element.mana");
            case DraggableElement.ARMOR_BAR -> Component.translatable((String)"gui.dynamic_resource_bars.element.armor");
            case DraggableElement.AIR_BAR -> Component.translatable((String)"gui.dynamic_resource_bars.element.air");
        };
        graphics.drawCenteredString(this.font, (Component)elementName, this.width / 2, 40, 0xAAAAAA);
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parentScreen);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static /* synthetic */ void lambda$init$1(Button btn) {
    }

    private static /* synthetic */ void lambda$init$0(Button btn) {
    }
}

