/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.config.gui;

import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.config.gui.HudEditorScreen;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ModConfigScreen
extends Screen {
    private final Screen parentScreen;
    private EditBox textColorBox;
    private EditBox textOpacityBox;
    private EditBox textSizeBox;

    public ModConfigScreen(Screen parent) {
        super((Component)Component.literal((String)"Dynamic RPG Resource Bars Configuration"));
        this.parentScreen = parent;
    }

    protected void init() {
        super.init();
        int buttonWidth = 200;
        int buttonHeight = 20;
        int centerX = this.width / 2;
        int currentY = this.height / 4;
        Minecraft mc = Minecraft.getInstance();
        boolean canEditHUD = mc.level != null;
        Button editHudButton = Button.builder((Component)Component.translatable((String)"gui.dynamic_resource_bars.config.button.open_hud_editor"), button -> {
            if (button.active) {
                this.minecraft.setScreen((Screen)new HudEditorScreen(this));
            }
        }).bounds(centerX - buttonWidth / 2, currentY, buttonWidth, buttonHeight).build();
        editHudButton.active = canEditHUD;
        if (!canEditHUD) {
            editHudButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.dynamic_resource_bars.config.tooltip.hud_editor_disabled")));
        }
        this.addRenderableWidget((GuiEventListener)editHudButton);
        currentY += buttonHeight + 15;
        ClientConfig config = ModConfigManager.getClient();
        int labelWidth = 80;
        int editBoxWidth = 60;
        int totalWidth = labelWidth + editBoxWidth + 5;
        int startX = centerX - totalWidth / 2;
        this.textColorBox = new EditBox(this.font, startX + labelWidth + 5, currentY, editBoxWidth, buttonHeight, (Component)Component.literal((String)String.format("#%06X", config.globalTextColor & 0xFFFFFF)));
        this.textColorBox.setValue(String.format("%06X", config.globalTextColor & 0xFFFFFF));
        this.textColorBox.setMaxLength(6);
        this.textColorBox.setResponder(text -> {
            try {
                int color = Integer.parseInt(text, 16);
                config.globalTextColor = color | 0xFF000000;
                this.textColorBox.setTextColor(0xE0E0E0);
            }
            catch (NumberFormatException e) {
                this.textColorBox.setTextColor(0xFF5555);
            }
        });
        this.addRenderableWidget((GuiEventListener)this.textColorBox);
        this.textOpacityBox = new EditBox(this.font, startX + labelWidth + 5, currentY += buttonHeight + 5, editBoxWidth, buttonHeight, (Component)Component.literal((String)String.valueOf(config.globalTextOpacity)));
        this.textOpacityBox.setValue(String.valueOf(config.globalTextOpacity));
        this.textOpacityBox.setMaxLength(3);
        this.textOpacityBox.setResponder(text -> {
            try {
                int opacity = Integer.parseInt(text);
                if (opacity >= 0 && opacity <= 255) {
                    config.globalTextOpacity = opacity;
                    this.textOpacityBox.setTextColor(0xE0E0E0);
                } else {
                    this.textOpacityBox.setTextColor(0xFF5555);
                }
            }
            catch (NumberFormatException e) {
                this.textOpacityBox.setTextColor(0xFF5555);
            }
        });
        this.addRenderableWidget((GuiEventListener)this.textOpacityBox);
        this.textSizeBox = new EditBox(this.font, startX + labelWidth + 5, currentY += buttonHeight + 5, editBoxWidth, buttonHeight, (Component)Component.literal((String)String.format("%.1f", Float.valueOf(config.globalTextSize))));
        this.textSizeBox.setValue(String.format("%.1f", Float.valueOf(config.globalTextSize)));
        this.textSizeBox.setMaxLength(4);
        this.textSizeBox.setResponder(text -> {
            try {
                float size = Float.parseFloat(text);
                if (size >= 0.1f && size <= 5.0f) {
                    config.globalTextSize = size;
                    this.textSizeBox.setTextColor(0xE0E0E0);
                } else {
                    this.textSizeBox.setTextColor(0xFF5555);
                }
            }
            catch (NumberFormatException e) {
                this.textSizeBox.setTextColor(0xFF5555);
            }
        });
        this.addRenderableWidget((GuiEventListener)this.textSizeBox);
        currentY += buttonHeight + 5;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), button -> this.onClose()).bounds(centerX - buttonWidth / 2, this.height - buttonHeight - 20, buttonWidth, buttonHeight).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        if (this.textColorBox != null) {
            int labelX = this.textColorBox.getX() - 95;
            int n = this.textColorBox.getY();
            int n2 = this.textColorBox.getHeight();
            Objects.requireNonNull(this.font);
            int labelY = n + (n2 - 9) / 2;
            graphics.drawString(this.font, (Component)Component.translatable((String)"gui.dynamic_resource_bars.config.label.text_color"), labelX, labelY, 0xFFFFFF);
            int n3 = this.textOpacityBox.getY();
            int n4 = this.textOpacityBox.getHeight();
            Objects.requireNonNull(this.font);
            labelY = n3 + (n4 - 9) / 2;
            graphics.drawString(this.font, (Component)Component.translatable((String)"gui.dynamic_resource_bars.config.label.text_opacity"), labelX, labelY, 0xFFFFFF);
            int n5 = this.textSizeBox.getY();
            int n6 = this.textSizeBox.getHeight();
            Objects.requireNonNull(this.font);
            labelY = n5 + (n6 - 9) / 2;
            graphics.drawString(this.font, (Component)Component.translatable((String)"gui.dynamic_resource_bars.config.label.text_size"), labelX, labelY, 0xFFFFFF);
        }
    }

    public void onClose() {
        ClientConfig.getInstance().save();
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parentScreen);
        }
    }
}

