/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.config.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class MultiLineConfirmResetScreen
extends Screen {
    private final Screen parentScreen;
    private final Runnable confirmAction;

    public MultiLineConfirmResetScreen(Screen parent, Component title, Runnable confirmAction) {
        super(title);
        this.parentScreen = parent;
        this.confirmAction = confirmAction;
    }

    protected void init() {
        super.init();
        int buttonWidth = 100;
        int buttonHeight = 20;
        int spacing = 10;
        int totalWidth = 2 * buttonWidth + spacing;
        int startX = (this.width - totalWidth) / 2;
        int buttonY = this.height / 2 + 40;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.yes"), button -> {
            this.confirmAction.run();
            this.onClose();
        }).bounds(startX, buttonY, buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.no"), button -> this.onClose()).bounds(startX + buttonWidth + spacing, buttonY, buttonWidth, buttonHeight).build());
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, this.height / 2 - 40, 0xFFFFFF);
        MutableComponent line1 = Component.translatable((String)"gui.dynamic_resource_bars.confirm.reset_element.line1");
        graphics.drawCenteredString(this.font, (Component)line1, this.width / 2, this.height / 2 - 20, 0xFFFFFF);
        MutableComponent line2 = Component.translatable((String)"gui.dynamic_resource_bars.confirm.reset_element.line2");
        graphics.drawCenteredString(this.font, (Component)line2, this.width / 2, this.height / 2 - 5, 0xFF4444);
        MutableComponent line3 = Component.translatable((String)"gui.dynamic_resource_bars.confirm.reset_element.line3");
        graphics.drawCenteredString(this.font, (Component)line3, this.width / 2, this.height / 2 + 10, 0xFF4444);
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parentScreen);
        }
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

