/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.config.gui;

import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.util.DraggableElement;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ResizeElementScreen
extends Screen {
    private final Screen parentScreen;
    private final DraggableElement elementToResize;
    private EditBox bgWidthBox;
    private EditBox bgHeightBox;
    private EditBox bgXOffsetBox;
    private EditBox bgYOffsetBox;
    private EditBox barWidthBox;
    private EditBox barHeightBox;
    private EditBox overlayWidthBox;
    private EditBox overlayHeightBox;

    public ResizeElementScreen(Screen parent, DraggableElement element) {
        super((Component)Component.translatable((String)"gui.dynamic_resource_bars.resize.title_format", (Object[])new Object[]{ResizeElementScreen.getFriendlyElementName(element)}));
        this.parentScreen = parent;
        this.elementToResize = element;
    }

    protected void init() {
        int overlayHeightConf;
        int overlayWidthConf;
        int barHeightConf;
        int barWidthConf;
        int bgYOffsetConf;
        int bgXOffsetConf;
        int bgHeightConf;
        int bgWidthConf;
        super.init();
        ClientConfig config = ModConfigManager.getClient();
        switch (this.elementToResize) {
            case HEALTH_BAR: {
                bgWidthConf = config.healthBackgroundWidth;
                bgHeightConf = config.healthBackgroundHeight;
                bgXOffsetConf = config.healthBackgroundXOffset;
                bgYOffsetConf = config.healthBackgroundYOffset;
                barWidthConf = config.healthBarWidth;
                barHeightConf = config.healthBarHeight;
                overlayWidthConf = config.healthOverlayWidth;
                overlayHeightConf = config.healthOverlayHeight;
                break;
            }
            case STAMINA_BAR: {
                bgWidthConf = config.staminaBackgroundWidth;
                bgHeightConf = config.staminaBackgroundHeight;
                bgXOffsetConf = config.staminaBackgroundXOffset;
                bgYOffsetConf = config.staminaBackgroundYOffset;
                barWidthConf = config.staminaBarWidth;
                barHeightConf = config.staminaBarHeight;
                overlayWidthConf = config.staminaOverlayWidth;
                overlayHeightConf = config.staminaOverlayHeight;
                break;
            }
            case MANA_BAR: {
                bgWidthConf = config.manaBackgroundWidth;
                bgHeightConf = config.manaBackgroundHeight;
                bgXOffsetConf = config.manaBackgroundXOffset;
                bgYOffsetConf = config.manaBackgroundYOffset;
                barWidthConf = config.manaBarWidth;
                barHeightConf = config.manaBarHeight;
                overlayWidthConf = config.manaOverlayWidth;
                overlayHeightConf = config.manaOverlayHeight;
                break;
            }
            default: {
                if (this.minecraft != null) {
                    this.minecraft.setScreen(this.parentScreen);
                }
                return;
            }
        }
        int boxWidth = 50;
        int boxHeight = 20;
        int labelWidth = 100;
        int componentBlockWidth = labelWidth + 5 + boxWidth;
        int startX = this.width / 2 - componentBlockWidth / 2;
        int editBoxX = startX + labelWidth + 5;
        int currentY = 40;
        int rowSpacing = 5;
        this.bgWidthBox = this.createIntEditBox(editBoxX, currentY, boxWidth, boxHeight, bgWidthConf);
        this.bgHeightBox = this.createIntEditBox(editBoxX, currentY + boxHeight + rowSpacing, boxWidth, boxHeight, bgHeightConf);
        this.bgXOffsetBox = this.createIntEditBox(editBoxX, currentY + 2 * (boxHeight + rowSpacing), boxWidth, boxHeight, bgXOffsetConf, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.bgYOffsetBox = this.createIntEditBox(editBoxX, currentY + 3 * (boxHeight + rowSpacing), boxWidth, boxHeight, bgYOffsetConf, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.addRenderableWidget((GuiEventListener)this.bgWidthBox);
        this.addRenderableWidget((GuiEventListener)this.bgHeightBox);
        this.addRenderableWidget((GuiEventListener)this.bgXOffsetBox);
        this.addRenderableWidget((GuiEventListener)this.bgYOffsetBox);
        this.barWidthBox = this.createIntEditBox(editBoxX, currentY += 4 * (boxHeight + rowSpacing) + rowSpacing, boxWidth, boxHeight, barWidthConf, 0, 256);
        this.barHeightBox = this.createIntEditBox(editBoxX, currentY + boxHeight + rowSpacing, boxWidth, boxHeight, barHeightConf, 0, 32);
        this.addRenderableWidget((GuiEventListener)this.barWidthBox);
        this.addRenderableWidget((GuiEventListener)this.barHeightBox);
        this.overlayWidthBox = this.createIntEditBox(editBoxX, currentY += 2 * (boxHeight + rowSpacing) + rowSpacing, boxWidth, boxHeight, overlayWidthConf, 0, 256);
        this.overlayHeightBox = this.createIntEditBox(editBoxX, currentY + boxHeight + rowSpacing, boxWidth, boxHeight, overlayHeightConf, 0, 256);
        this.addRenderableWidget((GuiEventListener)this.overlayWidthBox);
        this.addRenderableWidget((GuiEventListener)this.overlayHeightBox);
        int doneButtonWidth = 100;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), button -> this.onClose()).bounds(this.width / 2 - doneButtonWidth / 2, this.height - boxHeight - 20, doneButtonWidth, boxHeight).build());
    }

    private EditBox createIntEditBox(int x, int y, int width, int height, int configIntValue) {
        return this.createIntEditBox(x, y, width, height, configIntValue, 1, Integer.MAX_VALUE);
    }

    private EditBox createIntEditBox(int x, int y, int width, int height, int configIntValue, int minValue, int maxValue) {
        EditBox editBox = new EditBox(this.font, x, y, width, height, (Component)Component.empty());
        editBox.setValue(String.valueOf(configIntValue));
        editBox.setResponder(text -> {
            try {
                int value = Integer.parseInt(text);
                if (value >= minValue && value <= maxValue) {
                    editBox.setTextColor(0xE0E0E0);
                } else {
                    editBox.setTextColor(0xFF5555);
                }
            }
            catch (NumberFormatException e) {
                editBox.setTextColor(0xFF5555);
            }
        });
        return editBox;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        if (this.bgWidthBox != null) {
            int labelX = this.bgWidthBox.getX() - 5 - 100;
            MutableComponent mutableComponent = Component.translatable((String)"gui.dynamic_resource_bars.resize.label.background_width");
            int n = this.bgWidthBox.getY();
            int n2 = this.bgWidthBox.getHeight();
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (Component)mutableComponent, labelX, n + (n2 - 9) / 2, 0xFFFFFF);
            MutableComponent mutableComponent2 = Component.translatable((String)"gui.dynamic_resource_bars.resize.label.background_height");
            int n3 = this.bgHeightBox.getY();
            int n4 = this.bgHeightBox.getHeight();
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (Component)mutableComponent2, labelX, n3 + (n4 - 9) / 2, 0xFFFFFF);
            MutableComponent mutableComponent3 = Component.translatable((String)"gui.dynamic_resource_bars.resize.label.background_x_offset");
            int n5 = this.bgXOffsetBox.getY();
            int n6 = this.bgXOffsetBox.getHeight();
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (Component)mutableComponent3, labelX, n5 + (n6 - 9) / 2, 0xFFFFFF);
            MutableComponent mutableComponent4 = Component.translatable((String)"gui.dynamic_resource_bars.resize.label.background_y_offset");
            int n7 = this.bgYOffsetBox.getY();
            int n8 = this.bgYOffsetBox.getHeight();
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (Component)mutableComponent4, labelX, n7 + (n8 - 9) / 2, 0xFFFFFF);
            MutableComponent mutableComponent5 = Component.translatable((String)"gui.dynamic_resource_bars.resize.label.bar_width");
            int n9 = this.barWidthBox.getY();
            int n10 = this.barWidthBox.getHeight();
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (Component)mutableComponent5, labelX, n9 + (n10 - 9) / 2, 0xFFFFFF);
            MutableComponent mutableComponent6 = Component.translatable((String)"gui.dynamic_resource_bars.resize.label.bar_height");
            int n11 = this.barHeightBox.getY();
            int n12 = this.barHeightBox.getHeight();
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (Component)mutableComponent6, labelX, n11 + (n12 - 9) / 2, 0xFFFFFF);
            MutableComponent mutableComponent7 = Component.translatable((String)"gui.dynamic_resource_bars.resize.label.overlay_width");
            int n13 = this.overlayWidthBox.getY();
            int n14 = this.overlayWidthBox.getHeight();
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (Component)mutableComponent7, labelX, n13 + (n14 - 9) / 2, 0xFFFFFF);
            MutableComponent mutableComponent8 = Component.translatable((String)"gui.dynamic_resource_bars.resize.label.overlay_height");
            int n15 = this.overlayHeightBox.getY();
            int n16 = this.overlayHeightBox.getHeight();
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (Component)mutableComponent8, labelX, n15 + (n16 - 9) / 2, 0xFFFFFF);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        boolean unfocusedAny = false;
        for (GuiEventListener listener : this.children()) {
            if (!(listener instanceof EditBox)) continue;
            EditBox box = (EditBox)listener;
            ScreenRectangle vanillaRect = box.getRectangle();
            if (!box.isFocused() || vanillaRect.containsPoint((int)mouseX, (int)mouseY)) continue;
            box.setFocused(false);
            unfocusedAny = true;
        }
        return unfocusedAny;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.getFocused() != null && this.getFocused().keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        ClientConfig config = ModConfigManager.getClient();
        try {
            switch (this.elementToResize) {
                case HEALTH_BAR: {
                    config.healthBackgroundWidth = this.parseIntSafely(this.bgWidthBox.getValue(), config.healthBackgroundWidth, 1, Integer.MAX_VALUE);
                    config.healthBackgroundHeight = this.parseIntSafely(this.bgHeightBox.getValue(), config.healthBackgroundHeight, 1, Integer.MAX_VALUE);
                    config.healthBarWidth = this.parseIntSafely(this.barWidthBox.getValue(), config.healthBarWidth, 1, 256);
                    config.healthBarHeight = this.parseIntSafely(this.barHeightBox.getValue(), config.healthBarHeight, 1, 32);
                    config.healthOverlayWidth = this.parseIntSafely(this.overlayWidthBox.getValue(), config.healthOverlayWidth, 1, 256);
                    config.healthOverlayHeight = this.parseIntSafely(this.overlayHeightBox.getValue(), config.healthOverlayHeight, 1, 256);
                    config.healthBackgroundXOffset = this.parseIntSafely(this.bgXOffsetBox.getValue(), config.healthBackgroundXOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    config.healthBackgroundYOffset = this.parseIntSafely(this.bgYOffsetBox.getValue(), config.healthBackgroundYOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    break;
                }
                case STAMINA_BAR: {
                    config.staminaBackgroundWidth = this.parseIntSafely(this.bgWidthBox.getValue(), config.staminaBackgroundWidth, 1, Integer.MAX_VALUE);
                    config.staminaBackgroundHeight = this.parseIntSafely(this.bgHeightBox.getValue(), config.staminaBackgroundHeight, 1, Integer.MAX_VALUE);
                    config.staminaBarWidth = this.parseIntSafely(this.barWidthBox.getValue(), config.staminaBarWidth, 1, 256);
                    config.staminaBarHeight = this.parseIntSafely(this.barHeightBox.getValue(), config.staminaBarHeight, 1, 32);
                    config.staminaOverlayWidth = this.parseIntSafely(this.overlayWidthBox.getValue(), config.staminaOverlayWidth, 1, 256);
                    config.staminaOverlayHeight = this.parseIntSafely(this.overlayHeightBox.getValue(), config.staminaOverlayHeight, 1, 256);
                    config.staminaBackgroundXOffset = this.parseIntSafely(this.bgXOffsetBox.getValue(), config.staminaBackgroundXOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    config.staminaBackgroundYOffset = this.parseIntSafely(this.bgYOffsetBox.getValue(), config.staminaBackgroundYOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    break;
                }
                case MANA_BAR: {
                    config.manaBackgroundWidth = this.parseIntSafely(this.bgWidthBox.getValue(), config.manaBackgroundWidth, 1, Integer.MAX_VALUE);
                    config.manaBackgroundHeight = this.parseIntSafely(this.bgHeightBox.getValue(), config.manaBackgroundHeight, 1, Integer.MAX_VALUE);
                    config.manaBarWidth = this.parseIntSafely(this.barWidthBox.getValue(), config.manaBarWidth, 1, 256);
                    config.manaBarHeight = this.parseIntSafely(this.barHeightBox.getValue(), config.manaBarHeight, 1, 32);
                    config.manaOverlayWidth = this.parseIntSafely(this.overlayWidthBox.getValue(), config.manaOverlayWidth, 1, 256);
                    config.manaOverlayHeight = this.parseIntSafely(this.overlayHeightBox.getValue(), config.manaOverlayHeight, 1, 256);
                    config.manaBackgroundXOffset = this.parseIntSafely(this.bgXOffsetBox.getValue(), config.manaBackgroundXOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    config.manaBackgroundYOffset = this.parseIntSafely(this.bgYOffsetBox.getValue(), config.manaBackgroundYOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
                }
            }
            config.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parentScreen);
        }
    }

    private int parseIntSafely(String value, int defaultValue, int minValue, int maxValue) {
        try {
            int parsed = Integer.parseInt(value);
            if (parsed < minValue) {
                return minValue;
            }
            if (parsed > maxValue) {
                return maxValue;
            }
            return parsed;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static String getFriendlyElementName(DraggableElement element) {
        if (element == null) {
            return "";
        }
        return switch (element) {
            case DraggableElement.HEALTH_BAR -> Component.translatable((String)"gui.dynamic_resource_bars.element.health_bar").getString();
            case DraggableElement.MANA_BAR -> Component.translatable((String)"gui.dynamic_resource_bars.element.mana_bar").getString();
            case DraggableElement.STAMINA_BAR -> Component.translatable((String)"gui.dynamic_resource_bars.element.stamina_bar").getString();
            default -> element.name();
        };
    }
}

