/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.event;

import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.provider.StaminaBarBehavior;
import dev.muon.dynamic_resource_bars.render.AirBarRenderer;
import dev.muon.dynamic_resource_bars.render.ArmorBarRenderer;
import dev.muon.dynamic_resource_bars.render.HealthBarRenderer;
import dev.muon.dynamic_resource_bars.render.StaminaBarRenderer;
import dev.muon.dynamic_resource_bars.util.BarRenderBehavior;
import fuzs.puzzleslib.api.client.core.v1.ClientAbstractions;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;

public class CommonEvents {
    public static EventResult onRenderPlayerHealth(Minecraft minecraft, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        ClientConfig config = ModConfigManager.getClient();
        if (!config.enableHealthBar) {
            return EventResult.PASS;
        }
        LocalPlayer player = minecraft.player;
        if (player == null || minecraft.options.hideGui) {
            return EventResult.PASS;
        }
        float absorptionAmount = player.getAbsorptionAmount();
        HealthBarRenderer.render(guiGraphics, (Player)player, player.getMaxHealth(), player.getHealth(), (int)absorptionAmount, deltaTracker);
        ClientAbstractions.INSTANCE.addGuiLeftHeight(minecraft.gui, config.healthBackgroundHeight + 1);
        return EventResult.INTERRUPT;
    }

    public static EventResult onRenderHunger(Minecraft minecraft, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        ClientConfig config = ModConfigManager.getClient();
        if (!config.staminaBarBehavior.equals((Object)StaminaBarBehavior.FOOD)) {
            return EventResult.PASS;
        }
        LocalPlayer player = minecraft.player;
        if (player == null || minecraft.options.hideGui) {
            return EventResult.PASS;
        }
        StaminaBarRenderer.render(guiGraphics, (Player)player, deltaTracker);
        ClientAbstractions.INSTANCE.addGuiRightHeight(minecraft.gui, config.staminaBackgroundHeight + 1);
        return EventResult.INTERRUPT;
    }

    public static EventResult onRenderArmor(Minecraft minecraft, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        ClientConfig config = ModConfigManager.getClient();
        BarRenderBehavior armorBehavior = config.armorBarBehavior;
        if (armorBehavior == BarRenderBehavior.VANILLA) {
            return EventResult.PASS;
        }
        LocalPlayer player = minecraft.player;
        if (player == null || minecraft.options.hideGui) {
            return EventResult.INTERRUPT;
        }
        if (armorBehavior == BarRenderBehavior.CUSTOM) {
            ArmorBarRenderer.render(guiGraphics, (Player)player);
            ClientAbstractions.INSTANCE.addGuiLeftHeight(minecraft.gui, config.armorBackgroundHeight + 1);
        }
        return EventResult.INTERRUPT;
    }

    public static EventResult onRenderAir(Minecraft minecraft, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        ClientConfig config = ModConfigManager.getClient();
        BarRenderBehavior airBehavior = config.airBarBehavior;
        if (airBehavior == BarRenderBehavior.VANILLA) {
            return EventResult.PASS;
        }
        LocalPlayer player = minecraft.player;
        if (player == null || minecraft.options.hideGui) {
            return EventResult.INTERRUPT;
        }
        if (airBehavior == BarRenderBehavior.CUSTOM) {
            AirBarRenderer.render(guiGraphics, (Player)player, deltaTracker);
            ClientAbstractions.INSTANCE.addGuiRightHeight(minecraft.gui, config.airBackgroundHeight + 1);
        }
        return EventResult.INTERRUPT;
    }

    public static EventResult onRenderMountHealth(Minecraft minecraft, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        ClientConfig config = ModConfigManager.getClient();
        if (!config.mergeMountHealth && config.enableMountHealth) {
            return EventResult.PASS;
        }
        return EventResult.INTERRUPT;
    }
}

