/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.muon.dynamic_resource_bars.DynamicResourceBars;
import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.util.AnimationMetadata;
import dev.muon.dynamic_resource_bars.util.AnimationMetadataCache;
import dev.muon.dynamic_resource_bars.util.BarRenderBehavior;
import dev.muon.dynamic_resource_bars.util.DraggableElement;
import dev.muon.dynamic_resource_bars.util.EditModeManager;
import dev.muon.dynamic_resource_bars.util.HUDPositioning;
import dev.muon.dynamic_resource_bars.util.HorizontalAlignment;
import dev.muon.dynamic_resource_bars.util.NineSliceRenderer;
import dev.muon.dynamic_resource_bars.util.Position;
import dev.muon.dynamic_resource_bars.util.RenderUtil;
import dev.muon.dynamic_resource_bars.util.ScreenRect;
import dev.muon.dynamic_resource_bars.util.SubElementType;
import dev.muon.dynamic_resource_bars.util.TextBehavior;
import dev.muon.dynamic_resource_bars.util.TickHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;

public class ArmorBarRenderer {
    private static long armorTextStartTime = 0L;
    private static boolean shouldShowArmorText = false;
    private static boolean armorBarSetVisible = true;
    private static long armorBarDisabledStartTime = 0L;

    public static ScreenRect getScreenRect(Player player) {
        if (player == null) {
            return new ScreenRect(0, 0, 0, 0);
        }
        ClientConfig config = ModConfigManager.getClient();
        Position anchorPos = HUDPositioning.getPositionFromAnchor(config.armorBarAnchor);
        Position finalPos = anchorPos.offset(config.armorTotalXOffset, config.armorTotalYOffset);
        int backgroundWidth = config.armorBackgroundWidth;
        int backgroundHeight = config.armorBackgroundHeight;
        return new ScreenRect(finalPos.x(), finalPos.y(), backgroundWidth, backgroundHeight);
    }

    public static ScreenRect getSubElementRect(SubElementType type, Player player) {
        ScreenRect complexRect = ArmorBarRenderer.getScreenRect(player);
        if (complexRect == null || complexRect.width() == 0 && complexRect.height() == 0) {
            return new ScreenRect(0, 0, 0, 0);
        }
        ClientConfig config = ModConfigManager.getClient();
        int x = complexRect.x();
        int y = complexRect.y();
        switch (type) {
            case BACKGROUND: {
                return new ScreenRect(x + config.armorBackgroundXOffset, y + config.armorBackgroundYOffset, config.armorBackgroundWidth, config.armorBackgroundHeight);
            }
            case BAR_MAIN: {
                return new ScreenRect(x + config.armorBarXOffset, y + config.armorBarYOffset, config.armorBarWidth, config.armorBarHeight);
            }
            case TEXT: {
                return new ScreenRect(x + config.armorTextXOffset, y + config.armorTextYOffset, config.armorBarWidth, config.armorBarHeight);
            }
            case ICON: {
                return new ScreenRect(x + config.armorIconXOffset, y + config.armorIconYOffset, config.armorIconSize, config.armorIconSize);
            }
        }
        return new ScreenRect(0, 0, 0, 0);
    }

    public static void render(GuiGraphics graphics, Player player) {
        ClientConfig config = ModConfigManager.getClient();
        if (config.armorBarBehavior != BarRenderBehavior.CUSTOM) {
            return;
        }
        int armorValue = player.getArmorValue();
        if (EditModeManager.isEditModeEnabled() && armorValue == 0) {
            armorValue = config.maxExpectedArmor;
        }
        ArmorBarRenderer.setArmorBarVisibility(armorValue > 0 || EditModeManager.isEditModeEnabled());
        if (!ArmorBarRenderer.isArmorBarVisible() && !EditModeManager.isEditModeEnabled() && System.currentTimeMillis() - armorBarDisabledStartTime > 1500L) {
            return;
        }
        float currentAlphaForRender = ArmorBarRenderer.getArmorBarAlpha();
        if (EditModeManager.isEditModeEnabled() && !ArmorBarRenderer.isArmorBarVisible()) {
            currentAlphaForRender = 1.0f;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)currentAlphaForRender);
        Position armorPos = HUDPositioning.getPositionFromAnchor(config.armorBarAnchor).offset(config.armorTotalXOffset, config.armorTotalYOffset);
        int backgroundWidth = config.armorBackgroundWidth;
        int backgroundHeight = config.armorBackgroundHeight;
        int barWidth = config.armorBarWidth;
        int barHeight = config.armorBarHeight;
        int barOnlyXOffset = config.armorBarXOffset;
        int barOnlyYOffset = config.armorBarYOffset;
        int iconSize = config.armorIconSize;
        boolean isRightAnchored = config.armorBarAnchor.getSide() == HUDPositioning.AnchorSide.RIGHT;
        int xPos = armorPos.x();
        int yPos = armorPos.y();
        ResourceLocation bgTexture = DynamicResourceBars.loc("textures/gui/armor_background.png");
        AnimationMetadata.ScalingInfo bgScaling = AnimationMetadataCache.getScalingOrLoad(bgTexture, AnimationMetadata.TextureType.BACKGROUND);
        AnimationMetadata.TextureDimensions bgDims = AnimationMetadataCache.getTextureDimensions(bgTexture);
        NineSliceRenderer.renderWithScaling(graphics, bgTexture, bgScaling, xPos + config.armorBackgroundXOffset, yPos + config.armorBackgroundYOffset, backgroundWidth, backgroundHeight, bgDims.width, bgDims.height);
        float armorPercent = Math.min(1.0f, (float)armorValue / (float)config.maxExpectedArmor);
        int filledWidth = Math.round(((float)barWidth - (float)iconSize / 2.0f) * armorPercent);
        if (filledWidth > 0) {
            int barX = xPos + barOnlyXOffset;
            float actualBarTexturePortionWidth = config.armorBarWidth;
            if (config.enableArmorIcon) {
                actualBarTexturePortionWidth -= (float)config.armorIconSize / 2.0f;
            }
            int uTexOffset = 0;
            if (config.enableArmorIcon) {
                if (isRightAnchored) {
                    barX += barWidth - filledWidth - iconSize / 2;
                    uTexOffset = Math.round(actualBarTexturePortionWidth) - filledWidth;
                } else {
                    barX += iconSize / 2;
                }
            } else if (isRightAnchored) {
                barX += barWidth - filledWidth;
                uTexOffset = config.armorBarWidth - filledWidth;
            }
            if (uTexOffset < 0) {
                uTexOffset = 0;
            }
            ResourceLocation armorBarTexture = DynamicResourceBars.loc("textures/gui/armor_bar.png");
            AnimationMetadata.TextureDimensions armorBarDims = AnimationMetadataCache.getTextureDimensions(armorBarTexture);
            graphics.blit(armorBarTexture, barX, yPos + barOnlyYOffset, (float)uTexOffset, 0.0f, filledWidth, barHeight, armorBarDims.width, armorBarDims.height);
        }
        if (ArmorBarRenderer.shouldRenderText() || EditModeManager.isEditModeEnabled()) {
            ScreenRect textRect = ArmorBarRenderer.getSubElementRect(SubElementType.TEXT, player);
            int textX = textRect.x() + textRect.width() / 2;
            int textY = textRect.y() + textRect.height() / 2;
            int color = ArmorBarRenderer.getTextColor();
            HorizontalAlignment alignment = config.armorTextAlign;
            int baseX = textRect.x();
            if (alignment == HorizontalAlignment.CENTER) {
                baseX = textX;
            } else if (alignment == HorizontalAlignment.RIGHT) {
                baseX = textRect.x() + textRect.width();
            }
            RenderUtil.renderArmorText(armorValue, graphics, baseX, textY, color, alignment);
        }
        ArmorBarRenderer.renderProtectionOverlay(graphics, player, config, xPos, yPos, barWidth, barHeight, barOnlyXOffset, barOnlyYOffset, iconSize);
        if (config.enableArmorIcon || EditModeManager.isEditModeEnabled()) {
            ArmorIcon icon = ArmorIcon.fromArmorValue(armorValue);
            ScreenRect iconRect = ArmorBarRenderer.getSubElementRect(SubElementType.ICON, player);
            graphics.blit(DynamicResourceBars.loc("textures/gui/armors/" + icon.getTexture() + ".png"), iconRect.x(), iconRect.y(), 0.0f, 0.0f, iconRect.width(), iconRect.height(), iconRect.width(), iconRect.height());
        }
        if (EditModeManager.isEditModeEnabled()) {
            ScreenRect complexRect = ArmorBarRenderer.getScreenRect(player);
            if (EditModeManager.getFocusedElement() == DraggableElement.ARMOR_BAR) {
                int focusedBorderColor = -1593835776;
                ScreenRect bgRect = ArmorBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                graphics.renderOutline(bgRect.x() - 1, bgRect.y() - 1, bgRect.width() + 2, bgRect.height() + 2, focusedBorderColor);
                ScreenRect barRect = ArmorBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                graphics.renderOutline(barRect.x() - 1, barRect.y() - 1, barRect.width() + 2, barRect.height() + 2, -1597980480);
                graphics.renderOutline(complexRect.x() - 2, complexRect.y() - 2, complexRect.width() + 4, complexRect.height() + 4, -2130706433);
            } else {
                int borderColor = -2130706433;
                graphics.renderOutline(complexRect.x() - 1, complexRect.y() - 1, complexRect.width() + 2, complexRect.height() + 2, borderColor);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void renderProtectionOverlay(GuiGraphics graphics, Player player, ClientConfig config, int xPos, int yPos, int barWidth, int barHeight, int barOnlyXOffset, int barOnlyYOffset, int iconSize) {
        int totalProtection = 0;
        if (totalProtection <= 0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int maxProtection = config.maxExpectedProt;
        float protectionScale = Math.min(1.0f, (float)totalProtection / (float)maxProtection);
        float pulseAlpha = 0.5f + TickHandler.getOverlayFlashAlpha() * 0.5f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)pulseAlpha);
        int adjustedBarWidth = config.enableArmorIcon ? barWidth - iconSize / 2 : barWidth;
        int overlayWidth = (int)((float)adjustedBarWidth * protectionScale);
        ResourceLocation protectionTexture = DynamicResourceBars.loc("textures/gui/protection_overlay.png");
        AnimationMetadata.ScalingInfo protectionScaling = AnimationMetadataCache.getProtectionOverlayScaling();
        AnimationMetadata.TextureDimensions protectionDims = AnimationMetadataCache.getTextureDimensions(protectionTexture);
        NineSliceRenderer.renderWithScaling(graphics, protectionTexture, protectionScaling, xPos + (config.enableArmorIcon ? barOnlyXOffset + iconSize / 2 : barOnlyXOffset), yPos + barOnlyYOffset, overlayWidth, barHeight, protectionDims.width, protectionDims.height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static int getTextColor() {
        ClientConfig config = ModConfigManager.getClient();
        long timeSinceTextTrigger = armorTextStartTime > 0L ? System.currentTimeMillis() - armorTextStartTime : 0L;
        int baseColor = config.armorTextColor & 0xFFFFFF;
        int alpha = config.armorTextOpacity;
        if (!shouldShowArmorText && armorTextStartTime > 0L) {
            alpha = (int)((float)alpha * ((float)RenderUtil.calculateTextAlpha(timeSinceTextTrigger) / 200.0f));
        }
        alpha = (int)((float)alpha * ArmorBarRenderer.getArmorBarAlpha());
        alpha = Math.max(10, Math.min(255, alpha));
        return alpha << 24 | baseColor;
    }

    private static boolean shouldRenderText() {
        boolean hasArmor;
        if (EditModeManager.isEditModeEnabled()) {
            return true;
        }
        TextBehavior behavior = ModConfigManager.getClient().showArmorText;
        if (EditModeManager.isEditModeEnabled() && (behavior == TextBehavior.ALWAYS || behavior == TextBehavior.WHEN_NOT_FULL)) {
            return true;
        }
        if (behavior == TextBehavior.NEVER) {
            return false;
        }
        if (behavior == TextBehavior.ALWAYS) {
            return true;
        }
        int armorValue = Minecraft.getInstance().player.getArmorValue();
        boolean bl = hasArmor = armorValue > 0;
        if (!hasArmor) {
            if (armorTextStartTime == 0L) {
                armorTextStartTime = System.currentTimeMillis();
            }
            return System.currentTimeMillis() - armorTextStartTime < 2000L;
        }
        armorTextStartTime = 0L;
        return true;
    }

    public static void triggerTextDisplay() {
        armorTextStartTime = System.currentTimeMillis();
        shouldShowArmorText = true;
    }

    public static void stopTextDisplay() {
        shouldShowArmorText = false;
    }

    public static boolean isArmorRelevantItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.getItem() instanceof ArmorItem;
    }

    private static void setArmorBarVisibility(boolean visible) {
        if (armorBarSetVisible != visible) {
            if (!visible) {
                armorBarDisabledStartTime = System.currentTimeMillis();
            }
            armorBarSetVisible = visible;
        }
    }

    private static boolean isArmorBarVisible() {
        return armorBarSetVisible;
    }

    private static float getArmorBarAlpha() {
        if (ArmorBarRenderer.isArmorBarVisible()) {
            return 1.0f;
        }
        long timeSinceDisabled = System.currentTimeMillis() - armorBarDisabledStartTime;
        if (timeSinceDisabled >= 1500L) {
            return 0.0f;
        }
        return Math.max(0.0f, 1.0f - (float)timeSinceDisabled / 1500.0f);
    }

    private static enum ArmorIcon {
        NONE("tier_0"),
        LIGHT("tier_1"),
        MEDIUM("tier_2"),
        HEAVY("tier_3"),
        PLATE("tier_4"),
        REINFORCED("tier_5"),
        ENHANCED("tier_6"),
        MASTERWORK("tier_7"),
        LEGENDARY("tier_8"),
        MYTHICAL("tier_9"),
        DIVINE("tier_10");

        private final String texture;

        private ArmorIcon(String texture) {
            this.texture = texture;
        }

        public String getTexture() {
            return this.texture;
        }

        public static ArmorIcon fromArmorValue(int armorValue) {
            if (armorValue <= 0) {
                return NONE;
            }
            int maxArmor = ModConfigManager.getClient().maxExpectedArmor;
            int tier = Math.max(1, Math.min(10, (int)((float)armorValue / (float)maxArmor * 10.0f)));
            return ArmorIcon.values()[tier];
        }
    }
}

