/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.muon.dynamic_resource_bars.DynamicResourceBars;
import dev.muon.dynamic_resource_bars.compat.AppleSkinCompat;
import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.util.AnimationMetadata;
import dev.muon.dynamic_resource_bars.util.AnimationMetadataCache;
import dev.muon.dynamic_resource_bars.util.DraggableElement;
import dev.muon.dynamic_resource_bars.util.EditModeManager;
import dev.muon.dynamic_resource_bars.util.FillDirection;
import dev.muon.dynamic_resource_bars.util.HUDPositioning;
import dev.muon.dynamic_resource_bars.util.HorizontalAlignment;
import dev.muon.dynamic_resource_bars.util.NineSliceRenderer;
import dev.muon.dynamic_resource_bars.util.PlatformUtil;
import dev.muon.dynamic_resource_bars.util.Position;
import dev.muon.dynamic_resource_bars.util.RenderUtil;
import dev.muon.dynamic_resource_bars.util.ScreenRect;
import dev.muon.dynamic_resource_bars.util.SubElementType;
import dev.muon.dynamic_resource_bars.util.TextBehavior;
import dev.muon.dynamic_resource_bars.util.TickHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class HealthBarRenderer {
    private static float lastHealth = -1.0f;
    private static long fullHealthStartTime = 0L;
    private static boolean healthBarSetVisible = true;
    private static long healthBarDisabledStartTime = 0L;
    private static final long CHUNK_FADEOUT_DURATION = 500L;
    private static final List<FadingChunk> fadingChunks = new ArrayList<FadingChunk>();
    private static float previousHealth = -1.0f;
    private static float previousMaxHealth = -1.0f;

    public static ScreenRect getScreenRect(Player player) {
        if (player == null) {
            return new ScreenRect(0, 0, 0, 0);
        }
        Position healthPos = HUDPositioning.getPositionFromAnchor(ModConfigManager.getClient().healthBarAnchor).offset(ModConfigManager.getClient().healthTotalXOffset, ModConfigManager.getClient().healthTotalYOffset);
        int backgroundWidth = ModConfigManager.getClient().healthBackgroundWidth;
        int backgroundHeight = ModConfigManager.getClient().healthBackgroundHeight;
        return new ScreenRect(healthPos.x(), healthPos.y(), backgroundWidth, backgroundHeight);
    }

    public static ScreenRect getSubElementRect(SubElementType type, Player player) {
        ScreenRect complexRect = HealthBarRenderer.getScreenRect(player);
        if (complexRect == null || complexRect.width() == 0 && complexRect.height() == 0) {
            return new ScreenRect(0, 0, 0, 0);
        }
        int x = complexRect.x();
        int y = complexRect.y();
        switch (type) {
            case BACKGROUND: {
                return new ScreenRect(x + ModConfigManager.getClient().healthBackgroundXOffset, y + ModConfigManager.getClient().healthBackgroundYOffset, ModConfigManager.getClient().healthBackgroundWidth, ModConfigManager.getClient().healthBackgroundHeight);
            }
            case BAR_MAIN: {
                return new ScreenRect(x + ModConfigManager.getClient().healthBarXOffset, y + ModConfigManager.getClient().healthBarYOffset, ModConfigManager.getClient().healthBarWidth, ModConfigManager.getClient().healthBarHeight);
            }
            case FOREGROUND: {
                return new ScreenRect(x + ModConfigManager.getClient().healthOverlayXOffset, y + ModConfigManager.getClient().healthOverlayYOffset, ModConfigManager.getClient().healthOverlayWidth, ModConfigManager.getClient().healthOverlayHeight);
            }
            case TEXT: {
                return new ScreenRect(x + ModConfigManager.getClient().healthTextXOffset, y + ModConfigManager.getClient().healthTextYOffset, ModConfigManager.getClient().healthBarWidth, ModConfigManager.getClient().healthBarHeight);
            }
            case ABSORPTION_TEXT: {
                return new ScreenRect(x + ModConfigManager.getClient().healthAbsorptionTextXOffset, y + ModConfigManager.getClient().healthAbsorptionTextYOffset, 50, ModConfigManager.getClient().healthBarHeight);
            }
        }
        return new ScreenRect(0, 0, 0, 0);
    }

    public static void render(GuiGraphics graphics, Player player, float maxHealth, float actualHealth, int absorptionAmount, DeltaTracker deltaTracker) {
        ItemStack heldFood;
        HealthBarRenderer.updateChunkTracking(player, actualHealth, maxHealth, deltaTracker.getGameTimeDeltaTicks());
        boolean shouldFade = ModConfigManager.getClient().fadeHealthWhenFull && actualHealth >= maxHealth && absorptionAmount == 0;
        HealthBarRenderer.setHealthBarVisibility(!shouldFade || EditModeManager.isEditModeEnabled());
        if (!HealthBarRenderer.isHealthBarVisible() && !EditModeManager.isEditModeEnabled() && System.currentTimeMillis() - healthBarDisabledStartTime > 1500L) {
            return;
        }
        if (!Minecraft.getInstance().gameMode.canHurtPlayer() && !EditModeManager.isEditModeEnabled()) {
            return;
        }
        float currentAlphaForRender = HealthBarRenderer.getHealthBarAlpha();
        if (EditModeManager.isEditModeEnabled() && !HealthBarRenderer.isHealthBarVisible()) {
            currentAlphaForRender = 1.0f;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)currentAlphaForRender);
        ScreenRect complexRect = HealthBarRenderer.getScreenRect(player);
        int xPos = complexRect.x();
        int yPos = complexRect.y();
        int backgroundWidth = ModConfigManager.getClient().healthBackgroundWidth;
        int backgroundHeight = ModConfigManager.getClient().healthBackgroundHeight;
        if (ModConfigManager.getClient().enableHealthBackground) {
            ScreenRect bgRect = HealthBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
            ResourceLocation bgTexture = DynamicResourceBars.loc("textures/gui/health_background.png");
            AnimationMetadata.ScalingInfo bgScaling = AnimationMetadataCache.getHealthBackgroundScaling();
            AnimationMetadata.TextureDimensions bgDims = AnimationMetadataCache.getTextureDimensions(bgTexture);
            NineSliceRenderer.renderWithScaling(graphics, bgTexture, bgScaling, bgRect.x(), bgRect.y(), bgRect.width(), bgRect.height(), bgDims.width, bgDims.height);
        }
        AnimationMetadata.AnimationData animData = AnimationMetadataCache.getHealthBarAnimation();
        float ticks = (float)player.tickCount + deltaTracker.getGameTimeDeltaTicks();
        int animOffset = AnimationMetadata.calculateAnimationOffset(animData, ticks);
        ScreenRect mainBarRect = HealthBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
        boolean isRightAnchored = ModConfigManager.getClient().healthBarAnchor.getSide() == HUDPositioning.AnchorSide.RIGHT;
        HealthBarRenderer.renderBaseBar(graphics, player, maxHealth, actualHealth, mainBarRect.x(), mainBarRect.y(), mainBarRect.width(), mainBarRect.height(), 0, 0, animOffset, isRightAnchored, animData);
        HealthBarRenderer.renderFadingChunks(graphics, mainBarRect, actualHealth, maxHealth, isRightAnchored, currentAlphaForRender, animData);
        if (PlatformUtil.isModLoaded("appleskin") && !(heldFood = HealthBarRenderer.getHeldFood(player)).isEmpty()) {
            HealthBarRenderer.renderHealthRestoredOverlay(graphics, player, heldFood, actualHealth, maxHealth, mainBarRect, animOffset, isRightAnchored, animData);
        }
        HealthBarRenderer.renderBarOverlays(graphics, player, absorptionAmount, mainBarRect.x(), mainBarRect.y(), mainBarRect.width(), mainBarRect.height(), 0, 0);
        HealthBarRenderer.renderBackgroundOverlays(graphics, player, xPos, yPos, backgroundWidth, backgroundHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (HealthBarRenderer.shouldRenderHealthText(actualHealth, maxHealth, player)) {
            ScreenRect textRect = HealthBarRenderer.getSubElementRect(SubElementType.TEXT, player);
            int textX = textRect.x() + textRect.width() / 2;
            int textY = textRect.y() + textRect.height() / 2;
            int color = HealthBarRenderer.getHealthTextColor(actualHealth, maxHealth);
            HorizontalAlignment alignment = ModConfigManager.getClient().healthTextAlign;
            int baseX = textRect.x();
            if (alignment == HorizontalAlignment.CENTER) {
                baseX = textX;
            } else if (alignment == HorizontalAlignment.RIGHT) {
                baseX = textRect.x() + textRect.width();
            }
            RenderUtil.renderText(actualHealth, maxHealth, graphics, baseX, textY, color, alignment);
        }
        if (absorptionAmount > 0 || EditModeManager.isEditModeEnabled()) {
            String absorptionText = "+" + String.valueOf(EditModeManager.isEditModeEnabled() && absorptionAmount == 0 ? "8" : Integer.valueOf(absorptionAmount));
            ScreenRect absorptionRect = HealthBarRenderer.getSubElementRect(SubElementType.ABSORPTION_TEXT, player);
            int absorptionTextX = absorptionRect.x();
            int absorptionTextY = absorptionRect.y() + absorptionRect.height() / 2;
            ClientConfig config = ModConfigManager.getClient();
            int baseAbsorptionColor = config.healthTextColor & 0xFFFFFF;
            int absorptionAlpha = (int)((float)config.healthTextOpacity * currentAlphaForRender);
            absorptionAlpha = Math.max(10, Math.min(255, absorptionAlpha));
            int absorptionFinalColor = absorptionAlpha << 24 | baseAbsorptionColor;
            RenderUtil.renderAdditionText(absorptionText, graphics, absorptionTextX, absorptionTextY, absorptionFinalColor);
        }
        if (EditModeManager.isEditModeEnabled()) {
            DraggableElement currentBarType = DraggableElement.HEALTH_BAR;
            if (EditModeManager.getFocusedElement() == currentBarType) {
                ScreenRect absorptionRect;
                int focusedBorderColor = -1593835776;
                ScreenRect bgRect = HealthBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                graphics.renderOutline(bgRect.x() - 1, bgRect.y() - 1, bgRect.width() + 2, bgRect.height() + 2, focusedBorderColor);
                ScreenRect barRect = HealthBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                graphics.renderOutline(barRect.x() - 1, barRect.y() - 1, barRect.width() + 2, barRect.height() + 2, -1610547456);
                if (ModConfigManager.getClient().enableHealthForeground) {
                    ScreenRect fgRect = HealthBarRenderer.getSubElementRect(SubElementType.FOREGROUND, player);
                    graphics.renderOutline(fgRect.x() - 1, fgRect.y() - 1, fgRect.width() + 2, fgRect.height() + 2, -1593900801);
                }
                if ((absorptionRect = HealthBarRenderer.getSubElementRect(SubElementType.ABSORPTION_TEXT, player)) != null && absorptionRect.width() > 0 && absorptionRect.height() > 0) {
                    graphics.renderOutline(absorptionRect.x() - 1, absorptionRect.y() - 1, absorptionRect.width() + 2, absorptionRect.height() + 2, 0x60FFFFFF);
                }
                graphics.renderOutline(complexRect.x() - 2, complexRect.y() - 2, complexRect.width() + 4, complexRect.height() + 4, -2130706433);
            } else {
                int borderColor = -2130706433;
                graphics.renderOutline(complexRect.x() - 1, complexRect.y() - 1, complexRect.width() + 2, complexRect.height() + 2, borderColor);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void updateChunkTracking(Player player, float currentHealth, float maxHealth, float partialTicks) {
        Iterator<FadingChunk> it = fadingChunks.iterator();
        while (it.hasNext()) {
            FadingChunk chunk = it.next();
            if (!chunk.isExpired() && !(currentHealth >= chunk.endValue)) continue;
            it.remove();
        }
        if (previousHealth > 0.0f && currentHealth < previousHealth && previousMaxHealth == maxHealth) {
            BarType barType = BarType.fromPlayerState(player);
            String texture = barType.getTexture();
            AnimationMetadata.AnimationData animData = AnimationMetadataCache.getHealthBarAnimation();
            float ticks = (float)player.tickCount + partialTicks;
            int animOffset = AnimationMetadata.calculateAnimationOffset(animData, ticks);
            float chunkStart = Math.max(0.0f, currentHealth);
            fadingChunks.add(new FadingChunk(chunkStart, previousHealth, maxHealth, texture, animOffset));
        }
        previousHealth = currentHealth;
        previousMaxHealth = maxHealth;
    }

    private static void renderFadingChunks(GuiGraphics graphics, ScreenRect barRect, float currentHealth, float maxHealth, boolean isRightAnchored, float parentAlpha, AnimationMetadata.AnimationData animData) {
        if (fadingChunks.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        FillDirection fillDirection = ModConfigManager.getClient().healthFillDirection;
        for (FadingChunk chunk : fadingChunks) {
            int uOffset;
            int xPos;
            float endRatio;
            float startRatio;
            float alpha = chunk.getAlpha() * parentAlpha;
            if (alpha <= 0.0f) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            ResourceLocation chunkTexture = DynamicResourceBars.loc("textures/gui/" + chunk.texture + ".png");
            if (fillDirection == FillDirection.VERTICAL) {
                startRatio = Math.max(0.0f, Math.min(1.0f, chunk.startValue / chunk.maxValue));
                endRatio = Math.max(0.0f, Math.min(1.0f, chunk.endValue / chunk.maxValue));
                int startHeight = (int)((float)barRect.height() * startRatio);
                int endHeight = (int)((float)barRect.height() * endRatio);
                int chunkHeight = endHeight - startHeight;
                if (chunkHeight <= 0) continue;
                int yPos = barRect.y() + (barRect.height() - endHeight);
                int textureVOffset = chunk.animOffset + (barRect.height() - endHeight);
                RenderUtil.blitWithBinding(graphics, chunkTexture, barRect.x(), yPos, 0, textureVOffset, barRect.width(), chunkHeight, animData.textureWidth, animData.textureHeight);
                continue;
            }
            startRatio = Math.max(0.0f, Math.min(1.0f, chunk.startValue / chunk.maxValue));
            endRatio = Math.max(0.0f, Math.min(1.0f, chunk.endValue / chunk.maxValue));
            int startWidth = (int)((float)barRect.width() * startRatio);
            int endWidth = (int)((float)barRect.width() * endRatio);
            int chunkWidth = endWidth - startWidth;
            if (chunkWidth <= 0) continue;
            if (isRightAnchored) {
                xPos = barRect.x() + barRect.width() - endWidth;
                uOffset = barRect.width() - endWidth;
            } else {
                xPos = barRect.x() + startWidth;
                uOffset = startWidth;
            }
            RenderUtil.blitWithBinding(graphics, chunkTexture, xPos, barRect.y(), uOffset, chunk.animOffset, chunkWidth, barRect.height(), animData.textureWidth, animData.textureHeight);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void renderBaseBar(GuiGraphics graphics, Player player, float maxHealth, float actualHealth, int barAbsX, int barAbsY, int barAbsWidth, int barAbsHeight, int barXOffsetWithinTexture, int barYOffsetWithinTexture, int animOffset, boolean isRightAnchored, AnimationMetadata.AnimationData animData) {
        BarType barType = BarType.fromPlayerState(player);
        ResourceLocation barTexture = DynamicResourceBars.loc("textures/gui/" + barType.getTexture() + ".png");
        float currentHealthRatio = maxHealth == 0.0f ? 0.0f : Math.max(0.0f, Math.min(1.0f, actualHealth / maxHealth));
        FillDirection fillDirection = ModConfigManager.getClient().healthFillDirection;
        if (fillDirection == FillDirection.VERTICAL) {
            int partialBarHeight = (int)((float)barAbsHeight * currentHealthRatio);
            if (partialBarHeight <= 0 && actualHealth > 0.0f) {
                partialBarHeight = 1;
            }
            if (partialBarHeight > 0) {
                RenderUtil.blitWithBinding(graphics, barTexture, barAbsX, barAbsY + (barAbsHeight - partialBarHeight), barXOffsetWithinTexture, animOffset + barYOffsetWithinTexture + (barAbsHeight - partialBarHeight), barAbsWidth, partialBarHeight, animData.textureWidth, animData.textureHeight);
            }
        } else {
            int partialBarWidth = (int)((float)barAbsWidth * currentHealthRatio);
            if (partialBarWidth <= 0 && actualHealth > 0.0f) {
                partialBarWidth = 1;
            }
            if (partialBarWidth > 0) {
                int renderBarX = barAbsX;
                int uTexOffset = barXOffsetWithinTexture;
                if (isRightAnchored) {
                    renderBarX = barAbsX + barAbsWidth - partialBarWidth;
                    uTexOffset = barXOffsetWithinTexture + barAbsWidth - partialBarWidth;
                }
                RenderUtil.blitWithBinding(graphics, barTexture, renderBarX, barAbsY, uTexOffset, animOffset + barYOffsetWithinTexture, partialBarWidth, barAbsHeight, animData.textureWidth, animData.textureHeight);
            }
        }
    }

    private static void renderBarOverlays(GuiGraphics graphics, Player player, int absorptionAmount, int barAbsX, int barAbsY, int barAbsWidth, int barAbsHeight, int barXOffset, int barYOffset) {
        float pulseAlpha;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float tempScale = HealthBarRenderer.getTemperatureScale(player);
        HealthBarRenderer.renderTemperatureOverlay(graphics, tempScale, barAbsX + barXOffset, barAbsY + barYOffset, barAbsWidth, barAbsHeight, 0, 0);
        if (absorptionAmount > 0) {
            pulseAlpha = 0.5f + TickHandler.getOverlayFlashAlpha() * 0.5f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)pulseAlpha);
            ResourceLocation absorptionTexture = DynamicResourceBars.loc("textures/gui/absorption_overlay.png");
            AnimationMetadata.ScalingInfo absorptionScaling = AnimationMetadataCache.getAbsorptionOverlayScaling();
            AnimationMetadata.TextureDimensions absorptionDims = AnimationMetadataCache.getTextureDimensions(absorptionTexture);
            NineSliceRenderer.renderWithScaling(graphics, absorptionTexture, absorptionScaling, barAbsX + barXOffset, barAbsY + barYOffset, barAbsWidth, barAbsHeight, absorptionDims.width, absorptionDims.height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (PlatformUtil.isModLoaded("farmersdelight") && HealthBarRenderer.hasComfortEffect(player) && player.getFoodData().getSaturationLevel() == 0.0f && player.isHurt() && !player.hasEffect(MobEffects.REGENERATION)) {
            pulseAlpha = TickHandler.getOverlayFlashAlpha();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)pulseAlpha);
            ResourceLocation comfortTexture = DynamicResourceBars.loc("textures/gui/comfort_overlay.png");
            AnimationMetadata.ScalingInfo comfortScaling = AnimationMetadataCache.getComfortOverlayScaling();
            AnimationMetadata.TextureDimensions comfortDims = AnimationMetadataCache.getTextureDimensions(comfortTexture);
            NineSliceRenderer.renderWithScaling(graphics, comfortTexture, comfortScaling, barAbsX + barXOffset, barAbsY + barYOffset, barAbsWidth, barAbsHeight, comfortDims.width, comfortDims.height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (player.hasEffect(MobEffects.REGENERATION)) {
            pulseAlpha = TickHandler.getOverlayFlashAlpha();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)pulseAlpha);
            ResourceLocation regenTexture = DynamicResourceBars.loc("textures/gui/regeneration_overlay.png");
            AnimationMetadata.ScalingInfo regenScaling = AnimationMetadataCache.getRegenerationOverlayScaling();
            AnimationMetadata.TextureDimensions regenDims = AnimationMetadataCache.getTextureDimensions(regenTexture);
            NineSliceRenderer.renderWithScaling(graphics, regenTexture, regenScaling, barAbsX + barXOffset, barAbsY + barYOffset, barAbsWidth, barAbsHeight, regenDims.width, regenDims.height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.disableBlend();
    }

    private static void renderBackgroundOverlays(GuiGraphics graphics, Player player, int complexX, int complexY, int backgroundWidth, int backgroundHeight) {
        float wetScale;
        if (player.level().getLevelData().isHardcore()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            ResourceLocation hardcoreTexture = DynamicResourceBars.loc("textures/gui/hardcore_overlay.png");
            AnimationMetadata.ScalingInfo hardcoreScaling = AnimationMetadataCache.getHardcoreOverlayScaling();
            AnimationMetadata.TextureDimensions hardcoreDims = AnimationMetadataCache.getTextureDimensions(hardcoreTexture);
            NineSliceRenderer.renderWithScaling(graphics, hardcoreTexture, hardcoreScaling, complexX, complexY, backgroundWidth, backgroundHeight, hardcoreDims.width, hardcoreDims.height);
            RenderSystem.disableBlend();
        }
        if ((wetScale = HealthBarRenderer.getWetnessScale(player)) > 0.0f) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)wetScale);
            ResourceLocation wetnessTexture = DynamicResourceBars.loc("textures/gui/wetness_overlay.png");
            AnimationMetadata.ScalingInfo wetnessScaling = AnimationMetadataCache.getWetnessOverlayScaling();
            AnimationMetadata.TextureDimensions wetnessDims = AnimationMetadataCache.getTextureDimensions(wetnessTexture);
            NineSliceRenderer.renderWithScaling(graphics, wetnessTexture, wetnessScaling, complexX, complexY, backgroundWidth, backgroundHeight, wetnessDims.width, wetnessDims.height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
        if (ModConfigManager.getClient().enableHealthForeground) {
            ScreenRect fgRect = HealthBarRenderer.getSubElementRect(SubElementType.FOREGROUND, player);
            ResourceLocation fgTexture = DynamicResourceBars.loc("textures/gui/health_foreground.png");
            AnimationMetadata.ScalingInfo fgScaling = AnimationMetadataCache.getHealthForegroundScaling();
            AnimationMetadata.TextureDimensions fgDims = AnimationMetadataCache.getTextureDimensions(fgTexture);
            NineSliceRenderer.renderWithScaling(graphics, fgTexture, fgScaling, fgRect.x(), fgRect.y(), fgRect.width(), fgRect.height(), fgDims.width, fgDims.height);
        }
    }

    private static void renderTemperatureOverlay(GuiGraphics graphics, float tempScale, int xPos, int yPos, int barWidth, int barHeight, int barXOffset, int barYOffset) {
        if (tempScale > 0.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)HealthBarRenderer.getHealthBarAlpha());
            int heatWidth = (int)((float)barWidth * tempScale);
            ResourceLocation heatTexture = DynamicResourceBars.loc("textures/gui/heat_overlay.png");
            AnimationMetadata.ScalingInfo heatScaling = AnimationMetadataCache.getHeatOverlayScaling();
            AnimationMetadata.TextureDimensions heatDims = AnimationMetadataCache.getTextureDimensions(heatTexture);
            NineSliceRenderer.renderWithScaling(graphics, heatTexture, heatScaling, xPos + barXOffset, yPos + barYOffset, heatWidth, barHeight, heatDims.width, heatDims.height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else if (tempScale < 0.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)HealthBarRenderer.getHealthBarAlpha());
            int coldWidth = (int)((float)barWidth * -tempScale);
            ResourceLocation coldTexture = DynamicResourceBars.loc("textures/gui/cold_overlay.png");
            AnimationMetadata.ScalingInfo coldScaling = AnimationMetadataCache.getColdOverlayScaling();
            AnimationMetadata.TextureDimensions coldDims = AnimationMetadataCache.getTextureDimensions(coldTexture);
            NineSliceRenderer.renderWithScaling(graphics, coldTexture, coldScaling, xPos + barXOffset, yPos + barYOffset, coldWidth, barHeight, coldDims.width, coldDims.height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static float getWetnessScale(Player player) {
        if (PlatformUtil.isModLoaded("thermoo")) {
            try {
                Method getWetScale = player.getClass().getMethod("thermoo$getSoakedScale", new Class[0]);
                return ((Float)getWetScale.invoke((Object)player, new Object[0])).floatValue();
            }
            catch (Exception e) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    private static boolean isScorched(Player player) {
        if (PlatformUtil.isModLoaded("thermoo")) {
            try {
                Method getMaxTemp = player.getClass().getMethod("thermoo$getMaxTemperature", new Class[0]);
                Method getTemp = player.getClass().getMethod("thermoo$getTemperature", new Class[0]);
                int maxTemperature = (Integer)getMaxTemp.invoke((Object)player, new Object[0]);
                int temperature = (Integer)getTemp.invoke((Object)player, new Object[0]);
                return (double)temperature > 0.5 && temperature >= maxTemperature - 1;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private static boolean isFrozen(Player player) {
        if (player.isFullyFrozen()) {
            return true;
        }
        if (PlatformUtil.isModLoaded("thermoo")) {
            try {
                Method getTemp = player.getClass().getMethod("thermoo$getTemperature", new Class[0]);
                Method getTempScale = player.getClass().getMethod("thermoo$getTemperatureScale", new Class[0]);
                int minTemperature = (Integer)getTemp.invoke((Object)player, new Object[0]);
                if (minTemperature < 0) {
                    float tempScale = ((Float)getTempScale.invoke((Object)player, new Object[0])).floatValue();
                    return tempScale <= -0.99f;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static float getTemperatureScale(Player player) {
        try {
            Method getTempScale = player.getClass().getMethod("thermoo$getTemperatureScale", new Class[0]);
            return ((Float)getTempScale.invoke((Object)player, new Object[0])).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private static int getHealthTextColor(float currentHealth, float maxHealth) {
        TextBehavior behavior = ModConfigManager.getClient().showHealthText;
        ClientConfig config = ModConfigManager.getClient();
        int baseColor = config.healthTextColor & 0xFFFFFF;
        int alpha = config.healthTextOpacity;
        if (behavior == TextBehavior.WHEN_NOT_FULL && currentHealth >= maxHealth) {
            long timeSinceFull = System.currentTimeMillis() - fullHealthStartTime;
            alpha = (int)((float)alpha * ((float)RenderUtil.calculateTextAlpha(timeSinceFull) / 200.0f));
        }
        alpha = (int)((float)alpha * HealthBarRenderer.getHealthBarAlpha());
        alpha = Math.max(10, Math.min(255, alpha));
        return alpha << 24 | baseColor;
    }

    private static boolean shouldRenderHealthText(float currentHealth, float maxHealth, Player player) {
        boolean isFull;
        TextBehavior behavior = ModConfigManager.getClient().showHealthText;
        if (EditModeManager.isEditModeEnabled() && (behavior == TextBehavior.ALWAYS || behavior == TextBehavior.WHEN_NOT_FULL)) {
            return true;
        }
        if (behavior == TextBehavior.NEVER) {
            return false;
        }
        if (behavior == TextBehavior.ALWAYS) {
            return true;
        }
        boolean bl = isFull = currentHealth >= maxHealth;
        if (isFull) {
            if (lastHealth < maxHealth || lastHealth == -1.0f) {
                fullHealthStartTime = System.currentTimeMillis();
            }
            lastHealth = currentHealth;
            return System.currentTimeMillis() - fullHealthStartTime < 2000L;
        }
        lastHealth = currentHealth;
        return true;
    }

    private static void setHealthBarVisibility(boolean visible) {
        if (healthBarSetVisible != visible) {
            if (!visible) {
                healthBarDisabledStartTime = System.currentTimeMillis();
            }
            healthBarSetVisible = visible;
        }
    }

    private static boolean isHealthBarVisible() {
        return healthBarSetVisible;
    }

    private static float getHealthBarAlpha() {
        if (HealthBarRenderer.isHealthBarVisible()) {
            return 1.0f;
        }
        long timeSinceDisabled = System.currentTimeMillis() - healthBarDisabledStartTime;
        if (timeSinceDisabled >= 1500L) {
            return 0.0f;
        }
        return Math.max(0.0f, 1.0f - (float)timeSinceDisabled / 1500.0f);
    }

    private static ItemStack getHeldFood(Player player) {
        ItemStack mainHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (AppleSkinCompat.canConsume(mainHand, player)) {
            return mainHand;
        }
        ItemStack offHand = player.getItemInHand(InteractionHand.OFF_HAND);
        if (AppleSkinCompat.canConsume(offHand, player)) {
            return offHand;
        }
        return ItemStack.EMPTY;
    }

    private static void renderHealthRestoredOverlay(GuiGraphics graphics, Player player, ItemStack heldFood, float currentHealth, float maxHealth, ScreenRect barRect, int animOffset, boolean isRightAnchored, AnimationMetadata.AnimationData animData) {
        if (!PlatformUtil.isModLoaded("appleskin")) {
            return;
        }
        float healthRestoration = AppleSkinCompat.getEstimatedHealthRestoration(heldFood, player);
        if (healthRestoration <= 0.0f || currentHealth >= maxHealth) {
            return;
        }
        float restoredHealth = Math.min(maxHealth, currentHealth + healthRestoration);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)TickHandler.getOverlayFlashAlpha());
        FillDirection fillDirection = ModConfigManager.getClient().healthFillDirection;
        BarType barType = BarType.fromPlayerState(player);
        ResourceLocation barTexture = DynamicResourceBars.loc("textures/gui/" + barType.getTexture() + ".png");
        if (fillDirection == FillDirection.VERTICAL) {
            int currentHeight = (int)((float)barRect.height() * Math.max(0.0f, Math.min(1.0f, currentHealth / maxHealth)));
            int restoredHeight = (int)((float)barRect.height() * Math.max(0.0f, Math.min(1.0f, restoredHealth / maxHealth)));
            int overlayHeight = restoredHeight - currentHeight;
            if (overlayHeight > 0) {
                int yPos = barRect.y() + (barRect.height() - restoredHeight);
                int textureVOffset = animOffset + (barRect.height() - restoredHeight);
                RenderUtil.blitWithBinding(graphics, barTexture, barRect.x(), yPos, 0, textureVOffset, barRect.width(), overlayHeight, animData.textureWidth, animData.textureHeight);
            }
        } else {
            int currentWidth = (int)((float)barRect.width() * Math.max(0.0f, Math.min(1.0f, currentHealth / maxHealth)));
            int restoredWidth = (int)((float)barRect.width() * Math.max(0.0f, Math.min(1.0f, restoredHealth / maxHealth)));
            int overlayWidth = restoredWidth - currentWidth;
            if (overlayWidth > 0) {
                int uTexOffset;
                int xDrawPos;
                if (isRightAnchored) {
                    xDrawPos = barRect.x() + barRect.width() - restoredWidth;
                    uTexOffset = barRect.width() - restoredWidth;
                } else {
                    xDrawPos = barRect.x() + currentWidth;
                    uTexOffset = currentWidth;
                }
                RenderUtil.blitWithBinding(graphics, barTexture, xDrawPos, barRect.y(), uTexOffset, animOffset, overlayWidth, barRect.height(), animData.textureWidth, animData.textureHeight);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static boolean hasComfortEffect(Player player) {
        Holder comfortEffect = ModEffects.COMFORT;
        return player.hasEffect(comfortEffect);
    }

    private static class FadingChunk {
        final float startValue;
        final float endValue;
        final float maxValue;
        final long creationTime;
        final String texture;
        final int animOffset;

        FadingChunk(float startValue, float endValue, float maxValue, String texture, int animOffset) {
            this.startValue = startValue;
            this.endValue = endValue;
            this.maxValue = maxValue;
            this.creationTime = System.currentTimeMillis();
            this.texture = texture;
            this.animOffset = animOffset;
        }

        float getAlpha() {
            long elapsed = System.currentTimeMillis() - this.creationTime;
            if (elapsed >= 500L) {
                return 0.0f;
            }
            return 1.0f - (float)elapsed / 500.0f;
        }

        boolean isExpired() {
            return this.getAlpha() <= 0.0f;
        }
    }

    private static enum BarType {
        NORMAL("health_bar"),
        POISON("health_bar_poisoned"),
        WITHER("health_bar_withered"),
        FROZEN("health_bar_frozen"),
        SCORCHED("health_bar_scorched");

        private final String texture;

        private BarType(String texture) {
            this.texture = texture;
        }

        private BarType() {
            this.texture = this.name().toLowerCase();
        }

        public String getTexture() {
            return this.texture;
        }

        public static BarType fromPlayerState(Player player) {
            if (player.hasEffect(MobEffects.POISON)) {
                return POISON;
            }
            if (player.hasEffect(MobEffects.WITHER)) {
                return WITHER;
            }
            if (HealthBarRenderer.isFrozen(player)) {
                return FROZEN;
            }
            if (HealthBarRenderer.isScorched(player)) {
                return SCORCHED;
            }
            return NORMAL;
        }
    }
}

