/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.NativeImage;
import dev.muon.dynamic_resource_bars.DynamicResourceBars;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class TextureMetadata {
    public static FullMetadata loadFullMetadata(ResourceManager resourceManager, ResourceLocation textureLocation) {
        NineSliceInfo nineSlice;
        UVMapping uvMapping;
        AnimationInfo animation;
        int textureHeight;
        int textureWidth;
        block24: {
            block23: {
                textureWidth = 256;
                textureHeight = 1024;
                try {
                    Optional texResourceOpt = resourceManager.getResource(textureLocation);
                    if (!texResourceOpt.isPresent()) break block23;
                    try (InputStream stream = ((Resource)texResourceOpt.get()).open();){
                        NativeImage image = NativeImage.read((InputStream)stream);
                        textureWidth = image.getWidth();
                        textureHeight = image.getHeight();
                        image.close();
                        DynamicResourceBars.LOGGER.info("Detected texture size for {}: {}x{}", (Object)textureLocation, (Object)textureWidth, (Object)textureHeight);
                    }
                }
                catch (Exception e) {
                    DynamicResourceBars.LOGGER.warn("Could not read texture dimensions for {}, using defaults", (Object)textureLocation);
                }
            }
            animation = null;
            uvMapping = null;
            nineSlice = null;
            ResourceLocation mcmetaLocation = ResourceLocation.fromNamespaceAndPath((String)textureLocation.getNamespace(), (String)(textureLocation.getPath() + ".mcmeta"));
            try {
                Optional resourceOpt = resourceManager.getResource(mcmetaLocation);
                if (!resourceOpt.isPresent()) break block24;
                Resource resource = (Resource)resourceOpt.get();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.open(), StandardCharsets.UTF_8));){
                    JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    animation = TextureMetadata.parseAnimation(root, textureLocation, textureHeight);
                    if (root.has("dynamic_resource_bars")) {
                        JsonObject custom = root.getAsJsonObject("dynamic_resource_bars");
                        if (custom.has("uv")) {
                            uvMapping = TextureMetadata.parseUVMapping(custom.getAsJsonObject("uv"), textureWidth, textureHeight);
                        }
                        if (custom.has("nine_slice")) {
                            nineSlice = TextureMetadata.parseNineSlice(custom.getAsJsonObject("nine_slice"));
                        }
                    }
                }
                catch (Exception e) {
                    DynamicResourceBars.LOGGER.error("ERROR parsing .mcmeta for {}: {}", (Object)textureLocation, (Object)e.getMessage());
                }
            }
            catch (Exception e) {
                DynamicResourceBars.LOGGER.info("No .mcmeta for {} or could not load", (Object)textureLocation);
            }
        }
        if (animation == null) {
            int frameHeight = 32;
            int totalFrames = textureHeight / frameHeight;
            animation = new AnimationInfo(3, frameHeight, totalFrames, false);
            DynamicResourceBars.LOGGER.warn("No animation data in .mcmeta for {}, using defaults (frametime=3, height=32)", (Object)textureLocation);
        }
        if (uvMapping == null) {
            uvMapping = UVMapping.createDefault(textureWidth, animation.frameHeight);
        }
        if (nineSlice == null) {
            nineSlice = new NineSliceInfo(0, 0, 0, 0);
        }
        return new FullMetadata(textureWidth, textureHeight, animation, uvMapping, nineSlice);
    }

    private static AnimationInfo parseAnimation(JsonObject root, ResourceLocation location, int textureHeight) {
        int frameHeight;
        boolean interpolate;
        if (!root.has("animation")) {
            return null;
        }
        JsonObject animation = root.getAsJsonObject("animation");
        int frametime = animation.has("frametime") ? animation.get("frametime").getAsInt() : 3;
        boolean bl = interpolate = animation.has("interpolate") && animation.get("interpolate").getAsBoolean();
        if (animation.has("height")) {
            frameHeight = animation.get("height").getAsInt();
        } else if (animation.has("frameHeight")) {
            frameHeight = animation.get("frameHeight").getAsInt();
        } else {
            DynamicResourceBars.LOGGER.error("INVALID .mcmeta for {}: Missing 'height' field in animation! Using 32px.", (Object)location);
            frameHeight = 32;
        }
        int totalFrames = textureHeight / frameHeight;
        DynamicResourceBars.LOGGER.info("Loaded animation for {}: frametime={}, frameHeight={}, totalFrames={}", (Object)location, (Object)frametime, (Object)frameHeight, (Object)totalFrames);
        return new AnimationInfo(frametime, frameHeight, totalFrames, interpolate);
    }

    private static UVMapping parseUVMapping(JsonObject uv, int textureWidth, int defaultHeight) {
        int u = uv.has("u") ? uv.get("u").getAsInt() : 0;
        int v = uv.has("v") ? uv.get("v").getAsInt() : 0;
        int width = uv.has("width") ? uv.get("width").getAsInt() : textureWidth;
        int height = uv.has("height") ? uv.get("height").getAsInt() : defaultHeight;
        DynamicResourceBars.LOGGER.info("Loaded UV mapping: u={}, v={}, width={}, height={}", (Object)u, (Object)v, (Object)width, (Object)height);
        return new UVMapping(u, v, width, height);
    }

    private static NineSliceInfo parseNineSlice(JsonObject nineSlice) {
        int left = nineSlice.has("left") ? nineSlice.get("left").getAsInt() : 0;
        int right = nineSlice.has("right") ? nineSlice.get("right").getAsInt() : 0;
        int top = nineSlice.has("top") ? nineSlice.get("top").getAsInt() : 0;
        int bottom = nineSlice.has("bottom") ? nineSlice.get("bottom").getAsInt() : 0;
        DynamicResourceBars.LOGGER.info("Loaded nine-slice: left={}, right={}, top={}, bottom={}", (Object)left, (Object)right, (Object)top, (Object)bottom);
        return new NineSliceInfo(left, right, top, bottom);
    }

    public static class AnimationInfo {
        public final int frametime;
        public final int frameHeight;
        public final int totalFrames;
        public final boolean interpolate;

        public AnimationInfo(int frametime, int frameHeight, int totalFrames, boolean interpolate) {
            this.frametime = frametime;
            this.frameHeight = frameHeight;
            this.totalFrames = totalFrames;
            this.interpolate = interpolate;
        }
    }

    public static class UVMapping {
        public final int uOffset;
        public final int vOffset;
        public final int width;
        public final int height;

        public UVMapping(int uOffset, int vOffset, int width, int height) {
            this.uOffset = uOffset;
            this.vOffset = vOffset;
            this.width = width;
            this.height = height;
        }

        public static UVMapping createDefault(int width, int height) {
            return new UVMapping(0, 0, width, height);
        }
    }

    public static class NineSliceInfo {
        public final int left;
        public final int right;
        public final int top;
        public final int bottom;

        public NineSliceInfo(int left, int right, int top, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public boolean isEnabled() {
            return this.left > 0 || this.right > 0 || this.top > 0 || this.bottom > 0;
        }
    }

    public static class FullMetadata {
        public final int textureWidth;
        public final int textureHeight;
        public final AnimationInfo animation;
        public final UVMapping uvMapping;
        public final NineSliceInfo nineSlice;

        public FullMetadata(int textureWidth, int textureHeight, AnimationInfo animation, UVMapping uvMapping, NineSliceInfo nineSlice) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.animation = animation;
            this.uvMapping = uvMapping;
            this.nineSlice = nineSlice;
        }
    }
}

