/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.config.gui;

import dev.muon.dynamic_resource_bars.compat.ManaProviderManager;
import dev.muon.dynamic_resource_bars.compat.StaminaProviderManager;
import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.config.gui.ContextMenu;
import dev.muon.dynamic_resource_bars.config.gui.ContextMenuItem;
import dev.muon.dynamic_resource_bars.config.gui.ManualPositionScreen;
import dev.muon.dynamic_resource_bars.config.gui.ManualSizePositionScreen;
import dev.muon.dynamic_resource_bars.config.gui.MultiLineConfirmResetScreen;
import dev.muon.dynamic_resource_bars.provider.ManaBarBehavior;
import dev.muon.dynamic_resource_bars.provider.StaminaBarBehavior;
import dev.muon.dynamic_resource_bars.render.AirBarRenderer;
import dev.muon.dynamic_resource_bars.render.ArmorBarRenderer;
import dev.muon.dynamic_resource_bars.render.HealthBarRenderer;
import dev.muon.dynamic_resource_bars.render.ManaBarRenderer;
import dev.muon.dynamic_resource_bars.render.StaminaBarRenderer;
import dev.muon.dynamic_resource_bars.util.BarRenderBehavior;
import dev.muon.dynamic_resource_bars.util.DraggableElement;
import dev.muon.dynamic_resource_bars.util.EditModeManager;
import dev.muon.dynamic_resource_bars.util.FillDirection;
import dev.muon.dynamic_resource_bars.util.HUDPositioning;
import dev.muon.dynamic_resource_bars.util.HorizontalAlignment;
import dev.muon.dynamic_resource_bars.util.PlatformUtil;
import dev.muon.dynamic_resource_bars.util.Position;
import dev.muon.dynamic_resource_bars.util.ScreenRect;
import dev.muon.dynamic_resource_bars.util.SubElementType;
import dev.muon.dynamic_resource_bars.util.TextBehavior;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;

public class HudEditorScreen
extends class_437 {
    private static final int HELP_TEXT_TOP_Y = 15;
    private static final int LINE_SPACING = 2;
    private static final int HANDLE_SIZE = 3;
    private static final int HANDLE_HOVER_COLOR = -1426063616;
    private ResizeMode currentResizeMode = ResizeMode.NONE;
    private int resizeStartX;
    private int resizeStartY;
    private int initialWidth;
    private int initialHeight;
    private SubElementType resizingSubElement = null;
    private DraggableElement focusedElementForResize = null;
    private class_437 previousScreen;
    private long lastClickTime = 0L;
    private double lastClickX = 0.0;
    private double lastClickY = 0.0;
    private static final int DOUBLE_CLICK_TIME_MS = 300;
    private DraggableElement lastDraggedElementForUndo = null;
    private int lastDragInitialXOffset;
    private int lastDragInitialYOffset;
    private boolean canUndoLastDrag = false;
    private DraggableElement lastFocusedElementForSubUndo = null;
    private SubElementType lastDraggedSubElementForUndo = null;
    private int lastSubDragInitialXOffset;
    private int lastSubDragInitialYOffset;
    private boolean canUndoLastSubDrag = false;
    private class_4185 resetButtonForAllBars;
    private ContextMenu activeContextMenu = null;
    private DraggableElement contextMenuElement = null;
    private SubElementType contextMenuSubElement = null;
    private int contextMenuX = 0;
    private int contextMenuY = 0;

    public HudEditorScreen(class_437 previous) {
        super((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.title"));
        this.previousScreen = previous;
    }

    protected void method_25426() {
        super.method_25426();
        if (!EditModeManager.isEditModeEnabled()) {
            EditModeManager.toggleEditMode();
        }
        this.rebuildEditorWidgets();
        this.canUndoLastDrag = false;
        this.lastDraggedElementForUndo = null;
        this.canUndoLastSubDrag = false;
        this.lastFocusedElementForSubUndo = null;
        this.lastDraggedSubElementForUndo = null;
    }

    private void rebuildEditorWidgets() {
        DraggableElement focused = EditModeManager.getFocusedElement();
        ClientConfig config = ModConfigManager.getClient();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int fontHeight = 9;
        this.method_37067();
        this.resetButtonForAllBars = null;
        if (focused == null) {
            int gridButtonHeight = 20;
            int rowSpacing = 5;
            int colSpacing = 5;
            int gridTopY = 40;
            int threeColButtonWidth = 100;
            int threeColContentWidth = 3 * threeColButtonWidth + 2 * colSpacing;
            int threeColStartX = (this.field_22789 - threeColContentWidth) / 2;
            int currentY = gridTopY + 2 * (fontHeight + 2) + 10;
            int resetAllButtonWidth = 150;
            this.resetButtonForAllBars = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.button.reset_all_bars"), b -> this.openMultiLineConfirmScreen((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.confirm.reset_all.title"), this::resetAllDefaultsAction)).method_46434((this.field_22789 - resetAllButtonWidth) / 2, currentY, resetAllButtonWidth, gridButtonHeight).method_46431();
            this.method_37063((class_364)this.resetButtonForAllBars);
        } else {
            int focusButtonWidth = 120;
            int focusButtonHeight = 20;
            int buttonsTopY = 15 + 4 * (fontHeight + 2) + (fontHeight + 2) + 15;
            int currentY = buttonsTopY + 5;
            DraggableElement finalFocusedElement = focused;
            int currentX = (this.field_22789 - focusButtonWidth) / 2;
            class_4185 resetAllButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.button.reset_element"), b -> {
                class_5250 title = class_2561.method_43469((String)"gui.dynamic_resource_bars.confirm.reset_element.title", (Object[])new Object[]{this.getFriendlyElementName(finalFocusedElement)});
                this.openMultiLineConfirmScreen((class_2561)title, () -> {
                    this.resetElementToDefaults(finalFocusedElement, config);
                    this.rebuildEditorWidgets();
                });
            }).method_46434(currentX, currentY, focusButtonWidth, focusButtonHeight).method_46431();
            this.method_37063((class_364)resetAllButton);
        }
    }

    private TextBehavior getNextTextBehavior(TextBehavior current) {
        TextBehavior[] behaviors = TextBehavior.values();
        int nextIndex = (current.ordinal() + 1) % behaviors.length;
        return behaviors[nextIndex];
    }

    private HorizontalAlignment getNextHorizontalAlignment(HorizontalAlignment current) {
        HorizontalAlignment[] alignments = HorizontalAlignment.values();
        int nextIndex = (current.ordinal() + 1) % alignments.length;
        return alignments[nextIndex];
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        DraggableElement focused = EditModeManager.getFocusedElement();
        DraggableElement dragged = EditModeManager.getDraggedElement();
        class_746 player = class_310.method_1551().field_1724;
        class_327 font = this.field_22793;
        Objects.requireNonNull(font);
        int fontHeight = 9;
        int padding = 5;
        int backgroundColor = -1879048192;
        float minWidgetX = Float.MAX_VALUE;
        float minWidgetY = Float.MAX_VALUE;
        float maxWidgetX = Float.MIN_VALUE;
        float maxWidgetY = Float.MIN_VALUE;
        boolean hasWidgets = false;
        for (class_4068 renderable : this.field_33816) {
            if (!(renderable instanceof class_339)) continue;
            class_339 widget = (class_339)renderable;
            minWidgetX = Math.min(minWidgetX, (float)widget.method_46426());
            minWidgetY = Math.min(minWidgetY, (float)widget.method_46427());
            maxWidgetX = Math.max(maxWidgetX, (float)(widget.method_46426() + widget.method_25368()));
            maxWidgetY = Math.max(maxWidgetY, (float)(widget.method_46427() + widget.method_25364()));
            hasWidgets = true;
        }
        float overallMinX = minWidgetX;
        float overallMinY = 15.0f;
        float overallMaxX = maxWidgetX;
        float overallMaxY = minWidgetY;
        if (!hasWidgets) {
            overallMinX = (float)this.field_22789 / 2.0f - 100.0f;
            overallMaxX = (float)this.field_22789 / 2.0f + 100.0f;
            overallMaxY = 65.0f;
        } else {
            overallMaxY = maxWidgetY;
        }
        int currentTextY = 15;
        if (focused == null) {
            class_5250 helpLine1 = class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.help.main.line1");
            class_5250 helpLine2 = class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.help.main.line4");
            class_5250 helpLine3 = class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.help.main.line3");
            class_5250 helpLine4 = class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.help.main.line2");
            graphics.method_27534(font, (class_2561)helpLine1, this.field_22789 / 2, currentTextY, 0xFFFFFF);
            textWidth = font.method_27525((class_5348)helpLine1);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            graphics.method_27534(font, (class_2561)helpLine2, this.field_22789 / 2, currentTextY += fontHeight + 2, 0xFFFF00);
            textWidth = font.method_27525((class_5348)helpLine2);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            graphics.method_27534(font, (class_2561)helpLine3, this.field_22789 / 2, currentTextY += fontHeight + 2, 0xAAFFAA);
            textWidth = font.method_27525((class_5348)helpLine3);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            graphics.method_27534(font, (class_2561)helpLine4, this.field_22789 / 2, currentTextY += fontHeight + 2, 0x55FF55);
            textWidth = font.method_27525((class_5348)helpLine4);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            overallMaxY = Math.max(overallMaxY, (float)(currentTextY += fontHeight + 2));
        } else {
            class_5250 helpFocusLine1 = class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.help.focus.line1");
            class_5250 helpFocusLine2 = class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.help.focus.line2");
            class_5250 helpFocusLine3 = class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.help.focus.line3").method_27692(class_124.field_1061);
            class_5250 keyboardHelpLine = class_2561.method_43470((String)"Tab: Select Layer | Arrows: Move | Shift+Arrows: Resize");
            graphics.method_27534(font, (class_2561)helpFocusLine1, this.field_22789 / 2, currentTextY, 0xFFFFFF);
            textWidth = font.method_27525((class_5348)helpFocusLine1);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            graphics.method_27534(font, (class_2561)helpFocusLine2, this.field_22789 / 2, currentTextY += fontHeight + 2, 0xFFFFFF);
            textWidth = font.method_27525((class_5348)helpFocusLine2);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            graphics.method_27534(font, (class_2561)helpFocusLine3, this.field_22789 / 2, currentTextY += fontHeight + 2, 0xFFFFFF);
            textWidth = font.method_27525((class_5348)helpFocusLine3);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            graphics.method_27534(font, (class_2561)keyboardHelpLine, this.field_22789 / 2, currentTextY += fontHeight + 2, 0x55FF55);
            textWidth = font.method_27525((class_5348)keyboardHelpLine);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            currentTextY += fontHeight + 2;
            class_5250 headerText = class_2561.method_43469((String)"gui.dynamic_resource_bars.hud_editor.title_focused", (Object[])new Object[]{this.getFriendlyElementName(focused)});
            graphics.method_27534(font, (class_2561)headerText, this.field_22789 / 2, currentTextY += 5, 0xFFFFFF);
            textWidth = font.method_27525((class_5348)headerText);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            currentTextY += fontHeight + 2;
            SubElementType selectedSub = EditModeManager.getKeyboardSelectedSubElement();
            if (selectedSub != null) {
                class_5250 selectionText = class_2561.method_43470((String)" | SELECTED: ").method_27693(this.getSubElementName(selectedSub).getString().toUpperCase());
                graphics.method_27534(font, (class_2561)selectionText, this.field_22789 / 2, currentTextY, 0x55FFFF);
                textWidth = font.method_27525((class_5348)selectionText);
                overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
                overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
                currentTextY += fontHeight + 2;
            }
            overallMaxY = Math.max(overallMaxY, (float)currentTextY);
        }
        if (overallMinX <= overallMaxX && overallMinY <= overallMaxY) {
            graphics.method_25294((int)(overallMinX - (float)padding), (int)(overallMinY - (float)padding), (int)(overallMaxX + (float)padding), (int)(overallMaxY + (float)padding), backgroundColor);
        }
        if (focused == null && dragged != null && player != null) {
            ScreenRect barRect = null;
            HUDPositioning.BarPlacement currentAnchor = null;
            ClientConfig currentConfig = ModConfigManager.getClient();
            switch (dragged) {
                case HEALTH_BAR: {
                    barRect = HealthBarRenderer.getScreenRect((class_1657)player);
                    currentAnchor = currentConfig.healthBarAnchor;
                    break;
                }
                case MANA_BAR: {
                    barRect = ManaBarRenderer.getScreenRect((class_1657)player);
                    currentAnchor = currentConfig.manaBarAnchor;
                    break;
                }
                case STAMINA_BAR: {
                    barRect = StaminaBarRenderer.getScreenRect((class_1657)player);
                    currentAnchor = currentConfig.staminaBarAnchor;
                    break;
                }
                case ARMOR_BAR: {
                    barRect = ArmorBarRenderer.getScreenRect((class_1657)player);
                    currentAnchor = currentConfig.armorBarAnchor;
                    break;
                }
                case AIR_BAR: {
                    barRect = AirBarRenderer.getScreenRect((class_1657)player);
                    currentAnchor = currentConfig.airBarAnchor;
                }
            }
            if (barRect != null && currentAnchor != null && barRect.width() > 0 && barRect.height() > 0) {
                Position anchorPos = HUDPositioning.getPositionFromAnchor(currentAnchor);
                int barCenterX = barRect.x() + barRect.width() / 2;
                int barCenterY = barRect.y() + barRect.height() / 2;
                int lineColor = -1593835521;
                graphics.method_25292(anchorPos.x(), barCenterX, anchorPos.y(), lineColor);
                graphics.method_25301(barCenterX, anchorPos.y(), barCenterY, lineColor);
            }
        }
        if (focused != null && player != null) {
            this.drawResizeHandles(graphics, (class_1657)player, focused, mouseX, mouseY);
            ClientConfig config = ModConfigManager.getClient();
            boolean shouldDrawTextOutline = false;
            switch (focused) {
                case HEALTH_BAR: 
                case MANA_BAR: 
                case STAMINA_BAR: 
                case ARMOR_BAR: 
                case AIR_BAR: {
                    shouldDrawTextOutline = true;
                }
            }
            if (shouldDrawTextOutline) {
                ScreenRect textRect = null;
                switch (focused) {
                    case HEALTH_BAR: {
                        textRect = HealthBarRenderer.getSubElementRect(SubElementType.TEXT, (class_1657)player);
                        break;
                    }
                    case MANA_BAR: {
                        textRect = ManaBarRenderer.getSubElementRect(SubElementType.TEXT, (class_1657)player);
                        break;
                    }
                    case STAMINA_BAR: {
                        textRect = StaminaBarRenderer.getSubElementRect(SubElementType.TEXT, (class_1657)player);
                        break;
                    }
                    case ARMOR_BAR: {
                        textRect = ArmorBarRenderer.getSubElementRect(SubElementType.TEXT, (class_1657)player);
                        break;
                    }
                    case AIR_BAR: {
                        textRect = AirBarRenderer.getSubElementRect(SubElementType.TEXT, (class_1657)player);
                    }
                }
                if (textRect != null && textRect.width() > 0 && textRect.height() > 0) {
                    graphics.method_49601(textRect.x() - 1, textRect.y() - 1, textRect.width() + 2, textRect.height() + 2, 0x60FFFFFF);
                }
            }
            boolean shouldDrawIconOutline = false;
            switch (focused) {
                case ARMOR_BAR: 
                case AIR_BAR: {
                    shouldDrawIconOutline = true;
                }
            }
            if (shouldDrawIconOutline) {
                ScreenRect iconRect = null;
                switch (focused) {
                    case ARMOR_BAR: {
                        if (!config.enableArmorIcon) break;
                        iconRect = ArmorBarRenderer.getSubElementRect(SubElementType.ICON, (class_1657)player);
                        break;
                    }
                    case AIR_BAR: {
                        if (!config.enableAirIcon) break;
                        iconRect = AirBarRenderer.getSubElementRect(SubElementType.ICON, (class_1657)player);
                    }
                }
                if (iconRect != null && iconRect.width() > 0 && iconRect.height() > 0) {
                    int iconOutlineColor = focused == DraggableElement.ARMOR_BAR ? -1597980480 : -1599219482;
                    graphics.method_49601(iconRect.x() - 1, iconRect.y() - 1, iconRect.width() + 2, iconRect.height() + 2, iconOutlineColor);
                }
            }
        }
        if (player != null) {
            DraggableElement keyboardSelected = EditModeManager.getKeyboardSelectedElement();
            SubElementType keyboardSelectedSub = EditModeManager.getKeyboardSelectedSubElement();
            float pulse = (float)(System.currentTimeMillis() % 1000L) / 1000.0f;
            int alpha = (int)(128.0 + 64.0 * Math.sin((double)pulse * Math.PI * 2.0));
            int keyboardSelectionColor = alpha << 24 | 0xFF00;
            if (focused == null && keyboardSelected != null) {
                ScreenRect elementRect = null;
                switch (keyboardSelected) {
                    case HEALTH_BAR: {
                        elementRect = HealthBarRenderer.getScreenRect((class_1657)player);
                        break;
                    }
                    case MANA_BAR: {
                        elementRect = ManaBarRenderer.getScreenRect((class_1657)player);
                        break;
                    }
                    case STAMINA_BAR: {
                        elementRect = StaminaBarRenderer.getScreenRect((class_1657)player);
                        break;
                    }
                    case ARMOR_BAR: {
                        elementRect = ArmorBarRenderer.getScreenRect((class_1657)player);
                        break;
                    }
                    case AIR_BAR: {
                        elementRect = AirBarRenderer.getScreenRect((class_1657)player);
                    }
                }
                if (elementRect != null && elementRect.width() > 0 && elementRect.height() > 0) {
                    graphics.method_49601(elementRect.x() - 2, elementRect.y() - 2, elementRect.width() + 4, elementRect.height() + 4, keyboardSelectionColor);
                }
            } else if (focused != null && keyboardSelectedSub != null) {
                ScreenRect subElementRect = null;
                switch (focused) {
                    case HEALTH_BAR: {
                        subElementRect = HealthBarRenderer.getSubElementRect(keyboardSelectedSub, (class_1657)player);
                        break;
                    }
                    case MANA_BAR: {
                        subElementRect = ManaBarRenderer.getSubElementRect(keyboardSelectedSub, (class_1657)player);
                        break;
                    }
                    case STAMINA_BAR: {
                        subElementRect = StaminaBarRenderer.getSubElementRect(keyboardSelectedSub, (class_1657)player);
                        break;
                    }
                    case ARMOR_BAR: {
                        subElementRect = ArmorBarRenderer.getSubElementRect(keyboardSelectedSub, (class_1657)player);
                        break;
                    }
                    case AIR_BAR: {
                        subElementRect = AirBarRenderer.getSubElementRect(keyboardSelectedSub, (class_1657)player);
                    }
                }
                if (subElementRect != null && subElementRect.width() > 0 && subElementRect.height() > 0) {
                    graphics.method_49601(subElementRect.x() - 2, subElementRect.y() - 2, subElementRect.width() + 4, subElementRect.height() + 4, keyboardSelectionColor);
                }
            }
        }
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.activeContextMenu != null && this.activeContextMenu.isVisible()) {
            this.activeContextMenu.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void method_25420(class_332 graphics) {
    }

    private void drawResizeHandles(class_332 graphics, class_1657 player, DraggableElement focused, int mouseX, int mouseY) {
        ClientConfig config = ModConfigManager.getClient();
        ScreenRect bgRect = null;
        switch (focused) {
            case HEALTH_BAR: {
                if (config.enableHealthBackground) {
                    bgRect = HealthBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                    this.drawHandlesForRect(graphics, bgRect, focused, SubElementType.BACKGROUND, mouseX, mouseY);
                }
                ScreenRect barRect = HealthBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                this.drawHandlesForRect(graphics, barRect, focused, SubElementType.BAR_MAIN, mouseX, mouseY);
                if (!config.enableHealthForeground) break;
                ScreenRect fgRect = HealthBarRenderer.getSubElementRect(SubElementType.FOREGROUND, player);
                this.drawHandlesForRect(graphics, fgRect, focused, SubElementType.FOREGROUND, mouseX, mouseY);
                break;
            }
            case MANA_BAR: {
                if (config.enableManaBackground) {
                    bgRect = ManaBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                    this.drawHandlesForRect(graphics, bgRect, focused, SubElementType.BACKGROUND, mouseX, mouseY);
                }
                ScreenRect manaBarRect = ManaBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                this.drawHandlesForRect(graphics, manaBarRect, focused, SubElementType.BAR_MAIN, mouseX, mouseY);
                if (!config.enableManaForeground) break;
                ScreenRect fgRect = ManaBarRenderer.getSubElementRect(SubElementType.FOREGROUND, player);
                this.drawHandlesForRect(graphics, fgRect, focused, SubElementType.FOREGROUND, mouseX, mouseY);
                break;
            }
            case STAMINA_BAR: {
                if (config.enableStaminaBackground) {
                    bgRect = StaminaBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                    this.drawHandlesForRect(graphics, bgRect, focused, SubElementType.BACKGROUND, mouseX, mouseY);
                }
                ScreenRect staminaBarRect = StaminaBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                this.drawHandlesForRect(graphics, staminaBarRect, focused, SubElementType.BAR_MAIN, mouseX, mouseY);
                if (!config.enableStaminaForeground) break;
                ScreenRect fgRect = StaminaBarRenderer.getSubElementRect(SubElementType.FOREGROUND, player);
                this.drawHandlesForRect(graphics, fgRect, focused, SubElementType.FOREGROUND, mouseX, mouseY);
                break;
            }
            case ARMOR_BAR: {
                bgRect = ArmorBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                this.drawHandlesForRect(graphics, bgRect, focused, SubElementType.BACKGROUND, mouseX, mouseY);
                ScreenRect armorBarRect = ArmorBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                this.drawHandlesForRect(graphics, armorBarRect, focused, SubElementType.BAR_MAIN, mouseX, mouseY);
                break;
            }
            case AIR_BAR: {
                bgRect = AirBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                this.drawHandlesForRect(graphics, bgRect, focused, SubElementType.BACKGROUND, mouseX, mouseY);
                ScreenRect airBarRect = AirBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                this.drawHandlesForRect(graphics, airBarRect, focused, SubElementType.BAR_MAIN, mouseX, mouseY);
            }
        }
    }

    private void drawHandlesForRect(class_332 graphics, ScreenRect rect, DraggableElement focusedElement, SubElementType elementType, int mouseX, int mouseY) {
        if (rect == null || rect.width() <= 0 || rect.height() <= 0) {
            return;
        }
        int handleColor = this.getOutlineColorForSubElement(focusedElement, elementType);
        int centerY = rect.y() + rect.height() / 2;
        int centerX = rect.x() + rect.width() / 2;
        ScreenRect rightHandle = new ScreenRect(rect.x() + rect.width() - 1, centerY - 1, 3, 3);
        ScreenRect bottomHandle = new ScreenRect(centerX - 1, rect.y() + rect.height() - 1, 3, 3);
        boolean isRightHover = rightHandle.contains(mouseX, mouseY);
        boolean isBottomHover = bottomHandle.contains(mouseX, mouseY);
        if (isRightHover && this.currentResizeMode == ResizeMode.NONE || !isBottomHover || this.currentResizeMode == ResizeMode.NONE) {
            // empty if block
        }
        int rightActualColor = isRightHover ? -1426063616 : handleColor;
        int bottomActualColor = isBottomHover ? -1426063616 : handleColor;
        graphics.method_25294(rightHandle.x(), rightHandle.y(), rightHandle.x() + rightHandle.width(), rightHandle.y() + rightHandle.height(), rightActualColor);
        graphics.method_25294(bottomHandle.x(), bottomHandle.y(), bottomHandle.x() + bottomHandle.width(), bottomHandle.y() + bottomHandle.height(), bottomActualColor);
    }

    private ResizeData getResizeHandleAtPosition(DraggableElement element, SubElementType subElement, int mouseX, int mouseY) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || element == null || subElement == null) {
            return null;
        }
        ScreenRect rect = null;
        switch (element) {
            case HEALTH_BAR: {
                rect = HealthBarRenderer.getSubElementRect(subElement, (class_1657)player);
                break;
            }
            case MANA_BAR: {
                rect = ManaBarRenderer.getSubElementRect(subElement, (class_1657)player);
                break;
            }
            case STAMINA_BAR: {
                rect = StaminaBarRenderer.getSubElementRect(subElement, (class_1657)player);
                break;
            }
            case ARMOR_BAR: {
                rect = ArmorBarRenderer.getSubElementRect(subElement, (class_1657)player);
                break;
            }
            case AIR_BAR: {
                rect = AirBarRenderer.getSubElementRect(subElement, (class_1657)player);
            }
        }
        if (rect == null || rect.width() <= 0 || rect.height() <= 0) {
            return null;
        }
        int centerY = rect.y() + rect.height() / 2;
        int centerX = rect.x() + rect.width() / 2;
        ScreenRect rightHandle = new ScreenRect(rect.x() + rect.width() - 1, centerY - 1, 3, 3);
        ScreenRect bottomHandle = new ScreenRect(centerX - 1, rect.y() + rect.height() - 1, 3, 3);
        if (rightHandle.contains(mouseX, mouseY)) {
            return new ResizeData(element, subElement, ResizeMode.WIDTH, rect.width(), rect.height());
        }
        if (bottomHandle.contains(mouseX, mouseY)) {
            return new ResizeData(element, subElement, ResizeMode.HEIGHT, rect.width(), rect.height());
        }
        return null;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        DraggableElement clickedBarForDrag;
        if (this.activeContextMenu != null) {
            if (this.activeContextMenu.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            this.activeContextMenu = null;
            return false;
        }
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (!EditModeManager.isEditModeEnabled()) {
            return false;
        }
        if (button == 1) {
            DraggableElement clickedElement;
            SubElementType clickedSub;
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return false;
            }
            DraggableElement focusedElement = EditModeManager.getFocusedElement();
            if (focusedElement != null && (clickedSub = this.getClickedSubElement(focusedElement, mouseX, mouseY, (class_1657)player)) != null) {
                this.contextMenuElement = focusedElement;
                this.contextMenuSubElement = clickedSub;
                this.contextMenuX = (int)mouseX;
                this.contextMenuY = (int)mouseY;
                this.activeContextMenu = this.createSubElementContextMenu(this.contextMenuX, this.contextMenuY, this.contextMenuElement, this.contextMenuSubElement);
                if (this.activeContextMenu != null) {
                    this.activeContextMenu.setOnClose(() -> {
                        this.activeContextMenu = null;
                        this.contextMenuElement = null;
                        this.contextMenuSubElement = null;
                    });
                    return true;
                }
            }
            if ((clickedElement = this.getClickedBarComplex(mouseX, mouseY, (class_1657)player)) != null) {
                this.contextMenuElement = clickedElement;
                this.contextMenuSubElement = null;
                this.contextMenuX = (int)mouseX;
                this.contextMenuY = (int)mouseY;
                this.activeContextMenu = this.createMainElementContextMenu(this.contextMenuX, this.contextMenuY, this.contextMenuElement);
                if (this.activeContextMenu != null) {
                    this.activeContextMenu.setOnClose(() -> {
                        this.activeContextMenu = null;
                        this.contextMenuElement = null;
                        this.contextMenuSubElement = null;
                    });
                    return true;
                }
            }
            return true;
        }
        if (button != 0) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        boolean isDoubleClick = currentTime - this.lastClickTime < 300L && Math.abs(mouseX - this.lastClickX) < 5.0 && Math.abs(mouseY - this.lastClickY) < 5.0;
        boolean actionTaken = false;
        DraggableElement currentFocusedElement = EditModeManager.getFocusedElement();
        ClientConfig config = ModConfigManager.getClient();
        if (isDoubleClick) {
            DraggableElement clickedBarForFocus = this.getClickedBarComplex(mouseX, mouseY, (class_1657)player);
            if (clickedBarForFocus != null) {
                if (currentFocusedElement != null && currentFocusedElement == clickedBarForFocus) {
                    EditModeManager.clearFocusedElement();
                } else {
                    EditModeManager.setFocusedElement(clickedBarForFocus);
                }
                this.rebuildEditorWidgets();
            }
            this.lastClickTime = 0L;
            return true;
        }
        if (currentFocusedElement != null) {
            SubElementType[] subElementTypesToTest;
            for (SubElementType subType : subElementTypesToTest = new SubElementType[]{SubElementType.BACKGROUND, SubElementType.BAR_MAIN, SubElementType.FOREGROUND}) {
                ResizeData resizeData;
                boolean canTestThisSubElement = false;
                switch (currentFocusedElement) {
                    case HEALTH_BAR: {
                        if (subType == SubElementType.BACKGROUND && config.enableHealthBackground) {
                            canTestThisSubElement = true;
                        }
                        if (subType == SubElementType.BAR_MAIN) {
                            canTestThisSubElement = true;
                        }
                        if (subType != SubElementType.FOREGROUND || !config.enableHealthForeground) break;
                        canTestThisSubElement = true;
                        break;
                    }
                    case MANA_BAR: {
                        if (subType == SubElementType.BACKGROUND && config.enableManaBackground) {
                            canTestThisSubElement = true;
                        }
                        if (subType == SubElementType.BAR_MAIN) {
                            canTestThisSubElement = true;
                        }
                        if (subType != SubElementType.FOREGROUND || !config.enableManaForeground) break;
                        canTestThisSubElement = true;
                        break;
                    }
                    case STAMINA_BAR: {
                        if (subType == SubElementType.BACKGROUND && config.enableStaminaBackground) {
                            canTestThisSubElement = true;
                        }
                        if (subType == SubElementType.BAR_MAIN) {
                            canTestThisSubElement = true;
                        }
                        if (subType != SubElementType.FOREGROUND || !config.enableStaminaForeground) break;
                        canTestThisSubElement = true;
                        break;
                    }
                    case ARMOR_BAR: {
                        if (subType == SubElementType.BACKGROUND) {
                            canTestThisSubElement = true;
                        }
                        if (subType != SubElementType.BAR_MAIN) break;
                        canTestThisSubElement = true;
                        break;
                    }
                    case AIR_BAR: {
                        if (subType == SubElementType.BACKGROUND) {
                            canTestThisSubElement = true;
                        }
                        if (subType != SubElementType.BAR_MAIN) break;
                        canTestThisSubElement = true;
                    }
                }
                if (!canTestThisSubElement || (resizeData = this.getResizeHandleAtPosition(currentFocusedElement, subType, (int)mouseX, (int)mouseY)) == null) continue;
                this.startResizeOperation(resizeData, (int)mouseX, (int)mouseY);
                EditModeManager.setKeyboardSelectedSubElement(subType);
                actionTaken = true;
                break;
            }
            if (actionTaken) {
                this.lastClickTime = 0L;
                return true;
            }
        }
        if (!actionTaken && currentFocusedElement != null && this.currentResizeMode == ResizeMode.NONE) {
            SubElementType clickedSub = this.getClickedSubElement(currentFocusedElement, mouseX, mouseY, (class_1657)player);
            if (clickedSub != null) {
                int currentSubX = 0;
                int currentSubY = 0;
                switch (currentFocusedElement) {
                    case HEALTH_BAR: {
                        if (clickedSub == SubElementType.BAR_MAIN) {
                            currentSubX = config.healthBarXOffset;
                            currentSubY = config.healthBarYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.FOREGROUND) {
                            currentSubX = config.healthOverlayXOffset;
                            currentSubY = config.healthOverlayYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.BACKGROUND) {
                            currentSubX = config.healthBackgroundXOffset;
                            currentSubY = config.healthBackgroundYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.TEXT) {
                            currentSubX = config.healthTextXOffset;
                            currentSubY = config.healthTextYOffset;
                            break;
                        }
                        if (clickedSub != SubElementType.ABSORPTION_TEXT) break;
                        currentSubX = config.healthAbsorptionTextXOffset;
                        currentSubY = config.healthAbsorptionTextYOffset;
                        break;
                    }
                    case MANA_BAR: {
                        if (clickedSub == SubElementType.BAR_MAIN) {
                            currentSubX = config.manaBarXOffset;
                            currentSubY = config.manaBarYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.FOREGROUND) {
                            currentSubX = config.manaOverlayXOffset;
                            currentSubY = config.manaOverlayYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.BACKGROUND) {
                            currentSubX = config.manaBackgroundXOffset;
                            currentSubY = config.manaBackgroundYOffset;
                            break;
                        }
                        if (clickedSub != SubElementType.TEXT) break;
                        currentSubX = config.manaTextXOffset;
                        currentSubY = config.manaTextYOffset;
                        break;
                    }
                    case STAMINA_BAR: {
                        if (clickedSub == SubElementType.BAR_MAIN) {
                            currentSubX = config.staminaBarXOffset;
                            currentSubY = config.staminaBarYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.FOREGROUND) {
                            currentSubX = config.staminaOverlayXOffset;
                            currentSubY = config.staminaOverlayYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.BACKGROUND) {
                            currentSubX = config.staminaBackgroundXOffset;
                            currentSubY = config.staminaBackgroundYOffset;
                            break;
                        }
                        if (clickedSub != SubElementType.TEXT) break;
                        currentSubX = config.staminaTextXOffset;
                        currentSubY = config.staminaTextYOffset;
                        break;
                    }
                    case ARMOR_BAR: {
                        if (clickedSub == SubElementType.BAR_MAIN) {
                            currentSubX = config.armorBarXOffset;
                            currentSubY = config.armorBarYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.BACKGROUND) {
                            currentSubX = config.armorBackgroundXOffset;
                            currentSubY = config.armorBackgroundYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.TEXT) {
                            currentSubX = config.armorTextXOffset;
                            currentSubY = config.armorTextYOffset;
                            break;
                        }
                        if (clickedSub != SubElementType.ICON) break;
                        currentSubX = config.armorIconXOffset;
                        currentSubY = config.armorIconYOffset;
                        break;
                    }
                    case AIR_BAR: {
                        if (clickedSub == SubElementType.BAR_MAIN) {
                            currentSubX = config.airBarXOffset;
                            currentSubY = config.airBarYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.BACKGROUND) {
                            currentSubX = config.airBackgroundXOffset;
                            currentSubY = config.airBackgroundYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.TEXT) {
                            currentSubX = config.airTextXOffset;
                            currentSubY = config.airTextYOffset;
                            break;
                        }
                        if (clickedSub != SubElementType.ICON) break;
                        currentSubX = config.airIconXOffset;
                        currentSubY = config.airIconYOffset;
                    }
                }
                EditModeManager.setDraggedSubElement(clickedSub, (int)mouseX, (int)mouseY, currentSubX, currentSubY);
                EditModeManager.setKeyboardSelectedSubElement(clickedSub);
                this.lastFocusedElementForSubUndo = currentFocusedElement;
                this.lastDraggedSubElementForUndo = clickedSub;
                this.lastSubDragInitialXOffset = currentSubX;
                this.lastSubDragInitialYOffset = currentSubY;
                this.canUndoLastSubDrag = false;
                this.canUndoLastDrag = false;
                this.lastDraggedElementForUndo = null;
                actionTaken = true;
            }
            if (actionTaken) {
                this.lastClickTime = currentTime;
                this.lastClickX = mouseX;
                this.lastClickY = mouseY;
                return true;
            }
        }
        if (!actionTaken && EditModeManager.getFocusedElement() == null && this.currentResizeMode == ResizeMode.NONE && (clickedBarForDrag = this.getClickedBarComplex(mouseX, mouseY, (class_1657)player)) != null) {
            int totalX = 0;
            int totalY = 0;
            switch (clickedBarForDrag) {
                case HEALTH_BAR: {
                    totalX = config.healthTotalXOffset;
                    totalY = config.healthTotalYOffset;
                    break;
                }
                case MANA_BAR: {
                    totalX = config.manaTotalXOffset;
                    totalY = config.manaTotalYOffset;
                    break;
                }
                case STAMINA_BAR: {
                    totalX = config.staminaTotalXOffset;
                    totalY = config.staminaTotalYOffset;
                    break;
                }
                case ARMOR_BAR: {
                    totalX = config.armorTotalXOffset;
                    totalY = config.armorTotalYOffset;
                    break;
                }
                case AIR_BAR: {
                    totalX = config.airTotalXOffset;
                    totalY = config.airTotalYOffset;
                }
            }
            this.lastDraggedElementForUndo = clickedBarForDrag;
            this.lastDragInitialXOffset = totalX;
            this.lastDragInitialYOffset = totalY;
            this.canUndoLastDrag = false;
            EditModeManager.setDraggedElement(clickedBarForDrag, (int)mouseX, (int)mouseY, totalX, totalY);
            EditModeManager.setKeyboardSelectedElement(clickedBarForDrag);
            actionTaken = true;
        }
        if (!isDoubleClick && !actionTaken) {
            this.lastClickTime = currentTime;
            this.lastClickX = mouseX;
            this.lastClickY = mouseY;
        } else if (!actionTaken || isDoubleClick || this.currentResizeMode != ResizeMode.NONE || EditModeManager.getDraggedSubElement() != null || EditModeManager.getDraggedElement() == null) {
            // empty if block
        }
        return actionTaken;
    }

    private DraggableElement getClickedBarComplex(double mouseX, double mouseY, class_1657 player) {
        if (HealthBarRenderer.getScreenRect(player).contains((int)mouseX, (int)mouseY)) {
            return DraggableElement.HEALTH_BAR;
        }
        if (StaminaBarRenderer.getScreenRect(player).contains((int)mouseX, (int)mouseY)) {
            return DraggableElement.STAMINA_BAR;
        }
        if (ManaBarRenderer.getScreenRect(player).contains((int)mouseX, (int)mouseY)) {
            return DraggableElement.MANA_BAR;
        }
        if (ArmorBarRenderer.getScreenRect(player).contains((int)mouseX, (int)mouseY)) {
            return DraggableElement.ARMOR_BAR;
        }
        if (AirBarRenderer.getScreenRect(player).contains((int)mouseX, (int)mouseY)) {
            return DraggableElement.AIR_BAR;
        }
        return null;
    }

    private SubElementType getClickedSubElement(DraggableElement focusedBar, double mouseX, double mouseY, class_1657 player) {
        if (focusedBar == null) {
            return null;
        }
        ScreenRect barMainRect = null;
        ScreenRect barFgRect = null;
        ScreenRect barBgRect = null;
        ScreenRect barTextRect = null;
        ScreenRect barIconRect = null;
        ScreenRect barAbsorptionTextRect = null;
        ClientConfig currentConfig = ModConfigManager.getClient();
        switch (focusedBar) {
            case HEALTH_BAR: {
                barMainRect = HealthBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                barFgRect = HealthBarRenderer.getSubElementRect(SubElementType.FOREGROUND, player);
                barBgRect = HealthBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                barTextRect = HealthBarRenderer.getSubElementRect(SubElementType.TEXT, player);
                barAbsorptionTextRect = HealthBarRenderer.getSubElementRect(SubElementType.ABSORPTION_TEXT, player);
                break;
            }
            case STAMINA_BAR: {
                barMainRect = StaminaBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                barFgRect = StaminaBarRenderer.getSubElementRect(SubElementType.FOREGROUND, player);
                barBgRect = StaminaBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                barTextRect = StaminaBarRenderer.getSubElementRect(SubElementType.TEXT, player);
                break;
            }
            case MANA_BAR: {
                barMainRect = ManaBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                barFgRect = ManaBarRenderer.getSubElementRect(SubElementType.FOREGROUND, player);
                barBgRect = ManaBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                barTextRect = ManaBarRenderer.getSubElementRect(SubElementType.TEXT, player);
                break;
            }
            case ARMOR_BAR: {
                barMainRect = ArmorBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                barBgRect = ArmorBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                barTextRect = ArmorBarRenderer.getSubElementRect(SubElementType.TEXT, player);
                barIconRect = ArmorBarRenderer.getSubElementRect(SubElementType.ICON, player);
                break;
            }
            case AIR_BAR: {
                barMainRect = AirBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                barBgRect = AirBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                barTextRect = AirBarRenderer.getSubElementRect(SubElementType.TEXT, player);
                barIconRect = AirBarRenderer.getSubElementRect(SubElementType.ICON, player);
            }
        }
        if (barAbsorptionTextRect != null && barAbsorptionTextRect.contains((int)mouseX, (int)mouseY)) {
            return SubElementType.ABSORPTION_TEXT;
        }
        if (barIconRect != null && barIconRect.contains((int)mouseX, (int)mouseY)) {
            return SubElementType.ICON;
        }
        if (barTextRect != null && barTextRect.contains((int)mouseX, (int)mouseY)) {
            return SubElementType.TEXT;
        }
        if (barFgRect != null && barFgRect.contains((int)mouseX, (int)mouseY)) {
            return SubElementType.FOREGROUND;
        }
        if (barMainRect != null && barMainRect.contains((int)mouseX, (int)mouseY)) {
            return SubElementType.BAR_MAIN;
        }
        if (barBgRect != null && barBgRect.contains((int)mouseX, (int)mouseY)) {
            return SubElementType.BACKGROUND;
        }
        return null;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 0) {
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        ClientConfig config = ModConfigManager.getClient();
        if (this.currentResizeMode != ResizeMode.NONE && this.resizingSubElement != null && EditModeManager.getFocusedElement() != null) {
            this.handleResize((int)mouseX, (int)mouseY);
            return true;
        }
        if (EditModeManager.getDraggedSubElement() != null && EditModeManager.getFocusedElement() != null) {
            int finalNewSubX = EditModeManager.getInitialSubElementXOffset() + (int)(mouseX - (double)EditModeManager.getSubElementDragStartX());
            int finalNewSubY = EditModeManager.getInitialSubElementYOffset() + (int)(mouseY - (double)EditModeManager.getSubElementDragStartY());
            DraggableElement focused = EditModeManager.getFocusedElement();
            SubElementType sub = EditModeManager.getDraggedSubElement();
            switch (focused) {
                case HEALTH_BAR: {
                    if (sub == SubElementType.BAR_MAIN) {
                        config.healthBarXOffset = finalNewSubX;
                        config.healthBarYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.FOREGROUND) {
                        config.healthOverlayXOffset = finalNewSubX;
                        config.healthOverlayYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.BACKGROUND) {
                        config.healthBackgroundXOffset = finalNewSubX;
                        config.healthBackgroundYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.TEXT) {
                        config.healthTextXOffset = finalNewSubX;
                        config.healthTextYOffset = finalNewSubY;
                        break;
                    }
                    if (sub != SubElementType.ABSORPTION_TEXT) break;
                    config.healthAbsorptionTextXOffset = finalNewSubX;
                    config.healthAbsorptionTextYOffset = finalNewSubY;
                    break;
                }
                case MANA_BAR: {
                    if (sub == SubElementType.BAR_MAIN) {
                        config.manaBarXOffset = finalNewSubX;
                        config.manaBarYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.FOREGROUND) {
                        config.manaOverlayXOffset = finalNewSubX;
                        config.manaOverlayYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.BACKGROUND) {
                        config.manaBackgroundXOffset = finalNewSubX;
                        config.manaBackgroundYOffset = finalNewSubY;
                        break;
                    }
                    if (sub != SubElementType.TEXT) break;
                    config.manaTextXOffset = finalNewSubX;
                    config.manaTextYOffset = finalNewSubY;
                    break;
                }
                case STAMINA_BAR: {
                    if (sub == SubElementType.BAR_MAIN) {
                        config.staminaBarXOffset = finalNewSubX;
                        config.staminaBarYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.FOREGROUND) {
                        config.staminaOverlayXOffset = finalNewSubX;
                        config.staminaOverlayYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.BACKGROUND) {
                        config.staminaBackgroundXOffset = finalNewSubX;
                        config.staminaBackgroundYOffset = finalNewSubY;
                        break;
                    }
                    if (sub != SubElementType.TEXT) break;
                    config.staminaTextXOffset = finalNewSubX;
                    config.staminaTextYOffset = finalNewSubY;
                    break;
                }
                case ARMOR_BAR: {
                    if (sub == SubElementType.BAR_MAIN) {
                        config.armorBarXOffset = finalNewSubX;
                        config.armorBarYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.TEXT) {
                        config.armorTextXOffset = finalNewSubX;
                        config.armorTextYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.BACKGROUND) {
                        config.armorBackgroundXOffset = finalNewSubX;
                        config.armorBackgroundYOffset = finalNewSubY;
                        break;
                    }
                    if (sub != SubElementType.ICON) break;
                    config.armorIconXOffset = finalNewSubX;
                    config.armorIconYOffset = finalNewSubY;
                    break;
                }
                case AIR_BAR: {
                    if (sub == SubElementType.BAR_MAIN) {
                        config.airBarXOffset = finalNewSubX;
                        config.airBarYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.TEXT) {
                        config.airTextXOffset = finalNewSubX;
                        config.airTextYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.ICON) {
                        config.airIconXOffset = finalNewSubX;
                        config.airIconYOffset = finalNewSubY;
                        break;
                    }
                    if (sub != SubElementType.BACKGROUND) break;
                    config.airBackgroundXOffset = finalNewSubX;
                    config.airBackgroundYOffset = finalNewSubY;
                }
            }
            return true;
        }
        if (EditModeManager.getDraggedElement() != null) {
            int finalNewTotalX = EditModeManager.getInitialElementXOffset() + (int)(mouseX - (double)EditModeManager.getDragStartX());
            int finalNewTotalY = EditModeManager.getInitialElementYOffset() + (int)(mouseY - (double)EditModeManager.getDragStartY());
            DraggableElement dragged = EditModeManager.getDraggedElement();
            switch (dragged) {
                case HEALTH_BAR: {
                    config.healthTotalXOffset = finalNewTotalX;
                    config.healthTotalYOffset = finalNewTotalY;
                    break;
                }
                case MANA_BAR: {
                    config.manaTotalXOffset = finalNewTotalX;
                    config.manaTotalYOffset = finalNewTotalY;
                    break;
                }
                case STAMINA_BAR: {
                    config.staminaTotalXOffset = finalNewTotalX;
                    config.staminaTotalYOffset = finalNewTotalY;
                    break;
                }
                case ARMOR_BAR: {
                    config.armorTotalXOffset = finalNewTotalX;
                    config.armorTotalYOffset = finalNewTotalY;
                    break;
                }
                case AIR_BAR: {
                    config.airTotalXOffset = finalNewTotalX;
                    config.airTotalYOffset = finalNewTotalY;
                }
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        boolean handled = false;
        if (this.currentResizeMode != ResizeMode.NONE && button == 0) {
            this.finishResize();
            handled = true;
        }
        if (EditModeManager.getDraggedSubElement() != null && button == 0) {
            EditModeManager.clearDraggedSubElement();
            handled = true;
        }
        if (EditModeManager.getDraggedElement() != null && button == 0) {
            EditModeManager.clearDraggedElement();
            handled = true;
        }
        return handled || super.method_25406(mouseX, mouseY, button);
    }

    private void startResizeOperation(ResizeData resizeData, int mouseX, int mouseY) {
        this.currentResizeMode = resizeData.mode;
        this.focusedElementForResize = resizeData.element;
        this.resizingSubElement = resizeData.subElement;
        this.resizeStartX = mouseX;
        this.resizeStartY = mouseY;
        ClientConfig config = ModConfigManager.getClient();
        switch (resizeData.element) {
            case HEALTH_BAR: {
                if (resizeData.subElement == SubElementType.BACKGROUND) {
                    this.initialWidth = config.healthBackgroundWidth;
                    this.initialHeight = config.healthBackgroundHeight;
                    break;
                }
                if (resizeData.subElement == SubElementType.BAR_MAIN) {
                    this.initialWidth = config.healthBarWidth;
                    this.initialHeight = config.healthBarHeight;
                    break;
                }
                if (resizeData.subElement != SubElementType.FOREGROUND) break;
                this.initialWidth = config.healthOverlayWidth;
                this.initialHeight = config.healthOverlayHeight;
                break;
            }
            case MANA_BAR: {
                if (resizeData.subElement == SubElementType.BACKGROUND) {
                    this.initialWidth = config.manaBackgroundWidth;
                    this.initialHeight = config.manaBackgroundHeight;
                    break;
                }
                if (resizeData.subElement == SubElementType.BAR_MAIN) {
                    this.initialWidth = config.manaBarWidth;
                    this.initialHeight = config.manaBarHeight;
                    break;
                }
                if (resizeData.subElement != SubElementType.FOREGROUND) break;
                this.initialWidth = config.manaOverlayWidth;
                this.initialHeight = config.manaOverlayHeight;
                break;
            }
            case STAMINA_BAR: {
                if (resizeData.subElement == SubElementType.BACKGROUND) {
                    this.initialWidth = config.staminaBackgroundWidth;
                    this.initialHeight = config.staminaBackgroundHeight;
                    break;
                }
                if (resizeData.subElement == SubElementType.BAR_MAIN) {
                    this.initialWidth = config.staminaBarWidth;
                    this.initialHeight = config.staminaBarHeight;
                    break;
                }
                if (resizeData.subElement != SubElementType.FOREGROUND) break;
                this.initialWidth = config.staminaOverlayWidth;
                this.initialHeight = config.staminaOverlayHeight;
                break;
            }
            case ARMOR_BAR: {
                if (resizeData.subElement == SubElementType.BACKGROUND) {
                    this.initialWidth = config.armorBackgroundWidth;
                    this.initialHeight = config.armorBackgroundHeight;
                    break;
                }
                if (resizeData.subElement != SubElementType.BAR_MAIN) break;
                this.initialWidth = config.armorBarWidth;
                this.initialHeight = config.armorBarHeight;
                break;
            }
            case AIR_BAR: {
                if (resizeData.subElement == SubElementType.BACKGROUND) {
                    this.initialWidth = config.airBackgroundWidth;
                    this.initialHeight = config.airBackgroundHeight;
                    break;
                }
                if (resizeData.subElement != SubElementType.BAR_MAIN) break;
                this.initialWidth = config.airBarWidth;
                this.initialHeight = config.airBarHeight;
            }
        }
    }

    private void handleResize(int mouseX, int mouseY) {
        if (this.currentResizeMode == ResizeMode.NONE || this.resizingSubElement == null || this.focusedElementForResize == null) {
            return;
        }
        int deltaX = mouseX - this.resizeStartX;
        int deltaY = mouseY - this.resizeStartY;
        ClientConfig config = ModConfigManager.getClient();
        switch (this.focusedElementForResize) {
            case HEALTH_BAR: {
                this.applyHealthResizing(config, deltaX, deltaY);
                break;
            }
            case MANA_BAR: {
                this.applyManaResizing(config, deltaX, deltaY);
                break;
            }
            case STAMINA_BAR: {
                this.applyStaminaResizing(config, deltaX, deltaY);
                break;
            }
            case ARMOR_BAR: {
                this.applyArmorResizing(config, deltaX, deltaY);
                break;
            }
            case AIR_BAR: {
                this.applyAirResizing(config, deltaX, deltaY);
            }
        }
    }

    private void applyHealthResizing(ClientConfig config, int deltaX, int deltaY) {
        switch (this.resizingSubElement) {
            case BACKGROUND: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.healthBackgroundWidth = Math.max(10, this.initialWidth + deltaX);
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.healthBackgroundHeight = Math.max(4, this.initialHeight + deltaY);
                break;
            }
            case BAR_MAIN: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.healthBarWidth = Math.max(4, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.healthBarHeight = Math.max(1, Math.min(32, this.initialHeight + deltaY));
                break;
            }
            case FOREGROUND: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.healthOverlayWidth = Math.max(10, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.healthOverlayHeight = Math.max(4, Math.min(256, this.initialHeight + deltaY));
            }
        }
    }

    private void applyManaResizing(ClientConfig config, int deltaX, int deltaY) {
        switch (this.resizingSubElement) {
            case BACKGROUND: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.manaBackgroundWidth = Math.max(10, this.initialWidth + deltaX);
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.manaBackgroundHeight = Math.max(4, this.initialHeight + deltaY);
                break;
            }
            case BAR_MAIN: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.manaBarWidth = Math.max(4, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.manaBarHeight = Math.max(1, Math.min(32, this.initialHeight + deltaY));
                break;
            }
            case FOREGROUND: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.manaOverlayWidth = Math.max(10, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.manaOverlayHeight = Math.max(4, Math.min(256, this.initialHeight + deltaY));
            }
        }
    }

    private void applyStaminaResizing(ClientConfig config, int deltaX, int deltaY) {
        switch (this.resizingSubElement) {
            case BACKGROUND: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.staminaBackgroundWidth = Math.max(10, this.initialWidth + deltaX);
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.staminaBackgroundHeight = Math.max(4, this.initialHeight + deltaY);
                break;
            }
            case BAR_MAIN: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.staminaBarWidth = Math.max(4, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.staminaBarHeight = Math.max(1, Math.min(32, this.initialHeight + deltaY));
                break;
            }
            case FOREGROUND: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.staminaOverlayWidth = Math.max(10, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.staminaOverlayHeight = Math.max(4, Math.min(256, this.initialHeight + deltaY));
            }
        }
    }

    private void applyArmorResizing(ClientConfig config, int deltaX, int deltaY) {
        switch (this.resizingSubElement) {
            case BACKGROUND: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.armorBackgroundWidth = Math.max(10, this.initialWidth + deltaX);
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.armorBackgroundHeight = Math.max(4, this.initialHeight + deltaY);
                break;
            }
            case BAR_MAIN: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.armorBarWidth = Math.max(4, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.armorBarHeight = Math.max(1, Math.min(32, this.initialHeight + deltaY));
            }
        }
    }

    private void applyAirResizing(ClientConfig config, int deltaX, int deltaY) {
        switch (this.resizingSubElement) {
            case BACKGROUND: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.airBackgroundWidth = Math.max(10, this.initialWidth + deltaX);
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.airBackgroundHeight = Math.max(4, this.initialHeight + deltaY);
                break;
            }
            case BAR_MAIN: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.airBarWidth = Math.max(4, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.airBarHeight = Math.max(1, Math.min(32, this.initialHeight + deltaY));
            }
        }
    }

    private void finishResize() {
        if (this.currentResizeMode != ResizeMode.NONE) {
            this.currentResizeMode = ResizeMode.NONE;
            this.focusedElementForResize = null;
            this.resizingSubElement = null;
        }
    }

    public void method_25419() {
        if (EditModeManager.isEditModeEnabled()) {
            EditModeManager.toggleEditMode();
        }
        if (EditModeManager.getFocusedElement() != null) {
            EditModeManager.clearFocusedElement();
        }
        ClientConfig.getInstance().save();
        this.field_22787.method_1507(this.previousScreen);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25422() {
        return EditModeManager.getFocusedElement() == null;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean isShiftPressed;
        if (keyCode == 256 && EditModeManager.getFocusedElement() != null) {
            EditModeManager.clearFocusedElement();
            this.rebuildEditorWidgets();
            return true;
        }
        if (keyCode == 258) {
            this.handleTabNavigation();
            return true;
        }
        boolean bl = isShiftPressed = (modifiers & 1) != 0;
        if (keyCode == 265 || keyCode == 264 || keyCode == 263 || keyCode == 262) {
            if (isShiftPressed) {
                this.handleArrowResize(keyCode);
            } else {
                this.handleArrowMove(keyCode);
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void handleTabNavigation() {
        ClientConfig config = ModConfigManager.getClient();
        DraggableElement focused = EditModeManager.getFocusedElement();
        if (focused == null) {
            DraggableElement current = EditModeManager.getKeyboardSelectedElement();
            DraggableElement[] elements = DraggableElement.values();
            if (current == null) {
                EditModeManager.setKeyboardSelectedElement(elements[0]);
            } else {
                int currentIndex = current.ordinal();
                int nextIndex = (currentIndex + 1) % elements.length;
                EditModeManager.setKeyboardSelectedElement(elements[nextIndex]);
            }
        } else {
            SubElementType current = EditModeManager.getKeyboardSelectedSubElement();
            SubElementType[] availableSubElements = this.getAvailableSubElements(focused, config);
            if (availableSubElements.length == 0) {
                return;
            }
            if (current == null) {
                EditModeManager.setKeyboardSelectedSubElement(availableSubElements[0]);
            } else {
                int currentIndex = -1;
                for (int i = 0; i < availableSubElements.length; ++i) {
                    if (availableSubElements[i] != current) continue;
                    currentIndex = i;
                    break;
                }
                int nextIndex = (currentIndex + 1) % availableSubElements.length;
                EditModeManager.setKeyboardSelectedSubElement(availableSubElements[nextIndex]);
            }
        }
    }

    private SubElementType[] getAvailableSubElements(DraggableElement element, ClientConfig config) {
        ArrayList<SubElementType> available = new ArrayList<SubElementType>();
        switch (element) {
            case HEALTH_BAR: {
                available.add(SubElementType.BACKGROUND);
                available.add(SubElementType.BAR_MAIN);
                available.add(SubElementType.FOREGROUND);
                available.add(SubElementType.TEXT);
                available.add(SubElementType.ABSORPTION_TEXT);
                break;
            }
            case MANA_BAR: {
                available.add(SubElementType.BACKGROUND);
                available.add(SubElementType.BAR_MAIN);
                available.add(SubElementType.FOREGROUND);
                available.add(SubElementType.TEXT);
                break;
            }
            case STAMINA_BAR: {
                available.add(SubElementType.BACKGROUND);
                available.add(SubElementType.BAR_MAIN);
                available.add(SubElementType.FOREGROUND);
                available.add(SubElementType.TEXT);
                break;
            }
            case ARMOR_BAR: {
                available.add(SubElementType.BACKGROUND);
                available.add(SubElementType.BAR_MAIN);
                available.add(SubElementType.TEXT);
                available.add(SubElementType.ICON);
                break;
            }
            case AIR_BAR: {
                available.add(SubElementType.BACKGROUND);
                available.add(SubElementType.BAR_MAIN);
                available.add(SubElementType.TEXT);
                available.add(SubElementType.ICON);
            }
        }
        return available.toArray(new SubElementType[0]);
    }

    private void handleArrowMove(int keyCode) {
        ClientConfig config = ModConfigManager.getClient();
        DraggableElement focused = EditModeManager.getFocusedElement();
        int dx = 0;
        int dy = 0;
        switch (keyCode) {
            case 265: {
                dy = -1;
                break;
            }
            case 264: {
                dy = 1;
                break;
            }
            case 263: {
                dx = -1;
                break;
            }
            case 262: {
                dx = 1;
            }
        }
        if (focused == null) {
            DraggableElement selected = EditModeManager.getKeyboardSelectedElement();
            if (selected == null) {
                return;
            }
            switch (selected) {
                case HEALTH_BAR: {
                    config.healthTotalXOffset += dx;
                    config.healthTotalYOffset += dy;
                    break;
                }
                case MANA_BAR: {
                    config.manaTotalXOffset += dx;
                    config.manaTotalYOffset += dy;
                    break;
                }
                case STAMINA_BAR: {
                    config.staminaTotalXOffset += dx;
                    config.staminaTotalYOffset += dy;
                    break;
                }
                case ARMOR_BAR: {
                    config.armorTotalXOffset += dx;
                    config.armorTotalYOffset += dy;
                    break;
                }
                case AIR_BAR: {
                    config.airTotalXOffset += dx;
                    config.airTotalYOffset += dy;
                }
            }
        } else {
            SubElementType subSelected = EditModeManager.getKeyboardSelectedSubElement();
            if (subSelected == null) {
                return;
            }
            switch (focused) {
                case HEALTH_BAR: {
                    this.moveHealthSubElement(config, subSelected, dx, dy);
                    break;
                }
                case MANA_BAR: {
                    this.moveManaSubElement(config, subSelected, dx, dy);
                    break;
                }
                case STAMINA_BAR: {
                    this.moveStaminaSubElement(config, subSelected, dx, dy);
                    break;
                }
                case ARMOR_BAR: {
                    this.moveArmorSubElement(config, subSelected, dx, dy);
                    break;
                }
                case AIR_BAR: {
                    this.moveAirSubElement(config, subSelected, dx, dy);
                }
            }
        }
    }

    private void handleArrowResize(int keyCode) {
        ClientConfig config = ModConfigManager.getClient();
        DraggableElement focused = EditModeManager.getFocusedElement();
        int dw = 0;
        int dh = 0;
        switch (keyCode) {
            case 265: {
                dh = -1;
                break;
            }
            case 264: {
                dh = 1;
                break;
            }
            case 263: {
                dw = -1;
                break;
            }
            case 262: {
                dw = 1;
            }
        }
        if (focused == null) {
            DraggableElement selected = EditModeManager.getKeyboardSelectedElement();
            if (selected == null) {
                return;
            }
            switch (selected) {
                case HEALTH_BAR: {
                    config.healthBackgroundWidth = Math.max(10, config.healthBackgroundWidth + dw);
                    config.healthBackgroundHeight = Math.max(4, config.healthBackgroundHeight + dh);
                    break;
                }
                case MANA_BAR: {
                    config.manaBackgroundWidth = Math.max(10, config.manaBackgroundWidth + dw);
                    config.manaBackgroundHeight = Math.max(4, config.manaBackgroundHeight + dh);
                    break;
                }
                case STAMINA_BAR: {
                    config.staminaBackgroundWidth = Math.max(10, config.staminaBackgroundWidth + dw);
                    config.staminaBackgroundHeight = Math.max(4, config.staminaBackgroundHeight + dh);
                    break;
                }
                case ARMOR_BAR: {
                    config.armorBackgroundWidth = Math.max(10, config.armorBackgroundWidth + dw);
                    config.armorBackgroundHeight = Math.max(4, config.armorBackgroundHeight + dh);
                    break;
                }
                case AIR_BAR: {
                    config.airBackgroundWidth = Math.max(10, config.airBackgroundWidth + dw);
                    config.airBackgroundHeight = Math.max(4, config.airBackgroundHeight + dh);
                }
            }
        } else {
            SubElementType subSelected = EditModeManager.getKeyboardSelectedSubElement();
            if (subSelected == null) {
                return;
            }
            switch (focused) {
                case HEALTH_BAR: {
                    this.resizeHealthSubElement(config, subSelected, dw, dh);
                    break;
                }
                case MANA_BAR: {
                    this.resizeManaSubElement(config, subSelected, dw, dh);
                    break;
                }
                case STAMINA_BAR: {
                    this.resizeStaminaSubElement(config, subSelected, dw, dh);
                    break;
                }
                case ARMOR_BAR: {
                    this.resizeArmorSubElement(config, subSelected, dw, dh);
                    break;
                }
                case AIR_BAR: {
                    this.resizeAirSubElement(config, subSelected, dw, dh);
                }
            }
        }
    }

    private void moveHealthSubElement(ClientConfig config, SubElementType subType, int dx, int dy) {
        switch (subType) {
            case BACKGROUND: {
                config.healthBackgroundXOffset += dx;
                config.healthBackgroundYOffset += dy;
                break;
            }
            case BAR_MAIN: {
                config.healthBarXOffset += dx;
                config.healthBarYOffset += dy;
                break;
            }
            case FOREGROUND: {
                config.healthOverlayXOffset += dx;
                config.healthOverlayYOffset += dy;
                break;
            }
            case TEXT: {
                config.healthTextXOffset += dx;
                config.healthTextYOffset += dy;
                break;
            }
            case ABSORPTION_TEXT: {
                config.healthAbsorptionTextXOffset += dx;
                config.healthAbsorptionTextYOffset += dy;
            }
        }
    }

    private void moveManaSubElement(ClientConfig config, SubElementType subType, int dx, int dy) {
        switch (subType) {
            case BACKGROUND: {
                config.manaBackgroundXOffset += dx;
                config.manaBackgroundYOffset += dy;
                break;
            }
            case BAR_MAIN: {
                config.manaBarXOffset += dx;
                config.manaBarYOffset += dy;
                break;
            }
            case FOREGROUND: {
                config.manaOverlayXOffset += dx;
                config.manaOverlayYOffset += dy;
                break;
            }
            case TEXT: {
                config.manaTextXOffset += dx;
                config.manaTextYOffset += dy;
            }
        }
    }

    private void moveStaminaSubElement(ClientConfig config, SubElementType subType, int dx, int dy) {
        switch (subType) {
            case BACKGROUND: {
                config.staminaBackgroundXOffset += dx;
                config.staminaBackgroundYOffset += dy;
                break;
            }
            case BAR_MAIN: {
                config.staminaBarXOffset += dx;
                config.staminaBarYOffset += dy;
                break;
            }
            case FOREGROUND: {
                config.staminaOverlayXOffset += dx;
                config.staminaOverlayYOffset += dy;
                break;
            }
            case TEXT: {
                config.staminaTextXOffset += dx;
                config.staminaTextYOffset += dy;
            }
        }
    }

    private void moveArmorSubElement(ClientConfig config, SubElementType subType, int dx, int dy) {
        switch (subType) {
            case BACKGROUND: {
                config.armorBackgroundXOffset += dx;
                config.armorBackgroundYOffset += dy;
                break;
            }
            case BAR_MAIN: {
                config.armorBarXOffset += dx;
                config.armorBarYOffset += dy;
                break;
            }
            case TEXT: {
                config.armorTextXOffset += dx;
                config.armorTextYOffset += dy;
                break;
            }
            case ICON: {
                config.armorIconXOffset += dx;
                config.armorIconYOffset += dy;
            }
        }
    }

    private void moveAirSubElement(ClientConfig config, SubElementType subType, int dx, int dy) {
        switch (subType) {
            case BACKGROUND: {
                config.airBackgroundXOffset += dx;
                config.airBackgroundYOffset += dy;
                break;
            }
            case BAR_MAIN: {
                config.airBarXOffset += dx;
                config.airBarYOffset += dy;
                break;
            }
            case TEXT: {
                config.airTextXOffset += dx;
                config.airTextYOffset += dy;
                break;
            }
            case ICON: {
                config.airIconXOffset += dx;
                config.airIconYOffset += dy;
            }
        }
    }

    private void resizeHealthSubElement(ClientConfig config, SubElementType subType, int dw, int dh) {
        switch (subType) {
            case BACKGROUND: {
                config.healthBackgroundWidth = Math.max(10, config.healthBackgroundWidth + dw);
                config.healthBackgroundHeight = Math.max(4, config.healthBackgroundHeight + dh);
                break;
            }
            case BAR_MAIN: {
                config.healthBarWidth = Math.max(4, Math.min(256, config.healthBarWidth + dw));
                config.healthBarHeight = Math.max(1, Math.min(32, config.healthBarHeight + dh));
                break;
            }
            case FOREGROUND: {
                config.healthOverlayWidth = Math.max(10, Math.min(256, config.healthOverlayWidth + dw));
                config.healthOverlayHeight = Math.max(4, Math.min(256, config.healthOverlayHeight + dh));
            }
        }
    }

    private void resizeManaSubElement(ClientConfig config, SubElementType subType, int dw, int dh) {
        switch (subType) {
            case BACKGROUND: {
                config.manaBackgroundWidth = Math.max(10, config.manaBackgroundWidth + dw);
                config.manaBackgroundHeight = Math.max(4, config.manaBackgroundHeight + dh);
                break;
            }
            case BAR_MAIN: {
                config.manaBarWidth = Math.max(4, Math.min(256, config.manaBarWidth + dw));
                config.manaBarHeight = Math.max(1, Math.min(32, config.manaBarHeight + dh));
                break;
            }
            case FOREGROUND: {
                config.manaOverlayWidth = Math.max(10, Math.min(256, config.manaOverlayWidth + dw));
                config.manaOverlayHeight = Math.max(4, Math.min(256, config.manaOverlayHeight + dh));
            }
        }
    }

    private void resizeStaminaSubElement(ClientConfig config, SubElementType subType, int dw, int dh) {
        switch (subType) {
            case BACKGROUND: {
                config.staminaBackgroundWidth = Math.max(10, config.staminaBackgroundWidth + dw);
                config.staminaBackgroundHeight = Math.max(4, config.staminaBackgroundHeight + dh);
                break;
            }
            case BAR_MAIN: {
                config.staminaBarWidth = Math.max(4, Math.min(256, config.staminaBarWidth + dw));
                config.staminaBarHeight = Math.max(1, Math.min(32, config.staminaBarHeight + dh));
                break;
            }
            case FOREGROUND: {
                config.staminaOverlayWidth = Math.max(10, Math.min(256, config.staminaOverlayWidth + dw));
                config.staminaOverlayHeight = Math.max(4, Math.min(256, config.staminaOverlayHeight + dh));
            }
        }
    }

    private void resizeArmorSubElement(ClientConfig config, SubElementType subType, int dw, int dh) {
        switch (subType) {
            case BACKGROUND: {
                config.armorBackgroundWidth = Math.max(10, config.armorBackgroundWidth + dw);
                config.armorBackgroundHeight = Math.max(4, config.armorBackgroundHeight + dh);
                break;
            }
            case BAR_MAIN: {
                config.armorBarWidth = Math.max(4, Math.min(256, config.armorBarWidth + dw));
                config.armorBarHeight = Math.max(1, Math.min(32, config.armorBarHeight + dh));
            }
        }
    }

    private void resizeAirSubElement(ClientConfig config, SubElementType subType, int dw, int dh) {
        switch (subType) {
            case BACKGROUND: {
                config.airBackgroundWidth = Math.max(10, config.airBackgroundWidth + dw);
                config.airBackgroundHeight = Math.max(4, config.airBackgroundHeight + dh);
                break;
            }
            case BAR_MAIN: {
                config.airBarWidth = Math.max(4, Math.min(256, config.airBarWidth + dw));
                config.airBarHeight = Math.max(1, Math.min(32, config.airBarHeight + dh));
            }
        }
    }

    protected void method_37067() {
        this.field_33816.clear();
        this.method_25396().clear();
    }

    private void resetPositionDefaultsAction(DraggableElement element) {
        ClientConfig config = ModConfigManager.getClient();
        if (element == null) {
            return;
        }
        HUDPositioning.BarPlacement defaultAnchor = null;
        boolean defaultTotalY = false;
        int defaultBgWidthForCalc = 0;
        switch (element) {
            case HEALTH_BAR: {
                defaultAnchor = ClientConfig.DEFAULT_HEALTH_BAR_ANCHOR;
                defaultBgWidthForCalc = 80;
                config.healthBarAnchor = defaultAnchor;
                config.healthBarXOffset = 3;
                config.healthBarYOffset = 3;
                config.healthOverlayXOffset = 0;
                config.healthOverlayYOffset = -3;
                config.healthBackgroundXOffset = 0;
                config.healthBackgroundYOffset = 0;
                config.healthTotalYOffset = 0;
                config.healthTextXOffset = 3;
                config.healthTextYOffset = 3;
                config.healthAbsorptionTextXOffset = 65;
                config.healthAbsorptionTextYOffset = 3;
                break;
            }
            case STAMINA_BAR: {
                defaultAnchor = ClientConfig.DEFAULT_STAMINA_BAR_ANCHOR;
                defaultBgWidthForCalc = 80;
                config.staminaBarAnchor = defaultAnchor;
                config.staminaBarXOffset = 3;
                config.staminaBarYOffset = 3;
                config.staminaOverlayXOffset = 0;
                config.staminaOverlayYOffset = -3;
                config.staminaBackgroundXOffset = 0;
                config.staminaBackgroundYOffset = 0;
                config.staminaTotalYOffset = 0;
                config.staminaTextXOffset = 3;
                config.staminaTextYOffset = 3;
                break;
            }
            case MANA_BAR: {
                defaultAnchor = ClientConfig.DEFAULT_MANA_BAR_ANCHOR;
                defaultBgWidthForCalc = 80;
                config.manaBarAnchor = defaultAnchor;
                config.manaBarXOffset = 3;
                config.manaBarYOffset = 3;
                config.manaOverlayXOffset = 0;
                config.manaOverlayYOffset = -3;
                config.manaBackgroundXOffset = 0;
                config.manaBackgroundYOffset = 0;
                config.manaTotalYOffset = 0;
                config.manaTextXOffset = 3;
                config.manaTextYOffset = 3;
                break;
            }
            case ARMOR_BAR: {
                defaultAnchor = ClientConfig.DEFAULT_ARMOR_BAR_ANCHOR;
                defaultBgWidthForCalc = 80;
                config.armorBarAnchor = defaultAnchor;
                config.armorBarXOffset = 3;
                config.armorBarYOffset = 3;
                config.armorTotalYOffset = 0;
                config.armorTextXOffset = 3;
                config.armorTextYOffset = 3;
                config.armorIconXOffset = 0;
                config.armorIconYOffset = -4;
                config.armorBackgroundXOffset = 0;
                config.armorBackgroundYOffset = 0;
                break;
            }
            case AIR_BAR: {
                defaultAnchor = ClientConfig.DEFAULT_AIR_BAR_ANCHOR;
                defaultBgWidthForCalc = 80;
                config.airBarAnchor = defaultAnchor;
                config.airBarXOffset = 3;
                config.airBarYOffset = 3;
                config.airTotalYOffset = 0;
                config.airTextXOffset = 3;
                config.airTextYOffset = 3;
                config.airIconXOffset = 66;
                config.airIconYOffset = -4;
                config.airBackgroundXOffset = 0;
                config.airBackgroundYOffset = 0;
                break;
            }
            default: {
                return;
            }
        }
        int newDefaultTotalX = 0;
        if (defaultAnchor == HUDPositioning.BarPlacement.ABOVE_UTILITIES) {
            newDefaultTotalX = -defaultBgWidthForCalc / 2;
        } else if (defaultAnchor != null && defaultAnchor.getSide() == HUDPositioning.AnchorSide.RIGHT) {
            newDefaultTotalX = -defaultBgWidthForCalc;
        }
        switch (element) {
            case HEALTH_BAR: {
                config.healthTotalXOffset = newDefaultTotalX;
                break;
            }
            case STAMINA_BAR: {
                config.staminaTotalXOffset = newDefaultTotalX;
                break;
            }
            case MANA_BAR: {
                config.manaTotalXOffset = newDefaultTotalX;
                break;
            }
            case ARMOR_BAR: {
                config.armorTotalXOffset = newDefaultTotalX;
                break;
            }
            case AIR_BAR: {
                config.airTotalXOffset = newDefaultTotalX;
            }
        }
        this.rebuildEditorWidgets();
    }

    private void resetSizeDefaultsAction(DraggableElement element) {
        ClientConfig config = ModConfigManager.getClient();
        if (element == null) {
            return;
        }
        switch (element) {
            case HEALTH_BAR: {
                config.healthBackgroundWidth = 80;
                config.healthBackgroundHeight = 10;
                config.healthBarWidth = 74;
                config.healthBarHeight = 4;
                config.healthOverlayWidth = 80;
                config.healthOverlayHeight = 10;
                break;
            }
            case STAMINA_BAR: {
                config.staminaBackgroundWidth = 80;
                config.staminaBackgroundHeight = 10;
                config.staminaBarWidth = 74;
                config.staminaBarHeight = 4;
                config.staminaOverlayWidth = 80;
                config.staminaOverlayHeight = 10;
                break;
            }
            case MANA_BAR: {
                config.manaBackgroundWidth = 80;
                config.manaBackgroundHeight = 10;
                config.manaBarWidth = 74;
                config.manaBarHeight = 4;
                config.manaOverlayWidth = 81;
                config.manaOverlayHeight = 9;
                break;
            }
            case ARMOR_BAR: {
                config.armorBackgroundWidth = 80;
                config.armorBackgroundHeight = 10;
                config.armorBarWidth = 74;
                config.armorBarHeight = 4;
                break;
            }
            case AIR_BAR: {
                config.airBackgroundWidth = 80;
                config.airBackgroundHeight = 10;
                config.airBarWidth = 74;
                config.airBarHeight = 4;
            }
        }
        this.rebuildEditorWidgets();
    }

    private void resetAllDefaultsAction() {
        this.resetPositionDefaultsAction(DraggableElement.HEALTH_BAR);
        this.resetSizeDefaultsAction(DraggableElement.HEALTH_BAR);
        this.resetVisualDefaultsAction(DraggableElement.HEALTH_BAR);
        this.resetPositionDefaultsAction(DraggableElement.STAMINA_BAR);
        this.resetSizeDefaultsAction(DraggableElement.STAMINA_BAR);
        this.resetVisualDefaultsAction(DraggableElement.STAMINA_BAR);
        this.resetPositionDefaultsAction(DraggableElement.MANA_BAR);
        this.resetSizeDefaultsAction(DraggableElement.MANA_BAR);
        this.resetVisualDefaultsAction(DraggableElement.MANA_BAR);
        this.resetPositionDefaultsAction(DraggableElement.ARMOR_BAR);
        this.resetSizeDefaultsAction(DraggableElement.ARMOR_BAR);
        this.resetVisualDefaultsAction(DraggableElement.ARMOR_BAR);
        this.resetPositionDefaultsAction(DraggableElement.AIR_BAR);
        this.resetSizeDefaultsAction(DraggableElement.AIR_BAR);
        this.resetVisualDefaultsAction(DraggableElement.AIR_BAR);
        this.rebuildEditorWidgets();
    }

    private void resetVisualDefaultsAction(DraggableElement element) {
        ClientConfig config = ModConfigManager.getClient();
        if (element == null) {
            return;
        }
        switch (element) {
            case HEALTH_BAR: {
                config.enableHealthBar = true;
                config.enableHealthBackground = true;
                config.enableHealthForeground = false;
                config.fadeHealthWhenFull = false;
                config.showHealthText = ClientConfig.DEFAULT_SHOW_HEALTH_TEXT;
                config.healthTextAlign = ClientConfig.DEFAULT_HEALTH_TEXT_ALIGN;
                config.healthFillDirection = ClientConfig.DEFAULT_HEALTH_FILL_DIRECTION;
                break;
            }
            case STAMINA_BAR: {
                config.staminaBarBehavior = ClientConfig.DEFAULT_STAMINA_BAR_BEHAVIOR;
                config.enableStaminaBackground = true;
                config.enableStaminaForeground = false;
                config.fadeStaminaWhenFull = false;
                config.showStaminaText = ClientConfig.DEFAULT_SHOW_STAMINA_TEXT;
                config.staminaTextAlign = ClientConfig.DEFAULT_STAMINA_TEXT_ALIGN;
                config.staminaFillDirection = ClientConfig.DEFAULT_STAMINA_FILL_DIRECTION;
                break;
            }
            case MANA_BAR: {
                config.manaBarBehavior = ClientConfig.DEFAULT_MANA_BAR_BEHAVIOR;
                config.enableManaBackground = true;
                config.enableManaForeground = true;
                config.fadeManaWhenFull = true;
                config.showManaText = ClientConfig.DEFAULT_SHOW_MANA_TEXT;
                config.manaTextAlign = ClientConfig.DEFAULT_MANA_TEXT_ALIGN;
                config.manaFillDirection = ClientConfig.DEFAULT_MANA_FILL_DIRECTION;
                break;
            }
            case ARMOR_BAR: {
                config.armorBarBehavior = ClientConfig.DEFAULT_ARMOR_BAR_BEHAVIOR;
                config.enableArmorIcon = true;
                config.showArmorText = ClientConfig.DEFAULT_SHOW_ARMOR_TEXT;
                config.armorTextAlign = ClientConfig.DEFAULT_ARMOR_TEXT_ALIGN;
                break;
            }
            case AIR_BAR: {
                config.airBarBehavior = ClientConfig.DEFAULT_AIR_BAR_BEHAVIOR;
                config.enableAirIcon = true;
                config.showAirText = ClientConfig.DEFAULT_SHOW_AIR_TEXT;
                config.airTextAlign = ClientConfig.DEFAULT_AIR_TEXT_ALIGN;
            }
        }
    }

    private void openMultiLineConfirmScreen(class_2561 title, Runnable confirmAction) {
        this.field_22787.method_1507((class_437)new MultiLineConfirmResetScreen(this, title, confirmAction));
    }

    private class_2561 getFriendlyElementName(DraggableElement element) {
        if (element == null) {
            return class_2561.method_43470((String)"None");
        }
        String key = "gui.dynamic_resource_bars.element." + element.name().toLowerCase().replace("_bar", "");
        return class_2561.method_43471((String)key);
    }

    private int getOutlineColorForSubElement(DraggableElement focusedElement, SubElementType subElementType) {
        if (focusedElement == null || subElementType == null) {
            return -1;
        }
        switch (subElementType) {
            case BACKGROUND: {
                return -1593835776;
            }
            case BAR_MAIN: {
                switch (focusedElement) {
                    case HEALTH_BAR: {
                        return -1610547456;
                    }
                    case MANA_BAR: {
                        return -1610547201;
                    }
                    case STAMINA_BAR: {
                        return -1593858816;
                    }
                    case ARMOR_BAR: {
                        return -1597980480;
                    }
                    case AIR_BAR: {
                        return -1599219482;
                    }
                }
                return -1;
            }
            case FOREGROUND: {
                return -1593900801;
            }
        }
        return -1;
    }

    private ManaBarBehavior getNextAvailableManaBarBehavior(ManaBarBehavior current) {
        ManaBarBehavior next = current;
        int attempts = 0;
        do {
            next = next.getNext();
            if (++attempts <= ManaBarBehavior.values().length) continue;
            return ManaBarBehavior.OFF;
        } while (next != ManaBarBehavior.OFF && !this.isManaModAvailable(next));
        return next;
    }

    private boolean isManaModAvailable(ManaBarBehavior behavior) {
        switch (behavior) {
            case OFF: {
                return true;
            }
            case IRONS_SPELLBOOKS: {
                return PlatformUtil.isModLoaded("irons_spellbooks");
            }
            case ARS_NOUVEAU: {
                return PlatformUtil.isModLoaded("ars_nouveau");
            }
            case RPG_MANA: {
                return PlatformUtil.isModLoaded("rpgmana");
            }
            case MANA_ATTRIBUTES: {
                return PlatformUtil.isModLoaded("manaattributes");
            }
        }
        return false;
    }

    private StaminaBarBehavior getNextAvailableStaminaBarBehavior(StaminaBarBehavior current) {
        StaminaBarBehavior next = current.getNext();
        for (int attempts = 0; !this.isStaminaProviderAvailable(next) && attempts < StaminaBarBehavior.values().length; ++attempts) {
            next = next.getNext();
        }
        return next;
    }

    private boolean isStaminaProviderAvailable(StaminaBarBehavior behavior) {
        return switch (behavior) {
            default -> throw new IncompatibleClassChangeError();
            case StaminaBarBehavior.OFF, StaminaBarBehavior.FOOD -> true;
            case StaminaBarBehavior.STAMINA_ATTRIBUTES -> StaminaProviderManager.isModLoaded("staminaattributes");
        };
    }

    private ContextMenu createSubElementContextMenu(int mouseX, int mouseY, DraggableElement element, SubElementType subElement) {
        ArrayList<ContextMenuItem> items = new ArrayList<ContextMenuItem>();
        ClientConfig config = ModConfigManager.getClient();
        class_2561 layerName = this.getSubElementName(subElement);
        items.add(ContextMenuItem.title(layerName));
        if (this.canToggleSubElement(element, subElement)) {
            boolean isVisible = this.isSubElementVisible(element, subElement, config);
            class_5250 visibilityLabel = class_2561.method_43471((String)(isVisible ? "gui.dynamic_resource_bars.context.hide_layer" : "gui.dynamic_resource_bars.context.show_layer"));
            class_5250 statusText = isVisible ? class_2561.method_43471((String)"gui.dynamic_resource_bars.context.status.shown").method_27694(style -> style.method_36139(65280)) : class_2561.method_43471((String)"gui.dynamic_resource_bars.context.status.hidden").method_27694(style -> style.method_36139(0xFF0000));
            items.add(new ContextMenuItem((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)visibilityLabel).method_27693(" (").method_10852((class_2561)statusText).method_27693(")"), item -> {
                this.toggleSubElementVisibility(element, subElement, config);
                this.reopenContextMenuAfterRebuild();
            }));
        }
        if (subElement == SubElementType.TEXT) {
            this.addTextSettingsForSubElement(items, element, config);
        }
        items.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.context.set_size_position"), item -> this.openManualSizePositionDialog(element, subElement)));
        items.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.context.reset_layer"), item -> {
            this.resetSubElementToDefaults(element, subElement, config);
            this.reopenContextMenuAfterRebuild();
        }));
        return new ContextMenu(mouseX, mouseY, items);
    }

    private ContextMenu createMainElementContextMenu(int mouseX, int mouseY, DraggableElement element) {
        ArrayList<ContextMenuItem> items = new ArrayList<ContextMenuItem>();
        ClientConfig config = ModConfigManager.getClient();
        class_2561 groupName = this.getFriendlyElementName(element);
        items.add(ContextMenuItem.title(groupName));
        class_5250 sourceLabel = class_2561.method_43471((String)"gui.dynamic_resource_bars.context.source_behavior");
        class_2561 currentSource = this.getCurrentSourceBehavior(element, config);
        boolean canChangeSource = true;
        if (element == DraggableElement.MANA_BAR && !ManaProviderManager.hasAnyManaMods()) {
            canChangeSource = false;
        }
        items.add(new ContextMenuItem((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)sourceLabel).method_27693(": ").method_10852(currentSource), item -> {
            this.cycleSourceBehavior(element, config);
            this.reopenContextMenuAfterRebuild();
        }, canChangeSource));
        this.addElementSpecificOptions(items, element, config);
        class_5250 anchorLabel = class_2561.method_43471((String)"gui.dynamic_resource_bars.context.anchor_point");
        class_2561 currentAnchor = this.getAnchorName(element, config);
        items.add(new ContextMenuItem((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)anchorLabel).method_27693(": ").method_10852(currentAnchor), item -> {
            this.cycleAnchorPoint(element, config);
            this.reopenContextMenuAfterRebuild();
        }));
        items.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.context.set_position"), item -> this.openManualPositionDialog(element)));
        items.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.context.reset_element"), item -> {
            class_5250 title = class_2561.method_43469((String)"gui.dynamic_resource_bars.confirm.reset_element.title", (Object[])new Object[]{groupName});
            this.openMultiLineConfirmScreen((class_2561)title, () -> {
                this.resetElementToDefaults(element, config);
                this.rebuildEditorWidgets();
            });
        }));
        boolean canOpenSettings = this.isElementEnabled(element, config);
        items.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.context.open_settings"), item -> {
            this.contextMenuElement = null;
            this.contextMenuSubElement = null;
            EditModeManager.setFocusedElement(element);
            this.rebuildEditorWidgets();
        }, canOpenSettings));
        return new ContextMenu(mouseX, mouseY, items);
    }

    private void addElementSpecificOptions(List<ContextMenuItem> items, DraggableElement element, ClientConfig config) {
        if (element == DraggableElement.HEALTH_BAR || element == DraggableElement.STAMINA_BAR || element == DraggableElement.MANA_BAR) {
            boolean fadeEnabled = switch (element) {
                case DraggableElement.HEALTH_BAR -> config.fadeHealthWhenFull;
                case DraggableElement.STAMINA_BAR -> config.fadeStaminaWhenFull;
                case DraggableElement.MANA_BAR -> config.fadeManaWhenFull;
                default -> false;
            };
            items.add(new ContextMenuItem((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.context.fade_when_full", (Object[])new Object[]{fadeEnabled ? class_2561.method_43471((String)"options.on") : class_2561.method_43471((String)"options.off")}), item -> {
                switch (element) {
                    case HEALTH_BAR: {
                        config.fadeHealthWhenFull = !config.fadeHealthWhenFull;
                        break;
                    }
                    case STAMINA_BAR: {
                        config.fadeStaminaWhenFull = !config.fadeStaminaWhenFull;
                        break;
                    }
                    case MANA_BAR: {
                        config.fadeManaWhenFull = !config.fadeManaWhenFull;
                    }
                }
                this.reopenContextMenuAfterRebuild();
            }));
        }
        if (element == DraggableElement.HEALTH_BAR || element == DraggableElement.STAMINA_BAR || element == DraggableElement.MANA_BAR) {
            TextBehavior textBehavior = switch (element) {
                case DraggableElement.HEALTH_BAR -> config.showHealthText;
                case DraggableElement.STAMINA_BAR -> config.showStaminaText;
                case DraggableElement.MANA_BAR -> config.showManaText;
                default -> TextBehavior.NEVER;
            };
            items.add(new ContextMenuItem((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.context.text_behavior", (Object[])new Object[]{class_2561.method_43471((String)("text_behavior." + textBehavior.name().toLowerCase()))}), item -> {
                TextBehavior nextBehavior = this.getNextTextBehavior(textBehavior);
                switch (element) {
                    case HEALTH_BAR: {
                        config.showHealthText = nextBehavior;
                        break;
                    }
                    case STAMINA_BAR: {
                        config.showStaminaText = nextBehavior;
                        break;
                    }
                    case MANA_BAR: {
                        config.showManaText = nextBehavior;
                    }
                }
                this.reopenContextMenuAfterRebuild();
            }));
            HorizontalAlignment textAlign = switch (element) {
                case DraggableElement.HEALTH_BAR -> config.healthTextAlign;
                case DraggableElement.STAMINA_BAR -> config.staminaTextAlign;
                case DraggableElement.MANA_BAR -> config.manaTextAlign;
                default -> HorizontalAlignment.CENTER;
            };
            items.add(new ContextMenuItem((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.context.text_align", (Object[])new Object[]{class_2561.method_43471((String)("horizontal_alignment." + textAlign.name().toLowerCase()))}), item -> {
                HorizontalAlignment nextAlign = this.getNextHorizontalAlignment(textAlign);
                switch (element) {
                    case HEALTH_BAR: {
                        config.healthTextAlign = nextAlign;
                        break;
                    }
                    case STAMINA_BAR: {
                        config.staminaTextAlign = nextAlign;
                        break;
                    }
                    case MANA_BAR: {
                        config.manaTextAlign = nextAlign;
                    }
                }
                this.reopenContextMenuAfterRebuild();
            }));
        }
        if (element == DraggableElement.HEALTH_BAR || element == DraggableElement.STAMINA_BAR || element == DraggableElement.MANA_BAR) {
            FillDirection fillDirection = switch (element) {
                case DraggableElement.HEALTH_BAR -> config.healthFillDirection;
                case DraggableElement.STAMINA_BAR -> config.staminaFillDirection;
                case DraggableElement.MANA_BAR -> config.manaFillDirection;
                default -> FillDirection.HORIZONTAL;
            };
            items.add(new ContextMenuItem((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.context.fill_direction", (Object[])new Object[]{class_2561.method_43471((String)("fill_direction." + fillDirection.name().toLowerCase()))}), item -> {
                FillDirection nextDirection = fillDirection == FillDirection.HORIZONTAL ? FillDirection.VERTICAL : FillDirection.HORIZONTAL;
                switch (element) {
                    case HEALTH_BAR: {
                        config.healthFillDirection = nextDirection;
                        break;
                    }
                    case STAMINA_BAR: {
                        config.staminaFillDirection = nextDirection;
                        break;
                    }
                    case MANA_BAR: {
                        config.manaFillDirection = nextDirection;
                    }
                }
                this.reopenContextMenuAfterRebuild();
            }));
        }
    }

    private void addTextSettingsForSubElement(List<ContextMenuItem> items, DraggableElement element, ClientConfig config) {
        if (element == DraggableElement.HEALTH_BAR || element == DraggableElement.STAMINA_BAR || element == DraggableElement.MANA_BAR) {
            TextBehavior textBehavior = switch (element) {
                case DraggableElement.HEALTH_BAR -> config.showHealthText;
                case DraggableElement.STAMINA_BAR -> config.showStaminaText;
                case DraggableElement.MANA_BAR -> config.showManaText;
                default -> TextBehavior.NEVER;
            };
            items.add(new ContextMenuItem((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.context.text_behavior", (Object[])new Object[]{class_2561.method_43471((String)("text_behavior." + textBehavior.name().toLowerCase()))}), item -> {
                TextBehavior nextBehavior = this.getNextTextBehavior(textBehavior);
                switch (element) {
                    case HEALTH_BAR: {
                        config.showHealthText = nextBehavior;
                        break;
                    }
                    case STAMINA_BAR: {
                        config.showStaminaText = nextBehavior;
                        break;
                    }
                    case MANA_BAR: {
                        config.showManaText = nextBehavior;
                    }
                }
                this.reopenContextMenuAfterRebuild();
            }));
            HorizontalAlignment textAlign = switch (element) {
                case DraggableElement.HEALTH_BAR -> config.healthTextAlign;
                case DraggableElement.STAMINA_BAR -> config.staminaTextAlign;
                case DraggableElement.MANA_BAR -> config.manaTextAlign;
                default -> HorizontalAlignment.CENTER;
            };
            items.add(new ContextMenuItem((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.context.text_align", (Object[])new Object[]{class_2561.method_43471((String)("horizontal_alignment." + textAlign.name().toLowerCase()))}), item -> {
                HorizontalAlignment nextAlign = this.getNextHorizontalAlignment(textAlign);
                switch (element) {
                    case HEALTH_BAR: {
                        config.healthTextAlign = nextAlign;
                        break;
                    }
                    case STAMINA_BAR: {
                        config.staminaTextAlign = nextAlign;
                        break;
                    }
                    case MANA_BAR: {
                        config.manaTextAlign = nextAlign;
                    }
                }
                this.reopenContextMenuAfterRebuild();
            }));
        }
    }

    private void reopenContextMenuAfterRebuild() {
        this.rebuildEditorWidgets();
        if (this.contextMenuElement != null) {
            this.activeContextMenu = this.contextMenuSubElement != null ? this.createSubElementContextMenu(this.contextMenuX, this.contextMenuY, this.contextMenuElement, this.contextMenuSubElement) : this.createMainElementContextMenu(this.contextMenuX, this.contextMenuY, this.contextMenuElement);
            if (this.activeContextMenu != null) {
                this.activeContextMenu.setOnClose(() -> {
                    this.activeContextMenu = null;
                    this.contextMenuElement = null;
                    this.contextMenuSubElement = null;
                });
            }
        }
    }

    private boolean isElementEnabled(DraggableElement element, ClientConfig config) {
        return switch (element) {
            default -> throw new IncompatibleClassChangeError();
            case DraggableElement.HEALTH_BAR -> config.enableHealthBar;
            case DraggableElement.STAMINA_BAR -> {
                if (config.staminaBarBehavior != StaminaBarBehavior.OFF) {
                    yield true;
                }
                yield false;
            }
            case DraggableElement.MANA_BAR -> {
                if (config.manaBarBehavior != ManaBarBehavior.OFF) {
                    yield true;
                }
                yield false;
            }
            case DraggableElement.ARMOR_BAR -> {
                if (config.armorBarBehavior == BarRenderBehavior.CUSTOM) {
                    yield true;
                }
                yield false;
            }
            case DraggableElement.AIR_BAR -> config.airBarBehavior == BarRenderBehavior.CUSTOM;
        };
    }

    private class_2561 getSubElementName(SubElementType subElement) {
        String key = "gui.dynamic_resource_bars.subelement." + subElement.name().toLowerCase();
        return class_2561.method_43471((String)key);
    }

    private boolean canToggleSubElement(DraggableElement element, SubElementType subElement) {
        return subElement != SubElementType.BAR_MAIN && subElement != SubElementType.TEXT && subElement != SubElementType.ABSORPTION_TEXT;
    }

    private boolean isSubElementVisible(DraggableElement element, SubElementType subElement, ClientConfig config) {
        return switch (element) {
            default -> throw new IncompatibleClassChangeError();
            case DraggableElement.HEALTH_BAR -> {
                switch (subElement) {
                    case BACKGROUND: {
                        yield config.enableHealthBackground;
                    }
                    case FOREGROUND: {
                        yield config.enableHealthForeground;
                    }
                }
                yield true;
            }
            case DraggableElement.STAMINA_BAR -> {
                switch (subElement) {
                    case BACKGROUND: {
                        yield config.enableStaminaBackground;
                    }
                    case FOREGROUND: {
                        yield config.enableStaminaForeground;
                    }
                }
                yield true;
            }
            case DraggableElement.MANA_BAR -> {
                switch (subElement) {
                    case BACKGROUND: {
                        yield config.enableManaBackground;
                    }
                    case FOREGROUND: {
                        yield config.enableManaForeground;
                    }
                }
                yield true;
            }
            case DraggableElement.ARMOR_BAR -> {
                switch (subElement) {
                    case ICON: {
                        yield config.enableArmorIcon;
                    }
                }
                yield true;
            }
            case DraggableElement.AIR_BAR -> {
                switch (subElement) {
                    case ICON: {
                        yield config.enableAirIcon;
                    }
                }
                yield true;
            }
        };
    }

    private void toggleSubElementVisibility(DraggableElement element, SubElementType subElement, ClientConfig config) {
        switch (element) {
            case HEALTH_BAR: {
                if (subElement == SubElementType.BACKGROUND) {
                    config.enableHealthBackground = !config.enableHealthBackground;
                    break;
                }
                if (subElement != SubElementType.FOREGROUND) break;
                config.enableHealthForeground = !config.enableHealthForeground;
                break;
            }
            case STAMINA_BAR: {
                if (subElement == SubElementType.BACKGROUND) {
                    config.enableStaminaBackground = !config.enableStaminaBackground;
                    break;
                }
                if (subElement != SubElementType.FOREGROUND) break;
                config.enableStaminaForeground = !config.enableStaminaForeground;
                break;
            }
            case MANA_BAR: {
                if (subElement == SubElementType.BACKGROUND) {
                    config.enableManaBackground = !config.enableManaBackground;
                    break;
                }
                if (subElement != SubElementType.FOREGROUND) break;
                config.enableManaForeground = !config.enableManaForeground;
                break;
            }
            case ARMOR_BAR: {
                if (subElement != SubElementType.ICON) break;
                config.enableArmorIcon = !config.enableArmorIcon;
                break;
            }
            case AIR_BAR: {
                if (subElement != SubElementType.ICON) break;
                config.enableAirIcon = !config.enableAirIcon;
            }
        }
    }

    private class_2561 getCurrentSourceBehavior(DraggableElement element, ClientConfig config) {
        return switch (element) {
            default -> throw new IncompatibleClassChangeError();
            case DraggableElement.HEALTH_BAR -> {
                if (config.enableHealthBar) {
                    yield class_2561.method_43471((String)"gui.dynamic_resource_bars.behavior.custom_simple");
                }
                yield class_2561.method_43471((String)"gui.dynamic_resource_bars.behavior.vanilla_simple");
            }
            case DraggableElement.STAMINA_BAR -> class_2561.method_43471((String)config.staminaBarBehavior.getTranslationKey());
            case DraggableElement.MANA_BAR -> class_2561.method_43471((String)config.manaBarBehavior.getTranslationKey());
            case DraggableElement.ARMOR_BAR -> class_2561.method_43471((String)("bar_behavior." + config.armorBarBehavior.toString().toLowerCase()));
            case DraggableElement.AIR_BAR -> class_2561.method_43471((String)("bar_behavior." + config.airBarBehavior.toString().toLowerCase()));
        };
    }

    private void cycleSourceBehavior(DraggableElement element, ClientConfig config) {
        switch (element) {
            case HEALTH_BAR: {
                config.enableHealthBar = !config.enableHealthBar;
                break;
            }
            case STAMINA_BAR: {
                config.staminaBarBehavior = this.getNextAvailableStaminaBarBehavior(config.staminaBarBehavior);
                StaminaProviderManager.updateActiveProvider();
                break;
            }
            case MANA_BAR: {
                config.manaBarBehavior = this.getNextAvailableManaBarBehavior(config.manaBarBehavior);
                ManaProviderManager.updateActiveProvider();
                break;
            }
            case ARMOR_BAR: {
                config.armorBarBehavior = switch (config.armorBarBehavior) {
                    default -> throw new IncompatibleClassChangeError();
                    case BarRenderBehavior.VANILLA -> BarRenderBehavior.CUSTOM;
                    case BarRenderBehavior.CUSTOM -> BarRenderBehavior.HIDDEN;
                    case BarRenderBehavior.HIDDEN -> BarRenderBehavior.VANILLA;
                };
                break;
            }
            case AIR_BAR: {
                config.airBarBehavior = switch (config.airBarBehavior) {
                    default -> throw new IncompatibleClassChangeError();
                    case BarRenderBehavior.VANILLA -> BarRenderBehavior.CUSTOM;
                    case BarRenderBehavior.CUSTOM -> BarRenderBehavior.HIDDEN;
                    case BarRenderBehavior.HIDDEN -> BarRenderBehavior.VANILLA;
                };
            }
        }
    }

    private class_2561 getAnchorName(DraggableElement element, ClientConfig config) {
        HUDPositioning.BarPlacement anchor = switch (element) {
            default -> throw new IncompatibleClassChangeError();
            case DraggableElement.HEALTH_BAR -> config.healthBarAnchor;
            case DraggableElement.STAMINA_BAR -> config.staminaBarAnchor;
            case DraggableElement.MANA_BAR -> config.manaBarAnchor;
            case DraggableElement.ARMOR_BAR -> config.armorBarAnchor;
            case DraggableElement.AIR_BAR -> config.airBarAnchor;
        };
        return class_2561.method_43471((String)("gui.dynamic_resource_bars.anchor." + anchor.name().toLowerCase()));
    }

    private void cycleAnchorPoint(DraggableElement element, ClientConfig config) {
        switch (element) {
            case HEALTH_BAR: {
                config.healthBarAnchor = config.healthBarAnchor.getNext();
                break;
            }
            case STAMINA_BAR: {
                config.staminaBarAnchor = config.staminaBarAnchor.getNext();
                break;
            }
            case MANA_BAR: {
                config.manaBarAnchor = config.manaBarAnchor.getNext();
                break;
            }
            case ARMOR_BAR: {
                config.armorBarAnchor = config.armorBarAnchor.getNext();
                break;
            }
            case AIR_BAR: {
                config.airBarAnchor = config.airBarAnchor.getNext();
            }
        }
    }

    private void openManualSizePositionDialog(DraggableElement element, SubElementType subElement) {
        this.field_22787.method_1507((class_437)new ManualSizePositionScreen(this, element, subElement));
    }

    private void openManualPositionDialog(DraggableElement element) {
        this.field_22787.method_1507((class_437)new ManualPositionScreen(this, element));
    }

    private void resetSubElementToDefaults(DraggableElement element, SubElementType subElement, ClientConfig config) {
        switch (element) {
            case HEALTH_BAR: {
                this.resetHealthSubElement(subElement, config);
                break;
            }
            case STAMINA_BAR: {
                this.resetStaminaSubElement(subElement, config);
                break;
            }
            case MANA_BAR: {
                this.resetManaSubElement(subElement, config);
                break;
            }
            case ARMOR_BAR: {
                this.resetArmorSubElement(subElement, config);
                break;
            }
            case AIR_BAR: {
                this.resetAirSubElement(subElement, config);
            }
        }
    }

    private void resetHealthSubElement(SubElementType subElement, ClientConfig config) {
        switch (subElement) {
            case BACKGROUND: {
                config.healthBackgroundWidth = 80;
                config.healthBackgroundHeight = 10;
                config.healthBackgroundXOffset = 0;
                config.healthBackgroundYOffset = 0;
                break;
            }
            case BAR_MAIN: {
                config.healthBarWidth = 74;
                config.healthBarHeight = 4;
                config.healthBarXOffset = 3;
                config.healthBarYOffset = 3;
                break;
            }
            case FOREGROUND: {
                config.healthOverlayWidth = 80;
                config.healthOverlayHeight = 10;
                config.healthOverlayXOffset = 0;
                config.healthOverlayYOffset = -3;
                break;
            }
            case TEXT: {
                config.healthTextXOffset = 3;
                config.healthTextYOffset = 3;
                break;
            }
            case ABSORPTION_TEXT: {
                config.healthAbsorptionTextXOffset = 65;
                config.healthAbsorptionTextYOffset = 3;
            }
        }
    }

    private void resetStaminaSubElement(SubElementType subElement, ClientConfig config) {
        switch (subElement) {
            case BACKGROUND: {
                config.staminaBackgroundWidth = 80;
                config.staminaBackgroundHeight = 10;
                config.staminaBackgroundXOffset = 0;
                config.staminaBackgroundYOffset = 0;
                break;
            }
            case BAR_MAIN: {
                config.staminaBarWidth = 74;
                config.staminaBarHeight = 4;
                config.staminaBarXOffset = 3;
                config.staminaBarYOffset = 3;
                break;
            }
            case FOREGROUND: {
                config.staminaOverlayWidth = 80;
                config.staminaOverlayHeight = 10;
                config.staminaOverlayXOffset = 0;
                config.staminaOverlayYOffset = -3;
                break;
            }
            case TEXT: {
                config.staminaTextXOffset = 3;
                config.staminaTextYOffset = 3;
            }
        }
    }

    private void resetManaSubElement(SubElementType subElement, ClientConfig config) {
        switch (subElement) {
            case BACKGROUND: {
                config.manaBackgroundWidth = 80;
                config.manaBackgroundHeight = 10;
                config.manaBackgroundXOffset = 0;
                config.manaBackgroundYOffset = 0;
                break;
            }
            case BAR_MAIN: {
                config.manaBarWidth = 74;
                config.manaBarHeight = 4;
                config.manaBarXOffset = 3;
                config.manaBarYOffset = 3;
                break;
            }
            case FOREGROUND: {
                config.manaOverlayWidth = 81;
                config.manaOverlayHeight = 9;
                config.manaOverlayXOffset = 0;
                config.manaOverlayYOffset = -3;
                break;
            }
            case TEXT: {
                config.manaTextXOffset = 3;
                config.manaTextYOffset = 3;
            }
        }
    }

    private void resetArmorSubElement(SubElementType subElement, ClientConfig config) {
        switch (subElement) {
            case BACKGROUND: {
                config.armorBackgroundWidth = 80;
                config.armorBackgroundHeight = 10;
                config.armorBackgroundXOffset = 0;
                config.armorBackgroundYOffset = 0;
                break;
            }
            case BAR_MAIN: {
                config.armorBarWidth = 74;
                config.armorBarHeight = 4;
                config.armorBarXOffset = 3;
                config.armorBarYOffset = 3;
                break;
            }
            case TEXT: {
                config.armorTextXOffset = 3;
                config.armorTextYOffset = 3;
                break;
            }
            case ICON: {
                config.armorIconXOffset = 0;
                config.armorIconYOffset = -4;
            }
        }
    }

    private void resetAirSubElement(SubElementType subElement, ClientConfig config) {
        switch (subElement) {
            case BACKGROUND: {
                config.airBackgroundWidth = 80;
                config.airBackgroundHeight = 10;
                config.airBackgroundXOffset = 0;
                config.airBackgroundYOffset = 0;
                break;
            }
            case BAR_MAIN: {
                config.airBarWidth = 74;
                config.airBarHeight = 4;
                config.airBarXOffset = 3;
                config.airBarYOffset = 3;
                break;
            }
            case TEXT: {
                config.airTextXOffset = 3;
                config.airTextYOffset = 3;
                break;
            }
            case ICON: {
                config.airIconXOffset = 66;
                config.airIconYOffset = -4;
            }
        }
    }

    private void resetElementToDefaults(DraggableElement element, ClientConfig config) {
        switch (element) {
            case HEALTH_BAR: {
                this.resetHealthDefaults(config);
                break;
            }
            case STAMINA_BAR: {
                this.resetStaminaDefaults(config);
                break;
            }
            case MANA_BAR: {
                this.resetManaDefaults(config);
                break;
            }
            case ARMOR_BAR: {
                this.resetArmorDefaults(config);
                break;
            }
            case AIR_BAR: {
                this.resetAirDefaults(config);
            }
        }
    }

    private void resetHealthDefaults(ClientConfig config) {
        this.resetPositionDefaultsAction(DraggableElement.HEALTH_BAR);
        this.resetSizeDefaultsAction(DraggableElement.HEALTH_BAR);
        this.resetVisualDefaultsAction(DraggableElement.HEALTH_BAR);
    }

    private void resetStaminaDefaults(ClientConfig config) {
        this.resetPositionDefaultsAction(DraggableElement.STAMINA_BAR);
        this.resetSizeDefaultsAction(DraggableElement.STAMINA_BAR);
        this.resetVisualDefaultsAction(DraggableElement.STAMINA_BAR);
    }

    private void resetManaDefaults(ClientConfig config) {
        this.resetPositionDefaultsAction(DraggableElement.MANA_BAR);
        this.resetSizeDefaultsAction(DraggableElement.MANA_BAR);
        this.resetVisualDefaultsAction(DraggableElement.MANA_BAR);
    }

    private void resetArmorDefaults(ClientConfig config) {
        this.resetPositionDefaultsAction(DraggableElement.ARMOR_BAR);
        this.resetSizeDefaultsAction(DraggableElement.ARMOR_BAR);
        this.resetVisualDefaultsAction(DraggableElement.ARMOR_BAR);
    }

    private void resetAirDefaults(ClientConfig config) {
        this.resetPositionDefaultsAction(DraggableElement.AIR_BAR);
        this.resetSizeDefaultsAction(DraggableElement.AIR_BAR);
        this.resetVisualDefaultsAction(DraggableElement.AIR_BAR);
    }

    private static enum ResizeMode {
        NONE,
        WIDTH,
        HEIGHT;

    }

    private static class ResizeData {
        final DraggableElement element;
        final SubElementType subElement;
        final ResizeMode mode;
        final int initialWidth;
        final int initialHeight;

        ResizeData(DraggableElement element, SubElementType subElement, ResizeMode mode, int initialWidth, int initialHeight) {
            this.element = element;
            this.subElement = subElement;
            this.mode = mode;
            this.initialWidth = initialWidth;
            this.initialHeight = initialHeight;
        }
    }
}

