/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.muon.dynamic_resource_bars.DynamicResourceBars;
import dev.muon.dynamic_resource_bars.util.AnimationMetadata;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class NineSliceRenderer {
    public static void renderWithScaling(class_332 graphics, class_2960 texture, AnimationMetadata.ScalingInfo scalingInfo, int x, int y, int width, int height, int textureWidth, int textureHeight) {
        if (scalingInfo.mode == AnimationMetadata.ScalingMode.NONE) {
            if (scalingInfo.sourceRegion != null) {
                AnimationMetadata.SourceRegion src = scalingInfo.sourceRegion;
                graphics.method_25290(texture, x, y, (float)src.u, (float)src.v, width, height, textureWidth, textureHeight);
            } else {
                graphics.method_25290(texture, x, y, 0.0f, 0.0f, width, height, textureWidth, textureHeight);
            }
        } else if (scalingInfo.mode == AnimationMetadata.ScalingMode.STRETCH) {
            if (scalingInfo.sourceRegion != null) {
                AnimationMetadata.SourceRegion src = scalingInfo.sourceRegion;
                graphics.method_25293(texture, x, y, width, height, (float)src.u, (float)src.v, src.width, src.height, textureWidth, textureHeight);
            } else {
                graphics.method_25293(texture, x, y, width, height, 0.0f, 0.0f, textureWidth, textureHeight, textureWidth, textureHeight);
            }
        } else if (scalingInfo.mode == AnimationMetadata.ScalingMode.TILE) {
            if (scalingInfo.sourceRegion != null) {
                AnimationMetadata.SourceRegion src = scalingInfo.sourceRegion;
                NineSliceRenderer.renderTiled(graphics, texture, x, y, width, height, src.u, src.v, src.width, src.height, textureWidth, textureHeight);
            } else {
                NineSliceRenderer.renderTiled(graphics, texture, x, y, width, height, 0, 0, textureWidth, textureHeight, textureWidth, textureHeight);
            }
        } else if (scalingInfo.isNineSlice()) {
            NineSliceRenderer.renderNineSlice(graphics, texture, scalingInfo.nineSlice, x, y, width, height, textureWidth, textureHeight);
        } else {
            graphics.method_25290(texture, x, y, 0.0f, 0.0f, width, height, textureWidth, textureHeight);
        }
    }

    private static void renderTiled(class_332 graphics, class_2960 texture, int x, int y, int width, int height, int u, int v, int texWidth, int texHeight, int textureSheetWidth, int textureSheetHeight) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int tilesX = width / texWidth;
        int remainderX = width % texWidth;
        int tilesY = height / texHeight;
        int remainderY = height % texHeight;
        for (int ty = 0; ty < tilesY; ++ty) {
            for (int tx = 0; tx < tilesX; ++tx) {
                graphics.method_25290(texture, x + tx * texWidth, y + ty * texHeight, (float)u, (float)v, texWidth, texHeight, textureSheetWidth, textureSheetHeight);
            }
            if (remainderX <= 0) continue;
            graphics.method_25290(texture, x + tilesX * texWidth, y + ty * texHeight, (float)u, (float)v, remainderX, texHeight, textureSheetWidth, textureSheetHeight);
        }
        if (remainderY > 0) {
            for (int tx = 0; tx < tilesX; ++tx) {
                graphics.method_25290(texture, x + tx * texWidth, y + tilesY * texHeight, (float)u, (float)v, texWidth, remainderY, textureSheetWidth, textureSheetHeight);
            }
            if (remainderX > 0) {
                graphics.method_25290(texture, x + tilesX * texWidth, y + tilesY * texHeight, (float)u, (float)v, remainderX, remainderY, textureSheetWidth, textureSheetHeight);
            }
        }
    }

    private static void renderNineSlice(class_332 graphics, class_2960 texture, AnimationMetadata.NineSliceData nineSlice, int x, int y, int width, int height, int textureWidth, int textureHeight) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        AnimationMetadata.SourceRegion source = nineSlice.sourceRegion;
        if (source == null) {
            source = AnimationMetadata.SourceRegion.fullTexture(textureWidth, textureHeight);
        }
        int l = nineSlice.left;
        int r = nineSlice.right;
        int t = nineSlice.top;
        int b = nineSlice.bottom;
        int centerWidth = width - l - r;
        int centerHeight = height - t - b;
        int texCenterWidth = source.width - l - r;
        int texCenterHeight = source.height - t - b;
        if (centerWidth < 0 || centerHeight < 0) {
            graphics.method_25290(texture, x, y, (float)source.u, (float)source.v, width, height, textureWidth, textureHeight);
            return;
        }
        if (texCenterWidth <= 0 || texCenterHeight <= 0) {
            DynamicResourceBars.LOGGER.warn("Nine-slice borders too large for source region! Texture: {}, Source: {}x{}, Borders: ({},{},{},{}), Center would be: {}x{}", (Object)texture, (Object)source.width, (Object)source.height, (Object)l, (Object)r, (Object)t, (Object)b, (Object)texCenterWidth, (Object)texCenterHeight);
            graphics.method_25290(texture, x, y, (float)source.u, (float)source.v, width, height, textureWidth, textureHeight);
            return;
        }
        if (l > 0 && t > 0) {
            graphics.method_25290(texture, x, y, (float)source.u, (float)source.v, l, t, textureWidth, textureHeight);
        }
        if (t > 0 && centerWidth > 0) {
            NineSliceRenderer.renderRegion(graphics, texture, nineSlice.edgeMode, x + l, y, centerWidth, t, source.u + l, source.v, texCenterWidth, t, textureWidth, textureHeight);
        }
        if (r > 0 && t > 0) {
            graphics.method_25290(texture, x + width - r, y, (float)(source.u + source.width - r), (float)source.v, r, t, textureWidth, textureHeight);
        }
        if (l > 0 && centerHeight > 0) {
            NineSliceRenderer.renderRegion(graphics, texture, nineSlice.edgeMode, x, y + t, l, centerHeight, source.u, source.v + t, l, texCenterHeight, textureWidth, textureHeight);
        }
        if (centerWidth > 0 && centerHeight > 0) {
            NineSliceRenderer.renderRegion(graphics, texture, nineSlice.centerMode, x + l, y + t, centerWidth, centerHeight, source.u + l, source.v + t, texCenterWidth, texCenterHeight, textureWidth, textureHeight);
        }
        if (r > 0 && centerHeight > 0) {
            NineSliceRenderer.renderRegion(graphics, texture, nineSlice.edgeMode, x + width - r, y + t, r, centerHeight, source.u + source.width - r, source.v + t, r, texCenterHeight, textureWidth, textureHeight);
        }
        if (l > 0 && b > 0) {
            graphics.method_25290(texture, x, y + height - b, (float)source.u, (float)(source.v + source.height - b), l, b, textureWidth, textureHeight);
        }
        if (b > 0 && centerWidth > 0) {
            NineSliceRenderer.renderRegion(graphics, texture, nineSlice.edgeMode, x + l, y + height - b, centerWidth, b, source.u + l, source.v + source.height - b, texCenterWidth, b, textureWidth, textureHeight);
        }
        if (r > 0 && b > 0) {
            graphics.method_25290(texture, x + width - r, y + height - b, (float)(source.u + source.width - r), (float)(source.v + source.height - b), r, b, textureWidth, textureHeight);
        }
    }

    private static void renderRegion(class_332 graphics, class_2960 texture, AnimationMetadata.ScalingMode mode, int x, int y, int width, int height, int u, int v, int texWidth, int texHeight, int textureSheetWidth, int textureSheetHeight) {
        if (mode == AnimationMetadata.ScalingMode.TILE) {
            int tilesX = width / texWidth;
            int remainderX = width % texWidth;
            int tilesY = height / texHeight;
            int remainderY = height % texHeight;
            for (int ty = 0; ty < tilesY; ++ty) {
                for (int tx = 0; tx < tilesX; ++tx) {
                    graphics.method_25290(texture, x + tx * texWidth, y + ty * texHeight, (float)u, (float)v, texWidth, texHeight, textureSheetWidth, textureSheetHeight);
                }
                if (remainderX <= 0) continue;
                graphics.method_25290(texture, x + tilesX * texWidth, y + ty * texHeight, (float)u, (float)v, remainderX, texHeight, textureSheetWidth, textureSheetHeight);
            }
            if (remainderY > 0) {
                for (int tx = 0; tx < tilesX; ++tx) {
                    graphics.method_25290(texture, x + tx * texWidth, y + tilesY * texHeight, (float)u, (float)v, texWidth, remainderY, textureSheetWidth, textureSheetHeight);
                }
                if (remainderX > 0) {
                    graphics.method_25290(texture, x + tilesX * texWidth, y + tilesY * texHeight, (float)u, (float)v, remainderX, remainderY, textureSheetWidth, textureSheetHeight);
                }
            }
        } else {
            graphics.method_25293(texture, x, y, width, height, (float)u, (float)v, texWidth, texHeight, textureSheetWidth, textureSheetHeight);
        }
    }
}

