/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.muon.dynamic_resource_bars.DynamicResourceBars;
import dev.muon.dynamic_resource_bars.provider.ManaBarBehavior;
import dev.muon.dynamic_resource_bars.provider.StaminaBarBehavior;
import dev.muon.dynamic_resource_bars.util.BarRenderBehavior;
import dev.muon.dynamic_resource_bars.util.FillDirection;
import dev.muon.dynamic_resource_bars.util.HUDPositioning;
import dev.muon.dynamic_resource_bars.util.HorizontalAlignment;
import dev.muon.dynamic_resource_bars.util.TextBehavior;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class ClientConfig {
    private static Path CONFIG_FILE_PATH;
    private static final Gson GSON;
    public static final float DEFAULT_TEXT_SCALING_FACTOR = 0.5f;
    public double textScalingFactor = 0.5;
    public static final int DEFAULT_TEXT_COLOR = 0xFFFFFF;
    public static final int DEFAULT_TEXT_OPACITY = 200;
    public static final float DEFAULT_TEXT_SIZE = 1.0f;
    public int globalTextColor = 0xFFFFFF;
    public int globalTextOpacity = 200;
    public float globalTextSize = 1.0f;
    public static final boolean DEFAULT_ENABLE_HEALTH_BAR = true;
    public static final HUDPositioning.BarPlacement DEFAULT_HEALTH_BAR_ANCHOR;
    public static final boolean DEFAULT_FADE_HEALTH_WHEN_FULL = false;
    public static final TextBehavior DEFAULT_SHOW_HEALTH_TEXT;
    public static final HorizontalAlignment DEFAULT_HEALTH_TEXT_ALIGN;
    public static final boolean DEFAULT_ENABLE_HEALTH_FOREGROUND = false;
    public static final boolean DEFAULT_ENABLE_HEALTH_BACKGROUND = true;
    public static final FillDirection DEFAULT_HEALTH_FILL_DIRECTION;
    public static final int DEFAULT_HEALTH_BACKGROUND_WIDTH = 80;
    public static final int DEFAULT_HEALTH_BACKGROUND_HEIGHT = 10;
    public static final int DEFAULT_HEALTH_BAR_WIDTH = 74;
    public static final int DEFAULT_HEALTH_BAR_HEIGHT = 4;
    public static final int DEFAULT_HEALTH_OVERLAY_WIDTH = 80;
    public static final int DEFAULT_HEALTH_OVERLAY_HEIGHT = 10;
    public static final int DEFAULT_HEALTH_BAR_X_OFFSET = 3;
    public static final int DEFAULT_HEALTH_BAR_Y_OFFSET = 3;
    public static final int DEFAULT_HEALTH_TOTAL_X_OFFSET = 0;
    public static final int DEFAULT_HEALTH_TOTAL_Y_OFFSET = 0;
    public static final int DEFAULT_HEALTH_OVERLAY_X_OFFSET = 0;
    public static final int DEFAULT_HEALTH_OVERLAY_Y_OFFSET = -3;
    public static final int DEFAULT_HEALTH_BACKGROUND_X_OFFSET = 0;
    public static final int DEFAULT_HEALTH_BACKGROUND_Y_OFFSET = 0;
    public static final int DEFAULT_HEALTH_TEXT_X_OFFSET = 3;
    public static final int DEFAULT_HEALTH_TEXT_Y_OFFSET = 3;
    public static final int DEFAULT_HEALTH_TEXT_COLOR = 0xFFFFFF;
    public static final int DEFAULT_HEALTH_TEXT_OPACITY = 200;
    public static final float DEFAULT_HEALTH_TEXT_SIZE = 1.0f;
    public static final int DEFAULT_HEALTH_ABSORPTION_TEXT_X_OFFSET = 65;
    public static final int DEFAULT_HEALTH_ABSORPTION_TEXT_Y_OFFSET = 3;
    public boolean enableHealthBar = true;
    public HUDPositioning.BarPlacement healthBarAnchor;
    public boolean fadeHealthWhenFull = false;
    public TextBehavior showHealthText;
    public HorizontalAlignment healthTextAlign;
    public boolean enableHealthForeground = false;
    public boolean enableHealthBackground = true;
    public FillDirection healthFillDirection;
    public int healthBackgroundWidth = 80;
    public int healthBackgroundHeight = 10;
    public int healthBarWidth = 74;
    public int healthBarHeight = 4;
    public int healthOverlayWidth = 80;
    public int healthOverlayHeight = 10;
    public int healthBarXOffset = 3;
    public int healthBarYOffset = 3;
    public int healthTotalXOffset = 0;
    public int healthTotalYOffset = 0;
    public int healthOverlayXOffset = 0;
    public int healthOverlayYOffset = -3;
    public int healthBackgroundXOffset = 0;
    public int healthBackgroundYOffset = 0;
    public int healthTextXOffset = 3;
    public int healthTextYOffset = 3;
    public int healthTextColor = 0xFFFFFF;
    public int healthTextOpacity = 200;
    public float healthTextSize = 1.0f;
    public int healthAbsorptionTextXOffset = 65;
    public int healthAbsorptionTextYOffset = 3;
    public static final boolean DEFAULT_ENABLE_STAMINA_BAR = true;
    public static final StaminaBarBehavior DEFAULT_STAMINA_BAR_BEHAVIOR;
    public static final boolean DEFAULT_MERGE_MOUNT_HEALTH = true;
    public static final boolean DEFAULT_ENABLE_MOUNT_HEALTH = true;
    public static final HUDPositioning.BarPlacement DEFAULT_STAMINA_BAR_ANCHOR;
    public static final boolean DEFAULT_FADE_STAMINA_WHEN_FULL = false;
    public static final TextBehavior DEFAULT_SHOW_STAMINA_TEXT;
    public static final HorizontalAlignment DEFAULT_STAMINA_TEXT_ALIGN;
    public static final boolean DEFAULT_ENABLE_STAMINA_FOREGROUND = false;
    public static final boolean DEFAULT_ENABLE_STAMINA_BACKGROUND = true;
    public static final FillDirection DEFAULT_STAMINA_FILL_DIRECTION;
    public static final int DEFAULT_STAMINA_BACKGROUND_WIDTH = 80;
    public static final int DEFAULT_STAMINA_BACKGROUND_HEIGHT = 10;
    public static final int DEFAULT_STAMINA_BAR_WIDTH = 74;
    public static final int DEFAULT_STAMINA_BAR_HEIGHT = 4;
    public static final int DEFAULT_STAMINA_OVERLAY_WIDTH = 80;
    public static final int DEFAULT_STAMINA_OVERLAY_HEIGHT = 10;
    public static final int DEFAULT_STAMINA_OVERLAY_X_OFFSET = 0;
    public static final int DEFAULT_STAMINA_OVERLAY_Y_OFFSET = -3;
    public static final int DEFAULT_STAMINA_BAR_X_OFFSET = 3;
    public static final int DEFAULT_STAMINA_BAR_Y_OFFSET = 3;
    public static final int DEFAULT_STAMINA_TOTAL_X_OFFSET = -80;
    public static final int DEFAULT_STAMINA_TOTAL_Y_OFFSET = 0;
    public static final int DEFAULT_STAMINA_BACKGROUND_X_OFFSET = 0;
    public static final int DEFAULT_STAMINA_BACKGROUND_Y_OFFSET = 0;
    public static final int DEFAULT_STAMINA_TEXT_X_OFFSET = 3;
    public static final int DEFAULT_STAMINA_TEXT_Y_OFFSET = 3;
    public static final int DEFAULT_STAMINA_TEXT_COLOR = 0xFFFFFF;
    public static final int DEFAULT_STAMINA_TEXT_OPACITY = 200;
    public static final float DEFAULT_STAMINA_TEXT_SIZE = 1.0f;
    public StaminaBarBehavior staminaBarBehavior;
    public boolean mergeMountHealth = true;
    public boolean enableMountHealth = true;
    public HUDPositioning.BarPlacement staminaBarAnchor;
    public boolean fadeStaminaWhenFull = false;
    public TextBehavior showStaminaText;
    public HorizontalAlignment staminaTextAlign;
    public boolean enableStaminaForeground = false;
    public boolean enableStaminaBackground = true;
    public FillDirection staminaFillDirection;
    public int staminaBackgroundWidth = 80;
    public int staminaBackgroundHeight = 10;
    public int staminaBarWidth = 74;
    public int staminaBarHeight = 4;
    public int staminaOverlayWidth = 80;
    public int staminaOverlayHeight = 10;
    public int staminaOverlayXOffset = 0;
    public int staminaOverlayYOffset = -3;
    public int staminaBarXOffset = 3;
    public int staminaBarYOffset = 3;
    public int staminaTotalXOffset = -80;
    public int staminaTotalYOffset = 0;
    public int staminaBackgroundXOffset = 0;
    public int staminaBackgroundYOffset = 0;
    public int staminaTextXOffset = 3;
    public int staminaTextYOffset = 3;
    public int staminaTextColor = 0xFFFFFF;
    public int staminaTextOpacity = 200;
    public float staminaTextSize = 1.0f;
    public static final ManaBarBehavior DEFAULT_MANA_BAR_BEHAVIOR;
    public static final HUDPositioning.BarPlacement DEFAULT_MANA_BAR_ANCHOR;
    public static final boolean DEFAULT_ENABLE_MANA_BACKGROUND = true;
    public static final boolean DEFAULT_ENABLE_MANA_FOREGROUND = true;
    public static final boolean DEFAULT_FADE_MANA_WHEN_FULL = true;
    public static final TextBehavior DEFAULT_SHOW_MANA_TEXT;
    public static final HorizontalAlignment DEFAULT_MANA_TEXT_ALIGN;
    public static final FillDirection DEFAULT_MANA_FILL_DIRECTION;
    public static final int DEFAULT_MANA_TOTAL_X_OFFSET = -40;
    public static final int DEFAULT_MANA_TOTAL_Y_OFFSET = 0;
    public static final int DEFAULT_MANA_BACKGROUND_X_OFFSET = 0;
    public static final int DEFAULT_MANA_BACKGROUND_Y_OFFSET = 0;
    public static final int DEFAULT_MANA_BACKGROUND_WIDTH = 80;
    public static final int DEFAULT_MANA_BACKGROUND_HEIGHT = 10;
    public static final int DEFAULT_MANA_BAR_X_OFFSET = 3;
    public static final int DEFAULT_MANA_BAR_Y_OFFSET = 3;
    public static final int DEFAULT_MANA_BAR_WIDTH = 74;
    public static final int DEFAULT_MANA_BAR_HEIGHT = 4;
    public static final int DEFAULT_MANA_OVERLAY_X_OFFSET = 0;
    public static final int DEFAULT_MANA_OVERLAY_Y_OFFSET = -3;
    public static final int DEFAULT_MANA_OVERLAY_WIDTH = 81;
    public static final int DEFAULT_MANA_OVERLAY_HEIGHT = 9;
    public static final int DEFAULT_MANA_TEXT_X_OFFSET = 3;
    public static final int DEFAULT_MANA_TEXT_Y_OFFSET = 3;
    public ManaBarBehavior manaBarBehavior = DEFAULT_MANA_BAR_BEHAVIOR;
    public HUDPositioning.BarPlacement manaBarAnchor = DEFAULT_MANA_BAR_ANCHOR;
    public boolean enableManaBackground = true;
    public boolean enableManaForeground = true;
    public boolean fadeManaWhenFull = true;
    public TextBehavior showManaText;
    public HorizontalAlignment manaTextAlign;
    public FillDirection manaFillDirection;
    public int manaBackgroundWidth = 80;
    public int manaBackgroundHeight = 10;
    public int manaBarWidth = 74;
    public int manaBarHeight = 4;
    public int manaOverlayWidth = 81;
    public int manaOverlayHeight = 9;
    public int manaBarXOffset = 3;
    public int manaBarYOffset = 3;
    public int manaTotalXOffset = -40;
    public int manaTotalYOffset = 0;
    public int manaOverlayXOffset = 0;
    public int manaOverlayYOffset = -3;
    public int manaBackgroundXOffset = 0;
    public int manaBackgroundYOffset = 0;
    public int manaTextXOffset = 3;
    public int manaTextYOffset = 3;
    public int manaTextColor = 0xFFFFFF;
    public int manaTextOpacity = 200;
    public float manaTextSize = 1.0f;
    public static final BarRenderBehavior DEFAULT_ARMOR_BAR_BEHAVIOR;
    public static final HUDPositioning.BarPlacement DEFAULT_ARMOR_BAR_ANCHOR;
    public static final int DEFAULT_MAX_EXPECTED_ARMOR = 20;
    public static final int DEFAULT_MAX_EXPECTED_PROT = 16;
    public static final int DEFAULT_ARMOR_BACKGROUND_WIDTH = 80;
    public static final int DEFAULT_ARMOR_BACKGROUND_HEIGHT = 10;
    public static final int DEFAULT_ARMOR_BAR_WIDTH = 74;
    public static final int DEFAULT_ARMOR_BAR_HEIGHT = 4;
    public static final int DEFAULT_ARMOR_BAR_X_OFFSET = 3;
    public static final int DEFAULT_ARMOR_BAR_Y_OFFSET = 3;
    public static final int DEFAULT_ARMOR_TOTAL_X_OFFSET = 0;
    public static final int DEFAULT_ARMOR_TOTAL_Y_OFFSET = 0;
    public static final boolean DEFAULT_ENABLE_ARMOR_ICON = true;
    public static final int DEFAULT_ARMOR_ICON_SIZE = 16;
    public static final int DEFAULT_PROT_OVERLAY_ANIMATION_CYCLES = 16;
    public static final int DEFAULT_PROT_OVERLAY_FRAME_HEIGHT = 4;
    public static final int DEFAULT_ARMOR_ICON_X_OFFSET = 0;
    public static final int DEFAULT_ARMOR_ICON_Y_OFFSET = -4;
    public static final int DEFAULT_ARMOR_TEXT_X_OFFSET = 3;
    public static final int DEFAULT_ARMOR_TEXT_Y_OFFSET = 3;
    public static final int DEFAULT_ARMOR_TEXT_COLOR = 0xFFFFFF;
    public static final int DEFAULT_ARMOR_TEXT_OPACITY = 200;
    public static final float DEFAULT_ARMOR_TEXT_SIZE = 1.0f;
    public static final TextBehavior DEFAULT_SHOW_ARMOR_TEXT;
    public static final HorizontalAlignment DEFAULT_ARMOR_TEXT_ALIGN;
    public static final int DEFAULT_ARMOR_BACKGROUND_X_OFFSET = 0;
    public static final int DEFAULT_ARMOR_BACKGROUND_Y_OFFSET = 0;
    public BarRenderBehavior armorBarBehavior;
    public HUDPositioning.BarPlacement armorBarAnchor;
    public int maxExpectedArmor = 20;
    public int maxExpectedProt = 16;
    public int armorBackgroundWidth = 80;
    public int armorBackgroundHeight = 10;
    public int armorBarWidth = 74;
    public int armorBarHeight = 4;
    public int armorBarXOffset = 3;
    public int armorBarYOffset = 3;
    public int armorTotalXOffset = 0;
    public int armorTotalYOffset = 0;
    public boolean enableArmorIcon = true;
    public int armorIconSize = 16;
    public int protOverlayAnimationCycles = 16;
    public int protOverlayFrameHeight = 4;
    public int armorIconXOffset = 0;
    public int armorIconYOffset = -4;
    public int armorTextXOffset = 3;
    public int armorTextYOffset = 3;
    public int armorTextColor = 0xFFFFFF;
    public int armorTextOpacity = 200;
    public float armorTextSize = 1.0f;
    public TextBehavior showArmorText;
    public HorizontalAlignment armorTextAlign;
    public int armorBackgroundXOffset = 0;
    public int armorBackgroundYOffset = 0;
    public static final BarRenderBehavior DEFAULT_AIR_BAR_BEHAVIOR;
    public static final HUDPositioning.BarPlacement DEFAULT_AIR_BAR_ANCHOR;
    public static final int DEFAULT_AIR_BACKGROUND_WIDTH = 80;
    public static final int DEFAULT_AIR_BACKGROUND_HEIGHT = 10;
    public static final int DEFAULT_AIR_BAR_WIDTH = 74;
    public static final int DEFAULT_AIR_BAR_HEIGHT = 4;
    public static final int DEFAULT_AIR_BAR_X_OFFSET = 3;
    public static final int DEFAULT_AIR_BAR_Y_OFFSET = 3;
    public static final int DEFAULT_AIR_TOTAL_X_OFFSET = -80;
    public static final int DEFAULT_AIR_TOTAL_Y_OFFSET = 0;
    public static final boolean DEFAULT_ENABLE_AIR_ICON = true;
    public static final int DEFAULT_AIR_ICON_SIZE = 16;
    public static final int DEFAULT_AIR_ICON_X_OFFSET = 66;
    public static final int DEFAULT_AIR_ICON_Y_OFFSET = -4;
    public static final int DEFAULT_AIR_TEXT_X_OFFSET = 3;
    public static final int DEFAULT_AIR_TEXT_Y_OFFSET = 3;
    public static final int DEFAULT_AIR_TEXT_COLOR = 0xFFFFFF;
    public static final int DEFAULT_AIR_TEXT_OPACITY = 200;
    public static final float DEFAULT_AIR_TEXT_SIZE = 1.0f;
    public static final TextBehavior DEFAULT_SHOW_AIR_TEXT;
    public static final HorizontalAlignment DEFAULT_AIR_TEXT_ALIGN;
    public static final int DEFAULT_AIR_BACKGROUND_X_OFFSET = 0;
    public static final int DEFAULT_AIR_BACKGROUND_Y_OFFSET = 0;
    public static final FillDirection DEFAULT_AIR_FILL_DIRECTION;
    public BarRenderBehavior airBarBehavior;
    public HUDPositioning.BarPlacement airBarAnchor;
    public int airBackgroundWidth = 80;
    public int airBackgroundHeight = 10;
    public int airBarWidth = 74;
    public int airBarHeight = 4;
    public int airBarXOffset = 3;
    public int airBarYOffset = 3;
    public int airTotalXOffset = -80;
    public int airTotalYOffset = 0;
    public boolean enableAirIcon = true;
    public int airIconSize = 16;
    public int airIconXOffset = 66;
    public int airIconYOffset = -4;
    public int airTextXOffset = 3;
    public int airTextYOffset = 3;
    public int airTextColor = 0xFFFFFF;
    public int airTextOpacity = 200;
    public float airTextSize = 1.0f;
    public TextBehavior showAirText;
    public HorizontalAlignment airTextAlign;
    public int airBackgroundXOffset = 0;
    public int airBackgroundYOffset = 0;
    public FillDirection airFillDirection;
    private static transient ClientConfig instance;

    private ClientConfig() {
        this.healthBarAnchor = DEFAULT_HEALTH_BAR_ANCHOR;
        this.showHealthText = DEFAULT_SHOW_HEALTH_TEXT;
        this.healthTextAlign = DEFAULT_HEALTH_TEXT_ALIGN;
        this.healthFillDirection = DEFAULT_HEALTH_FILL_DIRECTION;
        this.staminaBarBehavior = DEFAULT_STAMINA_BAR_BEHAVIOR;
        this.staminaBarAnchor = DEFAULT_STAMINA_BAR_ANCHOR;
        this.showStaminaText = DEFAULT_SHOW_STAMINA_TEXT;
        this.staminaTextAlign = DEFAULT_STAMINA_TEXT_ALIGN;
        this.staminaFillDirection = DEFAULT_STAMINA_FILL_DIRECTION;
        this.manaBarBehavior = DEFAULT_MANA_BAR_BEHAVIOR;
        this.manaBarAnchor = DEFAULT_MANA_BAR_ANCHOR;
        this.showManaText = DEFAULT_SHOW_MANA_TEXT;
        this.manaTextAlign = DEFAULT_MANA_TEXT_ALIGN;
        this.manaFillDirection = DEFAULT_MANA_FILL_DIRECTION;
        this.armorBarBehavior = DEFAULT_ARMOR_BAR_BEHAVIOR;
        this.armorBarAnchor = DEFAULT_ARMOR_BAR_ANCHOR;
        this.showArmorText = DEFAULT_SHOW_ARMOR_TEXT;
        this.armorTextAlign = DEFAULT_ARMOR_TEXT_ALIGN;
        this.airBarBehavior = DEFAULT_AIR_BAR_BEHAVIOR;
        this.airBarAnchor = DEFAULT_AIR_BAR_ANCHOR;
        this.showAirText = DEFAULT_SHOW_AIR_TEXT;
        this.airTextAlign = DEFAULT_AIR_TEXT_ALIGN;
        this.airFillDirection = DEFAULT_AIR_FILL_DIRECTION;
    }

    public static void setConfigPath(Path path) {
        if (CONFIG_FILE_PATH != null && !CONFIG_FILE_PATH.equals(path)) {
            DynamicResourceBars.LOGGER.warn("ClientConfig path is being changed after initial setup. This might indicate an issue.");
        }
        CONFIG_FILE_PATH = path;
    }

    public static ClientConfig getInstance() {
        if (instance == null) {
            if (CONFIG_FILE_PATH == null) {
                DynamicResourceBars.LOGGER.error("CRITICAL: ClientConfig.CONFIG_FILE_PATH was not initialized before getInstance() was called. Config will not be saved or loaded correctly.");
                throw new IllegalStateException("ClientConfig.CONFIG_FILE_PATH must be set before getInstance() is called.");
            }
            instance = ClientConfig.load();
        }
        return instance;
    }

    private static ClientConfig load() {
        ClientConfig loadedConfig = null;
        boolean newConfigCreated = false;
        if (Files.exists(CONFIG_FILE_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_FILE_PATH);){
                loadedConfig = (ClientConfig)GSON.fromJson((Reader)reader, ClientConfig.class);
                if (loadedConfig == null) {
                    DynamicResourceBars.LOGGER.warn("Config file {} was empty or malformed. Creating new default config.", (Object)CONFIG_FILE_PATH);
                    loadedConfig = new ClientConfig();
                    newConfigCreated = true;
                }
            }
            catch (Exception e) {
                DynamicResourceBars.LOGGER.error("Failed to load client config from {}. A new default config will be created. Error: ", (Object)CONFIG_FILE_PATH, (Object)e);
                loadedConfig = new ClientConfig();
                newConfigCreated = true;
            }
        } else {
            DynamicResourceBars.LOGGER.info("No config file found at {}. Creating new default config.", (Object)CONFIG_FILE_PATH);
            loadedConfig = new ClientConfig();
            newConfigCreated = true;
        }
        boolean modifiedByDefaults = ClientConfig.ensureDefaults(loadedConfig);
        if (newConfigCreated || modifiedByDefaults) {
            DynamicResourceBars.LOGGER.info("Saving new or updated default config to {}.", (Object)CONFIG_FILE_PATH);
            loadedConfig.save();
        }
        return loadedConfig;
    }

    private static boolean ensureDefaults(ClientConfig cfg) {
        boolean modified = false;
        if (cfg.healthBarAnchor == null) {
            cfg.healthBarAnchor = DEFAULT_HEALTH_BAR_ANCHOR;
            modified = true;
        }
        if (cfg.showHealthText == null) {
            cfg.showHealthText = DEFAULT_SHOW_HEALTH_TEXT;
            modified = true;
        }
        if (cfg.healthTextAlign == null) {
            cfg.healthTextAlign = DEFAULT_HEALTH_TEXT_ALIGN;
            modified = true;
        }
        if (cfg.healthFillDirection == null) {
            cfg.healthFillDirection = DEFAULT_HEALTH_FILL_DIRECTION;
            modified = true;
        }
        if (cfg.healthOverlayWidth > 256) {
            cfg.healthOverlayWidth = 256;
            modified = true;
        }
        if (cfg.healthOverlayHeight > 256) {
            cfg.healthOverlayHeight = 256;
            modified = true;
        }
        if (cfg.healthOverlayWidth < 1) {
            cfg.healthOverlayWidth = 80;
            modified = true;
        }
        if (cfg.healthOverlayHeight < 1) {
            cfg.healthOverlayHeight = 10;
            modified = true;
        }
        if (cfg.staminaBarBehavior == null) {
            cfg.staminaBarBehavior = DEFAULT_STAMINA_BAR_BEHAVIOR;
            modified = true;
        }
        if (cfg.staminaBarAnchor == null) {
            cfg.staminaBarAnchor = DEFAULT_STAMINA_BAR_ANCHOR;
            modified = true;
        }
        if (cfg.showStaminaText == null) {
            cfg.showStaminaText = DEFAULT_SHOW_STAMINA_TEXT;
            modified = true;
        }
        if (cfg.staminaTextAlign == null) {
            cfg.staminaTextAlign = DEFAULT_STAMINA_TEXT_ALIGN;
            modified = true;
        }
        if (cfg.staminaFillDirection == null) {
            cfg.staminaFillDirection = DEFAULT_STAMINA_FILL_DIRECTION;
            modified = true;
        }
        if (cfg.staminaOverlayWidth > 256) {
            cfg.staminaOverlayWidth = 256;
            modified = true;
        }
        if (cfg.staminaOverlayHeight > 256) {
            cfg.staminaOverlayHeight = 256;
            modified = true;
        }
        if (cfg.staminaOverlayWidth < 1) {
            cfg.staminaOverlayWidth = 80;
            modified = true;
        }
        if (cfg.staminaOverlayHeight < 1) {
            cfg.staminaOverlayHeight = 10;
            modified = true;
        }
        if (cfg.manaBarAnchor == null) {
            cfg.manaBarAnchor = DEFAULT_MANA_BAR_ANCHOR;
            modified = true;
        }
        if (cfg.showManaText == null) {
            cfg.showManaText = DEFAULT_SHOW_MANA_TEXT;
            modified = true;
        }
        if (cfg.manaTextAlign == null) {
            cfg.manaTextAlign = DEFAULT_MANA_TEXT_ALIGN;
            modified = true;
        }
        if (cfg.manaFillDirection == null) {
            cfg.manaFillDirection = DEFAULT_MANA_FILL_DIRECTION;
            modified = true;
        }
        if (cfg.manaBarBehavior == null) {
            cfg.manaBarBehavior = DEFAULT_MANA_BAR_BEHAVIOR;
            modified = true;
        }
        if (cfg.manaOverlayWidth > 256) {
            cfg.manaOverlayWidth = 256;
            modified = true;
        }
        if (cfg.manaOverlayHeight > 256) {
            cfg.manaOverlayHeight = 256;
            modified = true;
        }
        if (cfg.manaOverlayWidth < 1) {
            cfg.manaOverlayWidth = 81;
            modified = true;
        }
        if (cfg.manaOverlayHeight < 1) {
            cfg.manaOverlayHeight = 9;
            modified = true;
        }
        if (cfg.armorBarBehavior == null) {
            cfg.armorBarBehavior = DEFAULT_ARMOR_BAR_BEHAVIOR;
            modified = true;
        }
        if (cfg.armorBarAnchor == null) {
            cfg.armorBarAnchor = DEFAULT_ARMOR_BAR_ANCHOR;
            modified = true;
        }
        if (cfg.showArmorText == null) {
            cfg.showArmorText = DEFAULT_SHOW_ARMOR_TEXT;
            modified = true;
        }
        if (cfg.armorTextAlign == null) {
            cfg.armorTextAlign = DEFAULT_ARMOR_TEXT_ALIGN;
            modified = true;
        }
        if (cfg.airBarBehavior == null) {
            cfg.airBarBehavior = DEFAULT_AIR_BAR_BEHAVIOR;
            modified = true;
        }
        if (cfg.airBarAnchor == null) {
            cfg.airBarAnchor = DEFAULT_AIR_BAR_ANCHOR;
            modified = true;
        }
        if (cfg.showAirText == null) {
            cfg.showAirText = DEFAULT_SHOW_AIR_TEXT;
            modified = true;
        }
        if (cfg.airTextAlign == null) {
            cfg.airTextAlign = DEFAULT_AIR_TEXT_ALIGN;
            modified = true;
        }
        if (cfg.airFillDirection == null) {
            cfg.airFillDirection = DEFAULT_AIR_FILL_DIRECTION;
            modified = true;
        }
        return modified;
    }

    public void save() {
        if (CONFIG_FILE_PATH == null) {
            DynamicResourceBars.LOGGER.error("ClientConfig.CONFIG_FILE_PATH is null, cannot save config.");
            return;
        }
        try {
            Files.createDirectories(CONFIG_FILE_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE_PATH, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (Exception e) {
            DynamicResourceBars.LOGGER.error("Failed to save client config to {}:", (Object)CONFIG_FILE_PATH, (Object)e);
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().enableComplexMapKeySerialization().create();
        DEFAULT_HEALTH_BAR_ANCHOR = HUDPositioning.BarPlacement.HEALTH;
        DEFAULT_SHOW_HEALTH_TEXT = TextBehavior.WHEN_NOT_FULL;
        DEFAULT_HEALTH_TEXT_ALIGN = HorizontalAlignment.CENTER;
        DEFAULT_HEALTH_FILL_DIRECTION = FillDirection.HORIZONTAL;
        DEFAULT_STAMINA_BAR_BEHAVIOR = StaminaBarBehavior.FOOD;
        DEFAULT_STAMINA_BAR_ANCHOR = HUDPositioning.BarPlacement.HUNGER;
        DEFAULT_SHOW_STAMINA_TEXT = TextBehavior.NEVER;
        DEFAULT_STAMINA_TEXT_ALIGN = HorizontalAlignment.CENTER;
        DEFAULT_STAMINA_FILL_DIRECTION = FillDirection.HORIZONTAL;
        DEFAULT_MANA_BAR_BEHAVIOR = ManaBarBehavior.OFF;
        DEFAULT_MANA_BAR_ANCHOR = HUDPositioning.BarPlacement.ABOVE_UTILITIES;
        DEFAULT_SHOW_MANA_TEXT = TextBehavior.WHEN_NOT_FULL;
        DEFAULT_MANA_TEXT_ALIGN = HorizontalAlignment.CENTER;
        DEFAULT_MANA_FILL_DIRECTION = FillDirection.HORIZONTAL;
        DEFAULT_ARMOR_BAR_BEHAVIOR = BarRenderBehavior.HIDDEN;
        DEFAULT_ARMOR_BAR_ANCHOR = HUDPositioning.BarPlacement.ARMOR;
        DEFAULT_SHOW_ARMOR_TEXT = TextBehavior.NEVER;
        DEFAULT_ARMOR_TEXT_ALIGN = HorizontalAlignment.CENTER;
        DEFAULT_AIR_BAR_BEHAVIOR = BarRenderBehavior.CUSTOM;
        DEFAULT_AIR_BAR_ANCHOR = HUDPositioning.BarPlacement.AIR;
        DEFAULT_SHOW_AIR_TEXT = TextBehavior.NEVER;
        DEFAULT_AIR_TEXT_ALIGN = HorizontalAlignment.CENTER;
        DEFAULT_AIR_FILL_DIRECTION = FillDirection.HORIZONTAL;
    }
}

