/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.shadowsofthedeep.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.shadowsofthedeep.client.model.ModelAngler;
import net.mcreator.shadowsofthedeep.client.model.animations.AnglerAnimation;
import net.mcreator.shadowsofthedeep.entity.TheAnglerEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class TheAnglerRenderer
extends MobRenderer<TheAnglerEntity, LivingEntityRenderState, ModelAngler> {
    private TheAnglerEntity entity = null;

    public TheAnglerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelAngler.LAYER_LOCATION)), 1.0f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, ModelAngler>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"shadows_of_the_deep:textures/entities/glow.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ModelAngler model = new ModelAngler(Minecraft.getInstance().getEntityModels().bakeLayer(ModelAngler.LAYER_LOCATION));
                model.setupAnim((EntityRenderState)state);
                model.renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(TheAnglerEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"shadows_of_the_deep:textures/entities/angler.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(1.5f, 1.5f, 1.5f);
    }

    private static final class AnimatedModel
    extends ModelAngler {
        private TheAnglerEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(TheAnglerEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animateWalk(AnglerAnimation.Swim, state.walkAnimationPos, state.walkAnimationSpeed, 0.5f, 1.0f);
            this.animate(this.entity.animationState1, AnglerAnimation.Swim, state.ageInTicks, 0.1f);
            super.setupAnim(state);
        }
    }
}

