/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import me.sciguymjm.uberenchant.UberEnchant;
import me.sciguymjm.uberenchant.api.utils.Rarity;
import me.sciguymjm.uberenchant.api.utils.UberConfiguration;
import me.sciguymjm.uberenchant.api.utils.UberRunnable;
import me.sciguymjm.uberenchant.api.utils.UberTask;
import me.sciguymjm.uberenchant.api.utils.UberUtils;
import me.sciguymjm.uberenchant.api.utils.persistence.UberMeta;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.IntTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.MetaTag;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class UberEnchantment
extends Enchantment
implements Listener {
    private static final Map<NamespacedKey, UberEnchantment> enchantments = new HashMap<NamespacedKey, UberEnchantment>();
    private boolean registered = false;
    private final NamespacedKey key;

    protected UberEnchantment(NamespacedKey namespacedKey) {
        this.key = namespacedKey;
        enchantments.put(this.key, this);
        UberEnchant.registerEvents(this);
    }

    public UberEnchantment(Plugin plugin, String key) {
        this(new NamespacedKey(plugin, key));
    }

    public UberEnchantment(String key) {
        this((Plugin)UberEnchant.instance(), key);
    }

    public final String getName() {
        return this.key.getKey();
    }

    public abstract String getDisplayName();

    public abstract Rarity getRarity();

    public abstract String getPermission();

    public final boolean containsEnchantment(ItemStack item) {
        return UberEnchantment.containsEnchantment(item, this);
    }

    public final List<String> getAliases() {
        return UberConfiguration.getByEnchant(this).getAliases();
    }

    public final <T> T getMetaTag(ItemStack item, MetaTag<T> tag) {
        return tag.get(item, this);
    }

    public final boolean testBoolTag(ItemStack item, MetaTag<Boolean> tag) {
        return this.testTag(item, tag, true);
    }

    public final boolean conditions(ItemStack item) {
        return false;
    }

    public final <T> boolean testTag(ItemStack item, MetaTag<T> tag, T testValue) {
        return tag.testValue(item, this, testValue);
    }

    public static boolean containsEnchantment(ItemStack item, UberEnchantment enchantment) {
        return UberUtils.containsData(item, enchantment);
    }

    public final int getLevel(ItemStack item) {
        return UberEnchantment.getLevel(item, this);
    }

    public static int getLevel(ItemStack item, UberEnchantment enchantment) {
        Integer level;
        if (UberEnchantment.containsEnchantment(item, enchantment) && (level = (Integer)IntTag.LEVEL.get(item, enchantment)) != null) {
            return level;
        }
        return 0;
    }

    public static boolean hasEnchantments(ItemStack item) {
        return UberUtils.hasData(item);
    }

    public static Map<UberEnchantment, Integer> getEnchantments(ItemStack item) {
        return UberUtils.getMap(item);
    }

    public static Map<UberEnchantment, Integer> getStoredEnchantments(ItemStack item) {
        return UberUtils.getStoredMap(item);
    }

    public static List<UberEnchantment> getRegisteredEnchantments() {
        return new ArrayList<UberEnchantment>(enchantments.values());
    }

    public static List<UberEnchantment> getRegisteredEnchantments(Plugin plugin) {
        return UberEnchantment.getRegisteredEnchantments(plugin.getName().toLowerCase(Locale.ROOT));
    }

    public static List<UberEnchantment> getRegisteredEnchantments(String plugin) {
        return enchantments.values().stream().filter(enchant -> enchant.getKey().getNamespace().equals(plugin)).collect(Collectors.toList());
    }

    public final boolean register() {
        return UberEnchantment.register(this);
    }

    public static boolean register(UberEnchantment enchantment) {
        enchantment.registered = true;
        return enchantment.isRegistered();
    }

    public final boolean isRegistered() {
        return UberEnchantment.isRegistered(this);
    }

    public static boolean isRegistered(UberEnchantment enchantment) {
        return enchantments.containsValue((Object)enchantment) && enchantment.registered;
    }

    public static UberEnchantment getByKey(NamespacedKey key) {
        return enchantments.get(key);
    }

    public static UberEnchantment getByName(String name) {
        return enchantments.values().stream().filter(enchant -> enchant.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public static boolean containsKey(NamespacedKey key) {
        return enchantments.containsKey(key);
    }

    public static UberEnchantment[] values() {
        return (UberEnchantment[])enchantments.values().toArray(UberEnchantment[]::new);
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    protected void addTask(UberTask task) {
        UberRunnable.addTask(task);
    }

    protected <T> T getTag(ItemStack item, UberMeta<T> tag) {
        return tag.get(item, this);
    }

    public final NamespacedKey getKeyOrThrow() {
        return this.getKeyOrNull();
    }

    public final NamespacedKey getKeyOrNull() {
        return this.getKey();
    }
}

