/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.api.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import me.sciguymjm.uberenchant.UberEnchant;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.api.utils.ExcellentEnchantsRecord;
import me.sciguymjm.uberenchant.api.utils.UberRecord;
import me.sciguymjm.uberenchant.utils.UberLocale;
import me.sciguymjm.uberenchant.utils.VersionUtils;
import me.sciguymjm.uberenchant.utils.Versions;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.plugin.Plugin;

public class UberConfiguration {
    private static final Set<String> plugins = new HashSet<String>();
    private static final Set<Enchantment> enchantments = Versions.isV1_20_4() ? new HashSet(Registry.ENCHANTMENT.stream().toList()) : new HashSet<Enchantment>(List.of(Enchantment.values()));
    private static final Set<File> files;

    public static Set<String> getIntegrated() {
        return plugins;
    }

    public static Set<UberRecord> getRecords() {
        return UberRecord.getRecords();
    }

    public static List<UberRecord> getRecords(Predicate<UberRecord> filter) {
        return UberRecord.getRecords(filter);
    }

    public static void loadFromFile(File file) {
        YamlConfiguration data2 = YamlConfiguration.loadConfiguration((File)file);
        files.add(file);
        for (Enchantment enchant : enchantments.stream().distinct().toList()) {
            ConfigurationSection cost;
            NamespacedKey key;
            String name;
            if (UberRecord.getRecords().stream().anyMatch(e -> e.getEnchant().equals(enchant)) || !data2.contains(name = (key = VersionUtils.getKey(enchant)).getKey().toLowerCase(), true)) continue;
            HashMap<Integer, Double> list = new HashMap<Integer, Double>();
            ConfigurationSection section = data2.getConfigurationSection(name);
            if (!section.contains("cost_for_level")) {
                cost = section.createSection("cost_for_level");
                cost.createSection("1");
                cost.createSection("5");
                cost.createSection("10");
                if (name.contains("curse") || enchant.isCursed()) {
                    cost.set("1", (Object)100.0);
                    cost.set("5", (Object)600.0);
                    cost.set("10", (Object)1700.0);
                } else {
                    cost.set("1", (Object)1000.0);
                    cost.set("5", (Object)6000.0);
                    cost.set("10", (Object)17000.0);
                }
                try {
                    data2.save(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            } else {
                cost = section.getConfigurationSection("cost_for_level");
            }
            cost.getKeys(false).forEach(k -> {
                try {
                    list.put(Integer.parseInt(k), cost.getDouble(k));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            String display = key.toString().replace(":", ".");
            if (enchant instanceof UberEnchantment) {
                UberEnchantment uber = (UberEnchantment)enchant;
                display = uber.getDisplayName();
            }
            if (key.getNamespace().equalsIgnoreCase("minecraft")) {
                display = UberLocale.get(key.toString().replace("minecraft:", "enchant."));
            }
            UberRecord record = new UberRecord(enchant, key, display, section.getInt("min_level"), section.getInt("max_level"), section.getDouble("cost"), section.getDouble("cost_multiplier"), section.getDouble("removal_cost"), section.getDouble("extraction_cost"), section.getBoolean("use_on_anything"), section.getStringList("aliases"), list);
            if (key.getNamespace().equalsIgnoreCase("ExcellentEnchants")) {
                UberRecord.addRecord(new ExcellentEnchantsRecord(record));
                continue;
            }
            UberRecord.addRecord(record);
        }
    }

    public static void loadFromFile(String path) {
        UberConfiguration.loadFromFile(new File(path));
    }

    public static void loadFromFile(String path, String file) {
        UberConfiguration.loadFromFile(new File(path, file));
    }

    public static void loadFromEnchantmentsFolder() {
        File folder = new File(UberEnchant.instance().getDataFolder() + "/enchantments/");
        for (File path : folder.listFiles()) {
            if (!path.isDirectory()) continue;
            for (File file : path.listFiles(f -> f.getName().endsWith(".yml"))) {
                if (!files.contains(file)) {
                    UberConfiguration.loadFromFile(file);
                    continue;
                }
                if (!path.getName().endsWith(".yml") || files.contains(path)) continue;
                UberConfiguration.loadFromFile(path);
            }
        }
    }

    public static void updateConfigs() {
        File folder = new File(UberEnchant.instance().getDataFolder() + "/enchantments/");
        for (File path : folder.listFiles()) {
            if (!path.isDirectory()) continue;
            for (File file : path.listFiles(f -> f.getName().endsWith(".yml"))) {
                if (!files.contains(file)) {
                    UberConfiguration.loadFromFile(file);
                    continue;
                }
                if (!path.getName().endsWith(".yml") || files.contains(path)) continue;
                UberConfiguration.loadFromFile(path);
            }
        }
    }

    private static <T> T find(Collection<T> collection, Predicate<T> predicate) {
        return collection.stream().filter(predicate).findFirst().orElse(null);
    }

    public static void saveToEnchantmentsFolder(Plugin plugin, String file) {
        UberConfiguration.saveToFile(plugin, new File(UberEnchant.instance().getDataFolder() + "/enchantments/" + plugin.getName() + "/" + file));
    }

    public static void saveToFile(Plugin plugin, String path) {
        UberConfiguration.saveToFile(plugin, new File(plugin.getDataFolder(), path));
    }

    public static void saveToFile(Plugin plugin, File file) {
        YamlConfiguration data2 = YamlConfiguration.loadConfiguration((File)file);
        for (UberRecord record : UberRecord.values().stream().filter(a -> VersionUtils.getKey(a.getEnchant()).getNamespace().equals(plugin.getName().toLowerCase(Locale.ROOT))).toList()) {
            ConfigurationSection path = data2.createSection(record.getKey().getKey());
            path.set("min_level", (Object)record.getMinLevel());
            path.set("max_level", (Object)record.getMaxLevel());
            path.set("cost", (Object)record.getCost());
            path.set("cost_multiplier", (Object)record.getCostMultiplier());
            path.createSection("cost_for_level", record.getLevelCost());
            path.set("removal_cost", (Object)record.getRemovalCost());
            path.set("extraction_cost", (Object)record.getExtractionCost());
            path.set("use_on_anything", (Object)record.getCanUseOnAnything());
            path.set("aliases", record.getAliases());
        }
        try {
            data2.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void reloadAll() {
        UberRecord.reset();
        files.forEach(f -> {
            if (f.exists()) {
                UberConfiguration.loadFromFile(f);
            }
        });
    }

    public static UberRecord getByEnchant(Enchantment enchantment) {
        return UberRecord.values().stream().filter(e -> e.getEnchant().equals(enchantment)).findFirst().orElse(null);
    }

    public static boolean addRecord(UberRecord record) {
        return UberRecord.addRecord(record);
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> key) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(key.apply(t), Boolean.TRUE) == null;
    }

    public static void integrate() {
        List<Object> temp = Versions.isV1_20_4() ? new ArrayList(Registry.ENCHANTMENT.stream().toList()) : Arrays.asList(Enchantment.values());
        List<String> plugins = temp.stream().filter(UberConfiguration.distinctByKey(e -> VersionUtils.getKey(e).getNamespace())).filter(e -> !(e instanceof UberEnchantment) && !VersionUtils.getKey(e).getNamespace().equalsIgnoreCase("minecraft")).map(k -> VersionUtils.getKey(k).getNamespace()).toList();
        for (String name : plugins) {
            Plugin plugin = Arrays.stream(Bukkit.getPluginManager().getPlugins()).filter(p -> p.getName().toLowerCase(Locale.ROOT).equals(name)).findFirst().orElse(null);
            if (plugin == null) continue;
            UberConfiguration.plugins.add(name);
            File file = new File(UberEnchant.instance().getDataFolder() + "/enchantments/" + name + "/default_enchantments.yml");
            if (file.exists()) {
                return;
            }
            YamlConfiguration data2 = YamlConfiguration.loadConfiguration((File)file);
            List<Enchantment> enchantments = temp.stream().filter(a -> VersionUtils.getKey(a).getNamespace().equalsIgnoreCase(name)).toList();
            for (Enchantment enchant : enchantments) {
                ConfigurationSection path = data2.createSection(VersionUtils.getKey(enchant).getKey());
                path.set("min_level", (Object)1);
                path.set("max_level", (Object)10);
                path.set("cost", (Object)1000.0);
                path.set("cost_multiplier", (Object)0.02);
                path.set("removal_cost", (Object)100.0);
                path.set("extraction_cost", (Object)1000.0);
                path.set("use_on_anything", (Object)false);
                path.set("aliases", new ArrayList());
            }
            try {
                data2.save(file);
                UberEnchant.log(Level.INFO, UberLocale.getF("console.plugin_integrated", enchantments.size(), plugin.getName()));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    static {
        Collections.addAll(enchantments, UberEnchantment.values());
        files = new HashSet<File>();
    }
}

