/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.api.utils.persistence.tags;

import java.util.Arrays;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.MetaTag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public enum BoolTag implements MetaTag<Boolean>
{
    ON_HELD,
    ON_HIT,
    ON_DROP,
    ON_PICKUP,
    ON_CONSUME,
    HAS_CHANCE,
    HIDDEN;


    @Override
    public String getName() {
        return this.name().toLowerCase();
    }

    @Override
    public PersistentDataType<?, Boolean> getType() {
        return PersistentDataType.BOOLEAN;
    }

    public static boolean matches(String tag) {
        return MetaTag.matches(BoolTag.values(), tag);
    }

    public static BoolTag fromString(String tag) {
        return Arrays.stream(BoolTag.values()).filter(v -> v.getName().equalsIgnoreCase(tag)).findFirst().orElse(null);
    }

    public boolean test(ItemStack item, UberEnchantment enchantment) {
        Boolean value = (Boolean)this.get(item, enchantment);
        return value != null && value != false;
    }

    public boolean testBool(ItemStack item, UberEnchantment enchantment, boolean def) {
        return this.test(item, enchantment) || def;
    }

    public static boolean test(ItemStack item, UberEnchantment enchantment, BoolTag ... tags) {
        if (tags.length == 0) {
            return false;
        }
        for (BoolTag tag : tags) {
            if (tag.test(item, enchantment)) continue;
            return false;
        }
        return true;
    }
}

