/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.api.utils.persistence.tags;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.sciguymjm.uberenchant.UberEnchant;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.api.utils.UberUtils;
import me.sciguymjm.uberenchant.api.utils.persistence.UberMeta;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.BoolTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.DoubleTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.IntTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.UUIDTag;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public interface MetaTag<T> {
    public String getName();

    public PersistentDataType<?, T> getType();

    default public Plugin getPlugin() {
        return UberEnchant.instance();
    }

    default public UberMeta<T> asMeta() {
        return new UberMeta(this);
    }

    default public NamespacedKey getKey() {
        return new NamespacedKey(this.getPlugin(), this.getName());
    }

    public static boolean matches(MetaTag<?>[] values, String tag) {
        return Arrays.stream(values).anyMatch(t -> t.getName().equalsIgnoreCase(tag));
    }

    public static boolean exists(String tag) {
        return MetaTag.matches((MetaTag[])Tags.tags.toArray(MetaTag[]::new), tag);
    }

    public static MetaTag<?> byName(String tag) {
        return Tags.get(tag);
    }

    public static MetaTag<?> byKey(NamespacedKey key) {
        return Tags.get(key);
    }

    default public T get(ItemStack item, UberEnchantment enchantment) {
        return UberUtils.getMetaTag(item, enchantment, this.asMeta());
    }

    default public T get(ItemStack item, UberEnchantment enchantment, T def) {
        T value = this.get(item, enchantment);
        return value == null ? def : value;
    }

    default public boolean has(ItemStack item, UberEnchantment enchantment) {
        return UberUtils.containsMeta(item, enchantment, this.asMeta());
    }

    default public boolean testValue(ItemStack item, UberEnchantment enchantment, T value) {
        return this.has(item, enchantment) && this.get(item, enchantment).equals(value);
    }

    public static <T> boolean testValues(ItemStack item, UberEnchantment enchantment, Map<? extends MetaTag<T>, T> map) {
        for (Map.Entry<MetaTag<T>, T> entry : map.entrySet()) {
            if (entry.getKey().testValue(item, enchantment, entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <T> MetaTag<T> create(String name, PersistentDataType<?, T> type) {
        return MetaTag.create(name, type, (Plugin)UberEnchant.instance());
    }

    public static <T> MetaTag<T> create(final String name, final PersistentDataType<?, T> type, final Plugin plugin) {
        MetaTag tag = new MetaTag<T>(){

            @Override
            public Plugin getPlugin() {
                return plugin;
            }

            @Override
            public NamespacedKey getKey() {
                return new NamespacedKey(plugin, this.getName());
            }

            @Override
            public String getName() {
                return name.toLowerCase();
            }

            @Override
            public PersistentDataType<?, T> getType() {
                return type;
            }
        };
        Tags.add(tag);
        return tag;
    }

    public static final class Tags {
        private static final Set<MetaTag<?>> tags = new HashSet();

        public static Set<MetaTag<?>> getAll() {
            return tags;
        }

        public static <T> Set<MetaTag<T>> getAll(PersistentDataType<?, T> type) {
            return tags.stream().filter(tag -> tag.getType().equals(type)).map(tag -> new MetaTag<T>(){
                final /* synthetic */ MetaTag val$tag;
                final /* synthetic */ PersistentDataType val$type;
                {
                    this.val$tag = metaTag;
                    this.val$type = persistentDataType;
                }

                @Override
                public NamespacedKey getKey() {
                    return this.val$tag.getKey();
                }

                @Override
                public String getName() {
                    return this.val$tag.getName();
                }

                @Override
                public PersistentDataType<?, T> getType() {
                    return this.val$type;
                }
            }).collect(Collectors.toSet());
        }

        static <T> MetaTag<T> get(Predicate<MetaTag<?>> filter, PersistentDataType<?, T> type) {
            return tags.stream().filter(filter.and(tag -> tag.getType().equals(type))).map(tag -> new MetaTag<T>(){
                final /* synthetic */ MetaTag val$tag;
                final /* synthetic */ PersistentDataType val$type;
                {
                    this.val$tag = metaTag;
                    this.val$type = persistentDataType;
                }

                @Override
                public NamespacedKey getKey() {
                    return this.val$tag.getKey();
                }

                @Override
                public String getName() {
                    return this.val$tag.getName();
                }

                @Override
                public PersistentDataType<?, T> getType() {
                    return this.val$type;
                }
            }).findFirst().orElse(null);
        }

        static MetaTag<?> get(String name) {
            return tags.stream().filter(tag -> tag.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
        }

        static <T> MetaTag<T> get(String name, PersistentDataType<?, T> type) {
            return Tags.get((MetaTag<?> tag) -> tag.getName().equalsIgnoreCase(name), type);
        }

        static MetaTag<?> get(NamespacedKey key) {
            return tags.stream().filter(tag -> tag.getKey().equals((Object)key)).findFirst().orElse(null);
        }

        static <T> MetaTag<T> get(NamespacedKey key, PersistentDataType<?, T> type) {
            return Tags.get((MetaTag<?> tag) -> tag.getKey().equals((Object)key), type);
        }

        static void add(MetaTag<?> tag) {
            tags.add(tag);
        }

        static void addAll(MetaTag<?>[] tag) {
            tags.addAll(List.of(tag));
        }

        static {
            Tags.addAll(BoolTag.values());
            Tags.addAll(DoubleTag.values());
            Tags.addAll(IntTag.values());
            Tags.addAll(UUIDTag.values());
        }
    }
}

