/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.api.utils.persistence.tags;

import java.util.UUID;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.MetaTag;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;

public enum UUIDTag implements MetaTag<UUID>
{
    PLAYER;


    @Override
    public String getName() {
        return this.name().toLowerCase();
    }

    @Override
    public PersistentDataType<?, UUID> getType() {
        return new UUIDType();
    }

    public static boolean matches(String tag) {
        return MetaTag.matches(UUIDTag.values(), tag);
    }

    protected static class UUIDType
    implements PersistentDataType<String, UUID> {
        protected UUIDType() {
        }

        public Class<String> getPrimitiveType() {
            return String.class;
        }

        public Class<UUID> getComplexType() {
            return UUID.class;
        }

        public String toPrimitive(UUID complex, PersistentDataAdapterContext context) {
            return complex.toString();
        }

        public UUID fromPrimitive(String primitive, PersistentDataAdapterContext context) {
            return UUID.fromString(primitive);
        }
    }
}

