/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.commands;

import java.util.ArrayList;
import java.util.List;
import me.sciguymjm.uberenchant.api.utils.UberUtils;
import me.sciguymjm.uberenchant.commands.abstraction.UberTabCommand;
import me.sciguymjm.uberenchant.utils.Reply;
import me.sciguymjm.uberenchant.utils.enchanting.EnchantmentUtils;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ClearCommand
extends UberTabCommand {
    @Override
    public boolean onCmd() {
        if (this.args.length == 1) {
            ItemStack item = this.player.getInventory().getItemInMainHand();
            switch (this.args[0].toLowerCase()) {
                case "enchant": {
                    if (this.hasPermission("uber.clear.enchant")) {
                        this.enchant(item);
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "effect": {
                    if (this.hasPermission("uber.clear.effect")) {
                        this.effect();
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "lore": {
                    if (this.hasPermission("uber.clear.lore")) {
                        this.lore(item);
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                default: {
                    EnchantmentUtils.help(this.player, "uclear");
                    break;
                }
            }
        } else {
            this.response("&6%1$s", this.command.getUsage());
        }
        return true;
    }

    @Override
    public List<String> onTab() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.args.length == 1) {
            if (this.hasPermission("uber.clear.enchant")) {
                list.add("enchant");
            }
            if (this.hasPermission("uber.clear.effect")) {
                list.add("effect");
            }
            if (this.hasPermission("uber.clear.lore")) {
                list.add("lore");
            }
        }
        return list;
    }

    private void enchant(ItemStack item) {
        if (item.hasItemMeta() && !UberUtils.getAllMap(item).isEmpty()) {
            UberUtils.getAllMap(item).keySet().forEach(enchant -> EnchantmentUtils.removeEnchantment(enchant, item));
            this.localized("&a", "actions.enchant.clear.success");
            return;
        }
        this.localized("&c", "actions.enchant.clear.fail");
    }

    private void effect() {
        if (!this.player.getActivePotionEffects().isEmpty()) {
            this.player.getActivePotionEffects().forEach(effect -> this.player.removePotionEffect(effect.getType()));
            this.localized("&a", "actions.effect.clear.success");
            return;
        }
        this.localized("&c", "actions.effect.clear.no_effects");
    }

    private void lore(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        meta.setLore(null);
        item.setItemMeta(meta);
        UberUtils.addEnchantmentLore(item);
        this.localized("&a", "actions.lore.clear.success");
    }
}

