/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.sciguymjm.uberenchant.commands.abstraction.UberTabCommand;
import me.sciguymjm.uberenchant.utils.ItemFileUtils;
import me.sciguymjm.uberenchant.utils.Reply;
import me.sciguymjm.uberenchant.utils.enchanting.EnchantmentUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemCommand
extends UberTabCommand {
    @Override
    public boolean onCmd() {
        if (this.args.length != 0) {
            switch (this.args[0].toLowerCase()) {
                case "save": {
                    if (this.hasPermission("uber.item.save")) {
                        this.save();
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "load": {
                    if (this.hasPermission("uber.item.load")) {
                        this.load();
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "delete": {
                    if (this.hasPermission("uber.item.delete")) {
                        this.delete();
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                default: {
                    EnchantmentUtils.help(this.player, "uitem");
                    break;
                }
            }
        } else {
            this.response("&6%1$s", this.command.getUsage());
        }
        return true;
    }

    @Override
    public List<String> onTab() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.args.length == 1) {
            if (this.hasPermission("uber.item.save")) {
                list.add("save");
            }
            if (this.hasPermission("uber.item.load")) {
                list.add("load");
            }
            if (this.hasPermission("uber.item.delete")) {
                list.add("delete");
            }
        }
        if (this.args.length == 2 && (this.args[0].equalsIgnoreCase("load") || this.args[0].equalsIgnoreCase("delete"))) {
            list.addAll(ItemFileUtils.getNames());
        }
        if (this.args.length == 3 && this.args[0].equalsIgnoreCase("load") && this.hasPermission("uber.item.load.others")) {
            list.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).toList());
        }
        return list;
    }

    private void save() {
        if (this.player == null) {
            this.localized("&c", "actions.item.console", this.args[0]);
            return;
        }
        if (this.args.length < 2) {
            this.response(Reply.ARGUMENTS);
            return;
        }
        ItemStack item = this.player.getInventory().getItemInMainHand();
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        if (this.args.length == 2) {
            ItemFileUtils.save(item, this.args[1]);
            this.localized("&a", "actions.item.save.success", this.args[1]);
        }
    }

    private void load() {
        boolean other = false;
        if (this.args.length < 2) {
            this.response(Reply.ARGUMENTS);
            return;
        }
        if (this.args.length == 3) {
            if (!this.hasPermission("uber.item.load.others")) {
                this.response(Reply.PERMISSIONS);
                return;
            }
            this.player = Bukkit.getPlayerExact((String)this.args[2]);
            if (this.player == null) {
                this.localized("&c", "actions.item.load.player.fail");
                return;
            }
            other = true;
        }
        if (this.player == null) {
            this.localized("&c", "actions.item.console", this.args[0]);
            return;
        }
        ItemStack item = null;
        if (this.args.length >= 2) {
            item = ItemFileUtils.load(this.args[1]);
        }
        if (item != null) {
            HashMap map = this.player.getInventory().addItem(new ItemStack[]{item});
            if (!map.isEmpty()) {
                this.player.getWorld().dropItemNaturally(this.player.getLocation(), (ItemStack)map.get(0));
                if (other) {
                    this.localized("&c", "actions.item.load.player.inventory", this.player.getDisplayName());
                } else {
                    this.localized("&c", "actions.item.load.inventory");
                }
            } else if (other) {
                this.localized("&a", "actions.item.load.player.success", this.player.getDisplayName(), this.args[1]);
            } else {
                this.localized("&a", "actions.item.load.success", this.args[1]);
            }
        } else {
            this.localized("&c", "actions.item.load.fail", this.args[1]);
        }
    }

    private void delete() {
        if (this.args.length < 2) {
            this.response(Reply.ARGUMENTS);
            return;
        }
        if (ItemFileUtils.delete(this.args[1])) {
            this.localized("&a", "actions.item.delete.success", this.args[1]);
        } else {
            this.localized("&c", "actions.item.delete.fail", this.args[1]);
        }
    }
}

