/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.commands;

import java.util.ArrayList;
import java.util.List;
import me.sciguymjm.uberenchant.UberEnchant;
import me.sciguymjm.uberenchant.commands.abstraction.UberTabCommand;
import me.sciguymjm.uberenchant.utils.ChatUtils;
import me.sciguymjm.uberenchant.utils.EffectUtils;
import me.sciguymjm.uberenchant.utils.Reply;
import me.sciguymjm.uberenchant.utils.UberLocale;
import me.sciguymjm.uberenchant.utils.enchanting.EnchantmentUtils;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.ExactMatchConversationCanceller;
import org.bukkit.conversations.InactivityConversationCanceller;
import org.bukkit.conversations.NumericPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.plugin.Plugin;

public class ListCommand
extends UberTabCommand {
    @Override
    public boolean onCmd() {
        if (this.args.length == 1) {
            switch (this.args[0].toLowerCase()) {
                case "enchants": {
                    if (this.hasPermission("uber.list.enchants")) {
                        this.converse();
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "effects": {
                    if (this.hasPermission("uber.list.effects")) {
                        this.response(EffectUtils.listEffects());
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                default: {
                    EnchantmentUtils.help(this.player, "ulist");
                    break;
                }
            }
        } else {
            this.response("&6%1$s", this.command.getUsage());
        }
        return true;
    }

    @Override
    public List<String> onTab() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.args.length == 1) {
            if (this.hasPermission("uber.list.enchants")) {
                list.add("enchants");
            }
            if (this.hasPermission("uber.list.effects")) {
                list.add("effects");
            }
        }
        return list;
    }

    private void converse() {
        ConversationFactory factory = new ConversationFactory((Plugin)UberEnchant.instance());
        Conversation chat = factory.withFirstPrompt((Prompt)new NumericPrompt(){
            private final String HELP = ChatUtils.color(UberLocale.getCF("&8", "actions.list.page.instructions", 1, EnchantmentUtils.getPages()));
            private final String INVALID = ChatUtils.color("&8&l[&5UberEnchant&8&l] " + UberLocale.getC("&c", "actions.list.page.invalid_input"));

            protected Prompt acceptValidatedInput(ConversationContext context, Number input) {
                context.setSessionData((Object)"invalid", (Object)false);
                int page = input.intValue();
                if (page < 1) {
                    page = 1;
                }
                context.setSessionData((Object)"page", (Object)page);
                return this;
            }

            public String getPromptText(ConversationContext context) {
                Object invalid = context.getSessionData((Object)"invalid");
                Object page = context.getSessionData((Object)"page");
                if (invalid != null && ((Boolean)invalid).booleanValue() || page == null || (Integer)page == 0) {
                    return this.HELP;
                }
                return EnchantmentUtils.listPage((Integer)page);
            }

            protected String getFailedValidationText(ConversationContext context, String input) {
                context.setSessionData((Object)"invalid", (Object)true);
                return this.INVALID;
            }
        }).withPrefix(context -> ChatUtils.color("&8&l[&5UberEnchant&8&l] ")).withLocalEcho(false).withTimeout(30).withEscapeSequence("exit").addConversationAbandonedListener(event -> {
            if (event.getCanceller() instanceof InactivityConversationCanceller) {
                this.localized("&c", "actions.list.page_timed_out");
            }
            if (event.gracefulExit() || event.getCanceller() instanceof ExactMatchConversationCanceller) {
                this.localized("&a", "actions.list.exit");
            }
        }).buildConversation((Conversable)this.player);
        chat.begin();
    }
}

