/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.commands.abstraction;

import me.sciguymjm.uberenchant.commands.abstraction.IUberCommand;
import me.sciguymjm.uberenchant.utils.ChatUtils;
import me.sciguymjm.uberenchant.utils.Reply;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class UberCommand
implements IUberCommand {
    protected Player player;
    protected CommandSender sender;
    protected Command command;
    protected String[] args;

    public final boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.command = command;
        this.sender = sender;
        this.args = args;
        if (sender instanceof Player) {
            Player plyr;
            this.player = plyr = (Player)sender;
        }
        if (!this.hasPermission()) {
            this.response(Reply.PERMISSIONS);
            return true;
        }
        return this.onCmd();
    }

    public final boolean hasPermission(String node) {
        return this.sender.hasPermission(node);
    }

    public final boolean hasPermission(String node, Object ... args) {
        return this.sender.hasPermission(node.formatted(args));
    }

    public final boolean hasPermission(String node, String[] args) {
        return this.sender.hasPermission(node.formatted(args));
    }

    public final boolean hasPermission() {
        return this.sender.hasPermission(this.command.getPermission());
    }

    public final void response(String message) {
        ChatUtils.response(this.sender, message);
    }

    public final void response(Reply reply) {
        ChatUtils.response(this.sender, reply.get());
    }

    public final void localized(String color, String key) {
        ChatUtils.localized(this.sender, color, key);
    }

    public final void localized(String color, String key, Object ... args) {
        ChatUtils.localized(this.sender, color, key, args);
    }

    public final void response(String message, Object ... args) {
        ChatUtils.response(this.sender, message, args);
    }

    public final void response(String message, String[] args) {
        ChatUtils.response(this.sender, message, args);
    }

    public final void response(String[] messages) {
        ChatUtils.response(this.sender, messages);
    }
}

