/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.enchantments.effects;

import me.sciguymjm.uberenchant.api.utils.Rarity;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.BoolTag;
import me.sciguymjm.uberenchant.enchantments.abstraction.EffectEnchantment;
import org.bukkit.Material;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class IncreaseDamageEnchantment
extends EffectEnchantment {
    public IncreaseDamageEnchantment() {
        super("INCREASE_DAMAGE");
        this.setTag(BoolTag.HAS_CHANCE, true);
    }

    @Override
    public Rarity getRarity() {
        return Rarity.VERY_RARE;
    }

    public EnchantmentTarget getItemTarget() {
        return EnchantmentTarget.BREAKABLE;
    }

    public boolean canEnchantItem(ItemStack itemStack) {
        return EnchantmentTarget.ARMOR.includes(itemStack) || EnchantmentTarget.WEAPON.includes(itemStack);
    }

    @Override
    @EventHandler(priority=EventPriority.MONITOR)
    public void OnHit(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item == null || item.getType() == Material.AIR || !this.containsEnchantment(item)) {
                return;
            }
            if (this.conditions(item)) {
                return;
            }
            if (BoolTag.HAS_CHANCE.test(item, this)) {
                this.apply(player);
            } else {
                this.apply(item, (LivingEntity)player);
            }
        }
    }
}

