/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.enchantments.tasks;

import me.sciguymjm.uberenchant.api.utils.random.WeightedChance;
import me.sciguymjm.uberenchant.api.utils.random.WeightedEntry;
import me.sciguymjm.uberenchant.enchantments.abstraction.EffectEnchantment;
import me.sciguymjm.uberenchant.enchantments.tasks.ArmorEffectTask;
import me.sciguymjm.uberenchant.enchantments.tasks.Conditional;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;

public class ArmorEffectChanceTask
extends ArmorEffectTask {
    private final WeightedChance<Boolean> chance;

    public ArmorEffectChanceTask(Player player, EffectEnchantment enchantment, EquipmentSlot slot, Conditional conditional) {
        super(player, enchantment, slot, conditional);
        this.n = 0;
        this.duration = 200;
        double value = (double)enchantment.getLevel(this.getItem()) / (double)enchantment.getMaxLevel();
        this.chance = WeightedChance.fromArray(new WeightedEntry<Boolean>(true, value), new WeightedEntry<Boolean>(false, 1.0 - value));
    }

    @Override
    public boolean update() {
        if (!this.player.isValid() || !this.player.isOnline() || this.player.isDead()) {
            return false;
        }
        this.item = this.getItem();
        if (this.item == null || this.conditional.test((LivingEntity)this.player, this.item, this.enchantment)) {
            this.player.removePotionEffect(this.effect);
            return false;
        }
        int level = this.enchantment.getLevel(this.item);
        if (this.n++ >= Math.max(100, this.duration - 20 * level)) {
            this.n = 0;
            if (this.chance.select().booleanValue()) {
                return this.enchantment.apply(this.item, (LivingEntity)this.player, Math.min(100, this.enchantment.getDuration(this.item)));
            }
        }
        return true;
    }
}

