/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import me.sciguymjm.uberenchant.utils.ChatUtils;
import me.sciguymjm.uberenchant.utils.UberEffects;
import me.sciguymjm.uberenchant.utils.UberLocale;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class EffectUtils {
    public static String[] listEffects() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(UberLocale.getC("&6", "utils.effects.list"));
        for (UberEffects effect : UberEffects.values()) {
            if (effect.getEffect() == null) continue;
            list.add(String.format("        &6&l%1$s (&c%2$s&6&l)", effect.getName(), effect.getId()));
        }
        return (String[])list.toArray(String[]::new);
    }

    public static PotionEffectType getEffect(String name) {
        if (name.isEmpty()) {
            return null;
        }
        Pattern pattern = Pattern.compile(name.toLowerCase());
        List<UberEffects> list = Arrays.stream(UberEffects.values()).filter(effect -> pattern.matcher(effect.getName().toLowerCase()).lookingAt() || pattern.matcher(String.valueOf(effect.getId())).matches()).toList();
        if (!list.isEmpty()) {
            return list.get(0).getEffect();
        }
        return null;
    }

    public static List<String> matchEffects(String name) {
        ArrayList<String> list = new ArrayList<String>();
        if (name.isEmpty()) {
            for (UberEffects value : UberEffects.values()) {
                if (list.contains(value.getName().toLowerCase())) continue;
                list.add(value.getName().toLowerCase());
            }
            return list;
        }
        for (UberEffects value : UberEffects.values()) {
            if (!String.valueOf(value.getId()).startsWith(name) && !value.getName().toLowerCase().startsWith(name.toLowerCase())) continue;
            list.add(value.getName().toLowerCase());
        }
        return list;
    }

    public static int getId(PotionEffectType effect) {
        return Stream.of(UberEffects.values()).filter(e -> e.getEffect().equals(effect)).map(UberEffects::getId).findFirst().orElse(0);
    }

    public static void removeEffect(Player player, PotionEffectType effect) {
        if (player.hasPotionEffect(effect)) {
            player.removePotionEffect(effect);
            ChatUtils.response((CommandSender)player, UberLocale.getC("&a", "utils.effects.remove_success"));
        } else {
            ChatUtils.response((CommandSender)player, UberLocale.getC("&c", "utils.effects.remove_fail"));
        }
    }

    public static void setEffect(Player player, PotionEffectType effect, int duration, int level) {
        effect.createEffect(duration, level).apply((LivingEntity)player);
    }
}

