/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import me.sciguymjm.uberenchant.UberEnchant;
import me.sciguymjm.uberenchant.utils.FileUtils;

public class UberLocale {
    private static PropertyResourceBundle bundle;
    private static PropertyResourceBundle defaults;
    private static String locale;
    private static final Map<String, PropertyResourceBundle> bundles;

    public static void update() {
        Properties def = new Properties();
        Properties prop = new Properties();
        try {
            FileInputStream input = new FileInputStream(FileUtils.getFile("/locale/en_us.properties"));
            def.load(UberEnchant.instance().getResource("locale/en_us.properties"));
            prop.load(input);
            input.close();
            def.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (!prop.containsKey(k)) {
                    prop.put(k, v);
                }
            }));
            FileOutputStream output = new FileOutputStream(FileUtils.getFile("/locale/en_us.properties"));
            prop.store(output, "");
            output.close();
            UberEnchant.log(Level.INFO, "&aUpdated translations in locale/en_us.properties!");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void load(File file) {
        try {
            bundle = new PropertyResourceBundle(new FileInputStream(file));
            locale = file.getName();
            bundles.put("loaded", bundle);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void add(String name, File file) {
        try {
            PropertyResourceBundle prb = new PropertyResourceBundle(new FileInputStream(file));
            bundles.put(name, prb);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String get(String key) {
        if (bundle.containsKey(key)) {
            return bundle.getString(key);
        }
        if (defaults.containsKey(key)) {
            UberEnchant.log(Level.WARNING, "Translation for " + key + " not found in " + locale + ", using default translation.");
            return defaults.getString(key);
        }
        UberEnchant.log(Level.WARNING, "No translation found for " + key + "!");
        return key;
    }

    public static String getF(String key, Object ... args) {
        String value = UberLocale.get(key);
        if (args != null && args.length > 0) {
            for (int n = 0; n < args.length; ++n) {
                value = value.replace("{" + n + "}", String.valueOf(args[n]));
            }
        }
        return value;
    }

    public static String getCF(String color, String key, Object ... args) {
        return color + UberLocale.getF(key, args);
    }

    public static String getC(String color, String key) {
        return color + UberLocale.get(key);
    }

    static {
        bundles = new HashMap<String, PropertyResourceBundle>();
        try {
            defaults = new PropertyResourceBundle(UberEnchant.instance().getResource("locale/en_us.properties"));
            bundles.put("defaults", defaults);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

