/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.utils.enchanting;

import java.util.HashMap;
import java.util.Map;
import me.sciguymjm.uberenchant.UberEnchant;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.api.utils.UberConfiguration;
import me.sciguymjm.uberenchant.api.utils.UberUtils;
import me.sciguymjm.uberenchant.api.utils.persistence.UberMeta;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.IntTag;
import me.sciguymjm.uberenchant.enchantments.abstraction.EffectEnchantment;
import me.sciguymjm.uberenchant.utils.ChatUtils;
import me.sciguymjm.uberenchant.utils.FileUtils;
import me.sciguymjm.uberenchant.utils.enchanting.EnchantmentUtils;
import me.sciguymjm.uberenchant.utils.enchanting.UberAnvil;
import me.sciguymjm.uberenchant.utils.plugins.ProtocolLibUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AnvilEvents
implements Listener {
    private static boolean colors;
    private static boolean ignore;
    private static boolean has_limit;
    private static int limit;

    public static void reload() {
        colors = FileUtils.updateAndGet("/mechanics/anvil.yml", "colors_enabled", false, Boolean.class);
        ignore = FileUtils.updateAndGet("/mechanics/anvil.yml", "ignore_too_expensive", false, Boolean.class);
        has_limit = FileUtils.updateAndGet("/mechanics/anvil.yml", "enable_level_cost_limit", false, Boolean.class);
        limit = FileUtils.updateAndGet("/mechanics/anvil.yml", "level_cost_limit", 39, Integer.class);
    }

    private short getDamage(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        return meta == null ? (short)0 : (short)((Damageable)meta).getDamage();
    }

    private void setDamage(ItemStack item, int damage) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            Damageable dMeta = (Damageable)meta;
            dMeta.setDamage(damage);
            item.setItemMeta((ItemMeta)dMeta);
        }
    }

    private short getMaxDamage(ItemStack item) {
        return item.getType().getMaxDurability();
    }

    private boolean isDamageable(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        return meta instanceof Damageable;
    }

    private void sched(final Test test) {
        new BukkitRunnable(){

            public void run() {
                test.run();
            }
        }.runTask((Plugin)UberEnchant.instance());
    }

    @EventHandler
    public void test(InventoryClickEvent event) {
        Inventory inv = event.getInventory();
        InventoryView view = event.getView();
        if (inv.getType().equals((Object)InventoryType.ANVIL) && inv instanceof AnvilInventory) {
            this.sched(() -> ((Player)event.getWhoClicked()).updateInventory());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onClose(InventoryCloseEvent event) {
        if (event.getInventory() instanceof AnvilInventory) {
            this.sched(() -> {
                Player player = (Player)event.getView().getPlayer();
                if (!player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                    ProtocolLibUtils.setBypass(player, false);
                }
            });
        }
    }

    @EventHandler
    public void onReload(ServerLoadEvent event) {
        if (event.getType().equals((Object)ServerLoadEvent.LoadType.RELOAD)) {
            Bukkit.getOnlinePlayers().forEach(player -> {
                if (!player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                    ProtocolLibUtils.setBypass(player, false);
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void createResult(PrepareAnvilEvent event) {
        this.calculate(event);
    }

    private void calculate(PrepareAnvilEvent event) {
        Map<Object, Object> durations = new HashMap();
        UberAnvil anvil = new UberAnvil(event);
        if (ignore) {
            anvil.setMaximumRepairCost(1000);
            this.sched(() -> {
                Player player = (Player)event.getView().getPlayer();
                if (!player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                    ProtocolLibUtils.setBypass(player, true);
                }
            });
        }
        ItemStack item = anvil.getItem(0);
        anvil.setRepairCost(1);
        int i = 0;
        if (item != null) {
            ItemStack itemstack1 = item.clone();
            ItemStack itemstack2 = anvil.getItem(1);
            HashMap<Enchantment, Integer> map = itemstack1.getType().equals((Object)Material.ENCHANTED_BOOK) ? new HashMap<Enchantment, Integer>(UberUtils.getAllStoredMap(itemstack1)) : new HashMap<Enchantment, Integer>(UberUtils.getAllMap(itemstack1));
            int j = ((Repairable)item.getItemMeta()).getRepairCost() + (itemstack2 == null ? 0 : ((Repairable)itemstack2.getItemMeta()).getRepairCost());
            anvil.setRepairCost(0);
            if (itemstack2 != null) {
                boolean flag;
                boolean bl = flag = itemstack2.getType().equals((Object)Material.ENCHANTED_BOOK) && !UberUtils.getAllStoredMap(itemstack2).isEmpty();
                if (itemstack1.getItemMeta() instanceof Repairable && this.isValid(item, itemstack2)) {
                    k = Math.min(this.getDamage(itemstack1), this.getMaxDamage(itemstack1) / 4);
                    if (k <= 0) {
                        anvil.setRepairCost(0);
                        event.setResult(null);
                        return;
                    }
                    for (i1 = 0; k > 0 && i1 < itemstack2.getAmount(); ++i1) {
                        l = this.getDamage(itemstack1) - k;
                        this.setDamage(itemstack1, l);
                        ++i;
                        k = Math.min(this.getDamage(itemstack1), this.getMaxDamage(itemstack1) / 4);
                    }
                    anvil.setRepairCost(i1);
                } else {
                    if (!(flag || itemstack1.getType().equals((Object)itemstack2.getType()) && this.isDamageable(itemstack1))) {
                        anvil.setRepairCost(0);
                        event.setResult(null);
                        return;
                    }
                    if (this.isDamageable(itemstack1) && !flag) {
                        k = this.getMaxDamage(item) - this.getDamage(item);
                        i1 = this.getMaxDamage(itemstack2) - this.getDamage(itemstack2);
                        l = i1 + this.getMaxDamage(itemstack1) * 12 / 100;
                        int j1 = k + l;
                        int k1 = this.getMaxDamage(itemstack1) - j1;
                        if (k1 < 0) {
                            k1 = 0;
                        }
                        if (k1 < this.getDamage(itemstack1)) {
                            this.setDamage(itemstack1, k1);
                            i += 2;
                        }
                    }
                    HashMap<Enchantment, Integer> map1 = itemstack2.getType().equals((Object)Material.ENCHANTED_BOOK) ? new HashMap<Enchantment, Integer>(UberUtils.getAllStoredMap(itemstack2)) : new HashMap<Enchantment, Integer>(UberUtils.getAllMap(itemstack2));
                    boolean flag1 = false;
                    boolean flag2 = false;
                    durations = this.average(itemstack1, itemstack2);
                    for (Enchantment enchantment : map1.keySet()) {
                        int i2;
                        if (enchantment == null) continue;
                        int l1 = map.getOrDefault(enchantment, 0);
                        i2 = l1 == (i2 = ((Integer)map1.get(enchantment)).intValue()) ? i2 + 1 : Math.max(i2, l1);
                        boolean flag3 = EnchantmentUtils.canEnchant(enchantment, item);
                        if (((HumanEntity)event.getViewers().get(0)).getGameMode().equals((Object)GameMode.CREATIVE) || item.getType().equals((Object)Material.ENCHANTED_BOOK)) {
                            flag3 = true;
                        }
                        for (Enchantment enchantment1 : map.keySet()) {
                            if (enchantment1 == enchantment || !enchantment.conflictsWith(enchantment1)) continue;
                            flag3 = false;
                            ++i;
                        }
                        if (!flag3) {
                            flag2 = true;
                            continue;
                        }
                        flag1 = true;
                        int max = UberConfiguration.getByEnchant(enchantment).getMaxLevel();
                        if (i2 > max) {
                            i2 = max;
                        }
                        map.put(enchantment, i2);
                        int j2 = 0;
                        switch ((int)EnchantmentUtils.getRarity(enchantment)) {
                            case 10: {
                                j2 = 1;
                                break;
                            }
                            case 5: {
                                j2 = 2;
                                break;
                            }
                            case 2: {
                                j2 = 4;
                                break;
                            }
                            case 1: {
                                j2 = 8;
                            }
                        }
                        if (flag) {
                            j2 = Math.max(1, j2 / 2);
                        }
                        i += j2 * i2;
                        if (item.getAmount() <= 1) continue;
                        i = 40;
                    }
                    if (flag2 && !flag1) {
                        anvil.setRepairCost(0);
                        event.setResult(null);
                        return;
                    }
                }
            }
            ItemMeta meta = itemstack1.getItemMeta();
            boolean rename = false;
            if (anvil.getRenameText() != null && !anvil.getRenameText().equals(meta.getDisplayName())) {
                String name = anvil.getRenameText();
                if (colors) {
                    name = ChatUtils.color(name);
                }
                meta.setDisplayName(name);
                itemstack1.setItemMeta(meta);
                ++i;
                rename = true;
            }
            ItemStack itemcopy = itemstack1.clone();
            anvil.setRepairCost(j + i);
            if (i <= 0) {
                anvil.setRepairCost(0);
                event.setResult(null);
                return;
            }
            if (!itemstack1.getType().equals((Object)Material.AIR)) {
                int k2 = ((Repairable)itemstack1.getItemMeta()).getRepairCost();
                if (itemstack2 != null && !itemstack2.getType().equals((Object)Material.AIR) && k2 < ((Repairable)itemstack2.getItemMeta()).getRepairCost()) {
                    k2 = ((Repairable)itemstack2.getItemMeta()).getRepairCost();
                }
                k2 = k2 * 2 + 1;
                Repairable meta2 = (Repairable)itemstack1.getItemMeta();
                meta2.setRepairCost(k2);
                itemstack1.setItemMeta((ItemMeta)meta2);
                if (itemstack1.getType().equals((Object)Material.ENCHANTED_BOOK)) {
                    EnchantmentUtils.setStoredEnchantments(map, itemstack1);
                } else {
                    EnchantmentUtils.setEnchantments(map, itemstack1);
                }
                if (!durations.isEmpty()) {
                    ItemStack item1 = itemstack1;
                    durations.forEach((k, v) -> UberUtils.setMetaTag(item1, k, UberMeta.DURATION, v));
                }
            }
            if (!this.hasChange(item, itemstack1) && (itemstack2 == null || itemstack2.getType().isAir())) {
                if (rename) {
                    anvil.setRepairCost(1);
                    event.setResult(itemcopy);
                } else {
                    anvil.setRepairCost(0);
                    event.setResult(null);
                }
                return;
            }
            if (has_limit && anvil.getRepairCost() > limit) {
                anvil.setRepairCost(limit);
            }
            if (!ignore && anvil.getRepairCost() > (has_limit ? limit : 39)) {
                event.setResult(null);
            } else {
                event.setResult(itemstack1);
            }
        }
    }

    private boolean hasChange(ItemStack a, ItemStack b) {
        ItemStack item1 = a.clone();
        ItemStack item2 = b.clone();
        Map<Enchantment, Integer> all1 = UberUtils.getAllMap(item1);
        Map<Enchantment, Integer> all2 = UberUtils.getAllMap(item2);
        return !all1.entrySet().stream().allMatch(entry -> {
            Object patt14151$temp;
            boolean match = ((Integer)entry.getValue()).equals(all2.get(entry.getKey()));
            if (match && (patt14151$temp = entry.getKey()) instanceof EffectEnchantment) {
                EffectEnchantment effect = (EffectEnchantment)((Object)((Object)patt14151$temp));
                Integer tag1 = (Integer)IntTag.DURATION.get(item1, effect);
                Integer tag2 = (Integer)IntTag.DURATION.get(item2, effect);
                if (tag1 == null || tag2 == null) {
                    return false;
                }
                return tag1.intValue() == tag2.intValue();
            }
            return match;
        });
    }

    private Map<EffectEnchantment, Integer> average(ItemStack item1, ItemStack item2) {
        HashMap<EffectEnchantment, Integer> map = new HashMap<EffectEnchantment, Integer>();
        UberUtils.getEnchants(item1).stream().filter(enchant -> enchant instanceof EffectEnchantment).forEach(enchant -> {
            int dur2;
            if (!enchant.containsEnchantment(item2)) {
                return;
            }
            int level1 = enchant.getLevel(item1);
            int level2 = enchant.getLevel(item2);
            int dur1 = (Integer)IntTag.DURATION.get(item1, (UberEnchantment)((Object)enchant));
            int duration = (int)((double)(dur1 + (dur2 = ((Integer)IntTag.DURATION.get(item2, (UberEnchantment)((Object)enchant))).intValue())) / 2.0) + (level1 == level2 ? 1 : 0);
            if (duration > enchant.getMaxLevel()) {
                duration = enchant.getMaxLevel();
            }
            map.put((EffectEnchantment)((Object)enchant), duration);
        });
        return map;
    }

    private boolean isValid(ItemStack item1, ItemStack item2) {
        Material m1 = item1.getType();
        Material m2 = item2.getType();
        switch (m1) {
            case WOODEN_AXE: 
            case WOODEN_HOE: 
            case WOODEN_PICKAXE: 
            case WOODEN_SHOVEL: 
            case WOODEN_SWORD: 
            case SHIELD: {
                switch (m2) {
                    case ACACIA_PLANKS: 
                    case BAMBOO_PLANKS: 
                    case BIRCH_PLANKS: 
                    case CHERRY_PLANKS: 
                    case CRIMSON_PLANKS: 
                    case DARK_OAK_PLANKS: 
                    case JUNGLE_PLANKS: 
                    case MANGROVE_PLANKS: 
                    case OAK_PLANKS: 
                    case SPRUCE_PLANKS: 
                    case WARPED_PLANKS: {
                        return true;
                    }
                }
                return false;
            }
            case LEATHER_BOOTS: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_HELMET: 
            case LEATHER_LEGGINGS: {
                return m2.equals((Object)Material.LEATHER);
            }
            case STONE_AXE: 
            case STONE_HOE: 
            case STONE_PICKAXE: 
            case STONE_SHOVEL: 
            case STONE_SWORD: {
                switch (m2) {
                    case COBBLED_DEEPSLATE: 
                    case COBBLESTONE: 
                    case BLACKSTONE: {
                        return true;
                    }
                }
                return false;
            }
            case CHAINMAIL_BOOTS: 
            case CHAINMAIL_CHESTPLATE: 
            case CHAINMAIL_HELMET: 
            case CHAINMAIL_LEGGINGS: 
            case IRON_AXE: 
            case IRON_HOE: 
            case IRON_BOOTS: 
            case IRON_CHESTPLATE: 
            case IRON_HELMET: 
            case IRON_LEGGINGS: 
            case IRON_PICKAXE: 
            case IRON_SWORD: 
            case IRON_SHOVEL: {
                return m2.equals((Object)Material.IRON_INGOT);
            }
            case GOLDEN_BOOTS: 
            case GOLDEN_CHESTPLATE: 
            case GOLDEN_HELMET: 
            case GOLDEN_LEGGINGS: 
            case GOLDEN_AXE: 
            case GOLDEN_HOE: 
            case GOLDEN_PICKAXE: 
            case GOLDEN_SHOVEL: 
            case GOLDEN_SWORD: {
                return m2.equals((Object)Material.GOLD_INGOT);
            }
            case DIAMOND_BOOTS: 
            case DIAMOND_CHESTPLATE: 
            case DIAMOND_HELMET: 
            case DIAMOND_LEGGINGS: 
            case DIAMOND_AXE: 
            case DIAMOND_HOE: 
            case DIAMOND_PICKAXE: 
            case DIAMOND_SHOVEL: 
            case DIAMOND_SWORD: {
                return m2.equals((Object)Material.DIAMOND);
            }
            case NETHERITE_BOOTS: 
            case NETHERITE_CHESTPLATE: 
            case NETHERITE_HELMET: 
            case NETHERITE_LEGGINGS: 
            case NETHERITE_AXE: 
            case NETHERITE_HOE: 
            case NETHERITE_PICKAXE: 
            case NETHERITE_SHOVEL: 
            case NETHERITE_SWORD: {
                return m2.equals((Object)Material.NETHERITE_INGOT);
            }
            case TURTLE_HELMET: {
                return m2.equals((Object)Material.getMaterial((String)"SCUTE"));
            }
            case ELYTRA: {
                return m2.equals((Object)Material.PHANTOM_MEMBRANE);
            }
        }
        return false;
    }

    static {
        AnvilEvents.reload();
    }

    public static interface Test {
        public void run();
    }
}

