/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.utils.enchanting;

import java.util.ArrayList;
import me.sciguymjm.uberenchant.api.utils.random.UberRandom;
import me.sciguymjm.uberenchant.utils.enchanting.EnchantmentTableUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.Player;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.inventory.ItemStack;

public class CustomOffer {
    private boolean enchanted = false;
    private int slot;
    private final int[] costs = new int[3];
    private final EnchantmentOffer[] offers;
    private final Player player;
    private final ItemStack item;
    private EnchantmentTableUtils.CustomList list;

    public void setEnchanted() {
        this.enchanted = true;
    }

    public boolean isEnchanted() {
        return this.enchanted;
    }

    public CustomOffer(PrepareItemEnchantEvent event, int button) {
        UberRandom random = new UberRandom(EnchantmentTableUtils.seed.get(event.getEnchanter().getUniqueId()));
        this.player = event.getEnchanter();
        this.item = event.getItem();
        this.offers = event.getOffers();
        this.slot = button;
        this.list = this.generate(event, random);
    }

    private boolean checkNull(EnchantmentOffer ... objects) {
        for (EnchantmentOffer object : objects) {
            if (object != null) continue;
            return true;
        }
        return false;
    }

    private EnchantmentTableUtils.CustomList generate(PrepareItemEnchantEvent event, UberRandom random) {
        int i;
        int bonus = event.getEnchantmentBonus();
        if (EnchantmentTableUtils.floorBonus() && bonus >= 15) {
            bonus += this.getFloorBonus(event.getEnchantBlock());
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            this.costs[i2] = EnchantmentTableUtils.getCost(random, i2, bonus, this.item);
            if (this.costs[i2] >= i2 + 1) continue;
            this.costs[i2] = 0;
        }
        EnchantmentTableUtils.CustomList list = new EnchantmentTableUtils.CustomList(new ArrayList<EnchantmentTableUtils.WeightedEnchantment>(), new ArrayList<EnchantmentTableUtils.WeightedEnchantment>());
        Enchantment[] enchants = new Enchantment[3];
        int[] levels = new int[3];
        for (i = 0; i < 3; ++i) {
            if (this.costs[i] <= 0 || (list = this.getEnchantmentList(i)) == null || list.vanilla().isEmpty()) continue;
            EnchantmentTableUtils.WeightedEnchantment enchant = list.vanilla().get(random.nextInt(list.vanilla().size()));
            enchants[i] = enchant.getEnchantment();
            levels[i] = enchant.getLevel();
        }
        for (i = 0; i < 3; ++i) {
            if (this.offers[i] == null || enchants[i] == null) continue;
            this.offers[i] = new EnchantmentOffer(enchants[i], levels[i], this.costs[i]);
        }
        return list;
    }

    private int getFloorBonus(Block block) {
        double bonus = 0.0;
        for (int x = 1; x >= -1; --x) {
            for (int z = 1; z >= -1; --z) {
                bonus += this.getBonusValue(block.getRelative(x, -1, z).getType());
            }
        }
        return (int)Math.round(bonus);
    }

    private double getBonusValue(Material material) {
        if (EnchantmentTableUtils.bonusBlocks().containsKey(material)) {
            return EnchantmentTableUtils.bonusBlocks().get(material);
        }
        return 0.0;
    }

    public boolean hasEnchanted() {
        return this.enchanted;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setHasEnchanted(boolean hasEnchanted) {
        this.enchanted = hasEnchanted;
    }

    public EnchantmentOffer getOffer() {
        if (this.slot == -1) {
            return null;
        }
        return this.offers[this.slot];
    }

    public EnchantmentOffer[] getOffers() {
        return this.offers;
    }

    public EnchantmentTableUtils.CustomList getEnchantmentList(int slot) {
        return EnchantmentTableUtils.getEnchantmentList(this.player, this.item, slot, this.costs[slot]);
    }

    public EnchantmentTableUtils.CustomList getList() {
        return this.list;
    }
}

