/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.utils.enchanting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.api.utils.ExcellentEnchantsRecord;
import me.sciguymjm.uberenchant.api.utils.UberConfiguration;
import me.sciguymjm.uberenchant.api.utils.UberRecord;
import me.sciguymjm.uberenchant.api.utils.UberUtils;
import me.sciguymjm.uberenchant.utils.ChatUtils;
import me.sciguymjm.uberenchant.utils.UberLocale;
import me.sciguymjm.uberenchant.utils.VersionUtils;
import me.sciguymjm.uberenchant.utils.Versions;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class EnchantmentUtils {
    public static String[] listEnchants(int page) {
        List<String> records = UberConfiguration.getRecords().stream().filter(value -> value.getEnchant() != null).map(value -> String.format("    &6&l%1$s&8 (&5%2$s&8)", value.getName(), value.getKey().getNamespace())).distinct().sorted().toList();
        int t = records.size();
        ArrayList<String> sub = new ArrayList<String>(records.subList(Math.max(Math.min(page * 10 - 10, t - 10), 0), Math.min(page * 10, t)));
        sub.add(0, UberLocale.getCF("&6", "utils.enchantments.list", page, sub.size() / 10));
        sub.add(sub.size(), UberLocale.getCF("&6", "utils.enchantments.list", page));
        return (String[])sub.toArray(String[]::new);
    }

    public static String listPage(int page) {
        List<String> records = UberConfiguration.getRecords().stream().filter(value -> value.getEnchant() != null).map(value -> String.format("    &6&l%1$s&8 (&5%2$s&8)", value.getName(), value.getKey().getNamespace())).distinct().sorted().toList();
        int t = records.size();
        int pages = (int)Math.ceil((double)t / 10.0);
        page = EnchantmentUtils.clamp(1, pages, page);
        int from = EnchantmentUtils.from(page, 10, t);
        int to = EnchantmentUtils.to(page, 10, t);
        ArrayList<String> sub = new ArrayList<String>(records.subList(from, to));
        sub.add(0, UberLocale.getCF("&6", "utils.enchantments.list", page, pages));
        return ChatUtils.color(String.join((CharSequence)"\n", sub));
    }

    public static int getPages() {
        int t = (int)UberConfiguration.getRecords().stream().filter(value -> value.getEnchant() != null).distinct().count();
        return (int)Math.ceil((double)t / 10.0);
    }

    private static int from(int value, int range, int total) {
        int a = value * range - range;
        int f = a + Math.max(Math.min(a, total - range), 0) % range;
        return f - f % range;
    }

    private static int to(int value, int range, int total) {
        return Math.min(value * range, total);
    }

    private static int clamp(int min, int max, int value) {
        return Math.min(Math.max(min, value), max);
    }

    public static Enchantment getEnchantment(String name) {
        if (name.isEmpty()) {
            return null;
        }
        Pattern pattern = Pattern.compile(name.toLowerCase());
        Predicate<String> filter = string -> pattern.matcher(string.toLowerCase()).lookingAt();
        return UberRecord.values().stream().filter(enchant -> filter.test(enchant.getName()) || filter.test(enchant.getKey().toString()) || enchant.getAliases().stream().anyMatch(filter)).findFirst().map(UberRecord::getEnchant).orElse(null);
    }

    public static Set<Enchantment> getMatches(String name) {
        return UberRecord.values().stream().filter(record -> record.getName().equalsIgnoreCase(name) || record.getName().contains(name.toLowerCase()) || record.getKey().toString().equalsIgnoreCase(name) || record.getKey().toString().contains(name.toLowerCase()) || record.getAliases().contains(name.toLowerCase()) || record.getAliases().stream().anyMatch(alias -> alias.equalsIgnoreCase(name) || alias.contains(name.toLowerCase()))).distinct().map(UberRecord::getEnchant).collect(Collectors.toSet());
    }

    public static Set<UberEnchantment> getMatches(ItemStack item, String name) {
        if (item.getType().equals((Object)Material.AIR) || UberUtils.getMap(item).isEmpty()) {
            return null;
        }
        HashSet<UberEnchantment> enchants = new HashSet<UberEnchantment>(UberUtils.getMap(item).keySet());
        if (name.isEmpty()) {
            return enchants;
        }
        return enchants.stream().filter(enchant -> enchant.getName().equalsIgnoreCase(name) || enchant.getName().contains(name.toLowerCase()) || enchant.getKey().toString().equalsIgnoreCase(name) || enchant.getKey().toString().contains(name.toLowerCase()) || enchant.getAliases().contains(name.toLowerCase()) || enchant.getAliases().stream().anyMatch(alias -> alias.equalsIgnoreCase(name) || alias.contains(name.toLowerCase()))).collect(Collectors.toSet());
    }

    public static boolean multi(Player player, Set<? extends Enchantment> set) {
        if (set == null || set.isEmpty()) {
            ChatUtils.localized((CommandSender)player, "&c", "actions.enchant.invalid");
            ChatUtils.response((CommandSender)player, "&a/ulist enchants");
            return true;
        }
        if (set.size() > 1) {
            ArrayList<String> list = new ArrayList<String>(set.stream().map(e -> {
                NamespacedKey key1 = VersionUtils.getKey(e);
                if (key1 == null) {
                    return "";
                }
                if (set.stream().filter(e2 -> {
                    NamespacedKey key2 = VersionUtils.getKey(e2);
                    if (key2 == null) {
                        return false;
                    }
                    return key2.getKey().equals(key1.getKey());
                }).count() > 1L) {
                    return "    - " + key1;
                }
                return "    - " + key1.getKey();
            }).toList());
            list.add(0, "\n" + UberLocale.get("utils.enchantments.multiple"));
            ChatUtils.response((CommandSender)player, (String[])list.toArray(String[]::new));
            return true;
        }
        return false;
    }

    public static boolean multi(Player player, List<Player> players) {
        if (players.size() > 1) {
            ArrayList<String> list = new ArrayList<String>(players.stream().map(p -> "    - " + p.getName()).toList());
            list.add(0, "\n" + UberLocale.get("utils.players.multiple"));
            ChatUtils.response((CommandSender)player, (String[])list.toArray(String[]::new));
            return true;
        }
        return false;
    }

    public static List<String> matchEnchants(String name) {
        ArrayList list = new ArrayList();
        UberRecord.values().forEach(record -> {
            list.add(record.getName());
            list.add(record.getKey().toString());
            list.addAll(record.getAliases());
        });
        return list.stream().filter(a -> name.isBlank() || a.toLowerCase().contains(name.toLowerCase())).distinct().toList();
    }

    public static <T extends Enchantment> void setEnchantment(T enchant, ItemStack item, int level) {
        if (enchant instanceof UberEnchantment) {
            UberEnchantment enchantment = (UberEnchantment)enchant;
            UberUtils.addData(item, enchantment, level);
        } else {
            item.addUnsafeEnchantment(enchant, level);
        }
    }

    public static <T extends Enchantment> void setStoredEnchantment(T enchant, ItemStack item, int level) {
        if (!item.getType().equals((Object)Material.ENCHANTED_BOOK)) {
            return;
        }
        if (enchant instanceof UberEnchantment) {
            UberEnchantment enchantment = (UberEnchantment)enchant;
            UberUtils.addStoredEnchantment(enchantment, item, level);
        } else {
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)item.getItemMeta();
            meta.addStoredEnchant(enchant, level, true);
            item.setItemMeta((ItemMeta)meta);
        }
    }

    public static void setEnchantments(Map<? extends Enchantment, Integer> enchants, ItemStack item) {
        enchants.forEach((enchant, level) -> EnchantmentUtils.setEnchantment(enchant, item, level));
    }

    public static void setStoredEnchantments(Map<? extends Enchantment, Integer> enchants, ItemStack item) {
        if (!item.getType().equals((Object)Material.ENCHANTED_BOOK)) {
            return;
        }
        enchants.forEach((k, v) -> EnchantmentUtils.setStoredEnchantment(k, item, v));
    }

    public static ItemStack extractEnchantment(Enchantment enchant, ItemStack item) {
        if (item.hasItemMeta() && UberUtils.getAllMap(item).containsKey(enchant)) {
            if (enchant instanceof UberEnchantment) {
                UberEnchantment enchantment = (UberEnchantment)enchant;
                return UberUtils.extractEnchantment(enchantment, item);
            }
            ItemStack book = new ItemStack(Material.ENCHANTED_BOOK, 1);
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)book.getItemMeta();
            if (meta == null) {
                return null;
            }
            meta.addStoredEnchant(enchant, item.getEnchantmentLevel(enchant), true);
            book.setItemMeta((ItemMeta)meta);
            return book;
        }
        return null;
    }

    public static boolean removeEnchantment(Enchantment enchant, ItemStack item) {
        if (item.hasItemMeta() && UberUtils.getAllMap(item).containsKey(enchant)) {
            if (enchant instanceof UberEnchantment) {
                UberEnchantment enchantment = (UberEnchantment)enchant;
                UberUtils.removeEnchantment(enchantment, item);
            } else {
                item.removeEnchantment(enchant);
            }
            return true;
        }
        return false;
    }

    public static void help(Player player, String command) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        EnchantmentUtils.add(map, "ulist", "effects | enchants");
        EnchantmentUtils.add(map, "uadd", "enchant <enchantment> <level>", "enchant all <level>", "effect <effect> <duration> <level>", "meta <enchantment> <tag> <value>", "name <string...>", "lore <string...>");
        EnchantmentUtils.add(map, "ucost", "<add | del | extract> enchant <enchantment> <level>");
        EnchantmentUtils.add(map, "udel", "enchant <enchantment>", "effect <effect>", "lore <line#>", "meta <enchantment> <tag>", "name");
        EnchantmentUtils.add(map, "uextract", "<enchantment | id>");
        EnchantmentUtils.add(map, "uset", "effect <effect> <duration> <level>", "hidden <true | false>", "lore <line#> <string...>", "meta <enchantment> <tag> <value>", "name <string...>");
        EnchantmentUtils.add(map, "uinsert", "lore <line#> <string...>");
        EnchantmentUtils.add(map, "uclear", "enchant | effect | lore");
        EnchantmentUtils.add(map, "uitem", "save <name>", "load <name> [player]", "delete <name>");
        EnchantmentUtils.add(map, "ureload", "");
        if (!map.containsKey(command)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("&6Command Help:");
            list.addAll(map.values().stream().map(l -> String.join((CharSequence)"\n", l)).toList());
            ChatUtils.response((CommandSender)player, (String[])list.toArray(String[]::new));
        } else {
            ChatUtils.response((CommandSender)player, "&6Command Help:\n" + String.join((CharSequence)"\n", (Iterable)map.get(command)));
        }
    }

    private static List<String> list(String command, String ... args) {
        boolean ver = Versions.v1_20_4.atLeast();
        return new ArrayList<String>(Arrays.stream(args).filter(arg -> !ver || !arg.contains("meta")).map(arg -> {
            if (arg.isEmpty()) {
                return "    &6&l/" + command;
            }
            return String.format("    &6&l/%1$s &7%2$s", command, arg);
        }).toList());
    }

    private static void add(Map<String, List<String>> map, String command, String ... args) {
        map.put(command, EnchantmentUtils.list(command, args));
    }

    public static String setHideEnchants(ItemStack item, boolean hide) {
        String msg;
        if (!item.hasItemMeta()) {
            return "";
        }
        ItemMeta meta = item.getItemMeta();
        if (hide) {
            if (!meta.hasItemFlag(ItemFlag.HIDE_ENCHANTS)) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                item.setItemMeta(meta);
                msg = UberLocale.getC("&a", "utils.enchantments.hidden_success");
            } else {
                msg = UberLocale.getC("&c", "utils.enchantments.already_hidden");
            }
            if (UberEnchantment.hasEnchantments(item)) {
                UberUtils.removeEnchantmentLore(item);
            }
        } else {
            if (meta.hasItemFlag(ItemFlag.HIDE_ENCHANTS)) {
                meta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                item.setItemMeta(meta);
                msg = UberLocale.getC("&a", "utils.enchantments.shown_success");
            } else {
                msg = UberLocale.getC("&c", "utils.enchantments.already_shown");
            }
            if (UberEnchantment.hasEnchantments(item)) {
                UberUtils.addEnchantmentLore(item);
            }
        }
        return msg;
    }

    public static List<String> find(Player player, String name) {
        if (player.hasPermission("uber.add.enchant.all")) {
            return EnchantmentUtils.matchEnchants(name);
        }
        return UberRecord.values().stream().filter(a -> {
            if (name.isBlank() || a.getKey().toString().toLowerCase().contains(name.toLowerCase())) {
                return player.hasPermission(String.format("uber.add.enchant.%1$s", a.getName().toLowerCase()));
            }
            return false;
        }).mapMulti((a, b) -> {
            NamespacedKey key = VersionUtils.getKey(a.getEnchant());
            if (key == null) {
                return;
            }
            b.accept(key.toString());
            a.getAliases().forEach(b);
        }).distinct().toList();
    }

    public static List<String> find(Player player, ItemStack item, String name) {
        Set<Enchantment> all = UberUtils.getAllMap(item).keySet();
        return UberRecord.values().stream().filter(record -> {
            if (all.contains(record.getEnchant()) && record.getKey().toString().toLowerCase().contains(name.toLowerCase())) {
                return player.hasPermission(String.format("uber.del.enchant.%1$s", record.getName().toLowerCase()));
            }
            return false;
        }).mapMulti((a, b) -> {
            NamespacedKey key = VersionUtils.getKey(a.getEnchant());
            if (key == null) {
                return;
            }
            b.accept(key.toString());
            a.getAliases().forEach(b);
        }).distinct().toList();
    }

    public static double getRarity(Enchantment enchantment) {
        NamespacedKey key = VersionUtils.getKey(enchantment);
        if (key == null) {
            return 0.0;
        }
        switch (key.getKey()) {
            case "protection": 
            case "sharpness": 
            case "efficiency": 
            case "power": 
            case "piercing": {
                return 10.0;
            }
            case "fire_protection": 
            case "feather_falling": 
            case "projectile_protection": 
            case "smite": 
            case "bane_of_arthropods": 
            case "knockback": 
            case "unbreaking": 
            case "loyalty": 
            case "quick_charge": 
            case "density": {
                return 5.0;
            }
            case "blast_protection": 
            case "respiration": 
            case "aqua_affinity": 
            case "depth_strider": 
            case "frost_walker": 
            case "fire_aspect": 
            case "looting": 
            case "sweeping": 
            case "fortune": 
            case "punch": 
            case "flame": 
            case "lure": 
            case "impaling": 
            case "riptide": 
            case "multishot": 
            case "mending": 
            case "breach": 
            case "wind_burst": {
                return 2.0;
            }
            case "thorns": 
            case "binding_curse": 
            case "soul_speed": 
            case "swift_sneak": 
            case "silk_touch": 
            case "infinity": 
            case "channeling": 
            case "vanishing_curse": {
                return 1.0;
            }
        }
        UberRecord record = UberRecord.byEnchantment(enchantment);
        if (record == null) {
            return 0.0;
        }
        if (enchantment instanceof UberEnchantment) {
            UberEnchantment uber = (UberEnchantment)enchantment;
            return uber.getRarity().getWeight();
        }
        if (record instanceof ExcellentEnchantsRecord) {
            ExcellentEnchantsRecord ex = (ExcellentEnchantsRecord)record;
            return ex.getWeight();
        }
        return 0.0;
    }

    public static boolean canEnchant(Enchantment e, ItemStack i) {
        UberRecord uberRecord = UberRecord.byEnchantment(e);
        if (uberRecord instanceof ExcellentEnchantsRecord) {
            ExcellentEnchantsRecord record = (ExcellentEnchantsRecord)uberRecord;
            return record.getTargets().contains(VersionUtils.getKey(i.getType()).getKey());
        }
        if (e instanceof UberEnchantment) {
            UberEnchantment ue = (UberEnchantment)e;
            return ue.canEnchantItem(i);
        }
        return e.canEnchantItem(i);
    }

    public static boolean isTreasure(Enchantment e) {
        UberRecord uberRecord = UberRecord.byEnchantment(e);
        if (uberRecord instanceof ExcellentEnchantsRecord) {
            ExcellentEnchantsRecord record = (ExcellentEnchantsRecord)uberRecord;
            return record.isTreasure();
        }
        return e.isTreasure();
    }
}

