/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.utils.plugins;

import java.util.logging.Level;
import me.sciguymjm.uberenchant.UberEnchant;
import me.sciguymjm.uberenchant.utils.UberLocale;
import me.sciguymjm.uberenchant.utils.plugins.PluginUtils;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultUtils
extends PluginUtils {
    private static VaultUtils instance;
    private static Economy economy;

    protected VaultUtils() {
        super("Vault");
        if (UberEnchant.instance().getConfig().getBoolean("use_economy")) {
            if (this.pluginLoaded) {
                RegisteredServiceProvider economyService = UberEnchant.instance().getServer().getServicesManager().getRegistration(Economy.class);
                if (economyService != null) {
                    economy = (Economy)economyService.getProvider();
                    this.pluginLoaded = economy.isEnabled();
                } else {
                    UberEnchant.log(Level.WARNING, UberLocale.getC("&c", "uberenchant.economy_not_found"));
                    this.pluginLoaded = false;
                }
            } else {
                UberEnchant.log(Level.WARNING, UberLocale.getC("&c", "uberenchant.economy_not_found"));
            }
        }
        instance = this;
    }

    public static VaultUtils instance() {
        if (instance == null) {
            instance = new VaultUtils();
        }
        return instance;
    }

    public static boolean isLoaded() {
        return instance.isPluginLoaded();
    }

    public static Economy getEconomy() {
        return economy;
    }

    public static boolean hasEconomy() {
        return economy != null;
    }

    public static boolean useEconomy() {
        return UberEnchant.instance().getConfig().getBoolean("use_economy");
    }

    public static double getCost(String path) {
        return UberEnchant.instance().getConfig().getDouble(path);
    }

    public static double getBalance(Player player) {
        return economy.getBalance((OfflinePlayer)player);
    }

    public static boolean has(Player player, double cost) {
        return economy.has((OfflinePlayer)player, cost);
    }

    public static EconomyResponse withdraw(Player player, double cost) {
        return economy.withdrawPlayer((OfflinePlayer)player, cost);
    }
}

