/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.utils.plugins;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import me.sciguymjm.uberenchant.utils.plugins.PluginUtils;
import org.bukkit.Location;
import org.bukkit.entity.Animals;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class WorldGuardUtils
extends PluginUtils {
    private static WorldGuardUtils instance;

    WorldGuardUtils() {
        super("WorldGuard");
        if (this.pluginLoaded) {
            this.pluginLoaded = WorldGuard.getInstance() != null;
        }
        instance = this;
    }

    public static WorldGuardUtils instance() {
        if (instance == null) {
            instance = new WorldGuardUtils();
        }
        return instance;
    }

    public static boolean isLoaded() {
        return instance.isPluginLoaded();
    }

    public static boolean flag(LivingEntity who, Location where, StateFlag flag) {
        if (WorldGuardUtils.isLoaded()) {
            if (who == null || !flag.requiresSubject()) {
                return WorldGuardUtils.flag(where, flag);
            }
            LocalPlayer lp = WorldGuardPlugin.inst().wrapPlayer((Player)who);
            return WorldGuardUtils.getWorldGuard().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)where), lp, new StateFlag[]{flag}) == StateFlag.State.DENY;
        }
        return true;
    }

    public static boolean flag(Location where, StateFlag flag) {
        if (WorldGuardUtils.isLoaded()) {
            return WorldGuardUtils.getWorldGuard().getPlatform().getRegionContainer().createQuery().queryState(BukkitAdapter.adapt((Location)where), null, new StateFlag[]{flag}) == StateFlag.State.DENY;
        }
        return true;
    }

    public static boolean denyDamage(LivingEntity a, LivingEntity b) {
        return WorldGuardUtils.isLoaded() && WorldGuardUtils.denyPvp(a, b) | WorldGuardUtils.denyDamageAnimals(a, b) | WorldGuardUtils.denyPotionSplash(a, b);
    }

    public static boolean denyPvp(LivingEntity who, Location where) {
        return WorldGuardUtils.isLoaded() && WorldGuardUtils.flag(who, where, Flags.PVP);
    }

    public static boolean denyPvp(LivingEntity who, LivingEntity entity) {
        return who instanceof Player && entity instanceof Player && WorldGuardUtils.denyPvp(who, entity.getLocation());
    }

    public static boolean denyDamageAnimals(LivingEntity who, Location where) {
        return WorldGuardUtils.isLoaded() && WorldGuardUtils.flag(who, where, Flags.DAMAGE_ANIMALS);
    }

    public static boolean denyDamageAnimals(LivingEntity who, LivingEntity entity) {
        return entity instanceof Animals && WorldGuardUtils.denyDamageAnimals(who, entity.getLocation());
    }

    public static boolean denyPotionSplash(LivingEntity who, Location where) {
        return WorldGuardUtils.isLoaded() && WorldGuardUtils.flag(who, where, Flags.POTION_SPLASH);
    }

    public static boolean denyPotionSplash(LivingEntity who, LivingEntity entity) {
        return WorldGuardUtils.denyPotionSplash(who, entity.getLocation());
    }

    public static WorldGuard getWorldGuard() {
        if (WorldGuardUtils.isLoaded()) {
            return WorldGuard.getInstance();
        }
        return null;
    }
}

